/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.List;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ListExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.StringExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolArgument;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolInvokeExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.Message;

public class FormatPatternChecker {
    private FormatPatternChecker() {
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public static void tcheck(ToolInvokeExpression invoke, CheckerContext ctxt) {
        switch (invoke.getTool().getName()) {
            default: {
                throw new RuntimeException("Unexpected tool" + invoke.getTool());
            }
            case "err": 
            case "fmt": 
            case "out": 
            case "errln": 
            case "outln": 
        }
        if (invoke.getArguments().size() < 1) {
            return;
        }
        ToolArgument patternArg = null;
        Expression value = null;
        if (((ToolArgument)invoke.getArguments().get(0)).getName() == null) {
            patternArg = (ToolArgument)invoke.getArguments().get(0);
            value = patternArg.getValue();
        } else {
            for (ToolArgument arg : invoke.getArguments()) {
                if (arg.getName() == null || !arg.getName().equals("pattern")) continue;
                patternArg = arg;
                value = arg.getValue();
                break;
            }
            if (patternArg == null) {
                return;
            }
        }
        if (!(value instanceof StringExpression)) {
            return;
        }
        List args = Lists.listc((int)(invoke.getArguments().size() - 1));
        for (ToolArgument arg : invoke.getArguments()) {
            if (arg == patternArg) continue;
            if (arg.getName() == null) {
                args.add(arg.getValue());
                continue;
            }
            Assert.check((boolean)arg.getName().equals("args"));
            Expression argsValue = arg.getValue();
            if (!(argsValue instanceof ListExpression)) {
                return;
            }
            args.addAll(((ListExpression)argsValue).getElements());
        }
        FormatPatternChecker.tcheck((StringExpression)value, args, ctxt);
    }

    private static void tcheck(StringExpression pattern, List<Expression> args, CheckerContext ctxt) {
        List valueTypes = Lists.listc((int)args.size());
        List valuePositions = Lists.listc((int)args.size());
        for (Expression arg : args) {
            valueTypes.add(ToolDefTypeUtils.normalizeType((ToolDefType)arg.getType()));
            valuePositions.add(arg.getPosition());
        }
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern.getValue());
        Position patternPos = pattern.getPosition();
        boolean decodingFailed = false;
        for (FormatDescription part : parts) {
            if (part.conversion != FormatDescription.Conversion.ERROR) continue;
            decodingFailed = true;
            ctxt.addProblem(Message.FMT_PAT_DECODE_ERR, FormatPatternChecker.createSubPos(patternPos, part), part.text);
        }
        if (decodingFailed) {
            throw new SemanticException();
        }
        int valueCount = valueTypes.size();
        boolean[] used = new boolean[valueCount];
        int implicitIndex = 0;
        block9: for (FormatDescription part : parts) {
            int idx1;
            if (part.conversion == FormatDescription.Conversion.LITERAL) continue;
            if (!part.index.isEmpty()) {
                idx1 = part.getExplicitIndex();
                if (idx1 == -1) {
                    ctxt.addProblem(Message.FMT_PAT_IDX_OVERFLOW, FormatPatternChecker.createSubPos(patternPos, part), new String[0]);
                    throw new SemanticException();
                }
            } else {
                idx1 = ++implicitIndex;
            }
            if (idx1 < 1 || idx1 > valueCount) {
                ctxt.addProblem(Message.FMT_PAT_IDX_OUT_OF_RANGE, FormatPatternChecker.createSubPos(patternPos, part), Numbers.toOrdinal((int)idx1));
                throw new SemanticException();
            }
            int idx0 = idx1 - 1;
            used[idx0] = true;
            ToolDefType type = (ToolDefType)valueTypes.get(idx0);
            switch (part.conversion) {
                case BOOLEAN: {
                    if (type instanceof BoolType) break;
                    ctxt.addProblem(Message.FMT_PAT_WRONG_TYPE, FormatPatternChecker.createSubPos(patternPos, part), part.text, "bool\" or \"bool?", Numbers.toOrdinal((int)idx1), ToolDefTextUtils.typeToStr((ToolDefType)type));
                    break;
                }
                case INTEGER: {
                    if (!type.isNullable() && (type instanceof IntType || type instanceof LongType)) continue block9;
                    ctxt.addProblem(Message.FMT_PAT_WRONG_TYPE, FormatPatternChecker.createSubPos(patternPos, part), part.text, "int\" or \"long", Numbers.toOrdinal((int)idx1), ToolDefTextUtils.typeToStr((ToolDefType)type));
                    break;
                }
                case REAL: {
                    if (!type.isNullable() && (type instanceof IntType || type instanceof LongType || type instanceof DoubleType)) continue block9;
                    ctxt.addProblem(Message.FMT_PAT_WRONG_TYPE, FormatPatternChecker.createSubPos(patternPos, part), part.text, "int\", \"long\", or \"double", Numbers.toOrdinal((int)idx1), ToolDefTextUtils.typeToStr((ToolDefType)type));
                    break;
                }
                case STRING: {
                    break;
                }
                case LITERAL: 
                case ERROR: {
                    String msg = "Unexpected: " + part.conversion;
                    throw new RuntimeException(msg);
                }
            }
        }
        int i = 0;
        while (i < used.length) {
            if (!used[i]) {
                ctxt.addProblem(Message.FMT_PAT_UNUSED_VALUE, (Position)valuePositions.get(i), Numbers.toOrdinal((int)(i + 1)));
            }
            ++i;
        }
    }

    private static TextPosition createSubPos(Position pos, FormatDescription fd) {
        return PositionUtils.toTextPosition((Position)PositionUtils.getSubRange((Position)pos, (int)(fd.offset + 1), (int)fd.length));
    }
}

