/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EventCodeGenerator {
    private EventCodeGenerator() {
    }

    public static void gencodeEvents(Specification spec, CifCompilerContext ctxt) {
        List<Event> events = ctxt.getEvents();
        Event tau = ctxt.tauEvent;
        String tauName = ctxt.getEventClassName(tau);
        Assert.check((boolean)tauName.equals("Event_tau"));
        int eventIdx = 0;
        while (eventIdx < events.size()) {
            String absName;
            Event event = events.get(eventIdx);
            boolean isTau = event == tau;
            boolean isComm = event.getType() != null;
            String string = absName = isTau ? "tau" : CifTextUtils.getAbsName((PositionObject)event);
            String ctrlTxt = event.getControllable() == null ? "null" : (event.getControllable() != false ? "true" : "false");
            String className = ctxt.getEventClassName(event);
            JavaCodeFile file = ctxt.addCodeFile(className);
            CodeBox h = file.header;
            h.add("/** Event \"%s\". */", new Object[]{absName});
            h.add("public final class %s extends RuntimeEvent<State> {", new Object[]{className});
            CodeBox c = file.body;
            c.add("public %s() {", new Object[]{className});
            c.indent();
            c.add("super(\"%s\", %d, %s);", new Object[]{absName, eventIdx, ctrlTxt});
            c.dedent();
            c.add("}");
            c.add();
            c.add("@Override");
            c.add("public boolean fillData(State state) {");
            c.indent();
            if (isComm) {
                c.add("// Send.");
                c.add("SPEC.sendData.get(%d).clear();", new Object[]{eventIdx});
                EventCodeGenerator.genFillCallsSend(event, c, ctxt);
                c.add("if (SPEC.sendData.get(%d).isEmpty()) return false;", new Object[]{eventIdx});
                c.add();
                c.add("// Receive.");
                c.add("SPEC.recvData.get(%d).clear();", new Object[]{eventIdx});
                EventCodeGenerator.genFillCallsRecv(event, c, ctxt);
                c.add("if (SPEC.recvData.get(%d).isEmpty()) return false;", new Object[]{eventIdx});
                c.add();
            }
            if (isTau) {
                c.add("SPEC.tauData.clear();");
                EventCodeGenerator.genFillCallsTau(c, ctxt);
                c.add("return !SPEC.tauData.isEmpty();");
            } else {
                c.add("// Sync.");
                c.add("boolean proceed;");
                EventCodeGenerator.genFillCallsSync(event, c, ctxt);
                c.add();
                c.add("// All done, possible so far.");
                if (!isComm && ctxt.getSyncAuts(event).isEmpty()) {
                    c.add("return false; // No aut has event in alphabet.");
                } else {
                    c.add("return true;");
                }
            }
            c.dedent();
            c.add("}");
            if (isComm) {
                List<Automaton> sendAuts = ctxt.getSendAuts(event);
                List<Automaton> recvAuts = ctxt.getRecvAuts(event);
                List<Automaton> syncAuts = ctxt.getSyncAuts(event);
                int cnt = 0;
                cnt += sendAuts.size();
                cnt += recvAuts.size();
                if ((cnt += syncAuts.size()) > 0 && sendAuts.isEmpty()) {
                    OutputProvider.warn((String)"No senders found for channel \"%s\".", (Object[])new Object[]{absName});
                }
                if (cnt > 0 && recvAuts.isEmpty()) {
                    OutputProvider.warn((String)"No receivers found for channel \"%s\".", (Object[])new Object[]{absName});
                }
            }
            c.add();
            c.add("@Override");
            c.add("public boolean allowedByInvs(State state) {");
            c.indent();
            EventCodeGenerator.genAllowedByInvsComp((ComplexComponent)spec, event, c, ctxt);
            for (Automaton aut : ctxt.getAutomata()) {
                EventCodeGenerator.genAllowedByInvsAutLocs(aut, event, c, ctxt);
            }
            c.add("// Event allowed by invariants.");
            c.add("return true;");
            c.dedent();
            c.add("}");
            ++eventIdx;
        }
    }

    private static void genFillCallsTau(CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getAutomata();
        for (Automaton aut : auts) {
            c.add("%s.fillTauData(state);", new Object[]{ctxt.getAutClassName(aut)});
        }
    }

    private static void genFillCallsSend(Event event, CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getSendAuts(event);
        for (Automaton aut : auts) {
            c.add("%s.fillSendData_%s(state);", new Object[]{ctxt.getAutClassName(aut), ctxt.getEventFieldName(event)});
        }
    }

    private static void genFillCallsRecv(Event event, CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getRecvAuts(event);
        for (Automaton aut : auts) {
            c.add("%s.fillRecvData_%s(state);", new Object[]{ctxt.getAutClassName(aut), ctxt.getEventFieldName(event)});
        }
    }

    private static void genFillCallsSync(Event event, CodeBox c, CifCompilerContext ctxt) {
        List<Automaton> auts = ctxt.getSyncAuts(event);
        for (Automaton aut : auts) {
            c.add();
            c.add("// Check automaton \"%s\".", new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            c.add("proceed = %s.fillSyncData_%s(state);", new Object[]{ctxt.getAutClassName(aut), ctxt.getEventFieldName(event)});
            c.add("if (!proceed) return false;");
        }
    }

    private static void genAllowedByInvsComp(ComplexComponent comp, Event event, CodeBox c, CifCompilerContext ctxt) {
        List stateEvtExclInvs = Lists.list();
        for (Invariant inv : comp.getInvariants()) {
            Event invEvent;
            if (inv.getInvKind() == InvKind.STATE || (invEvent = ((EventExpression)inv.getEvent()).getEvent()) != event) continue;
            stateEvtExclInvs.add(inv);
        }
        String absName = CifTextUtils.getAbsName((PositionObject)comp);
        if (!stateEvtExclInvs.isEmpty()) {
            c.add("// Invariants for \"%s\".", new Object[]{absName});
        }
        String compTxt = CifTextUtils.getComponentText2((ComplexComponent)comp);
        for (Invariant inv : stateEvtExclInvs) {
            Expression pred = inv.getPredicate();
            c.add("try {");
            c.indent();
            String predCode = ExprCodeGenerator.gencodeExpr(pred, ctxt, "state");
            InvKind invKind = inv.getInvKind();
            switch (invKind) {
                case EVENT_DISABLES: {
                    c.add("if (%s) return false;", new Object[]{predCode});
                    break;
                }
                case EVENT_NEEDS: {
                    c.add("if (!(%s)) return false;", new Object[]{predCode});
                    break;
                }
                default: {
                    String msg = "Unknown state/evt excl inv: " + invKind;
                    throw new RuntimeException(msg);
                }
            }
            String invTxt = CifTextUtils.invToStr((Invariant)inv, (boolean)false);
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of invariant \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)invTxt), StringEscapeUtils.escapeJava((String)compTxt)});
            c.dedent();
            c.add("}");
            c.add();
            if (inv.getSupKind() != SupKind.REQUIREMENT) continue;
            OutputProvider.warn((String)"Invariant \"%s\" of %s is a requirement, but will be simulated as a plant.", (Object[])new Object[]{invTxt, compTxt});
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                EventCodeGenerator.genAllowedByInvsComp((ComplexComponent)child, event, c, ctxt);
            }
        }
    }

    private static void genAllowedByInvsAutLocs(Automaton aut, Event event, CodeBox c, CifCompilerContext ctxt) {
        c.add("// Invariants for current location.");
        c.add("switch (state.%s.%s) {", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        c.indent();
        EList locs = aut.getLocations();
        int locIdx = 0;
        while (locIdx < locs.size()) {
            Location loc = (Location)locs.get(locIdx);
            List locEvtExclInvs = Lists.list();
            for (Invariant inv : loc.getInvariants()) {
                Event invEvent;
                if (inv.getInvKind() == InvKind.STATE || (invEvent = ((EventExpression)inv.getEvent()).getEvent()) != event) continue;
                locEvtExclInvs.add(inv);
            }
            if (!locEvtExclInvs.isEmpty()) {
                c.add("case %s:", new Object[]{ctxt.getLocationValueText(loc, locIdx)});
                c.indent();
                String locTxt = CifTextUtils.getLocationText2((Location)loc);
                for (Invariant inv : locEvtExclInvs) {
                    Expression pred = inv.getPredicate();
                    c.add("try {");
                    c.indent();
                    String predCode = ExprCodeGenerator.gencodeExpr(pred, ctxt, "state");
                    InvKind invKind = inv.getInvKind();
                    switch (invKind) {
                        case EVENT_DISABLES: {
                            c.add("if (%s) return false;", new Object[]{predCode});
                            break;
                        }
                        case EVENT_NEEDS: {
                            c.add("if (!(%s)) return false;", new Object[]{predCode});
                            break;
                        }
                        default: {
                            String msg = "Unknown state/evt excl inv: " + invKind;
                            throw new RuntimeException(msg);
                        }
                    }
                    String invTxt = CifTextUtils.invToStr((Invariant)inv, (boolean)false);
                    c.dedent();
                    c.add("} catch (CifSimulatorException e) {");
                    c.indent();
                    c.add("throw new CifSimulatorException(\"Evaluation of invariant \\\"%s\\\" of %s failed.\", e, state);", new Object[]{StringEscapeUtils.escapeJava((String)invTxt), StringEscapeUtils.escapeJava((String)locTxt)});
                    c.dedent();
                    c.add("}");
                    if (inv.getSupKind() != SupKind.REQUIREMENT) continue;
                    OutputProvider.warn((String)"Invariant \"%s\" of %s is a requirement, but will be simulated as a plant.", (Object[])new Object[]{invTxt, locTxt});
                }
                c.add("break;");
                c.dedent();
            }
            ++locIdx;
        }
        c.dedent();
        c.add("}");
        c.add();
    }

    public static void collectEvents(ComplexComponent comp, List<Pair<String, Event>> events) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            events.add((Pair<String, Event>)Pair.pair((Object)CifTextUtils.getAbsName((PositionObject)decl, (boolean)false), (Object)((Event)decl)));
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                EventCodeGenerator.collectEvents((ComplexComponent)child, events);
            }
        }
    }
}

