/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.escet.cif.common.CifExtFuncUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExtJavaFuncCodeGenerator {
    private ExtJavaFuncCodeGenerator() {
    }

    public static void gencodeClassFields(ExternalFunction func, CodeBox c) {
        c.add();
        c.add("private java.lang.reflect.Method method;");
    }

    public static void gencodeBody(ExternalFunction func, CifType retType, CodeBox c, CifCompilerContext ctxt) {
        String[] parts = CifExtFuncUtils.splitExtJavaRef((String)func.getFunction());
        String className = parts[1];
        String methodName = parts[2];
        String classPath = parts[3];
        String specFileDir = ctxt.getSpecFileDir();
        c.add("if (method == null) {");
        c.indent();
        c.add("String cifFuncName = %s;", new Object[]{Strings.stringToJava((String)CifTextUtils.getAbsName((PositionObject)func))});
        c.add("String className = %s;", new Object[]{Strings.stringToJava((String)className)});
        c.add("String methodName = %s;", new Object[]{Strings.stringToJava((String)methodName)});
        c.add("String classPath = %s;", new Object[]{classPath == null ? "null" : Strings.stringToJava((String)classPath)});
        c.add("String specFileDir = %s;", new Object[]{Strings.stringToJava((String)specFileDir)});
        List paramTypes = Lists.listc((int)func.getParameters().size());
        for (FunctionParameter param : func.getParameters()) {
            CifType paramType = param.getParameter().getType();
            paramTypes.add(ExtJavaFuncCodeGenerator.typeToJavaClsStr(paramType, false));
        }
        c.add("Class<?>[] paramTypes = {%s};", new Object[]{String.join((CharSequence)", ", paramTypes)});
        c.add("Class<?> expReturnType = %s;", new Object[]{ExtJavaFuncCodeGenerator.typeToJavaClsStr(retType, true)});
        c.add("method = ExtFuncs.loadJavaMethod(cifFuncName, className, methodName, classPath, specFileDir, paramTypes, expReturnType);");
        c.dedent();
        c.add("}");
        c.add();
        List paramNames = Lists.listc((int)func.getParameters().size());
        for (FunctionParameter param : func.getParameters()) {
            DiscVariable var = param.getParameter();
            paramNames.add(ctxt.getFuncParamMethodParamName(var));
        }
        c.add("Object rslt = ExtFuncs.invokeJavaMethodAsync(SPEC.ctxt, method, cifToJava(%s));", new Object[]{String.join((CharSequence)", ", paramNames)});
        c.add("return javaToCif(rslt);");
    }

    public static void gencodeAdditionalMethods(ExternalFunction func, CifType retType, CodeBox c, CifCompilerContext ctxt) {
        ExtJavaFuncCodeGenerator.gencodeCifToJava(func, c, ctxt);
        ExtJavaFuncCodeGenerator.gencodeJavaToCif(func, retType, c, ctxt);
    }

    private static void gencodeCifToJava(ExternalFunction func, CodeBox c, CifCompilerContext ctxt) {
        List paramTxts = Lists.listc((int)func.getParameters().size());
        for (FunctionParameter param : func.getParameters()) {
            DiscVariable var = param.getParameter();
            String typeTxt = TypeCodeGenerator.gencodeType(var.getType(), ctxt);
            String name = ctxt.getFuncParamMethodParamName(var);
            paramTxts.add(String.valueOf(typeTxt) + " " + name);
        }
        c.add();
        c.add("private Object[] cifToJava(%s) {", new Object[]{String.join((CharSequence)", ", paramTxts)});
        c.indent();
        c.add("Object[] rslt = new Object[%d];", new Object[]{func.getParameters().size()});
        AtomicInteger nr = new AtomicInteger();
        int i = 0;
        while (i < func.getParameters().size()) {
            c.add();
            FunctionParameter param = (FunctionParameter)func.getParameters().get(i);
            DiscVariable var = param.getParameter();
            CifType ptype = var.getType();
            ExtJavaFuncCodeGenerator.gencodeCifToJava(ptype, ctxt.getFuncParamMethodParamName(var), Strings.fmt((String)"rslt[%d] = %%s;", (Object[])new Object[]{i}), nr, c, ctxt);
            ++i;
        }
        c.add();
        c.add("return rslt;");
        c.dedent();
        c.add("}");
    }

    private static void gencodeCifToJava(CifType type, String srcTxt, String tgtTxt, AtomicInteger nr, CodeBox c, CifCompilerContext ctxt) {
        if (type instanceof BoolType) {
            c.add(tgtTxt, new Object[]{srcTxt});
        } else if (type instanceof IntType) {
            c.add(tgtTxt, new Object[]{srcTxt});
        } else if (type instanceof TypeRef) {
            ExtJavaFuncCodeGenerator.gencodeCifToJava(((TypeRef)type).getType().getType(), srcTxt, tgtTxt, nr, c, ctxt);
        } else if (type instanceof RealType) {
            c.add(tgtTxt, new Object[]{srcTxt});
        } else if (type instanceof StringType) {
            c.add(tgtTxt, new Object[]{srcTxt});
        } else if (type instanceof ListType) {
            int listNr = nr.getAndIncrement();
            c.add("%s lst%d = new Array%s(%s.size());", new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), listNr, ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), srcTxt});
            int elemNr = nr.getAndIncrement();
            CifType etype = ((ListType)type).getElementType();
            c.add("for (%s elem%d: %s) {", new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt), elemNr, srcTxt});
            c.indent();
            ExtJavaFuncCodeGenerator.gencodeCifToJava(etype, "elem" + elemNr, Strings.fmt((String)"lst%d.add(%%s);", (Object[])new Object[]{listNr}), nr, c, ctxt);
            c.dedent();
            c.add("}");
            c.add(tgtTxt, new Object[]{"lst" + listNr});
        } else if (type instanceof SetType) {
            int setNr = nr.getAndIncrement();
            c.add("%s set%d = new LinkedHash%s(%s.size());", new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), setNr, ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), srcTxt});
            int elemNr = nr.getAndIncrement();
            CifType etype = ((SetType)type).getElementType();
            c.add("for (%s elem%d: %s) {", new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt), elemNr, srcTxt});
            c.indent();
            ExtJavaFuncCodeGenerator.gencodeCifToJava(etype, "elem" + elemNr, Strings.fmt((String)"set%d.add(%%s);", (Object[])new Object[]{setNr}), nr, c, ctxt);
            c.dedent();
            c.add("}");
            c.add(tgtTxt, new Object[]{"set" + setNr});
        } else if (type instanceof DictType) {
            int mapNr = nr.getAndIncrement();
            c.add("%s map%d = new LinkedHash%s(%s.size());", new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), mapNr, ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), srcTxt});
            int entryNr = nr.getAndIncrement();
            CifType ktype = ((DictType)type).getKeyType();
            CifType vtype = ((DictType)type).getValueType();
            c.add("for (Entry<%s, %s> entry%d: %s.entrySet()) {", new Object[]{TypeCodeGenerator.gencodeType(ktype, ctxt, true), TypeCodeGenerator.gencodeType(vtype, ctxt, true), entryNr, srcTxt});
            c.indent();
            int keyNr = nr.getAndIncrement();
            c.add("%s key%d;", new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(ktype, false), keyNr});
            ExtJavaFuncCodeGenerator.gencodeCifToJava(ktype, Strings.fmt((String)"entry%d.getKey()", (Object[])new Object[]{entryNr}), Strings.fmt((String)"key%d = %%s;", (Object[])new Object[]{keyNr}), nr, c, ctxt);
            int valueNr = nr.getAndIncrement();
            c.add("%s value%d;", new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(vtype, false), valueNr});
            ExtJavaFuncCodeGenerator.gencodeCifToJava(vtype, Strings.fmt((String)"entry%d.getValue()", (Object[])new Object[]{entryNr}), Strings.fmt((String)"value%d = %%s;", (Object[])new Object[]{valueNr}), nr, c, ctxt);
            c.add("map%d.put(key%d, value%d);", new Object[]{mapNr, keyNr, valueNr});
            c.dedent();
            c.add("}");
            c.add(tgtTxt, new Object[]{"map" + mapNr});
        } else if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            int tplNr = nr.getAndIncrement();
            c.add("%s tpl%d = new Array%s(%d);", new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), tplNr, ExtJavaFuncCodeGenerator.typeToJavaStr(type, false), ttype.getFields().size()});
            int i = 0;
            while (i < ttype.getFields().size()) {
                Field field = (Field)ttype.getFields().get(i);
                String fieldName = ctxt.getTupleTypeFieldFieldName(ttype, i);
                ExtJavaFuncCodeGenerator.gencodeCifToJava(field.getType(), String.valueOf(srcTxt) + "." + fieldName, Strings.fmt((String)"tpl%d.add(%%s);", (Object[])new Object[]{tplNr}), nr, c, ctxt);
                ++i;
            }
            c.add(tgtTxt, new Object[]{"tpl" + tplNr});
        } else {
            throw new RuntimeException("Unexpected type: " + type);
        }
    }

    private static void gencodeJavaToCif(ExternalFunction func, CifType retType, CodeBox c, CifCompilerContext ctxt) {
        c.add();
        c.add("private %s javaToCif(Object retValue) {", new Object[]{TypeCodeGenerator.gencodeType(retType, ctxt)});
        c.indent();
        c.add("%s rslt;", new Object[]{TypeCodeGenerator.gencodeType(retType, ctxt)});
        c.add();
        AtomicInteger nr = new AtomicInteger();
        ExtJavaFuncCodeGenerator.gencodeJavaToCif(retType, "retValue", "rslt = %s;", nr, c, ctxt);
        c.add();
        c.add("return rslt;");
        c.dedent();
        c.add("}");
    }

    private static void gencodeJavaToCif(CifType type, String srcTxt, String tgtTxt, AtomicInteger nr, CodeBox c, CifCompilerContext ctxt) {
        c.add("ExtFuncs.checkJavaNullReturn(%s);", new Object[]{srcTxt});
        if (type instanceof BoolType) {
            c.add("if (!(%s instanceof Boolean)) ExtFuncs.checkJavaRetTypeFailed(%s, Boolean.class);", new Object[]{srcTxt, srcTxt});
            c.add(tgtTxt, new Object[]{"(Boolean)" + srcTxt});
        } else if (type instanceof IntType) {
            c.add("if (!(%s instanceof Integer)) ExtFuncs.checkJavaRetTypeFailed(%s, Integer.class);", new Object[]{srcTxt, srcTxt});
            IntType itype = (IntType)type;
            if (!CifTypeUtils.isRangeless((IntType)itype)) {
                int lower = CifTypeUtils.getLowerBound((IntType)itype);
                int upper = CifTypeUtils.getUpperBound((IntType)itype);
                c.add("if ((Integer)%s < %d || %d < (Integer)%s) ExtFuncs.checkJavaIntRangeFailed((Integer)%s, %d, %d);", new Object[]{srcTxt, lower, upper, srcTxt, srcTxt, lower, upper});
            }
            c.add(tgtTxt, new Object[]{"(Integer)" + srcTxt});
        } else if (type instanceof TypeRef) {
            ExtJavaFuncCodeGenerator.gencodeJavaToCif(((TypeRef)type).getType().getType(), srcTxt, tgtTxt, nr, c, ctxt);
        } else if (type instanceof RealType) {
            c.add("if (!(%s instanceof Double)) ExtFuncs.checkJavaRetTypeFailed(%s, Double.class);", new Object[]{srcTxt, srcTxt});
            c.add("ExtFuncs.checkJavaDoubleReturn((Double)%s);", new Object[]{srcTxt});
            c.add(tgtTxt, new Object[]{"(Double)" + srcTxt});
        } else if (type instanceof StringType) {
            c.add("if (!(%s instanceof String)) ExtFuncs.checkJavaRetTypeFailed(%s, String.class);", new Object[]{srcTxt, srcTxt});
            c.add(tgtTxt, new Object[]{"(String)" + srcTxt});
        } else if (type instanceof ListType) {
            c.add("if (!(%s instanceof List)) ExtFuncs.checkJavaRetTypeFailed(%s, List.class);", new Object[]{srcTxt, srcTxt});
            ListType ltype = (ListType)type;
            if (!CifTypeUtils.isRangeless((ListType)ltype)) {
                int lower = CifTypeUtils.getLowerBound((ListType)ltype);
                int upper = CifTypeUtils.getUpperBound((ListType)ltype);
                c.add("if (((List<?>)%s).size() < %d || %d < ((List<?>)%s).size()) ExtFuncs.checkJavaListRangeFailed((List<?>)%s, %d, %d);", new Object[]{srcTxt, lower, upper, srcTxt, srcTxt, lower, upper});
            }
            int listNr = nr.getAndIncrement();
            c.add("%s lst%d = new Array%s(((List<?>)%s).size());", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), listNr, TypeCodeGenerator.gencodeType(type, ctxt), srcTxt});
            int elemNr = nr.getAndIncrement();
            CifType etype = ((ListType)type).getElementType();
            c.add("for (Object elem%d: (List<?>)%s) {", new Object[]{elemNr, srcTxt});
            c.indent();
            ExtJavaFuncCodeGenerator.gencodeJavaToCif(etype, "elem" + elemNr, Strings.fmt((String)"lst%d.add(%%s);", (Object[])new Object[]{listNr}), nr, c, ctxt);
            c.dedent();
            c.add("}");
            c.add(tgtTxt, new Object[]{"lst" + listNr});
        } else if (type instanceof SetType) {
            c.add("if (!(%s instanceof Set)) ExtFuncs.checkJavaRetTypeFailed(%s, Set.class);", new Object[]{srcTxt, srcTxt});
            int setNr = nr.getAndIncrement();
            c.add("%s set%d = new LinkedHash%s(((Set<?>)%s).size());", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), setNr, TypeCodeGenerator.gencodeType(type, ctxt), srcTxt});
            int elemNr = nr.getAndIncrement();
            CifType etype = ((SetType)type).getElementType();
            c.add("for (Object elem%d: (Set<?>)%s) {", new Object[]{elemNr, srcTxt});
            c.indent();
            ExtJavaFuncCodeGenerator.gencodeJavaToCif(etype, "elem" + elemNr, Strings.fmt((String)"set%d.add(%%s);", (Object[])new Object[]{setNr}), nr, c, ctxt);
            c.dedent();
            c.add("}");
            c.add(tgtTxt, new Object[]{"set" + setNr});
        } else if (type instanceof DictType) {
            c.add("if (!(%s instanceof Map)) ExtFuncs.checkJavaRetTypeFailed(%s, Map.class);", new Object[]{srcTxt, srcTxt});
            int mapNr = nr.getAndIncrement();
            c.add("%s map%d = new LinkedHash%s(((Map<?, ?>)%s).size());", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), mapNr, TypeCodeGenerator.gencodeType(type, ctxt), srcTxt});
            int entryNr = nr.getAndIncrement();
            CifType ktype = ((DictType)type).getKeyType();
            CifType vtype = ((DictType)type).getValueType();
            c.add("for (Entry<?, ?> entry%d: ((Map<?, ?>)%s).entrySet()) {", new Object[]{entryNr, srcTxt});
            c.indent();
            int keyNr = nr.getAndIncrement();
            c.add("%s key%d;", new Object[]{TypeCodeGenerator.gencodeType(ktype, ctxt), keyNr});
            ExtJavaFuncCodeGenerator.gencodeJavaToCif(ktype, Strings.fmt((String)"entry%d.getKey()", (Object[])new Object[]{entryNr}), Strings.fmt((String)"key%d = %%s;", (Object[])new Object[]{keyNr}), nr, c, ctxt);
            c.add();
            int valueNr = nr.getAndIncrement();
            c.add("%s value%d;", new Object[]{TypeCodeGenerator.gencodeType(vtype, ctxt), valueNr});
            ExtJavaFuncCodeGenerator.gencodeJavaToCif(vtype, Strings.fmt((String)"entry%d.getValue()", (Object[])new Object[]{entryNr}), Strings.fmt((String)"value%d = %%s;", (Object[])new Object[]{valueNr}), nr, c, ctxt);
            c.add("map%d.put(key%d, value%d);", new Object[]{mapNr, keyNr, valueNr});
            c.dedent();
            c.add("}");
            c.add(tgtTxt, new Object[]{"map" + mapNr});
        } else if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            c.add("if (!(%s instanceof List)) ExtFuncs.checkJavaRetTypeFailed(%s, List.class);", new Object[]{srcTxt, srcTxt});
            int tplJavaNr = nr.getAndIncrement();
            c.add("List<?> tplJava%d = (List<?>)%s;", new Object[]{tplJavaNr, srcTxt});
            c.add("if (tplJava%d.size() != %d) throw new CifSimulatorException(fmt(\"The return value of the external Java function contains a list of size %%d, for a tuple with %d fields.\", tplJava%d.size()));", new Object[]{tplJavaNr, ttype.getFields().size(), ttype.getFields().size(), tplJavaNr});
            StringBuilder constructorArgs = new StringBuilder();
            int i = 0;
            while (i < ttype.getFields().size()) {
                Field field = (Field)ttype.getFields().get(i);
                int fldJavaNr = nr.getAndIncrement();
                c.add("Object fldJava%d = tplJava%d.get(%d);", new Object[]{fldJavaNr, tplJavaNr, i});
                int fldCifNr = nr.getAndIncrement();
                c.add("%s fldCif%d;", new Object[]{TypeCodeGenerator.gencodeType(field.getType(), ctxt), fldCifNr});
                if (constructorArgs.length() > 0) {
                    constructorArgs.append(", ");
                }
                constructorArgs.append("fldCif" + fldCifNr);
                ExtJavaFuncCodeGenerator.gencodeJavaToCif(field.getType(), "fldJava" + fldJavaNr, Strings.fmt((String)"fldCif%d = %%s;", (Object[])new Object[]{fldCifNr}), nr, c, ctxt);
                c.add();
                ++i;
            }
            int tplCifNr = nr.getAndIncrement();
            c.add("%s tplCif%d = new %s(%s);", new Object[]{TypeCodeGenerator.gencodeType(type, ctxt), tplCifNr, TypeCodeGenerator.gencodeType(type, ctxt), constructorArgs.toString()});
            c.add(tgtTxt, new Object[]{"tplCif" + tplCifNr});
        } else {
            throw new RuntimeException("Unexpected type: " + type);
        }
    }

    private static String typeToJavaStr(CifType type, boolean generic) {
        if (type instanceof BoolType) {
            return generic ? "Boolean" : "boolean";
        }
        if (type instanceof IntType) {
            return generic ? "Integer" : "int";
        }
        if (type instanceof TypeRef) {
            return ExtJavaFuncCodeGenerator.typeToJavaStr(((TypeRef)type).getType().getType(), generic);
        }
        if (type instanceof RealType) {
            return generic ? "Double" : "double";
        }
        if (type instanceof StringType) {
            return "String";
        }
        if (type instanceof ListType) {
            CifType etype = ((ListType)type).getElementType();
            return Strings.fmt((String)"List<%s>", (Object[])new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(etype, true)});
        }
        if (type instanceof SetType) {
            CifType etype = ((SetType)type).getElementType();
            return Strings.fmt((String)"Set<%s>", (Object[])new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(etype, true)});
        }
        if (type instanceof DictType) {
            CifType ktype = ((DictType)type).getKeyType();
            CifType vtype = ((DictType)type).getValueType();
            return Strings.fmt((String)"Map<%s, %s>", (Object[])new Object[]{ExtJavaFuncCodeGenerator.typeToJavaStr(ktype, true), ExtJavaFuncCodeGenerator.typeToJavaStr(vtype, true)});
        }
        if (type instanceof TupleType) {
            return "List<Object>";
        }
        throw new RuntimeException("Unexpected type: " + type);
    }

    private static String typeToJavaClsStr(CifType type, boolean generic) {
        if (type instanceof BoolType) {
            return generic ? "Boolean.class" : "boolean.class";
        }
        if (type instanceof IntType) {
            return generic ? "Integer.class" : "int.class";
        }
        if (type instanceof TypeRef) {
            return ExtJavaFuncCodeGenerator.typeToJavaClsStr(((TypeRef)type).getType().getType(), generic);
        }
        if (type instanceof RealType) {
            return generic ? "Double.class" : "double.class";
        }
        if (type instanceof StringType) {
            return "String.class";
        }
        if (type instanceof ListType) {
            return "List.class";
        }
        if (type instanceof SetType) {
            return "Set.class";
        }
        if (type instanceof DictType) {
            return "Map.class";
        }
        if (type instanceof TupleType) {
            return "List.class";
        }
        throw new RuntimeException("Unexpected type: " + type);
    }
}

