/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.multivaluetrees;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.multivaluetrees.VarInfo;

public class Node {
    public static final int ONE_LEVEL = -2;
    public static final int ZERO_LEVEL = -1;
    public final VarInfo varInfo;
    public final Node[] childs;

    Node(VarInfo varInfo, Node[] childs) {
        this.varInfo = varInfo;
        this.childs = childs;
        Assert.check((varInfo.length == childs.length ? 1 : 0) != 0);
    }

    public void dumpGraphLines(String nodeName) {
        List lines = Lists.list((Object[])new String[]{null, null});
        Map mappedNodes = Maps.map();
        mappedNodes.put(Tree.ZERO, ".");
        mappedNodes.put(Tree.ONE, "T");
        String rootNodeName = this.constructGraphLines(mappedNodes, lines);
        OutputProvider.dbg((String)"%s: node %s", (Object[])new Object[]{nodeName, rootNodeName});
        OutputProvider.idbg();
        for (String line : lines) {
            if (line == null) continue;
            OutputProvider.dbg((String)line);
        }
        OutputProvider.ddbg();
    }

    private String constructGraphLines(Map<Node, String> mappedNodes, List<String> lines) {
        String myName = mappedNodes.get(this);
        if (myName != null) {
            return myName;
        }
        int myLine = lines.size();
        lines.add(null);
        myName = String.valueOf(myLine);
        mappedNodes.put(this, myName);
        List childNodeNames = Lists.listc((int)this.varInfo.length);
        Node[] nodeArray = this.childs;
        int n = this.childs.length;
        int n2 = 0;
        while (n2 < n) {
            Node child = nodeArray[n2];
            childNodeNames.add(child.constructGraphLines(mappedNodes, lines));
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(myName);
        sb.append("=");
        sb.append(this.varInfo.toString());
        sb.append(", children=[");
        int i = 0;
        while (i < childNodeNames.size()) {
            if (i > 0) {
                sb.append(' ');
            }
            if (this.varInfo.length > 6) {
                sb.append(i + this.varInfo.lower);
                sb.append("=");
            }
            sb.append((String)childNodeNames.get(i));
            ++i;
        }
        sb.append("]");
        lines.set(myLine, sb.toString());
        return myName;
    }

    public Boolean evaluate(Map<VarInfo, Integer> valuation) {
        Node curNode = this;
        while (!curNode.equals(Tree.ONE)) {
            if (curNode.equals(Tree.ZERO)) {
                return false;
            }
            VarInfo variable = curNode.varInfo;
            Integer value = valuation.get(variable);
            if (value == null) {
                throw new RuntimeException("No value in valuation for: " + variable);
            }
            int index = value - this.varInfo.lower;
            curNode = curNode.childs[index];
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        Node otherNode = (Node)other;
        if (this.varInfo != otherNode.varInfo) {
            return false;
        }
        if (this.childs.length != otherNode.childs.length) {
            return false;
        }
        int i = 0;
        while (i < this.childs.length) {
            if (this.childs[i] != otherNode.childs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = this.varInfo.level;
        if (this.childs != null) {
            Node[] nodeArray = this.childs;
            int n = this.childs.length;
            int n2 = 0;
            while (n2 < n) {
                Node c = nodeArray[n2];
                h = h * 3 + c.varInfo.level;
                ++n2;
            }
        }
        return h;
    }

    public String toString() {
        if (this.varInfo.level == -2) {
            return "*TRUE*";
        }
        if (this.varInfo.level == -1) {
            return "*FALSE*";
        }
        return Strings.fmt((String)"Node(level=%d, var=%s)", (Object[])new Object[]{this.varInfo.level, this.varInfo});
    }
}

