/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.dsm.BusDetectionAlgorithm;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.Strings;

public class ClusterInputData {
    public final RealMatrix adjacencies;
    public final Label[] labels;
    public double evap;
    public int stepCount;
    public double inflation;
    public double epsilon;
    public BusDetectionAlgorithm busDetectionAlgorithm;
    public double busInclusion;

    public ClusterInputData(RealMatrix adjacencies, Label[] labels) {
        this(adjacencies, labels, 2.5, 2, 2.5, 1.0E-4, BusDetectionAlgorithm.NO_BUS, 2.0);
    }

    public ClusterInputData(RealMatrix adjacencies, Label[] labels, double evap, int stepCount, double inflation, double epsilon, BusDetectionAlgorithm busDetectionAlgorithm, double busInclusion) {
        this.adjacencies = adjacencies;
        this.labels = labels;
        this.evap = evap;
        this.stepCount = stepCount;
        this.inflation = inflation;
        this.epsilon = epsilon;
        this.busDetectionAlgorithm = busDetectionAlgorithm;
        this.setBusInclusionFactor(busInclusion);
    }

    public void setBusInclusionFactor(double newValue) {
        switch (this.busDetectionAlgorithm) {
            case NO_BUS: {
                this.busInclusion = newValue;
                break;
            }
            case FIX_POINT: {
                if (newValue >= 1.0 && newValue <= 4.0) {
                    this.busInclusion = newValue;
                    break;
                }
                String msg = Strings.fmt((String)"Bus factor values for the fixed-point algorithm are only allowed to be between 1.0 and 4.0 (including the boundaries). The supplied value of %f is outside this interval.", (Object[])new Object[]{newValue});
                throw new InvalidInputException(msg);
            }
            case TOP_K: {
                newValue = (int)newValue;
                if (newValue >= 0.0 && newValue <= (double)this.adjacencies.getRowDimension()) {
                    this.busInclusion = newValue;
                    break;
                }
                String msg = Strings.fmt((String)"Bus factor values for the top-k algorithm are only allowed to be between 0 and the number of elements of the DSM (which is %d in this case). The supplied value of %f is outside this interval.", (Object[])new Object[]{this.adjacencies.getRowDimension(), newValue});
                throw new InvalidInputException(msg);
            }
            default: {
                String msg = Strings.fmt((String)"Unsupported bus detection algorithm encountered: %s.", (Object[])new Object[]{this.busDetectionAlgorithm});
                throw new UnsupportedException(msg);
            }
        }
    }
}

