/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.dsm.BusComputing;
import org.eclipse.escet.common.dsm.BusDetectionAlgorithm;
import org.eclipse.escet.common.dsm.ClusterComputing;
import org.eclipse.escet.common.dsm.ClusterInputData;
import org.eclipse.escet.common.dsm.Dsm;
import org.eclipse.escet.common.dsm.DsmHelper;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.dsm.MatrixHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;

public class DsmClustering {
    private DsmClustering() {
    }

    public static Dsm flowBasedMarkovClustering(ClusterInputData inputData) {
        return DsmClustering.flowBasedMarkovClustering(inputData.adjacencies, inputData.labels, inputData.evap, inputData.stepCount, inputData.inflation, inputData.epsilon, inputData.busDetectionAlgorithm, inputData.busInclusion);
    }

    public static Dsm flowBasedMarkovClustering(RealMatrix adjacencies, Label[] labels, double evap, int stepCount, double inflation, double epsilon, BusDetectionAlgorithm busDetectionAlgorithm, double busInclusion) {
        int size = adjacencies.getRowDimension();
        OutputProvider.dbg((String)"Flow-based Markov clustering for %d nodes.", (Object[])new Object[]{size});
        List groups = Lists.list();
        RealMatrix adjacenciesOriginal = adjacencies.copy();
        MatrixHelper.clearDiagonal(adjacencies);
        BitSet potentionalBusNodes = BitSets.ones((int)size);
        BitSet busNodes = new BitSet();
        switch (busDetectionAlgorithm) {
            case NO_BUS: {
                break;
            }
            case FIX_POINT: {
                busNodes = BusComputing.computeFixPointBus(adjacencies, busInclusion, potentionalBusNodes);
                break;
            }
            case TOP_K: {
                busNodes = BusComputing.computeTopKBus(adjacencies, busInclusion, potentionalBusNodes);
            }
        }
        Group busGroup = ClusterComputing.hierarchicalClustering(adjacencies, busNodes, evap, stepCount, inflation, epsilon, Group.GroupType.BUS);
        if (busGroup != null) {
            OutputProvider.dbg((String)"Bus-group found:");
            busGroup.dbgDump("  ");
            Assert.implies((busGroup.childGroups.size() == 1 ? 1 : 0) != 0, (busGroup.localNodes != null ? 1 : 0) != 0);
            groups.add(busGroup);
        } else {
            OutputProvider.dbg((String)"No bus found.");
        }
        BitSet nonbusNodes = BitSets.ones((int)size);
        nonbusNodes.andNot(busNodes);
        Group nonbusGroup = ClusterComputing.hierarchicalClustering(adjacencies, nonbusNodes, evap, stepCount, inflation, epsilon, Group.GroupType.CLUSTER);
        if (nonbusGroup != null) {
            OutputProvider.dbg((String)"Clustering-group found:");
            nonbusGroup.dbgDump("  ");
            Assert.implies((nonbusGroup.childGroups.size() == 1 ? 1 : 0) != 0, (nonbusGroup.localNodes != null ? 1 : 0) != 0);
            groups.add(nonbusGroup);
        } else {
            OutputProvider.dbg((String)"No clustering found.");
        }
        if (groups.isEmpty()) {
            return null;
        }
        Group rootGroup = groups.size() == 1 ? (Group)Lists.first((List)groups) : new Group(Group.GroupType.COLLECTION, null, groups);
        Dsm dsm = DsmClustering.shuffleNodes(adjacenciesOriginal, labels, rootGroup);
        OutputProvider.dbg((String)"Shuffled nodes of groups near each other:");
        dsm.rootGroup.dbgDump("  ");
        return dsm;
    }

    private static Dsm shuffleNodes(RealMatrix adjacencies, Label[] labels, Group rootGroup) {
        int[] nodeShuffle = DsmClustering.computeShuffle(rootGroup);
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Node mapping new <- original:");
            int i = 0;
            while (i < nodeShuffle.length) {
                OutputProvider.dbg((String)"  %d <- %d", (Object[])new Object[]{i, nodeShuffle[i]});
                ++i;
            }
            OutputProvider.dbg();
        }
        adjacencies = DsmClustering.shuffleMatrix(nodeShuffle, adjacencies);
        labels = DsmHelper.shuffleArray(labels, nodeShuffle);
        return new Dsm(nodeShuffle, adjacencies, labels, rootGroup);
    }

    private static int[] computeShuffle(Group group) {
        int size = group.members.cardinality();
        int[] nodeShuffle = new int[size];
        Arrays.fill(nodeShuffle, -1);
        int nextFree = DsmClustering.assignGroups(nodeShuffle, 0, group);
        Assert.check((nextFree == size ? 1 : 0) != 0);
        int i = 0;
        while (i < size) {
            Assert.check((nodeShuffle[i] >= 0 ? 1 : 0) != 0);
            ++i;
        }
        return nodeShuffle;
    }

    private static int assignGroups(int[] nodeShuffle, int base, Group group) {
        group.setShuffledBase(base);
        Collections.sort(group.childGroups, GroupComparator.COMPARATOR);
        for (Group child : group.childGroups) {
            int nextFree = DsmClustering.assignGroups(nodeShuffle, base, child);
            Assert.check((base + child.members.cardinality() == nextFree ? 1 : 0) != 0);
            base = nextFree;
        }
        if (group.localNodes != null) {
            Iterator<Group> iterator = BitSets.iterateTrueBits((BitSet)group.localNodes).iterator();
            while (iterator.hasNext()) {
                int i;
                nodeShuffle[base] = i = ((Integer)((Object)iterator.next())).intValue();
                ++base;
            }
        }
        return base;
    }

    private static RealMatrix shuffleMatrix(int[] nodeShuffle, RealMatrix adjacencies) {
        int size = nodeShuffle.length;
        Assert.check((adjacencies.getColumnDimension() == size ? 1 : 0) != 0);
        Assert.check((adjacencies.getRowDimension() == size ? 1 : 0) != 0);
        BlockRealMatrix result = new BlockRealMatrix(size, size);
        int i = 0;
        while (i < size) {
            int origRow = nodeShuffle[i];
            int j = 0;
            while (j < size) {
                result.setEntry(i, j, adjacencies.getEntry(origRow, nodeShuffle[j]));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static class GroupComparator
    implements Comparator<Group> {
        public static final GroupComparator COMPARATOR = new GroupComparator();

        private GroupComparator() {
        }

        @Override
        public int compare(Group g1, Group g2) {
            boolean g1Bus = g1.groupType.equals((Object)Group.GroupType.BUS);
            boolean g2Bus = g2.groupType.equals((Object)Group.GroupType.BUS);
            if (g1Bus && !g2Bus) {
                return -1;
            }
            if (!g1Bus && g2Bus) {
                return 1;
            }
            return Integer.compare(g1.members.cardinality(), g2.members.cardinality());
        }
    }
}

