/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValidationUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.expressions.ABinaryExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ABoolExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ACastExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ADictExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ADictPair;
import org.eclipse.escet.cif.parser.ast.expressions.AElifExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AEmptySetDictExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AFuncCallExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AIfExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AIntExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AListExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ANameExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AProjectionExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ARealExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AReceivedExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ASelfExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ASetExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ASliceExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AStdLibFunctionExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AStringExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ASwitchCase;
import org.eclipse.escet.cif.parser.ast.expressions.ASwitchExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ATauExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ATimeExpression;
import org.eclipse.escet.cif.parser.ast.expressions.ATupleExpression;
import org.eclipse.escet.cif.parser.ast.expressions.AUnaryExpression;
import org.eclipse.escet.cif.typechecker.CifFormatPatternChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.ExprContext;
import org.eclipse.escet.cif.typechecker.SourceFile;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.declwrap.EnumDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FormalEventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InvDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.TypeDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.AutScope;
import org.eclipse.escet.cif.typechecker.scopes.CompInstScope;
import org.eclipse.escet.cif.typechecker.scopes.CompParamScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SpecScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.common.typechecker.SemanticProblem;

public class CifExprsTypeChecker {
    public static final CifType NO_TYPE_HINT = null;
    public static final BoolType BOOL_TYPE_HINT = CifConstructors.newBoolType();
    public static final IntType INT_TYPE_HINT = CifConstructors.newIntType();
    public static final RealType REAL_TYPE_HINT = CifConstructors.newRealType();
    public static final StringType STRING_TYPE_HINT = CifConstructors.newStringType();
    private static final Map<String, UnaryOperator> UNOP_MAP = Maps.map();
    private static final Map<String, BinaryOperator> BINOP_MAP;
    private static final Map<String, StdLibFunction> FUNC_MAP;
    public static final int[][] POW_RANGES;

    static {
        UNOP_MAP.put("not", UnaryOperator.INVERSE);
        UNOP_MAP.put("-", UnaryOperator.NEGATE);
        UNOP_MAP.put("+", UnaryOperator.PLUS);
        UNOP_MAP.put("sample", UnaryOperator.SAMPLE);
        BINOP_MAP = Maps.map();
        BINOP_MAP.put("=>", BinaryOperator.IMPLICATION);
        BINOP_MAP.put("<=>", BinaryOperator.BI_CONDITIONAL);
        BINOP_MAP.put("or", BinaryOperator.DISJUNCTION);
        BINOP_MAP.put("and", BinaryOperator.CONJUNCTION);
        BINOP_MAP.put("<", BinaryOperator.LESS_THAN);
        BINOP_MAP.put("<=", BinaryOperator.LESS_EQUAL);
        BINOP_MAP.put(">", BinaryOperator.GREATER_THAN);
        BINOP_MAP.put(">=", BinaryOperator.GREATER_EQUAL);
        BINOP_MAP.put("=", BinaryOperator.EQUAL);
        BINOP_MAP.put("!=", BinaryOperator.UNEQUAL);
        BINOP_MAP.put("+", BinaryOperator.ADDITION);
        BINOP_MAP.put("-", BinaryOperator.SUBTRACTION);
        BINOP_MAP.put("*", BinaryOperator.MULTIPLICATION);
        BINOP_MAP.put("/", BinaryOperator.DIVISION);
        BINOP_MAP.put("div", BinaryOperator.INTEGER_DIVISION);
        BINOP_MAP.put("mod", BinaryOperator.MODULUS);
        BINOP_MAP.put("sub", BinaryOperator.SUBSET);
        BINOP_MAP.put("in", BinaryOperator.ELEMENT_OF);
        FUNC_MAP = Maps.map();
        FUNC_MAP.put("acos", StdLibFunction.ACOS);
        FUNC_MAP.put("acosh", StdLibFunction.ACOSH);
        FUNC_MAP.put("asin", StdLibFunction.ASIN);
        FUNC_MAP.put("asinh", StdLibFunction.ASINH);
        FUNC_MAP.put("atan", StdLibFunction.ATAN);
        FUNC_MAP.put("atanh", StdLibFunction.ATANH);
        FUNC_MAP.put("cos", StdLibFunction.COS);
        FUNC_MAP.put("cosh", StdLibFunction.COSH);
        FUNC_MAP.put("sin", StdLibFunction.SIN);
        FUNC_MAP.put("sinh", StdLibFunction.SINH);
        FUNC_MAP.put("tan", StdLibFunction.TAN);
        FUNC_MAP.put("tanh", StdLibFunction.TANH);
        FUNC_MAP.put("abs", StdLibFunction.ABS);
        FUNC_MAP.put("cbrt", StdLibFunction.CBRT);
        FUNC_MAP.put("ceil", StdLibFunction.CEIL);
        FUNC_MAP.put("del", StdLibFunction.DELETE);
        FUNC_MAP.put("empty", StdLibFunction.EMPTY);
        FUNC_MAP.put("exp", StdLibFunction.EXP);
        FUNC_MAP.put("floor", StdLibFunction.FLOOR);
        FUNC_MAP.put("fmt", StdLibFunction.FORMAT);
        FUNC_MAP.put("ln", StdLibFunction.LN);
        FUNC_MAP.put("log", StdLibFunction.LOG);
        FUNC_MAP.put("max", StdLibFunction.MAXIMUM);
        FUNC_MAP.put("min", StdLibFunction.MINIMUM);
        FUNC_MAP.put("pop", StdLibFunction.POP);
        FUNC_MAP.put("pow", StdLibFunction.POWER);
        FUNC_MAP.put("round", StdLibFunction.ROUND);
        FUNC_MAP.put("scale", StdLibFunction.SCALE);
        FUNC_MAP.put("sign", StdLibFunction.SIGN);
        FUNC_MAP.put("size", StdLibFunction.SIZE);
        FUNC_MAP.put("sqrt", StdLibFunction.SQRT);
        FUNC_MAP.put("bernoulli", StdLibFunction.BERNOULLI);
        FUNC_MAP.put("beta", StdLibFunction.BETA);
        FUNC_MAP.put("binomial", StdLibFunction.BINOMIAL);
        FUNC_MAP.put("constant", StdLibFunction.CONSTANT);
        FUNC_MAP.put("erlang", StdLibFunction.ERLANG);
        FUNC_MAP.put("exponential", StdLibFunction.EXPONENTIAL);
        FUNC_MAP.put("gamma", StdLibFunction.GAMMA);
        FUNC_MAP.put("geometric", StdLibFunction.GEOMETRIC);
        FUNC_MAP.put("lognormal", StdLibFunction.LOG_NORMAL);
        FUNC_MAP.put("normal", StdLibFunction.NORMAL);
        FUNC_MAP.put("poisson", StdLibFunction.POISSON);
        FUNC_MAP.put("random", StdLibFunction.RANDOM);
        FUNC_MAP.put("triangle", StdLibFunction.TRIANGLE);
        FUNC_MAP.put("uniform", StdLibFunction.UNIFORM);
        FUNC_MAP.put("weibull", StdLibFunction.WEIBULL);
        POW_RANGES = new int[][]{{2, -46340, 46340}, {3, -1290, 1290}, {4, -215, 215}, {5, -73, 73}, {6, -35, 35}, {7, -21, 21}, {8, -14, 14}, {9, -10, 10}, {10, -8, 8}, {11, -7, 7}, {12, -5, 5}, {13, -5, 5}, {14, -4, 4}, {15, -4, 4}, {16, -3, 3}, {17, -3, 3}, {18, -3, 3}, {19, -3, 3}, {20, -2, 2}, {21, -2, 2}, {22, -2, 2}, {23, -2, 2}, {24, -2, 2}, {25, -2, 2}, {26, -2, 2}, {27, -2, 2}, {28, -2, 2}, {29, -2, 2}, {30, -2, 2}, {31, -2, 1}};
    }

    private CifExprsTypeChecker() {
    }

    public static boolean checkStaticEvaluable(Expression expr, CifTypeChecker tchecker) {
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof TimeExpression) {
            if (tchecker == null) {
                return false;
            }
            tchecker.addProblem(ErrMsg.STATIC_EVAL_TIME, expr.getPosition(), new String[0]);
            throw new SemanticException();
        }
        if (expr instanceof CastExpression) {
            CastExpression cexpr = (CastExpression)expr;
            return CifExprsTypeChecker.checkStaticEvaluable(cexpr.getChild(), tchecker);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            if (uexpr.getOperator() == UnaryOperator.SAMPLE) {
                if (tchecker == null) {
                    return false;
                }
                tchecker.addProblem(ErrMsg.STATIC_EVAL_SAMPLE, expr.getPosition(), new String[0]);
                throw new SemanticException();
            }
            return CifExprsTypeChecker.checkStaticEvaluable(uexpr.getChild(), tchecker);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            if (!CifExprsTypeChecker.checkStaticEvaluable(bexpr.getLeft(), tchecker)) {
                return false;
            }
            return CifExprsTypeChecker.checkStaticEvaluable(bexpr.getRight(), tchecker);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            for (Expression guard : ifExpr.getGuards()) {
                if (CifExprsTypeChecker.checkStaticEvaluable(guard, tchecker)) continue;
                return false;
            }
            if (!CifExprsTypeChecker.checkStaticEvaluable(ifExpr.getThen(), tchecker)) {
                return false;
            }
            for (ElifExpression elif : ifExpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    if (CifExprsTypeChecker.checkStaticEvaluable(guard, tchecker)) continue;
                    return false;
                }
                if (CifExprsTypeChecker.checkStaticEvaluable(elif.getThen(), tchecker)) continue;
                return false;
            }
            return CifExprsTypeChecker.checkStaticEvaluable(ifExpr.getElse(), tchecker);
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            if (!CifExprsTypeChecker.checkStaticEvaluable(switchExpr.getValue(), tchecker)) {
                return false;
            }
            for (SwitchCase cse : switchExpr.getCases()) {
                if (cse.getKey() != null && !CifExprsTypeChecker.checkStaticEvaluable(cse.getKey(), tchecker)) {
                    return false;
                }
                if (CifExprsTypeChecker.checkStaticEvaluable(cse.getValue(), tchecker)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            if (!CifExprsTypeChecker.checkStaticEvaluable(pexpr.getChild(), tchecker)) {
                return false;
            }
            if (pexpr.getIndex() instanceof FieldExpression) {
                return true;
            }
            return CifExprsTypeChecker.checkStaticEvaluable(pexpr.getIndex(), tchecker);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            if (!CifExprsTypeChecker.checkStaticEvaluable(sexpr.getChild(), tchecker)) {
                return false;
            }
            if (sexpr.getBegin() != null && !CifExprsTypeChecker.checkStaticEvaluable(sexpr.getBegin(), tchecker)) {
                return false;
            }
            return sexpr.getEnd() == null || CifExprsTypeChecker.checkStaticEvaluable(sexpr.getEnd(), tchecker);
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            if (fcexpr.getFunction() instanceof StdLibFunctionExpression) {
                StdLibFunctionExpression stdlib = (StdLibFunctionExpression)fcexpr.getFunction();
                StdLibFunction func = stdlib.getFunction();
                if (CifTypeUtils.isDistFunction((StdLibFunction)func)) {
                    if (tchecker == null) {
                        return false;
                    }
                    tchecker.addProblem(ErrMsg.STATIC_EVAL_DIST, expr.getPosition(), CifTextUtils.functionToStr((StdLibFunction)func));
                    throw new SemanticException();
                }
            } else {
                if (tchecker == null) {
                    return false;
                }
                Expression fexpr = fcexpr.getFunction();
                tchecker.addProblem(ErrMsg.STATIC_EVAL_FCALL_USER_DEF_FUNC, expr.getPosition(), CifTextUtils.exprToStr((Expression)fexpr));
                throw new SemanticException();
            }
            for (Expression param : fcexpr.getParams()) {
                if (CifExprsTypeChecker.checkStaticEvaluable(param, tchecker)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifExprsTypeChecker.checkStaticEvaluable(elem, tchecker)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifExprsTypeChecker.checkStaticEvaluable(elem, tchecker)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression elem : texpr.getFields()) {
                if (CifExprsTypeChecker.checkStaticEvaluable(elem, tchecker)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifExprsTypeChecker.checkStaticEvaluable(pair.getKey(), tchecker)) {
                    return false;
                }
                if (CifExprsTypeChecker.checkStaticEvaluable(pair.getValue(), tchecker)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ConstantExpression) {
            return true;
        }
        if (expr instanceof DiscVariableExpression) {
            String varTypeText;
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            EObject parent = var.eContainer();
            if (parent instanceof ComplexComponent) {
                varTypeText = "discrete variable";
            } else if (parent instanceof InternalFunction) {
                varTypeText = "variable";
            } else if (parent instanceof FunctionParameter) {
                varTypeText = "function parameter";
            } else {
                String msg = "Unknown disc var parent: " + parent;
                throw new RuntimeException(msg);
            }
            if (tchecker == null) {
                return false;
            }
            tchecker.addProblem(ErrMsg.STATIC_EVAL_DISC_VAR, expr.getPosition(), varTypeText, CifTextUtils.getAbsName((PositionObject)var));
            throw new SemanticException();
        }
        if (expr instanceof AlgVariableExpression) {
            if (tchecker == null) {
                return false;
            }
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            tchecker.addProblem(ErrMsg.STATIC_EVAL_ALG_VAR, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)var));
            throw new SemanticException();
        }
        if (expr instanceof ContVariableExpression) {
            if (tchecker == null) {
                return false;
            }
            ContVariableExpression cvexpr = (ContVariableExpression)expr;
            ContVariable cvar = cvexpr.getVariable();
            String derTxt = cvexpr.isDerivative() ? "the derivative of " : "";
            tchecker.addProblem(ErrMsg.STATIC_EVAL_CONT_VAR, expr.getPosition(), derTxt, CifTextUtils.getAbsName((PositionObject)cvar));
            throw new SemanticException();
        }
        if (expr instanceof TauExpression) {
            throw new RuntimeException("Tau is not relevant for static eval.");
        }
        if (expr instanceof LocationExpression) {
            if (tchecker == null) {
                return false;
            }
            Location loc = ((LocationExpression)expr).getLocation();
            tchecker.addProblem(ErrMsg.STATIC_EVAL_LOC, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)loc));
            throw new SemanticException();
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event is not relevant for static eval.");
        }
        if (expr instanceof FieldExpression) {
            String msg = "Unexpected field expr: proj expr should handle it.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            return true;
        }
        if (expr instanceof FunctionExpression) {
            return true;
        }
        if (expr instanceof InputVariableExpression) {
            if (tchecker == null) {
                return false;
            }
            InputVariable var = ((InputVariableExpression)expr).getVariable();
            tchecker.addProblem(ErrMsg.STATIC_EVAL_INPUT_VAR, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)var));
            throw new SemanticException();
        }
        if (expr instanceof ComponentExpression) {
            if (tchecker == null) {
                return false;
            }
            Component comp = ((ComponentExpression)expr).getComponent();
            Automaton aut = CifScopeUtils.getAutomaton((Component)comp);
            tchecker.addProblem(ErrMsg.STATIC_EVAL_AUT_REF, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)aut));
            throw new SemanticException();
        }
        if (expr instanceof CompParamExpression) {
            if (tchecker == null) {
                return false;
            }
            ComponentParameter compParam = ((CompParamExpression)expr).getParameter();
            tchecker.addProblem(ErrMsg.STATIC_EVAL_COMP_PARAM, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)compParam));
            throw new SemanticException();
        }
        if (expr instanceof CompInstWrapExpression) {
            Expression rexpr = ((CompInstWrapExpression)expr).getReference();
            return CifExprsTypeChecker.checkStaticEvaluable(rexpr, tchecker);
        }
        if (expr instanceof CompParamWrapExpression) {
            Expression rexpr = ((CompParamWrapExpression)expr).getReference();
            return CifExprsTypeChecker.checkStaticEvaluable(rexpr, tchecker);
        }
        if (expr instanceof ReceivedExpression) {
            if (tchecker == null) {
                return false;
            }
            tchecker.addProblem(ErrMsg.STATIC_EVAL_RCV_VALUE, expr.getPosition(), new String[0]);
            throw new SemanticException();
        }
        if (expr instanceof SelfExpression) {
            if (tchecker == null) {
                return false;
            }
            tchecker.addProblem(ErrMsg.STATIC_EVAL_SELF, expr.getPosition(), new String[0]);
            throw new SemanticException();
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    public static Pair<Expression, List<SemanticProblem>> postTransExpression(AExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker, SourceFile sourceFile) {
        List problems;
        Expression rslt;
        block9: {
            tchecker.preparePostUse();
            if (sourceFile != null) {
                tchecker.sourceFiles.add(sourceFile);
            }
            rslt = null;
            try {
                try {
                    rslt = CifExprsTypeChecker.transExpression(expr, hint, scope, context, tchecker);
                }
                catch (SemanticException semanticException) {
                    problems = tchecker.finalizePostUse();
                    if (sourceFile != null) {
                        tchecker.sourceFiles.remove(sourceFile);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                List problems2 = tchecker.finalizePostUse();
                if (sourceFile != null) {
                    tchecker.sourceFiles.remove(sourceFile);
                }
                throw throwable;
            }
            problems = tchecker.finalizePostUse();
            if (sourceFile != null) {
                tchecker.sourceFiles.remove(sourceFile);
            }
        }
        return Pair.pair((Object)rslt, (Object)problems);
    }

    public static Expression transExpression(AExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        if (expr instanceof ABoolExpression) {
            return CifExprsTypeChecker.transBoolExpression((ABoolExpression)expr, hint, scope);
        }
        if (expr instanceof AIntExpression) {
            return CifExprsTypeChecker.transIntExpression((AIntExpression)expr, hint, scope, tchecker);
        }
        if (expr instanceof ARealExpression) {
            return CifExprsTypeChecker.transRealExpression((ARealExpression)expr, hint, scope, tchecker);
        }
        if (expr instanceof AStringExpression) {
            return CifExprsTypeChecker.transStringExpression((AStringExpression)expr, hint, scope);
        }
        if (expr instanceof ATimeExpression) {
            return CifExprsTypeChecker.transTimeExpression((ATimeExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ACastExpression) {
            return CifExprsTypeChecker.transCastExpression((ACastExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof AUnaryExpression) {
            return CifExprsTypeChecker.transUnaryExpression((AUnaryExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ABinaryExpression) {
            return CifExprsTypeChecker.transBinaryExpression((ABinaryExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof AIfExpression) {
            return CifExprsTypeChecker.transIfExpression((AIfExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ASwitchExpression) {
            return CifExprsTypeChecker.transSwitchExpression((ASwitchExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof AProjectionExpression) {
            return CifExprsTypeChecker.transProjExpression((AProjectionExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ASliceExpression) {
            return CifExprsTypeChecker.transSliceExpression((ASliceExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof AFuncCallExpression) {
            return CifExprsTypeChecker.transFuncCallExpression((AFuncCallExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof AListExpression) {
            return CifExprsTypeChecker.transListExpression((AListExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof AEmptySetDictExpression) {
            return CifExprsTypeChecker.transEmptySetDictExpression((AEmptySetDictExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ASetExpression) {
            return CifExprsTypeChecker.transSetExpression((ASetExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ATupleExpression) {
            return CifExprsTypeChecker.transTupleExpression((ATupleExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ADictExpression) {
            return CifExprsTypeChecker.transDictExpression((ADictExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ANameExpression) {
            return CifExprsTypeChecker.transNameExpression((ANameExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ATauExpression) {
            return CifExprsTypeChecker.transTauExpression((ATauExpression)expr, hint, scope);
        }
        if (expr instanceof AReceivedExpression) {
            return CifExprsTypeChecker.transReceivedExpression((AReceivedExpression)expr, hint, scope, context, tchecker);
        }
        if (expr instanceof ASelfExpression) {
            return CifExprsTypeChecker.transSelfExpression((ASelfExpression)expr, hint, scope, context, tchecker);
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    private static BoolExpression transBoolExpression(ABoolExpression expr, CifType hint, SymbolScope<?> scope) {
        BoolType type = CifConstructors.newBoolType();
        type.setPosition(expr.createPosition());
        BoolExpression rslt = CifConstructors.newBoolExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setValue(expr.value);
        rslt.setType((CifType)type);
        return rslt;
    }

    private static Expression transIntExpression(AIntExpression expr, CifType hint, SymbolScope<?> scope, CifTypeChecker tchecker) {
        int value;
        try {
            value = Integer.parseInt(expr.value);
        }
        catch (NumberFormatException e) {
            tchecker.addProblem(ErrMsg.INT_VALUE_OVERFLOW, expr.position, Numbers.formatNumber((String)expr.value));
            throw new SemanticException();
        }
        IntExpression intExpr = CifConstructors.newIntExpression();
        intExpr.setPosition(expr.createPosition());
        intExpr.setValue(value);
        IntType type = CifConstructors.newIntType();
        type.setPosition(expr.createPosition());
        type.setLower(Integer.valueOf(value));
        type.setUpper(Integer.valueOf(value));
        intExpr.setType((CifType)type);
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        if (nhint instanceof RealType) {
            Assert.check((value >= 0 ? 1 : 0) != 0);
            RealExpression realExpr = CifConstructors.newRealExpression();
            realExpr.setValue(String.valueOf(Strings.str((Object)value)) + ".0");
            realExpr.setPosition(intExpr.getPosition());
            realExpr.setType((CifType)CifConstructors.newRealType());
            return realExpr;
        }
        return intExpr;
    }

    private static RealExpression transRealExpression(ARealExpression expr, CifType hint, SymbolScope<?> scope, CifTypeChecker tchecker) {
        double value;
        try {
            value = Double.parseDouble(expr.value);
            Assert.check((!Double.isNaN(value) ? 1 : 0) != 0);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        if (Double.isInfinite(value)) {
            tchecker.addProblem(ErrMsg.REAL_VALUE_OVERFLOW, expr.position, expr.value);
            throw new SemanticException();
        }
        Assert.check((value >= 0.0 ? 1 : 0) != 0);
        RealType type = CifConstructors.newRealType();
        type.setPosition(expr.createPosition());
        RealExpression rslt = CifConstructors.newRealExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setValue(expr.value);
        rslt.setType((CifType)type);
        return rslt;
    }

    private static StringExpression transStringExpression(AStringExpression expr, CifType hint, SymbolScope<?> scope) {
        StringType type = CifConstructors.newStringType();
        type.setPosition(expr.createPosition());
        StringExpression rslt = CifConstructors.newStringExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setValue(expr.value);
        rslt.setType((CifType)type);
        return rslt;
    }

    private static TimeExpression transTimeExpression(ATimeExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        if (context != null && context.conditions.contains((Object)ExprContext.Condition.NO_TIME)) {
            tchecker.addProblem(ErrMsg.TIME_IN_FUNC, expr.position, new String[0]);
            throw new SemanticException();
        }
        RealType type = CifConstructors.newRealType();
        type.setPosition(expr.createPosition());
        TimeExpression rslt = CifConstructors.newTimeExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)type);
        return rslt;
    }

    private static CastExpression transCastExpression(ACastExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        CifType ttype = CifTypesTypeChecker.transCifType(expr.type, scope, tchecker);
        CifType nttype = CifTypeUtils.normalizeType((CifType)ttype);
        CifType childHint = null;
        if (!(nttype instanceof BoolType || nttype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)nttype)) || nttype instanceof RealType || nttype instanceof StringType)) {
            childHint = ttype;
        }
        Expression child = CifExprsTypeChecker.transExpression(expr.child, childHint, scope, context, tchecker);
        CifType ctype = child.getType();
        CifType nctype = CifTypeUtils.normalizeType((CifType)ctype);
        boolean allowed = false;
        if (CifTypeUtils.checkTypeCompat((CifType)nctype, (CifType)nttype, (RangeCompat)RangeCompat.EQUAL)) {
            allowed = true;
        } else if (nttype instanceof BoolType) {
            if (nctype instanceof StringType) {
                allowed = true;
            }
        } else if (nttype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)nttype))) {
            if (nctype instanceof StringType) {
                allowed = true;
            }
        } else if (nttype instanceof RealType) {
            if (nctype instanceof IntType) {
                allowed = true;
            }
            if (nctype instanceof StringType) {
                allowed = true;
            }
        } else if (nttype instanceof StringType) {
            if (nctype instanceof BoolType) {
                allowed = true;
            }
            if (nctype instanceof IntType) {
                allowed = true;
            }
            if (nctype instanceof RealType) {
                allowed = true;
            }
            if (CifTypeUtils.isAutRefExpr((Expression)child)) {
                allowed = true;
            }
        }
        if (!allowed) {
            tchecker.addProblem(ErrMsg.CAST_INVALID_TYPES, expr.position, CifTextUtils.typeToStr((CifType)ctype), CifTextUtils.typeToStr((CifType)ttype));
            throw new SemanticException();
        }
        CastExpression rslt = CifConstructors.newCastExpression();
        rslt.setChild(child);
        rslt.setPosition(expr.createPosition());
        rslt.setType(ttype);
        return rslt;
    }

    private static UnaryExpression transUnaryExpression(AUnaryExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        UnaryOperator op = UNOP_MAP.get(expr.operator);
        Assert.notNull((Object)op);
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        BoolType childHint = null;
        switch (op) {
            case INVERSE: {
                childHint = BOOL_TYPE_HINT;
                break;
            }
            case NEGATE: {
                childHint = hint;
                break;
            }
            case PLUS: {
                childHint = hint;
                break;
            }
            case SAMPLE: {
                TupleType ttype;
                if (!(nhint instanceof TupleType) || (ttype = (TupleType)nhint).getFields().size() != 2) break;
                childHint = ((Field)ttype.getFields().get(1)).getType();
            }
        }
        Expression child = CifExprsTypeChecker.transExpression(expr.child, (CifType)childHint, scope, context, tchecker);
        UnaryExpression rslt = CifConstructors.newUnaryExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setChild(child);
        rslt.setOperator(op);
        CifType ctype = child.getType();
        CifType nctype = CifTypeUtils.normalizeType((CifType)ctype);
        switch (op) {
            case INVERSE: {
                if (!(nctype instanceof BoolType)) {
                    tchecker.addProblem(ErrMsg.UNOP_INVALID_CHILD_TYPE, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ctype));
                    throw new SemanticException();
                }
                rslt.setType((CifType)EMFHelper.deepclone((EObject)ctype));
                break;
            }
            case NEGATE: {
                if (!(nctype instanceof IntType) && !(nctype instanceof RealType)) {
                    tchecker.addProblem(ErrMsg.UNOP_INVALID_CHILD_TYPE, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ctype));
                    throw new SemanticException();
                }
                if (nctype instanceof IntType) {
                    IntType itype = (IntType)nctype;
                    IntType type = CifConstructors.newIntType();
                    type.setPosition(expr.createPosition());
                    rslt.setType((CifType)type);
                    if (CifTypeUtils.isRangeless((IntType)itype)) break;
                    int lower = itype.getLower();
                    int upper = itype.getUpper();
                    if (lower == Integer.MIN_VALUE) {
                        tchecker.addProblem(ErrMsg.UNOP_NEGATE_OVERFLOW, expr.position, CifTextUtils.typeToStr((CifType)ctype));
                        throw new SemanticException();
                    }
                    type.setLower(Integer.valueOf(-upper));
                    type.setUpper(Integer.valueOf(-lower));
                    break;
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
                break;
            }
            case PLUS: {
                if (!(nctype instanceof IntType) && !(nctype instanceof RealType)) {
                    tchecker.addProblem(ErrMsg.UNOP_INVALID_CHILD_TYPE, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ctype));
                    throw new SemanticException();
                }
                rslt.setType((CifType)EMFHelper.deepclone((EObject)ctype));
                break;
            }
            case SAMPLE: {
                if (!(nctype instanceof DistType)) {
                    tchecker.addProblem(ErrMsg.UNOP_INVALID_CHILD_TYPE, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ctype));
                    throw new SemanticException();
                }
                DistType dtype = (DistType)nctype;
                CifType type = CifTypeUtils.makeTupleType((List)Lists.list((Object[])new CifType[]{dtype.getSampleType(), ctype}));
                rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            }
        }
        return rslt;
    }

    private static BinaryExpression transBinaryExpression(ABinaryExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        BinaryOperator op = BINOP_MAP.get(expr.operator);
        Assert.notNull((Object)op);
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        CifType leftHint = null;
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: {
                leftHint = hint;
                break;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                leftHint = hint;
                break;
            }
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                break;
            }
            case EQUAL: 
            case UNEQUAL: {
                break;
            }
            case ADDITION: {
                leftHint = hint;
                break;
            }
            case SUBTRACTION: {
                leftHint = hint;
                break;
            }
            case MULTIPLICATION: {
                leftHint = hint;
                break;
            }
            case DIVISION: {
                break;
            }
            case INTEGER_DIVISION: {
                leftHint = hint;
                break;
            }
            case MODULUS: {
                leftHint = hint;
                break;
            }
            case ELEMENT_OF: {
                break;
            }
        }
        Expression left = CifExprsTypeChecker.transExpression(expr.left, leftHint, scope, context, tchecker);
        CifType ltype = left.getType();
        CifType nltype = CifTypeUtils.normalizeType((CifType)ltype);
        CifType rightHint = null;
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: {
                rightHint = ltype;
                break;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                rightHint = ltype;
                break;
            }
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                break;
            }
            case EQUAL: 
            case UNEQUAL: {
                rightHint = ltype;
                break;
            }
            case ADDITION: {
                if (nhint instanceof IntType || nhint instanceof RealType) {
                    rightHint = hint;
                    break;
                }
                rightHint = ltype;
                break;
            }
            case SUBTRACTION: {
                if (nhint instanceof IntType || nhint instanceof RealType) {
                    rightHint = hint;
                    break;
                }
                if (nhint instanceof DictType) break;
                rightHint = ltype;
                break;
            }
            case MULTIPLICATION: {
                rightHint = hint;
                break;
            }
            case DIVISION: {
                break;
            }
            case INTEGER_DIVISION: {
                rightHint = hint;
                break;
            }
            case MODULUS: {
                rightHint = hint;
                break;
            }
            case ELEMENT_OF: {
                break;
            }
            case SUBSET: {
                rightHint = ltype;
            }
        }
        Expression right = CifExprsTypeChecker.transExpression(expr.right, rightHint, scope, context, tchecker);
        CifType rtype = right.getType();
        CifType nrtype = CifTypeUtils.normalizeType((CifType)rtype);
        BinaryExpression rslt = CifConstructors.newBinaryExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setLeft(left);
        rslt.setRight(right);
        rslt.setOperator(op);
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: {
                if (!(nltype instanceof BoolType) || !(nrtype instanceof BoolType)) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                BoolType type = CifConstructors.newBoolType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
                break;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                boolean allowed = false;
                if (nltype instanceof BoolType && nrtype instanceof BoolType) {
                    allowed = true;
                } else if (nltype instanceof SetType && nrtype instanceof SetType) {
                    SetType lstype = (SetType)nltype;
                    SetType rstype = (SetType)nrtype;
                    allowed = CifTypeUtils.checkTypeCompat((CifType)lstype.getElementType(), (CifType)rstype.getElementType(), (RangeCompat)RangeCompat.IGNORE);
                }
                if (!allowed) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                rslt.setType(CifTypeUtils.mergeTypes((CifType)ltype, (CifType)rtype));
                break;
            }
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                if (!(nltype instanceof IntType) && !(nltype instanceof RealType) || !(nrtype instanceof IntType) && !(nrtype instanceof RealType)) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                BoolType type = CifConstructors.newBoolType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
                break;
            }
            case EQUAL: 
            case UNEQUAL: {
                if (!(CifTypeUtils.supportsValueEquality((CifType)ltype) && CifTypeUtils.supportsValueEquality((CifType)rtype) && CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)rtype, (RangeCompat)RangeCompat.IGNORE))) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                BoolType type = CifConstructors.newBoolType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
                break;
            }
            case ADDITION: {
                IntType resultType = null;
                if (nltype instanceof IntType && nrtype instanceof IntType) {
                    IntType type = CifConstructors.newIntType();
                    type.setPosition(expr.createPosition());
                    resultType = type;
                    IntType litype = (IntType)nltype;
                    IntType ritype = (IntType)nrtype;
                    if (!CifTypeUtils.isRangeless((IntType)litype) && !CifTypeUtils.isRangeless((IntType)ritype)) {
                        long l1 = litype.getLower().intValue();
                        long u1 = litype.getUpper().intValue();
                        long l2 = ritype.getLower().intValue();
                        long u2 = ritype.getUpper().intValue();
                        long l = l1 + l2;
                        long u = u1 + u2;
                        if (l < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
                            tchecker.addProblem(ErrMsg.BINOP_OVERFLOW, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                            throw new SemanticException();
                        }
                        type.setLower(Integer.valueOf((int)l));
                        type.setUpper(Integer.valueOf((int)u));
                    }
                } else if ((nltype instanceof IntType || nltype instanceof RealType) && (nrtype instanceof IntType || nrtype instanceof RealType)) {
                    RealType type = CifConstructors.newRealType();
                    type.setPosition(expr.createPosition());
                    resultType = type;
                } else if (nltype instanceof ListType && nrtype instanceof ListType) {
                    if (CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)rtype, (RangeCompat)RangeCompat.IGNORE)) {
                        resultType = CifTypeUtils.mergeTypes((CifType)ltype, (CifType)rtype);
                    }
                    ListType lltype = (ListType)nltype;
                    ListType rltype = (ListType)nrtype;
                    if (resultType != null && !CifTypeUtils.isRangeless((ListType)lltype) && !CifTypeUtils.isRangeless((ListType)rltype)) {
                        long l1 = lltype.getLower().intValue();
                        long u1 = lltype.getUpper().intValue();
                        long l2 = rltype.getLower().intValue();
                        long u2 = rltype.getUpper().intValue();
                        long l = l1 + l2;
                        long u = u1 + u2;
                        if (u > Integer.MAX_VALUE) {
                            tchecker.addProblem(ErrMsg.BINOP_OVERFLOW, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                            throw new SemanticException();
                        }
                        ((ListType)resultType).setLower(Integer.valueOf((int)l));
                        ((ListType)resultType).setUpper(Integer.valueOf((int)u));
                    }
                } else if (nltype instanceof StringType && nrtype instanceof StringType) {
                    resultType = CifTypeUtils.mergeTypes((CifType)ltype, (CifType)rtype);
                } else if (nltype instanceof DictType && nrtype instanceof DictType && CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)rtype, (RangeCompat)RangeCompat.IGNORE)) {
                    resultType = CifTypeUtils.mergeTypes((CifType)ltype, (CifType)rtype);
                }
                if (resultType == null) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                rslt.setType((CifType)resultType);
                break;
            }
            case SUBTRACTION: {
                IntType resultType = null;
                if (nltype instanceof IntType && nrtype instanceof IntType) {
                    IntType type = CifConstructors.newIntType();
                    type.setPosition(expr.createPosition());
                    resultType = type;
                    IntType litype = (IntType)nltype;
                    IntType ritype = (IntType)nrtype;
                    if (!CifTypeUtils.isRangeless((IntType)litype) && !CifTypeUtils.isRangeless((IntType)ritype)) {
                        long l1 = litype.getLower().intValue();
                        long u1 = litype.getUpper().intValue();
                        long l2 = ritype.getLower().intValue();
                        long u2 = ritype.getUpper().intValue();
                        long l = l1 - u2;
                        long u = u1 - l2;
                        if (l < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
                            tchecker.addProblem(ErrMsg.BINOP_OVERFLOW, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                            throw new SemanticException();
                        }
                        type.setLower(Integer.valueOf((int)l));
                        type.setUpper(Integer.valueOf((int)u));
                    }
                } else if ((nltype instanceof IntType || nltype instanceof RealType) && (nrtype instanceof IntType || nrtype instanceof RealType)) {
                    RealType type = CifConstructors.newRealType();
                    type.setPosition(expr.createPosition());
                    resultType = type;
                } else if (nltype instanceof SetType && nrtype instanceof SetType) {
                    if (CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)rtype, (RangeCompat)RangeCompat.IGNORE)) {
                        resultType = CifTypeUtils.mergeTypes((CifType)ltype, (CifType)rtype);
                    }
                } else if (nltype instanceof DictType && nrtype instanceof DictType) {
                    if (CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)rtype, (RangeCompat)RangeCompat.IGNORE)) {
                        resultType = CifTypeUtils.mergeTypes((CifType)ltype, (CifType)rtype);
                    }
                } else if (nltype instanceof DictType && nrtype instanceof SetType) {
                    DictType dtype = (DictType)nltype;
                    SetType stype = (SetType)nrtype;
                    if (CifTypeUtils.checkTypeCompat((CifType)dtype.getKeyType(), (CifType)stype.getElementType(), (RangeCompat)RangeCompat.IGNORE)) {
                        resultType = (CifType)EMFHelper.deepclone((EObject)ltype);
                    }
                } else if (nltype instanceof DictType && nrtype instanceof ListType) {
                    DictType dtype = (DictType)nltype;
                    ListType listType = (ListType)nrtype;
                    if (CifTypeUtils.checkTypeCompat((CifType)dtype.getKeyType(), (CifType)listType.getElementType(), (RangeCompat)RangeCompat.IGNORE)) {
                        resultType = (CifType)EMFHelper.deepclone((EObject)ltype);
                    }
                }
                if (resultType == null) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                rslt.setType((CifType)resultType);
                break;
            }
            case MULTIPLICATION: {
                IntType resultType = null;
                if (nltype instanceof IntType && nrtype instanceof IntType) {
                    IntType type = CifConstructors.newIntType();
                    type.setPosition(expr.createPosition());
                    resultType = type;
                    IntType litype = (IntType)nltype;
                    IntType ritype = (IntType)nrtype;
                    if (!CifTypeUtils.isRangeless((IntType)litype) && !CifTypeUtils.isRangeless((IntType)ritype)) {
                        long l1 = litype.getLower().intValue();
                        long u1 = litype.getUpper().intValue();
                        long l2 = ritype.getLower().intValue();
                        long u2 = ritype.getUpper().intValue();
                        long l = CifExprsTypeChecker.min(l1 * l2, l1 * u2, u1 * l2, u1 * u2);
                        long u = CifExprsTypeChecker.max(l1 * l2, l1 * u2, u1 * l2, u1 * u2);
                        if (l < Integer.MIN_VALUE || u > Integer.MAX_VALUE) {
                            tchecker.addProblem(ErrMsg.BINOP_OVERFLOW, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                            throw new SemanticException();
                        }
                        type.setLower(Integer.valueOf((int)l));
                        type.setUpper(Integer.valueOf((int)u));
                    }
                } else if ((nltype instanceof IntType || nltype instanceof RealType) && (nrtype instanceof IntType || nrtype instanceof RealType)) {
                    RealType type = CifConstructors.newRealType();
                    type.setPosition(expr.createPosition());
                    resultType = type;
                }
                if (resultType == null) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                rslt.setType((CifType)resultType);
                break;
            }
            case DIVISION: {
                if (!(nltype instanceof IntType) && !(nltype instanceof RealType) || !(nrtype instanceof IntType) && !(nrtype instanceof RealType)) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
                break;
            }
            case INTEGER_DIVISION: {
                if (!(nltype instanceof IntType) || !(nrtype instanceof IntType)) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                IntType type = CifConstructors.newIntType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
                IntType litype = (IntType)nltype;
                IntType ritype = (IntType)nrtype;
                if (CifTypeUtils.isRangeless((IntType)litype) || CifTypeUtils.isRangeless((IntType)ritype)) break;
                int l1 = litype.getLower();
                int u1 = litype.getUpper();
                int l2 = ritype.getLower();
                int u2 = ritype.getUpper();
                if (l2 == 0 && u2 == 0) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                int[] resultRange = CifExprsTypeChecker.getDivResultRange(l1, u1, l2, u2);
                type.setLower(Integer.valueOf(resultRange[0]));
                type.setUpper(Integer.valueOf(resultRange[1]));
                break;
            }
            case MODULUS: {
                if (!(nltype instanceof IntType) || !(nrtype instanceof IntType)) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                IntType type = CifConstructors.newIntType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
                IntType litype = (IntType)nltype;
                IntType ritype = (IntType)nrtype;
                if (CifTypeUtils.isRangeless((IntType)litype) || CifTypeUtils.isRangeless((IntType)ritype)) break;
                int l1 = litype.getLower();
                int u1 = litype.getUpper();
                int l2 = ritype.getLower();
                int u2 = ritype.getUpper();
                if (l2 == 0 && u2 == 0) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                int[] resultRange = CifExprsTypeChecker.getModResultRange(l1, u1, l2, u2);
                type.setLower(Integer.valueOf(resultRange[0]));
                type.setUpper(Integer.valueOf(resultRange[1]));
                break;
            }
            case ELEMENT_OF: {
                DictType dtype;
                BoolType resultType = null;
                if (nrtype instanceof ListType) {
                    ListType listType = (ListType)nrtype;
                    if (CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)listType.getElementType(), (RangeCompat)RangeCompat.IGNORE) && CifTypeUtils.supportsValueEquality((CifType)ltype)) {
                        resultType = CifConstructors.newBoolType();
                        resultType.setPosition(expr.createPosition());
                    }
                } else if (nrtype instanceof SetType) {
                    SetType stype = (SetType)nrtype;
                    if (CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)stype.getElementType(), (RangeCompat)RangeCompat.IGNORE)) {
                        resultType = CifConstructors.newBoolType();
                        resultType.setPosition(expr.createPosition());
                    }
                } else if (nrtype instanceof DictType && CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)(dtype = (DictType)nrtype).getKeyType(), (RangeCompat)RangeCompat.IGNORE)) {
                    resultType = CifConstructors.newBoolType();
                    resultType.setPosition(expr.createPosition());
                }
                if (resultType == null) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                rslt.setType(resultType);
                break;
            }
            case SUBSET: {
                if (!(nltype instanceof SetType && nrtype instanceof SetType && CifTypeUtils.checkTypeCompat((CifType)ltype, (CifType)rtype, (RangeCompat)RangeCompat.IGNORE))) {
                    tchecker.addProblem(ErrMsg.BINOP_INVALID_TYPES, expr.position, expr.operator, CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype));
                    throw new SemanticException();
                }
                BoolType type = CifConstructors.newBoolType();
                type.setPosition(expr.createPosition());
                rslt.setType((CifType)type);
            }
        }
        return rslt;
    }

    public static int[] getDivResultRange(int l1, int u1, int l2, int u2) {
        List range1 = Lists.list((Object[])new Integer[]{l1, u1});
        List range2 = Lists.list((Object[])new Integer[]{l2, u2});
        if (l1 <= -2147483647 && -2147483647 <= u2) {
            range1.add(-2147483647);
        }
        if (l2 <= -2 && -2 <= u2) {
            range2.add(-2);
        }
        if (l2 <= -1 && -1 <= u2) {
            range2.add(-1);
        }
        if (l2 <= 1 && 1 <= u2) {
            range2.add(1);
        }
        int minimum = Integer.MAX_VALUE;
        int maximum = Integer.MIN_VALUE;
        Iterator iterator = range1.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            Iterator iterator2 = range2.iterator();
            while (iterator2.hasNext()) {
                int rslt;
                int y = (Integer)iterator2.next();
                if (y == 0 || x == Integer.MIN_VALUE && y == -1) continue;
                try {
                    rslt = CifMath.div((int)x, (int)y, null);
                }
                catch (CifEvalException e) {
                    throw new RuntimeException(e);
                }
                minimum = Math.min(minimum, rslt);
                maximum = Math.max(maximum, rslt);
            }
        }
        return new int[]{minimum, maximum};
    }

    public static int[] getModResultRange(int l1, int u1, int l2, int u2) {
        int max = Math.max(Math.abs(l2), Math.abs(u2));
        int minimum = l1 < 0 ? Math.min(0, -max + 1) : 0;
        int maximum = u1 >= 0 ? Math.max(0, max - 1) : 0;
        return new int[]{minimum, maximum};
    }

    private static ProjectionExpression transProjExpression(AProjectionExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        CifType resultType;
        CifType childHint = null;
        Expression child = CifExprsTypeChecker.transExpression(expr.child, childHint, scope, context, tchecker);
        CifType ctype = child.getType();
        CifType nctype = CifTypeUtils.normalizeType((CifType)ctype);
        if (!(nctype instanceof ListType || nctype instanceof DictType || nctype instanceof StringType || nctype instanceof TupleType)) {
            tchecker.addProblem(ErrMsg.PROJ_CHILD_TYPE, expr.position, CifTextUtils.typeToStr((CifType)ctype));
            throw new SemanticException();
        }
        Expression index = null;
        if (nctype instanceof TupleType && expr.index instanceof ANameExpression) {
            ANameExpression nameExpr = (ANameExpression)expr.index;
            String name = nameExpr.name.name;
            TupleType ttype = (TupleType)nctype;
            int i = 0;
            while (i < ttype.getFields().size()) {
                Field field = (Field)ttype.getFields().get(i);
                if (field.getName() != null && field.getName().equals(name)) {
                    IntType type = CifConstructors.newIntType();
                    type.setPosition(nameExpr.createPosition());
                    type.setLower(Integer.valueOf(i));
                    type.setUpper(Integer.valueOf(i));
                    FieldExpression fieldRef = CifConstructors.newFieldExpression();
                    fieldRef.setField(field);
                    fieldRef.setPosition(nameExpr.createPosition());
                    fieldRef.setType((CifType)type);
                    index = fieldRef;
                    if (!nameExpr.derivative) break;
                    tchecker.addProblem(ErrMsg.DER_OF_NON_CONT_VAR, nameExpr.position, "tuple field ", name);
                    break;
                }
                ++i;
            }
        }
        if (index == null) {
            IntType indexHint = null;
            if (nctype instanceof ListType) {
                indexHint = INT_TYPE_HINT;
            } else if (nctype instanceof DictType) {
                indexHint = ((DictType)nctype).getKeyType();
            } else if (nctype instanceof StringType) {
                indexHint = INT_TYPE_HINT;
            } else if (nctype instanceof TupleType) {
                indexHint = INT_TYPE_HINT;
            }
            index = CifExprsTypeChecker.transExpression(expr.index, (CifType)indexHint, scope, context, tchecker);
        }
        CifType itype = index.getType();
        CifType nitype = CifTypeUtils.normalizeType((CifType)itype);
        if (nctype instanceof ListType) {
            if (!(nitype instanceof IntType)) {
                tchecker.addProblem(ErrMsg.PROJ_INDEX_TYPE, expr.position, CifTextUtils.typeToStr((CifType)ctype), CifTextUtils.typeToStr((CifType)itype), "int", "");
                throw new SemanticException();
            }
            ListType ltype = (ListType)nctype;
            IntType intType = (IntType)nitype;
            if (!CifTypeUtils.isRangeless((ListType)ltype) && !CifTypeUtils.isRangeless((IntType)intType)) {
                long listUpper = ltype.getUpper().intValue();
                long indexLower = intType.getLower().intValue();
                long indexUpper = intType.getUpper().intValue();
                if (listUpper >= 0L && indexLower <= indexUpper) {
                    long normalizedIndex;
                    if (indexLower >= listUpper) {
                        tchecker.addProblem(ErrMsg.PROJ_LIST_OUT_OF_BOUNDS, expr.position, CifTextUtils.typeToStr((CifType)nctype), CifTextUtils.typeToStr((CifType)nitype));
                        throw new SemanticException();
                    }
                    if (indexUpper < 0L && (normalizedIndex = indexUpper + listUpper) < 0L) {
                        tchecker.addProblem(ErrMsg.PROJ_LIST_OUT_OF_BOUNDS, expr.position, CifTextUtils.typeToStr((CifType)nctype), CifTextUtils.typeToStr((CifType)nitype));
                        throw new SemanticException();
                    }
                }
            }
            resultType = (CifType)EMFHelper.deepclone((EObject)((ListType)nctype).getElementType());
        } else if (nctype instanceof DictType) {
            CifType ktype = ((DictType)nctype).getKeyType();
            if (!CifTypeUtils.checkTypeCompat((CifType)ktype, (CifType)itype, (RangeCompat)RangeCompat.IGNORE)) {
                tchecker.addProblem(ErrMsg.PROJ_INDEX_TYPE, expr.position, CifTextUtils.typeToStr((CifType)ctype), CifTextUtils.typeToStr((CifType)itype), CifTextUtils.typeToStr((CifType)ktype), "");
                throw new SemanticException();
            }
            resultType = (CifType)EMFHelper.deepclone((EObject)((DictType)nctype).getValueType());
        } else if (nctype instanceof StringType) {
            if (!(nitype instanceof IntType)) {
                tchecker.addProblem(ErrMsg.PROJ_INDEX_TYPE, expr.position, CifTextUtils.typeToStr((CifType)ctype), CifTextUtils.typeToStr((CifType)itype), "int", "");
                throw new SemanticException();
            }
            resultType = (CifType)EMFHelper.deepclone((EObject)ctype);
        } else if (nctype instanceof TupleType) {
            if (index instanceof FieldExpression) {
                Field field = ((FieldExpression)index).getField();
                resultType = (CifType)EMFHelper.deepclone((EObject)field.getType());
            } else {
                int idx;
                if (!(nitype instanceof IntType)) {
                    tchecker.addProblem(ErrMsg.PROJ_INDEX_TYPE, expr.position, CifTextUtils.typeToStr((CifType)ctype), CifTextUtils.typeToStr((CifType)itype), "int", " (or a field name)");
                    throw new SemanticException();
                }
                CifExprsTypeChecker.checkStaticEvaluable(index, tchecker);
                try {
                    idx = (Integer)CifEvalUtils.eval((Expression)index, (boolean)false);
                }
                catch (CifEvalException e) {
                    tchecker.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
                    throw new SemanticException();
                }
                TupleType ttype = (TupleType)nctype;
                if (idx < 0 || idx >= ttype.getFields().size()) {
                    tchecker.addProblem(ErrMsg.PROJ_TUPLE_INDEX_BOUNDS, expr.position, CifTextUtils.typeToStr((CifType)ctype), Integer.toString(idx));
                    throw new SemanticException();
                }
                resultType = (CifType)EMFHelper.deepclone((EObject)((Field)ttype.getFields().get(idx)).getType());
            }
        } else {
            throw new RuntimeException("Checks above should prevent this.");
        }
        ProjectionExpression rslt = CifConstructors.newProjectionExpression();
        rslt.setChild(child);
        rslt.setIndex(index);
        rslt.setPosition(expr.createPosition());
        rslt.setType(resultType);
        return rslt;
    }

    private static SliceExpression transSliceExpression(ASliceExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        CifType childHint = hint;
        Expression child = CifExprsTypeChecker.transExpression(expr.child, childHint, scope, context, tchecker);
        CifType ctype = child.getType();
        CifType nctype = CifTypeUtils.normalizeType((CifType)ctype);
        if (!(nctype instanceof StringType) && !(nctype instanceof ListType)) {
            tchecker.addProblem(ErrMsg.SLICE_CHILD_TYPE, expr.position, CifTextUtils.typeToStr((CifType)ctype));
            throw new SemanticException();
        }
        Expression begin = null;
        IntType bitype = null;
        if (expr.begin != null) {
            begin = CifExprsTypeChecker.transExpression(expr.begin, (CifType)CifConstructors.newIntType(), scope, context, tchecker);
            CifType btype = begin.getType();
            CifType nbtype = CifTypeUtils.normalizeType((CifType)btype);
            if (!(nbtype instanceof IntType)) {
                tchecker.addProblem(ErrMsg.SLICE_IDX_NON_INT, begin.getPosition(), "begin");
                throw new SemanticException();
            }
            bitype = (IntType)nbtype;
        }
        Expression end = null;
        IntType eitype = null;
        if (expr.end != null) {
            end = CifExprsTypeChecker.transExpression(expr.end, (CifType)CifConstructors.newIntType(), scope, context, tchecker);
            CifType etype = end.getType();
            CifType netype = CifTypeUtils.normalizeType((CifType)etype);
            if (!(netype instanceof IntType)) {
                tchecker.addProblem(ErrMsg.SLICE_IDX_NON_INT, end.getPosition(), "end");
                throw new SemanticException();
            }
            eitype = (IntType)netype;
        }
        SliceExpression rslt = CifConstructors.newSliceExpression();
        rslt.setChild(child);
        rslt.setBegin(begin);
        rslt.setEnd(end);
        rslt.setPosition(expr.createPosition());
        if (nctype instanceof StringType) {
            rslt.setType((CifType)EMFHelper.deepclone((EObject)child.getType()));
        } else {
            Assert.check((boolean)(nctype instanceof ListType));
            ListType ltype = (ListType)nctype;
            ListType rtype = (ListType)EMFHelper.deepclone((EObject)ltype);
            if (!CifTypeUtils.isRangeless((ListType)ltype)) {
                int u;
                int l = ltype.getLower();
                if (l == (u = ltype.getUpper().intValue())) {
                    if ((bitype == null || !CifTypeUtils.isRangeless((IntType)bitype) && bitype.getLower().equals(bitype.getUpper())) && (eitype == null || !CifTypeUtils.isRangeless((IntType)eitype) && eitype.getLower().equals(eitype.getUpper()))) {
                        Integer y = bitype == null ? null : bitype.getLower();
                        Integer z = eitype == null ? null : eitype.getLower();
                        int rsltSize = CifExprsTypeChecker.getSliceResultSize(l, y, z);
                        rtype.setLower(Integer.valueOf(rsltSize));
                        rtype.setUpper(Integer.valueOf(rsltSize));
                    } else {
                        rtype.setLower(Integer.valueOf(0));
                        rtype.setUpper(Integer.valueOf(l));
                    }
                } else if ((bitype == null || !CifTypeUtils.isRangeless((IntType)bitype) && bitype.getLower().equals(bitype.getUpper()) && bitype.getLower() >= 0 && bitype.getLower() <= l) && (eitype == null || !CifTypeUtils.isRangeless((IntType)eitype) && eitype.getLower().equals(eitype.getUpper()) && eitype.getLower() >= 0 && eitype.getLower() <= l)) {
                    Integer y = bitype == null ? null : bitype.getLower();
                    Integer z = eitype == null ? null : eitype.getLower();
                    int[] rsltRange = CifExprsTypeChecker.getSliceResultRange(l, u, y, z);
                    rtype.setLower(Integer.valueOf(rsltRange[0]));
                    rtype.setUpper(Integer.valueOf(rsltRange[1]));
                } else {
                    rtype.setLower(Integer.valueOf(0));
                    rtype.setUpper(Integer.valueOf(u));
                }
            }
            rslt.setType((CifType)rtype);
        }
        return rslt;
    }

    public static int getSliceResultSize(int len, Integer begin, Integer end) {
        int e;
        int b = begin == null ? 0 : begin;
        int n = e = end == null ? len : end;
        if (b < 0) {
            b = len + b;
        }
        if (e < 0) {
            e = len + e;
        }
        if (b < 0) {
            b = 0;
        }
        if (e < 0) {
            e = 0;
        }
        if (b > len) {
            b = len;
        }
        if (e > len) {
            e = len;
        }
        if (b > e) {
            b = e;
        }
        return e - b;
    }

    public static int[] getSliceResultRange(int l, int u, Integer begin, Integer end) {
        int s1 = CifExprsTypeChecker.getSliceResultSize(l, begin, end);
        int s2 = CifExprsTypeChecker.getSliceResultSize(u, begin, end);
        return new int[]{Math.min(s1, s2), Math.max(s1, s2)};
    }

    private static FunctionCallExpression transFuncCallExpression(AFuncCallExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        if (expr.function instanceof AStdLibFunctionExpression) {
            return CifExprsTypeChecker.transFuncCallExpressionStdLib(expr, hint, scope, context, tchecker);
        }
        return CifExprsTypeChecker.transFuncCallExpressionFunc(expr, hint, scope, context, tchecker);
    }

    private static FunctionCallExpression transFuncCallExpressionFunc(AFuncCallExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        FunctionCallExpression rslt = CifConstructors.newFunctionCallExpression();
        rslt.setPosition(expr.createPosition());
        List astArgs = expr.arguments == null ? Collections.emptyList() : expr.arguments;
        Expression fexpr = CifExprsTypeChecker.transExpression(expr.function, NO_TYPE_HINT, scope, context, tchecker);
        rslt.setFunction(fexpr);
        CifType ftype = fexpr.getType();
        CifType nftype = CifTypeUtils.normalizeType((CifType)ftype);
        if (!(nftype instanceof FuncType)) {
            tchecker.addProblem(ErrMsg.FCALL_NON_FUNC, expr.position, CifTextUtils.typeToStr((CifType)ftype));
            throw new SemanticException();
        }
        FuncType funcType = (FuncType)nftype;
        int expectedCount = funcType.getParamTypes().size();
        if (astArgs.size() != expectedCount) {
            String funcText = "of type \"" + CifTextUtils.typeToStr((CifType)funcType) + "\"";
            tchecker.addProblem(ErrMsg.FCALL_WRONG_ARG_COUNT, expr.position, funcText, String.valueOf(String.valueOf(expectedCount)) + " argument" + (expectedCount == 1 ? "" : "s"), String.valueOf(String.valueOf(astArgs.size())) + (astArgs.size() == 1 ? " argument is" : " arguments are"));
            throw new SemanticException();
        }
        List args = Lists.listc((int)astArgs.size());
        int i = 0;
        while (i < astArgs.size()) {
            AExpression astArg = (AExpression)astArgs.get(i);
            CifType argHint = (CifType)funcType.getParamTypes().get(i);
            args.add(CifExprsTypeChecker.transExpression(astArg, argHint, scope, context, tchecker));
            ++i;
        }
        rslt.getParams().addAll((Collection)args);
        i = 0;
        while (i < expectedCount) {
            CifType actualType;
            CifType expectedType = (CifType)funcType.getParamTypes().get(i);
            if (!CifTypeUtils.checkTypeCompat((CifType)expectedType, (CifType)(actualType = ((Expression)args.get(i)).getType()), (RangeCompat)RangeCompat.CONTAINED)) {
                String funcText = "of type \"" + CifTextUtils.typeToStr((CifType)funcType) + "\"";
                List argTypes = Lists.list();
                for (Expression arg : args) {
                    argTypes.add("\"" + CifTextUtils.typeToStr((CifType)arg.getType()) + "\"");
                }
                tchecker.addProblem(ErrMsg.FCALL_WRONG_ARG_TYPES, expr.position, funcText, String.join((CharSequence)", ", argTypes));
                throw new SemanticException();
            }
            ++i;
        }
        rslt.setType((CifType)EMFHelper.deepclone((EObject)((FuncType)nftype).getReturnType()));
        return rslt;
    }

    private static FunctionCallExpression transFuncCallExpressionStdLib(AFuncCallExpression astCall, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        AStdLibFunctionExpression astStdLib = (AStdLibFunctionExpression)astCall.function;
        StdLibFunction func = FUNC_MAP.get(astStdLib.function);
        Assert.notNull((Object)func);
        if (CifTypeUtils.isDistFunction((StdLibFunction)func) && (context == null || !context.conditions.contains((Object)ExprContext.Condition.ALLOW_DIST))) {
            tchecker.addProblem(ErrMsg.STDLIB_OCCURRENCE, astStdLib.position, CifTextUtils.functionToStr((StdLibFunction)func));
        }
        FunctionCallExpression mmCall = CifConstructors.newFunctionCallExpression();
        mmCall.setPosition(astCall.createPosition());
        StdLibFunctionExpression mmStdLib = CifConstructors.newStdLibFunctionExpression();
        mmCall.setFunction((Expression)mmStdLib);
        mmStdLib.setFunction(func);
        mmStdLib.setPosition(astStdLib.createPosition());
        List astArgs = astCall.arguments == null ? Collections.emptyList() : astCall.arguments;
        switch (func) {
            case ACOSH: 
            case ACOS: 
            case ASINH: 
            case ASIN: 
            case ATANH: 
            case ATAN: 
            case COSH: 
            case COS: 
            case SINH: 
            case SIN: 
            case TANH: 
            case TAN: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case ABS: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case CBRT: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case CEIL: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case DELETE: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case EMPTY: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case EXP: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case FLOOR: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case FORMAT: {
                if (!astArgs.isEmpty()) break;
                tchecker.addProblem(ErrMsg.FCALL_WRONG_ARG_COUNT, astStdLib.position, "\"fmt\"", "at least 1 argument", "0 arguments are");
                throw new SemanticException();
            }
            case LN: 
            case LOG: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case MAXIMUM: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case MINIMUM: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case POP: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case POWER: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case ROUND: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case SCALE: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 5, tchecker);
                break;
            }
            case SIGN: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case SIZE: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case SQRT: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case BERNOULLI: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case BETA: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case BINOMIAL: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case CONSTANT: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case ERLANG: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case EXPONENTIAL: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case GAMMA: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case GEOMETRIC: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case LOG_NORMAL: 
            case NORMAL: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case POISSON: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 1, tchecker);
                break;
            }
            case RANDOM: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 0, tchecker);
                break;
            }
            case TRIANGLE: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 3, tchecker);
                break;
            }
            case UNIFORM: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
                break;
            }
            case WEIBULL: {
                CifExprsTypeChecker.checkFuncCallArgCounts(astStdLib, astArgs, 2, tchecker);
            }
        }
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        CifType[] argHints = new CifType[astArgs.size()];
        List args = Lists.listc((int)astArgs.size());
        CifType[] atypes = new CifType[astArgs.size()];
        CifType[] natypes = new CifType[astArgs.size()];
        int i = 0;
        while (i < astArgs.size()) {
            CifType atype;
            switch (func) {
                case ACOSH: 
                case ACOS: 
                case ASINH: 
                case ASIN: 
                case ATANH: 
                case ATAN: 
                case COSH: 
                case COS: 
                case SINH: 
                case SIN: 
                case TANH: 
                case TAN: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case ABS: {
                    argHints[0] = hint;
                    break;
                }
                case CBRT: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case CEIL: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case DELETE: {
                    if (i == 0) {
                        argHints[0] = hint;
                    }
                    if (i != 1) break;
                    argHints[1] = INT_TYPE_HINT;
                    break;
                }
                case EMPTY: {
                    break;
                }
                case EXP: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case FLOOR: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case FORMAT: {
                    if (i != 0) break;
                    argHints[0] = STRING_TYPE_HINT;
                    break;
                }
                case LN: 
                case LOG: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case MAXIMUM: {
                    argHints[i] = hint;
                    break;
                }
                case MINIMUM: {
                    argHints[i] = hint;
                    break;
                }
                case POP: {
                    TupleType ttype;
                    if (!(nhint instanceof TupleType) || (ttype = (TupleType)nhint).getFields().size() != 2) break;
                    argHints[0] = ((Field)ttype.getFields().get(1)).getType();
                    break;
                }
                case POWER: {
                    argHints[i] = hint;
                    break;
                }
                case ROUND: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case SCALE: {
                    break;
                }
                case SIGN: {
                    break;
                }
                case SIZE: {
                    break;
                }
                case SQRT: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case BERNOULLI: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case BETA: {
                    argHints[i] = REAL_TYPE_HINT;
                    break;
                }
                case BINOMIAL: {
                    if (i == 0) {
                        argHints[0] = REAL_TYPE_HINT;
                    }
                    if (i != 1) break;
                    argHints[1] = INT_TYPE_HINT;
                    break;
                }
                case CONSTANT: {
                    if (!(nhint instanceof DistType)) break;
                    argHints[0] = ((DistType)nhint).getSampleType();
                    break;
                }
                case ERLANG: {
                    if (i == 0) {
                        argHints[0] = INT_TYPE_HINT;
                    }
                    if (i != 1) break;
                    argHints[1] = REAL_TYPE_HINT;
                    break;
                }
                case EXPONENTIAL: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case GAMMA: {
                    argHints[i] = REAL_TYPE_HINT;
                    break;
                }
                case GEOMETRIC: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case LOG_NORMAL: 
                case NORMAL: {
                    argHints[i] = REAL_TYPE_HINT;
                    break;
                }
                case POISSON: {
                    argHints[0] = REAL_TYPE_HINT;
                    break;
                }
                case RANDOM: {
                    break;
                }
                case TRIANGLE: {
                    argHints[i] = REAL_TYPE_HINT;
                    break;
                }
                case UNIFORM: {
                    argHints[i] = hint;
                    break;
                }
                case WEIBULL: {
                    argHints[i] = REAL_TYPE_HINT;
                }
            }
            AExpression astArg = (AExpression)astArgs.get(i);
            Expression arg = CifExprsTypeChecker.transExpression(astArg, argHints[i], scope, context, tchecker);
            args.add(arg);
            atypes[i] = atype = arg.getType();
            natypes[i] = CifTypeUtils.normalizeType((CifType)atype);
            ++i;
        }
        mmCall.getParams().addAll((Collection)args);
        FuncType resultType = CifConstructors.newFuncType();
        mmStdLib.setType((CifType)resultType);
        resultType.setPosition(astStdLib.createPosition());
        int i2 = 0;
        while (i2 < atypes.length) {
            resultType.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)atypes[i2])));
            ++i2;
        }
        switch (func) {
            case ACOSH: 
            case ACOS: 
            case ASINH: 
            case ASIN: 
            case ATANH: 
            case ATAN: 
            case COSH: 
            case COS: 
            case SINH: 
            case SIN: 
            case TANH: 
            case TAN: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case ABS: {
                IntType itype;
                CifType ntype = natypes[0];
                if (!(ntype instanceof IntType) && !(ntype instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                if (ntype instanceof IntType) {
                    itype = CifConstructors.newIntType();
                    itype.setPosition(astStdLib.createPosition());
                    resultType.setReturnType((CifType)itype);
                    if (CifTypeUtils.isRangeless((IntType)((IntType)ntype))) break;
                    int lower = ((IntType)ntype).getLower();
                    int upper = ((IntType)ntype).getUpper();
                    if (lower == Integer.MIN_VALUE) {
                        tchecker.addProblem(ErrMsg.FCALL_ABS_OVERFLOW, astStdLib.position, CifTextUtils.typeToStr((CifType)atypes[0]));
                        throw new SemanticException();
                    }
                    int[] resultRange = CifExprsTypeChecker.getAbsResultRange(lower, upper);
                    itype.setLower(Integer.valueOf(resultRange[0]));
                    itype.setUpper(Integer.valueOf(resultRange[1]));
                    break;
                }
                Assert.check((boolean)(ntype instanceof RealType));
                DistType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case CBRT: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case CEIL: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType type = CifConstructors.newIntType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case DELETE: {
                ListType type;
                if (!(natypes[0] instanceof ListType) || !(natypes[1] instanceof IntType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                ListType ltype = (ListType)natypes[0];
                IntType itype = (IntType)natypes[1];
                if (!CifTypeUtils.isRangeless((ListType)ltype) && !CifTypeUtils.isRangeless((IntType)itype)) {
                    long u = ltype.getUpper().intValue();
                    long a = itype.getLower().intValue();
                    long b = itype.getUpper().intValue();
                    if (a >= 0L && b >= 0L && a >= u) {
                        tchecker.addProblem(ErrMsg.FCALL_DELETE_OUT_OF_BOUNDS, astStdLib.position, CifTextUtils.typeToStr((CifType)atypes[0]), CifTextUtils.typeToStr((CifType)atypes[1]));
                        throw new SemanticException();
                    }
                }
                if (!CifTypeUtils.isRangeless((ListType)(type = (ListType)EMFHelper.deepclone((EObject)ltype)))) {
                    type.setLower(Integer.valueOf(Math.max(0, type.getLower() - 1)));
                    type.setUpper(Integer.valueOf(Math.max(0, type.getUpper() - 1)));
                }
                resultType.setReturnType((CifType)type);
                break;
            }
            case EMPTY: {
                if (!(natypes[0] instanceof ListType || natypes[0] instanceof SetType || natypes[0] instanceof DictType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                BoolType type = CifConstructors.newBoolType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case EXP: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case FLOOR: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType type = CifConstructors.newIntType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case FORMAT: {
                if (!(args.get(0) instanceof StringExpression)) {
                    tchecker.addProblem(ErrMsg.FCALL_FMT_NOT_PATTERN, ((Expression)args.get(0)).getPosition(), new String[0]);
                    throw new SemanticException();
                }
                List valueTypes = Lists.listc((int)(args.size() - 1));
                List valuePositions = Lists.listc((int)(args.size() - 1));
                int i3 = 1;
                while (i3 < args.size()) {
                    valueTypes.add(atypes[i3]);
                    valuePositions.add(((Expression)args.get(i3)).getPosition());
                    ++i3;
                }
                StringExpression pattern = (StringExpression)args.get(0);
                CifFormatPatternChecker.checkFormatPattern(tchecker, valueTypes, valuePositions, pattern.getValue(), pattern.getPosition());
                StringType type = CifConstructors.newStringType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case LN: 
            case LOG: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case MAXIMUM: {
                if (!(natypes[0] instanceof IntType) && !(natypes[0] instanceof RealType) || !(natypes[1] instanceof IntType) && !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                if (natypes[0] instanceof IntType && natypes[1] instanceof IntType) {
                    IntType type = CifConstructors.newIntType();
                    type.setPosition(astStdLib.createPosition());
                    resultType.setReturnType((CifType)type);
                    if (CifTypeUtils.isRangeless((IntType)((IntType)natypes[0])) || CifTypeUtils.isRangeless((IntType)((IntType)natypes[1]))) break;
                    int l1 = ((IntType)natypes[0]).getLower();
                    int u1 = ((IntType)natypes[0]).getUpper();
                    int l2 = ((IntType)natypes[1]).getLower();
                    int u2 = ((IntType)natypes[1]).getUpper();
                    int l = Math.max(l1, l2);
                    int u = Math.max(u1, u2);
                    type.setLower(Integer.valueOf(l));
                    type.setUpper(Integer.valueOf(u));
                    break;
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case MINIMUM: {
                if (!(natypes[0] instanceof IntType) && !(natypes[0] instanceof RealType) || !(natypes[1] instanceof IntType) && !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                if (natypes[0] instanceof IntType && natypes[1] instanceof IntType) {
                    IntType type = CifConstructors.newIntType();
                    type.setPosition(astStdLib.createPosition());
                    resultType.setReturnType((CifType)type);
                    if (CifTypeUtils.isRangeless((IntType)((IntType)natypes[0])) || CifTypeUtils.isRangeless((IntType)((IntType)natypes[1]))) break;
                    int l1 = ((IntType)natypes[0]).getLower();
                    int u1 = ((IntType)natypes[0]).getUpper();
                    int l2 = ((IntType)natypes[1]).getLower();
                    int u2 = ((IntType)natypes[1]).getUpper();
                    int l = Math.min(l1, l2);
                    int u = Math.min(u1, u2);
                    type.setLower(Integer.valueOf(l));
                    type.setUpper(Integer.valueOf(u));
                    break;
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case POP: {
                ListType ltype;
                if (!(natypes[0] instanceof ListType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                if (!CifTypeUtils.isRangeless((ListType)(ltype = (ListType)EMFHelper.deepclone((EObject)((ListType)natypes[0]))))) {
                    ltype.setLower(Integer.valueOf(Math.max(0, ltype.getLower() - 1)));
                    ltype.setUpper(Integer.valueOf(Math.max(0, ltype.getUpper() - 1)));
                }
                CifType rtype = CifTypeUtils.makeTupleType((List)Lists.list((Object[])new CifType[]{ltype.getElementType(), ltype}));
                resultType.setReturnType((CifType)EMFHelper.deepclone((EObject)rtype));
                break;
            }
            case POWER: {
                if (!(natypes[0] instanceof IntType) && !(natypes[0] instanceof RealType) || !(natypes[1] instanceof IntType) && !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                boolean done = false;
                if (natypes[0] instanceof IntType && natypes[1] instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)natypes[0])) && !CifTypeUtils.isRangeless((IntType)((IntType)natypes[1]))) {
                    int l1 = ((IntType)natypes[0]).getLower();
                    int u1 = ((IntType)natypes[0]).getUpper();
                    int l2 = ((IntType)natypes[1]).getLower();
                    int u2 = ((IntType)natypes[1]).getUpper();
                    if (l2 >= 0) {
                        if (l2 > 1) {
                            if (l2 <= 31) {
                                int[] range = POW_RANGES[l2 - 2];
                                Assert.check((range[0] == l2 ? 1 : 0) != 0);
                                int minBase = range[1];
                                int maxBase = range[2];
                                if (l1 < minBase || u1 > maxBase) {
                                    tchecker.addProblem(ErrMsg.FCALL_POW_OVERFLOW, astStdLib.position, CifTextUtils.typeToStr((CifType)atypes[0]), CifTextUtils.typeToStr((CifType)atypes[1]));
                                    throw new SemanticException();
                                }
                            } else if (l1 < -1 || u1 > 1) {
                                tchecker.addProblem(ErrMsg.FCALL_POW_OVERFLOW, astStdLib.position, CifTextUtils.typeToStr((CifType)atypes[0]), CifTextUtils.typeToStr((CifType)atypes[1]));
                                throw new SemanticException();
                            }
                        }
                        int[] resultRange = CifExprsTypeChecker.getPowResultRange(l1, u1, l2, u2);
                        IntType itype = CifConstructors.newIntType();
                        itype.setPosition(astStdLib.createPosition());
                        resultType.setReturnType((CifType)itype);
                        itype.setLower(Integer.valueOf(resultRange[0]));
                        itype.setUpper(Integer.valueOf(resultRange[1]));
                        done = true;
                    }
                }
                if (done) break;
                DistType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case ROUND: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType type = CifConstructors.newIntType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case SCALE: {
                i2 = 0;
                while (i2 < args.size()) {
                    if (!(natypes[i2] instanceof IntType) && !(natypes[i2] instanceof RealType)) {
                        CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                    }
                    ++i2;
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case SIGN: {
                if (!(natypes[0] instanceof IntType) && !(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType itype = CifConstructors.newIntType();
                itype.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)itype);
                if (natypes[0] instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)natypes[0]))) {
                    int lower = ((IntType)natypes[0]).getLower();
                    int upper = ((IntType)natypes[0]).getUpper();
                    itype.setLower(Integer.valueOf(CifMath.sign((int)lower)));
                    itype.setUpper(Integer.valueOf(CifMath.sign((int)upper)));
                    break;
                }
                itype.setLower(Integer.valueOf(-1));
                itype.setUpper(Integer.valueOf(1));
                break;
            }
            case SIZE: {
                if (!(natypes[0] instanceof StringType || natypes[0] instanceof ListType || natypes[0] instanceof SetType || natypes[0] instanceof DictType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType type = CifConstructors.newIntType();
                type.setPosition(astStdLib.createPosition());
                if (natypes[0] instanceof ListType && !CifTypeUtils.isRangeless((ListType)((ListType)natypes[0]))) {
                    ListType ltype = (ListType)natypes[0];
                    type.setLower(ltype.getLower());
                    type.setUpper(ltype.getUpper());
                }
                resultType.setReturnType((CifType)type);
                break;
            }
            case SQRT: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType type = CifConstructors.newRealType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                break;
            }
            case BERNOULLI: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                BoolType stype = CifConstructors.newBoolType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case BETA: {
                if (!(natypes[0] instanceof RealType) || !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case BINOMIAL: {
                if (!(natypes[0] instanceof RealType) || !(natypes[1] instanceof IntType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType stype = CifConstructors.newIntType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case CONSTANT: {
                IntType stype;
                if (!(natypes[0] instanceof BoolType || natypes[0] instanceof IntType || natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                if (natypes[0] instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)natypes[0]))) {
                    stype = CifConstructors.newIntType();
                    stype.setPosition(astStdLib.createPosition());
                    type.setSampleType((CifType)stype);
                } else {
                    type.setSampleType((CifType)EMFHelper.deepclone((EObject)atypes[0]));
                }
                resultType.setReturnType((CifType)type);
                break;
            }
            case ERLANG: {
                if (!(natypes[0] instanceof IntType) || !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case EXPONENTIAL: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case GAMMA: {
                if (!(natypes[0] instanceof RealType) || !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case GEOMETRIC: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType stype = CifConstructors.newIntType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case LOG_NORMAL: 
            case NORMAL: {
                if (!(natypes[0] instanceof RealType) || !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case POISSON: {
                if (!(natypes[0] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                IntType stype = CifConstructors.newIntType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case RANDOM: {
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case TRIANGLE: {
                if (!(natypes[0] instanceof RealType && natypes[1] instanceof RealType && natypes[2] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
                break;
            }
            case UNIFORM: {
                IntType stype;
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                resultType.setReturnType((CifType)type);
                if (natypes[0] instanceof IntType && natypes[1] instanceof IntType) {
                    stype = CifConstructors.newIntType();
                    stype.setPosition(astStdLib.createPosition());
                    type.setSampleType((CifType)stype);
                    break;
                }
                if (natypes[0] instanceof RealType && natypes[1] instanceof RealType) {
                    stype = CifConstructors.newRealType();
                    stype.setPosition(astStdLib.createPosition());
                    type.setSampleType((CifType)stype);
                    break;
                }
                CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                break;
            }
            case WEIBULL: {
                if (!(natypes[0] instanceof RealType) || !(natypes[1] instanceof RealType)) {
                    CifExprsTypeChecker.addFcallArgProblem(astStdLib, args, tchecker);
                }
                RealType stype = CifConstructors.newRealType();
                stype.setPosition(astStdLib.createPosition());
                DistType type = CifConstructors.newDistType();
                type.setPosition(astStdLib.createPosition());
                type.setSampleType((CifType)stype);
                resultType.setReturnType((CifType)type);
            }
        }
        mmCall.setType((CifType)EMFHelper.deepclone((EObject)resultType.getReturnType()));
        return mmCall;
    }

    private static void checkFuncCallArgCounts(AStdLibFunctionExpression expr, List<AExpression> args, int expected, CifTypeChecker tchecker) {
        if (args.size() != expected) {
            tchecker.addProblem(ErrMsg.FCALL_WRONG_ARG_COUNT, expr.position, "\"" + expr.function + "\"", String.valueOf(String.valueOf(expected)) + " argument" + (expected == 1 ? "" : "s"), String.valueOf(String.valueOf(args.size())) + (args.size() == 1 ? " argument is" : " arguments are"));
            throw new SemanticException();
        }
    }

    private static void addFcallArgProblem(AStdLibFunctionExpression expr, List<Expression> args, CifTypeChecker tchecker) {
        List argTypeTexts = Lists.list();
        for (Expression arg : args) {
            argTypeTexts.add("\"" + CifTextUtils.typeToStr((CifType)arg.getType()) + "\"");
        }
        tchecker.addProblem(ErrMsg.FCALL_WRONG_ARG_TYPES, expr.position, "\"" + expr.function + "\"", String.join((CharSequence)", ", argTypeTexts));
        throw new SemanticException();
    }

    public static int[] getAbsResultRange(int lower, int upper) {
        int rsltL = Math.min(Math.abs(lower), Math.abs(upper));
        int rsltU = Math.max(Math.abs(lower), Math.abs(upper));
        if (lower <= 0 && upper >= 0) {
            rsltL = 0;
        }
        return new int[]{rsltL, rsltU};
    }

    public static int[] getPowResultRange(int l1, int u1, int l2, int u2) {
        Assert.check((l2 >= 0 ? 1 : 0) != 0);
        List range1 = Lists.list((Object[])new Integer[]{l1, u1});
        List range2 = Lists.list((Object[])new Integer[]{l2, u2});
        if (l1 <= 0 && u1 >= 0) {
            range1.add(0);
        }
        if (l2 <= 0 && u2 >= 0) {
            range2.add(0);
        }
        if (l1 + 1 <= u1) {
            range1.add(l1 + 1);
        }
        if (l2 + 1 <= u2) {
            range2.add(l2 + 1);
        }
        if (l1 <= u1 - 1) {
            range1.add(u1 - 1);
        }
        if (l2 <= u2 - 1) {
            range2.add(u2 - 1);
        }
        int minimum = Integer.MAX_VALUE;
        int maximum = Integer.MIN_VALUE;
        Iterator iterator = range1.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            Iterator iterator2 = range2.iterator();
            while (iterator2.hasNext()) {
                int y = (Integer)iterator2.next();
                Assert.check((y >= 0 ? 1 : 0) != 0);
                int rslt = (int)Math.pow(x, y);
                minimum = Math.min(minimum, rslt);
                maximum = Math.max(maximum, rslt);
            }
        }
        return new int[]{minimum, maximum};
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ListExpression transListExpression(AListExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        CifType childHint = null;
        if (nhint instanceof ListType) {
            childHint = ((ListType)nhint).getElementType();
        }
        List elems = Lists.listc((int)expr.elements.size());
        boolean first = true;
        for (AExpression aexpr : expr.elements) {
            Expression child = CifExprsTypeChecker.transExpression(aexpr, childHint, scope, context, tchecker);
            elems.add(child);
            if (!first) continue;
            first = false;
            childHint = child.getType();
        }
        CifType etype = null;
        if (elems.isEmpty()) {
            if (childHint == null) {
                tchecker.addProblem(ErrMsg.EXPR_UNKNOWN_TYPE, expr.position, "[]");
                throw new SemanticException();
            }
            etype = (CifType)EMFHelper.deepclone((EObject)childHint);
        } else {
            for (Expression elem : elems) {
                if (etype == null) {
                    etype = (CifType)EMFHelper.deepclone((EObject)elem.getType());
                    if (!CifTypeUtils.hasComponentLikeType((CifType)etype)) continue;
                    tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, expr.position, CifTextUtils.typeToStr((CifType)etype), "elements of lists");
                    throw new SemanticException();
                }
                if (!CifTypeUtils.checkTypeCompat((CifType)etype, (CifType)elem.getType(), (RangeCompat)RangeCompat.IGNORE)) {
                    tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, elem.getPosition(), CifTextUtils.typeToStr((CifType)etype), CifTextUtils.typeToStr((CifType)elem.getType()), "elements of a list");
                    tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, ((Expression)Lists.first((List)elems)).getPosition(), CifTextUtils.typeToStr((CifType)etype), CifTextUtils.typeToStr((CifType)elem.getType()), "elements of a list");
                    throw new SemanticException();
                }
                etype = CifTypeUtils.mergeTypes((CifType)etype, (CifType)elem.getType());
            }
        }
        ListType type = CifConstructors.newListType();
        type.setPosition(expr.createPosition());
        type.setElementType(etype);
        type.setLower(Integer.valueOf(elems.size()));
        type.setUpper(Integer.valueOf(elems.size()));
        ListExpression rslt = CifConstructors.newListExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)type);
        rslt.getElements().addAll((Collection)elems);
        return rslt;
    }

    private static Expression transEmptySetDictExpression(AEmptySetDictExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        SetExpression rslt = null;
        if (nhint instanceof SetType) {
            rslt = CifConstructors.newSetExpression();
        } else if (nhint instanceof DictType) {
            rslt = CifConstructors.newDictExpression();
        } else {
            tchecker.addProblem(ErrMsg.EXPR_UNKNOWN_TYPE, expr.position, "{}");
            throw new SemanticException();
        }
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)EMFHelper.deepclone((EObject)hint));
        return rslt;
    }

    private static SetExpression transSetExpression(ASetExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        Assert.check((!expr.elements.isEmpty() ? 1 : 0) != 0);
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        CifType childHint = null;
        if (nhint instanceof SetType) {
            childHint = ((SetType)nhint).getElementType();
        }
        List elems = Lists.listc((int)expr.elements.size());
        boolean first = true;
        for (AExpression aexpr : expr.elements) {
            Expression child = CifExprsTypeChecker.transExpression(aexpr, childHint, scope, context, tchecker);
            elems.add(child);
            if (!first) continue;
            first = false;
            childHint = child.getType();
        }
        CifType etype = null;
        for (Expression elem : elems) {
            if (etype == null) {
                etype = (CifType)EMFHelper.deepclone((EObject)elem.getType());
                if (CifTypeUtils.supportsValueEquality((CifType)etype)) continue;
                tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, expr.position, CifTextUtils.typeToStr((CifType)etype), "elements of sets");
                throw new SemanticException();
            }
            if (!CifTypeUtils.checkTypeCompat((CifType)etype, (CifType)elem.getType(), (RangeCompat)RangeCompat.IGNORE)) {
                tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, elem.getPosition(), CifTextUtils.typeToStr((CifType)etype), CifTextUtils.typeToStr((CifType)elem.getType()), "elements of a set");
                tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, ((Expression)Lists.first((List)elems)).getPosition(), CifTextUtils.typeToStr((CifType)etype), CifTextUtils.typeToStr((CifType)elem.getType()), "elements of a set");
                throw new SemanticException();
            }
            etype = CifTypeUtils.mergeTypes((CifType)etype, (CifType)elem.getType());
        }
        SetType type = CifConstructors.newSetType();
        type.setPosition(expr.createPosition());
        type.setElementType(etype);
        SetExpression rslt = CifConstructors.newSetExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)type);
        rslt.getElements().addAll((Collection)elems);
        return rslt;
    }

    private static TupleExpression transTupleExpression(ATupleExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        CifType[] fieldHints = new CifType[expr.elements.size()];
        if (nhint instanceof TupleType) {
            EList fields = ((TupleType)nhint).getFields();
            int cnt = Math.min(fieldHints.length, fields.size());
            int i = 0;
            while (i < cnt) {
                fieldHints[i] = ((Field)fields.get(i)).getType();
                ++i;
            }
        }
        List elems = Lists.listc((int)expr.elements.size());
        int i = 0;
        while (i < expr.elements.size()) {
            AExpression aexpr = (AExpression)expr.elements.get(i);
            CifType fieldHint = fieldHints[i];
            Expression elem = CifExprsTypeChecker.transExpression(aexpr, fieldHint, scope, context, tchecker);
            elems.add(elem);
            ++i;
        }
        TupleType ttype = CifConstructors.newTupleType();
        ttype.setPosition(expr.createPosition());
        for (Expression elem : elems) {
            Field field = CifConstructors.newField();
            field.setPosition(PositionUtils.copyPosition((Position)elem.getPosition()));
            field.setType((CifType)EMFHelper.deepclone((EObject)elem.getType()));
            ttype.getFields().add((Object)field);
            if (!CifTypeUtils.hasComponentLikeType((CifType)elem.getType())) continue;
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, expr.position, CifTextUtils.typeToStr((CifType)elem.getType()), "fields of tuples");
            throw new SemanticException();
        }
        TupleExpression rslt = CifConstructors.newTupleExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)ttype);
        rslt.getFields().addAll((Collection)elems);
        return rslt;
    }

    private static DictExpression transDictExpression(ADictExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        Assert.check((!expr.pairs.isEmpty() ? 1 : 0) != 0);
        CifType nhint = CifExprsTypeChecker.normalizeHint(hint);
        CifType keyHint = null;
        CifType valueHint = null;
        if (nhint instanceof DictType) {
            keyHint = ((DictType)nhint).getKeyType();
            valueHint = ((DictType)nhint).getValueType();
        }
        List pairs = Lists.listc((int)expr.pairs.size());
        boolean first = true;
        for (ADictPair apair : expr.pairs) {
            Expression key = CifExprsTypeChecker.transExpression(apair.key, keyHint, scope, context, tchecker);
            Expression value = CifExprsTypeChecker.transExpression(apair.value, valueHint, scope, context, tchecker);
            DictPair pair = CifConstructors.newDictPair();
            pair.setPosition(apair.createPosition());
            pair.setKey(key);
            pair.setValue(value);
            pairs.add(pair);
            if (!first) continue;
            first = false;
            keyHint = key.getType();
            valueHint = value.getType();
        }
        CifType ktype = null;
        CifType vtype = null;
        for (DictPair pair : pairs) {
            if (ktype == null) {
                ktype = (CifType)EMFHelper.deepclone((EObject)pair.getKey().getType());
                vtype = (CifType)EMFHelper.deepclone((EObject)pair.getValue().getType());
                if (!CifTypeUtils.supportsValueEquality((CifType)ktype)) {
                    tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, expr.position, CifTextUtils.typeToStr((CifType)ktype), "keys of dictionaries");
                    throw new SemanticException();
                }
                if (!CifTypeUtils.hasComponentLikeType((CifType)vtype)) continue;
                tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, expr.position, CifTextUtils.typeToStr((CifType)vtype), "values of dictionaries");
                throw new SemanticException();
            }
            if (!CifTypeUtils.checkTypeCompat((CifType)ktype, (CifType)pair.getKey().getType(), (RangeCompat)RangeCompat.IGNORE)) {
                tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, pair.getKey().getPosition(), CifTextUtils.typeToStr((CifType)ktype), CifTextUtils.typeToStr((CifType)pair.getKey().getType()), "keys of a dictionary");
                tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, ((DictPair)Lists.first((List)pairs)).getKey().getPosition(), CifTextUtils.typeToStr((CifType)ktype), CifTextUtils.typeToStr((CifType)pair.getKey().getType()), "keys of a dictionary");
                throw new SemanticException();
            }
            ktype = CifTypeUtils.mergeTypes((CifType)ktype, (CifType)pair.getKey().getType());
            if (!CifTypeUtils.checkTypeCompat((CifType)vtype, (CifType)pair.getValue().getType(), (RangeCompat)RangeCompat.IGNORE)) {
                tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, pair.getValue().getPosition(), CifTextUtils.typeToStr((CifType)vtype), CifTextUtils.typeToStr((CifType)pair.getValue().getType()), "values of a dictionary");
                tchecker.addProblem(ErrMsg.CONTAINER_EXPR_INCOMPAT_TYPES, ((DictPair)Lists.first((List)pairs)).getValue().getPosition(), CifTextUtils.typeToStr((CifType)vtype), CifTextUtils.typeToStr((CifType)pair.getValue().getType()), "values of a dictionary");
                throw new SemanticException();
            }
            vtype = CifTypeUtils.mergeTypes((CifType)vtype, (CifType)pair.getValue().getType());
        }
        DictType type = CifConstructors.newDictType();
        type.setPosition(expr.createPosition());
        type.setKeyType(ktype);
        type.setValueType(vtype);
        DictExpression rslt = CifConstructors.newDictExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)type);
        rslt.getPairs().addAll((Collection)pairs);
        return rslt;
    }

    private static IfExpression transIfExpression(AIfExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        IfExpression rslt = CifConstructors.newIfExpression();
        rslt.setPosition(expr.createPosition());
        EList guards = rslt.getGuards();
        for (AExpression g : expr.guards) {
            Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)BOOL_TYPE_HINT, scope, context, tchecker);
            CifType t = guard.getType();
            CifType nt = CifTypeUtils.normalizeType((CifType)t);
            if (!(nt instanceof BoolType)) {
                tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
                throw new SemanticException();
            }
            guards.add(guard);
        }
        Expression thenExpr = CifExprsTypeChecker.transExpression(expr.then, hint, scope, context, tchecker);
        CifType thenType = thenExpr.getType();
        rslt.setThen(thenExpr);
        if (CifTypeUtils.hasComponentLikeType((CifType)thenType)) {
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, expr.position, CifTextUtils.typeToStr((CifType)thenType), "results of ifs");
            throw new SemanticException();
        }
        Expression elseExpr = CifExprsTypeChecker.transExpression(expr.elseExpr, hint, scope, context, tchecker);
        CifType elseType = elseExpr.getType();
        rslt.setElse(elseExpr);
        if (!CifTypeUtils.checkTypeCompat((CifType)thenType, (CifType)elseType, (RangeCompat)RangeCompat.IGNORE)) {
            tchecker.addProblem(ErrMsg.IFEXPR_INCOMPAT_TYPES, elseExpr.getPosition(), CifTextUtils.typeToStr((CifType)thenType), "else", CifTextUtils.typeToStr((CifType)elseType));
            throw new SemanticException();
        }
        EList elifs = rslt.getElifs();
        for (AElifExpression elif : expr.elifs) {
            ElifExpression elifRslt = CifConstructors.newElifExpression();
            elifRslt.setPosition(elif.createPosition());
            elifs.add(elifRslt);
            guards = elifRslt.getGuards();
            for (AExpression g : elif.guards) {
                Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)BOOL_TYPE_HINT, scope, context, tchecker);
                CifType t = guard.getType();
                CifType nt = CifTypeUtils.normalizeType((CifType)t);
                if (!(nt instanceof BoolType)) {
                    tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
                    throw new SemanticException();
                }
                guards.add(guard);
            }
            Expression elifExpr = CifExprsTypeChecker.transExpression(elif.then, hint, scope, context, tchecker);
            CifType elifType = elifExpr.getType();
            elifRslt.setThen(elifExpr);
            if (CifTypeUtils.checkTypeCompat((CifType)thenType, (CifType)elifType, (RangeCompat)RangeCompat.IGNORE)) continue;
            tchecker.addProblem(ErrMsg.IFEXPR_INCOMPAT_TYPES, elifExpr.getPosition(), CifTextUtils.typeToStr((CifType)thenType), "elif", CifTextUtils.typeToStr((CifType)elifType));
            throw new SemanticException();
        }
        CifType mergedType = thenType;
        mergedType = CifTypeUtils.mergeTypes((CifType)mergedType, (CifType)elseType);
        for (ElifExpression elif : rslt.getElifs()) {
            CifType elifType = elif.getThen().getType();
            mergedType = CifTypeUtils.mergeTypes((CifType)mergedType, (CifType)elifType);
        }
        rslt.setType(mergedType);
        return rslt;
    }

    private static SwitchExpression transSwitchExpression(ASwitchExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        SwitchExpression rslt = CifConstructors.newSwitchExpression();
        rslt.setPosition(expr.createPosition());
        Expression value = CifExprsTypeChecker.transExpression(expr.value, NO_TYPE_HINT, scope, context, tchecker);
        rslt.setValue(value);
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        if (!isAutRef) {
            if (CifTypeUtils.hasComponentLikeType((CifType)value.getType())) {
                tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, expr.value.position, CifTextUtils.typeToStr((CifType)value.getType()), "the control value of a switch");
                throw new SemanticException();
            }
            if (!CifTypeUtils.supportsValueEquality((CifType)value.getType())) {
                tchecker.addProblem(ErrMsg.SWITCH_NO_VALUE_EQ, expr.value.position, CifTextUtils.typeToStr((CifType)value.getType()));
                throw new SemanticException();
            }
        }
        EList cases = rslt.getCases();
        CifType firstCaseValueType = null;
        boolean caseErr = false;
        for (ASwitchCase acase : expr.cases) {
            SwitchCase cse;
            try {
                cse = CifExprsTypeChecker.transSwitchCase(expr, rslt.getValue(), acase, isAutRef, firstCaseValueType, hint, scope, context, tchecker);
            }
            catch (SemanticException ex) {
                caseErr = true;
                continue;
            }
            cases.add(cse);
            if (firstCaseValueType != null) continue;
            firstCaseValueType = cse.getValue().getType();
        }
        if (caseErr) {
            throw new SemanticException();
        }
        if (isAutRef) {
            CifExprsTypeChecker.checkSwitchLocsComplete(rslt, scope, tchecker);
        } else if (((SwitchCase)Lists.last((List)cases)).getKey() != null) {
            tchecker.addProblem(ErrMsg.SWITCH_MISSING_ELSE, expr.position, new String[0]);
            throw new SemanticException();
        }
        CifType mergedType = null;
        for (SwitchCase cse : cases) {
            CifType caseType = cse.getValue().getType();
            CifType cifType = mergedType = mergedType == null ? caseType : CifTypeUtils.mergeTypes((CifType)mergedType, (CifType)caseType);
        }
        if (cases.size() == 1) {
            mergedType = (CifType)EMFHelper.deepclone(mergedType);
        }
        rslt.setType(mergedType);
        return rslt;
    }

    private static SwitchCase transSwitchCase(ASwitchExpression astSwitch, Expression switchValue, ASwitchCase astCase, boolean isAutRef, CifType firstCaseValueType, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        boolean typeMatch;
        SwitchCase cse = CifConstructors.newSwitchCase();
        cse.setPosition(astCase.createPosition());
        AExpression astKey = astCase.key;
        if (astKey != null) {
            if (isAutRef) {
                ParentScope<?> keyScope;
                Automaton aut = CifExprsTypeChecker.getAutomaton(switchValue, scope);
                if (!(astKey instanceof ANameExpression)) {
                    tchecker.addProblem(ErrMsg.SWITCH_CASE_LOC_ID, astKey.position, CifTextUtils.getAbsName((PositionObject)aut));
                    throw new SemanticException();
                }
                ANameExpression astNameExpr = (ANameExpression)astKey;
                if (astNameExpr.derivative) {
                    tchecker.addProblem(ErrMsg.SWITCH_CASE_LOC_ID, astKey.position, CifTextUtils.getAbsName((PositionObject)aut));
                    throw new SemanticException();
                }
                String locName = astNameExpr.name.name;
                if (!CifValidationUtils.isValidIdentifier((String)locName)) {
                    tchecker.addProblem(ErrMsg.SWITCH_CASE_LOC_ID, astKey.position, CifTextUtils.getAbsName((PositionObject)aut));
                    throw new SemanticException();
                }
                AExpression astSwitchValue = astSwitch.value;
                boolean isSelf = astSwitchValue instanceof ASelfExpression;
                if (isSelf) {
                    keyScope = scope;
                } else {
                    Assert.check((boolean)(astSwitchValue instanceof ANameExpression));
                    String autRef = ((ANameExpression)astSwitchValue).name.name;
                    SymbolTableEntry entry = scope.resolve(null, autRef, tchecker, null);
                    keyScope = (ParentScope<?>)entry;
                    if (keyScope instanceof CompInstScope) {
                        keyScope = ((CompInstScope)((Object)keyScope)).getCompDefScope();
                    } else if (keyScope instanceof CompParamScope) {
                        keyScope = ((CompParamScope)((Object)keyScope)).getCompDefScope();
                    }
                }
                Expression key = CifExprsTypeChecker.transExpression(astKey, NO_TYPE_HINT, keyScope, context, tchecker);
                cse.setKey(key);
                Expression ukey = CifTypeUtils.unwrapExpression((Expression)key);
                if (!(ukey instanceof LocationExpression)) {
                    tchecker.addProblem(ErrMsg.SWITCH_CASE_LOC_REF, astKey.position, CifTextUtils.getAbsName((PositionObject)CifScopeUtils.getRefObjFromRef((Expression)key)), CifTextUtils.getAbsName((PositionObject)aut));
                    throw new SemanticException();
                }
                Location loc = ((LocationExpression)ukey).getLocation();
                if (!(loc.eContainer() instanceof Automaton)) {
                    tchecker.addProblem(ErrMsg.SWITCH_CASE_LOC_REF, astKey.position, CifTextUtils.getAbsName((PositionObject)loc), CifTextUtils.getAbsName((PositionObject)aut));
                    throw new SemanticException();
                }
                Automaton locAut = (Automaton)loc.eContainer();
                Assert.check((locAut == aut ? 1 : 0) != 0);
                CifExprsTypeChecker.changeLocRefScope(key, switchValue);
            } else {
                CifType keyHint = switchValue.getType();
                Expression key = CifExprsTypeChecker.transExpression(astKey, keyHint, scope, context, tchecker);
                cse.setKey(key);
                if (!CifTypeUtils.checkTypeCompat((CifType)switchValue.getType(), (CifType)key.getType(), (RangeCompat)RangeCompat.IGNORE)) {
                    tchecker.addProblem(ErrMsg.SWITCH_CASE_KEY_TYPE, astKey.position, CifTextUtils.typeToStr((CifType)key.getType()), CifTextUtils.typeToStr((CifType)switchValue.getType()));
                    throw new SemanticException();
                }
            }
        }
        CifType valueHint = firstCaseValueType == null ? hint : firstCaseValueType;
        Expression valueExpr = CifExprsTypeChecker.transExpression(astCase.value, valueHint, scope, context, tchecker);
        cse.setValue(valueExpr);
        CifType caseValueType = valueExpr.getType();
        if (CifTypeUtils.hasComponentLikeType((CifType)caseValueType)) {
            tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, astCase.value.position, CifTextUtils.typeToStr((CifType)caseValueType), "results of switches");
            throw new SemanticException();
        }
        if (firstCaseValueType != null && !(typeMatch = CifTypeUtils.checkTypeCompat((CifType)firstCaseValueType, (CifType)caseValueType, (RangeCompat)RangeCompat.IGNORE))) {
            tchecker.addProblem(ErrMsg.SWITCH_EXPR_INCOMPAT_TYPES, valueExpr.getPosition(), CifTextUtils.typeToStr((CifType)caseValueType), CifTextUtils.typeToStr((CifType)firstCaseValueType));
            throw new SemanticException();
        }
        return cse;
    }

    private static Expression changeLocRefScope(Expression locRef, Expression autRef) {
        if (autRef instanceof SelfExpression) {
            return locRef;
        }
        if (autRef instanceof CompParamExpression) {
            CompParamExpression expr = (CompParamExpression)autRef;
            CompParamWrapExpression wrap = CifConstructors.newCompParamWrapExpression();
            wrap.setParameter(expr.getParameter());
            wrap.setType((CifType)CifConstructors.newBoolType());
            EMFHelper.updateParentContainment((EObject)locRef, (EObject)wrap);
            wrap.setReference(locRef);
            return wrap;
        }
        if (autRef instanceof CompParamWrapExpression) {
            CompParamWrapExpression wrap1 = (CompParamWrapExpression)autRef;
            locRef = CifExprsTypeChecker.changeLocRefScope(locRef, wrap1.getReference());
            CompParamWrapExpression wrap2 = CifConstructors.newCompParamWrapExpression();
            wrap2.setParameter(wrap1.getParameter());
            wrap2.setType((CifType)CifConstructors.newBoolType());
            EMFHelper.updateParentContainment((EObject)locRef, (EObject)wrap2);
            wrap2.setReference(locRef);
            return wrap2;
        }
        if (autRef instanceof CompInstWrapExpression) {
            CompInstWrapExpression wrap1 = (CompInstWrapExpression)autRef;
            locRef = CifExprsTypeChecker.changeLocRefScope(locRef, wrap1.getReference());
            CompInstWrapExpression wrap2 = CifConstructors.newCompInstWrapExpression();
            wrap2.setInstantiation(wrap1.getInstantiation());
            wrap2.setType((CifType)CifConstructors.newBoolType());
            EMFHelper.updateParentContainment((EObject)locRef, (EObject)wrap2);
            wrap2.setReference(locRef);
            return wrap2;
        }
        if (autRef instanceof ComponentExpression) {
            Component comp = ((ComponentExpression)autRef).getComponent();
            if (comp instanceof Automaton) {
                return locRef;
            }
            Assert.check((boolean)(comp instanceof ComponentInst));
            Automaton aut = CifScopeUtils.getAutomaton((Component)comp);
            Assert.notNull((Object)aut);
            CompInstWrapExpression wrap = CifConstructors.newCompInstWrapExpression();
            wrap.setType((CifType)CifConstructors.newBoolType());
            wrap.setInstantiation((ComponentInst)comp);
            EMFHelper.updateParentContainment((EObject)locRef, (EObject)wrap);
            wrap.setReference(locRef);
            return wrap;
        }
        throw new RuntimeException("Unexpected aut ref/wrap expr: " + autRef);
    }

    private static void checkSwitchLocsComplete(SwitchExpression switchExpr, SymbolScope<?> scope, CifTypeChecker tchecker) {
        Automaton aut = CifExprsTypeChecker.getAutomaton(switchExpr.getValue(), scope);
        Set todo = Sets.list2set((List)aut.getLocations());
        Map done = Maps.map();
        Position elsePos = null;
        EList cases = switchExpr.getCases();
        for (SwitchCase cse : cases) {
            Expression locRef = cse.getKey();
            if (locRef == null) {
                Assert.check((elsePos == null ? 1 : 0) != 0);
                elsePos = cse.getPosition();
                continue;
            }
            locRef = CifTypeUtils.unwrapExpression((Expression)locRef);
            Location loc = ((LocationExpression)locRef).getLocation();
            todo.remove(loc);
            Position prevPos = (Position)done.get(loc);
            if (prevPos != null) {
                tchecker.addProblem(ErrMsg.SWITCH_AUT_DUPL_LOC, locRef.getPosition(), CifTextUtils.getAbsName((PositionObject)loc));
                tchecker.addProblem(ErrMsg.SWITCH_AUT_DUPL_LOC, prevPos, CifTextUtils.getAbsName((PositionObject)loc));
                throw new SemanticException();
            }
            done.put(loc, locRef.getPosition());
        }
        if (!todo.isEmpty() && elsePos == null) {
            for (Location loc : todo) {
                tchecker.addProblem(ErrMsg.SWITCH_AUT_MISSING_LOC, switchExpr.getPosition(), CifTextUtils.getAbsName((PositionObject)loc));
            }
            throw new SemanticException();
        }
        if (todo.isEmpty() && !aut.getLocations().isEmpty() && elsePos != null) {
            tchecker.addProblem(ErrMsg.SWITCH_AUT_SUPERFLUOUS_ELSE, elsePos, new String[0]);
        }
    }

    private static Automaton getAutomaton(Expression autRef, SymbolScope<?> scope) {
        if ((autRef = CifTypeUtils.unwrapExpression((Expression)autRef)) instanceof SelfExpression) {
            if (scope instanceof AutScope) {
                return (Automaton)((AutScope)scope).getObject();
            }
            Assert.check((boolean)(scope instanceof AutDefScope));
            ComponentDef cdef = (ComponentDef)((AutDefScope)scope).getObject();
            return (Automaton)cdef.getBody();
        }
        if (autRef instanceof CompParamExpression) {
            CifType t = CifTypeUtils.normalizeType((CifType)((CompParamExpression)autRef).getType());
            Assert.check((boolean)(t instanceof ComponentDefType));
            ComponentDef cdef = ((ComponentDefType)t).getDefinition();
            return (Automaton)cdef.getBody();
        }
        Assert.check((boolean)(autRef instanceof ComponentExpression));
        Component comp = ((ComponentExpression)autRef).getComponent();
        return CifScopeUtils.getAutomaton((Component)comp);
    }

    private static Expression transNameExpression(ANameExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        SymbolTableEntry entry = scope.resolve(expr.position, expr.name.name, tchecker, scope);
        if (entry instanceof EnumDeclWrap || entry instanceof TypeDeclWrap) {
            tchecker.addProblem(ErrMsg.TYPE_REF_IN_EXPR, expr.position, entry.getAbsName());
            throw new SemanticException();
        }
        if (entry instanceof InvDeclWrap) {
            tchecker.addProblem(ErrMsg.INV_REF_IN_EXPR, expr.position, entry.getAbsName());
            throw new SemanticException();
        }
        Assert.check((!(entry instanceof SpecScope) ? 1 : 0) != 0);
        if (entry instanceof AutDefScope || entry instanceof GroupDefScope) {
            tchecker.addProblem(ErrMsg.COMPDEF_REF_IN_EXPR, expr.position, entry.getAbsName());
            throw new SemanticException();
        }
        if (!(!(entry instanceof EventDeclWrap) && !(entry instanceof FormalEventDeclWrap) || context != null && context.conditions.contains((Object)ExprContext.Condition.ALLOW_EVENT))) {
            tchecker.addProblem(ErrMsg.EVENT_OCCURRENCE, expr.position, entry.getAbsName());
            throw new SemanticException();
        }
        entry.tcheckForUse();
        Expression rslt = scope.resolveAsExpr(expr.name.name, expr.position, "", tchecker);
        Expression urslt = CifTypeUtils.unwrapExpression((Expression)rslt);
        if (urslt instanceof ContVariableExpression) {
            ((ContVariableExpression)urslt).setDerivative(expr.derivative);
        } else if (expr.derivative) {
            tchecker.addProblem(ErrMsg.DER_OF_NON_CONT_VAR, expr.position, "", entry.getAbsName());
        }
        return rslt;
    }

    private static Expression transTauExpression(ATauExpression expr, CifType hint, SymbolScope<?> scope) {
        BoolType type = CifConstructors.newBoolType();
        type.setPosition(expr.createPosition());
        TauExpression rslt = CifConstructors.newTauExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)type);
        return rslt;
    }

    private static Expression transReceivedExpression(AReceivedExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        if (context == null || context.receiveType == null) {
            tchecker.addProblem(ErrMsg.RCVD_VALUE_OCCURRENCE, expr.position, new String[0]);
            throw new SemanticException();
        }
        CifType ntype = CifTypeUtils.normalizeType((CifType)context.receiveType);
        if (ntype instanceof VoidType) {
            tchecker.addProblem(ErrMsg.RCVD_VALUE_VOID, expr.position, new String[0]);
            throw new SemanticException();
        }
        ReceivedExpression rslt = CifConstructors.newReceivedExpression();
        rslt.setPosition(expr.createPosition());
        rslt.setType((CifType)EMFHelper.deepclone((EObject)context.receiveType));
        return rslt;
    }

    private static Expression transSelfExpression(ASelfExpression expr, CifType hint, SymbolScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        if (!(scope instanceof AutScope) && !(scope instanceof AutDefScope)) {
            tchecker.addProblem(ErrMsg.SELF_OCCURRENCE, expr.position, scope.getAbsText());
            throw new SemanticException();
        }
        SelfExpression rslt = CifConstructors.newSelfExpression();
        rslt.setPosition(expr.createPosition());
        if (scope instanceof AutScope) {
            Automaton aut = (Automaton)((AutScope)scope).getObject();
            ComponentType type = CifConstructors.newComponentType();
            type.setComponent((Component)aut);
            rslt.setType((CifType)type);
        } else {
            Assert.check((boolean)(scope instanceof AutDefScope));
            ComponentDef cdef = (ComponentDef)((AutDefScope)scope).getObject();
            ComponentDefType type = CifConstructors.newComponentDefType();
            type.setDefinition(cdef);
            rslt.setType((CifType)type);
        }
        return rslt;
    }

    private static CifType normalizeHint(CifType hint) {
        return hint == null ? null : CifTypeUtils.normalizeType((CifType)hint);
    }

    public static long min(long ... values) {
        Assert.check((values.length > 0 ? 1 : 0) != 0);
        long rslt = Integer.MAX_VALUE;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            rslt = rslt <= value ? rslt : value;
            ++n2;
        }
        return rslt;
    }

    public static long max(long ... values) {
        Assert.check((values.length > 0 ? 1 : 0) != 0);
        long rslt = Integer.MIN_VALUE;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            rslt = rslt >= value ? rslt : value;
            ++n2;
        }
        return rslt;
    }
}

