/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgCopy;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgFile;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgIn;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgInEventIf;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgInEventIfEntry;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgInEventSingle;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgMove;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgOut;
import org.eclipse.escet.cif.typechecker.CifEventRefTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifSvgTypeChecker {
    private final CifTypeChecker tchecker;

    public CifSvgTypeChecker(CifTypeChecker tchecker) {
        this.tchecker = tchecker;
    }

    public SvgFile checkSvgFile(ASvgFile astSvgFile, ParentScope<?> scope) {
        SvgFile svgFile = CifConstructors.newSvgFile();
        svgFile.setPath(astSvgFile.svgPath.txt);
        svgFile.setPosition(astSvgFile.svgPath.createPosition());
        return svgFile;
    }

    public SvgCopy checkSvgCopy(ASvgCopy astSvgCopy, ParentScope<?> scope) {
        CifType ntype;
        CifType type;
        SvgCopy svgCopy = CifConstructors.newSvgCopy();
        svgCopy.setPosition(astSvgCopy.createPosition());
        Expression id = CifExprsTypeChecker.transExpression(astSvgCopy.svgId, (CifType)CifExprsTypeChecker.STRING_TYPE_HINT, scope, null, this.tchecker);
        svgCopy.setId(id);
        CifType idtype = id.getType();
        CifType nidtype = CifTypeUtils.normalizeType((CifType)idtype);
        if (!(nidtype instanceof StringType)) {
            this.tchecker.addProblem(ErrMsg.SVG_ID_NON_STR, id.getPosition(), CifTextUtils.typeToStr((CifType)idtype));
            throw new SemanticException();
        }
        if (astSvgCopy.pre == null && astSvgCopy.post == null) {
            this.tchecker.addProblem(ErrMsg.SVG_COPY_NO_PRE_POST, svgCopy.getPosition(), new String[0]);
            throw new SemanticException();
        }
        if (astSvgCopy.pre != null) {
            Expression pre = CifExprsTypeChecker.transExpression(astSvgCopy.pre, (CifType)CifExprsTypeChecker.STRING_TYPE_HINT, scope, null, this.tchecker);
            svgCopy.setPre(pre);
            type = pre.getType();
            ntype = CifTypeUtils.normalizeType((CifType)type);
            if (!(ntype instanceof StringType)) {
                this.tchecker.addProblem(ErrMsg.SVG_COPY_NON_STR, pre.getPosition(), "prefix", CifTextUtils.typeToStr((CifType)type));
                throw new SemanticException();
            }
        }
        if (astSvgCopy.post != null) {
            Expression post = CifExprsTypeChecker.transExpression(astSvgCopy.post, (CifType)CifExprsTypeChecker.STRING_TYPE_HINT, scope, null, this.tchecker);
            svgCopy.setPost(post);
            type = post.getType();
            ntype = CifTypeUtils.normalizeType((CifType)type);
            if (!(ntype instanceof StringType)) {
                this.tchecker.addProblem(ErrMsg.SVG_COPY_NON_STR, post.getPosition(), "postfix", CifTextUtils.typeToStr((CifType)type));
                throw new SemanticException();
            }
        }
        if (astSvgCopy.svgFile != null) {
            svgCopy.setSvgFile(this.checkSvgFile(astSvgCopy.svgFile, scope));
        }
        return svgCopy;
    }

    public SvgMove checkSvgMove(ASvgMove astSvgMove, ParentScope<?> scope) {
        SvgMove svgMove = CifConstructors.newSvgMove();
        svgMove.setPosition(astSvgMove.createPosition());
        Expression id = CifExprsTypeChecker.transExpression(astSvgMove.svgId, (CifType)CifExprsTypeChecker.STRING_TYPE_HINT, scope, null, this.tchecker);
        svgMove.setId(id);
        CifType idtype = id.getType();
        CifType nidtype = CifTypeUtils.normalizeType((CifType)idtype);
        if (!(nidtype instanceof StringType)) {
            this.tchecker.addProblem(ErrMsg.SVG_ID_NON_STR, id.getPosition(), CifTextUtils.typeToStr((CifType)idtype));
            throw new SemanticException();
        }
        Expression x = CifExprsTypeChecker.transExpression(astSvgMove.x, CifExprsTypeChecker.NO_TYPE_HINT, scope, null, this.tchecker);
        svgMove.setX(x);
        CifType xtype = x.getType();
        CifType nxtype = CifTypeUtils.normalizeType((CifType)xtype);
        if (!(nxtype instanceof IntType) && !(nxtype instanceof RealType)) {
            this.tchecker.addProblem(ErrMsg.SVG_MOVE_NON_NUM, x.getPosition(), "x", CifTextUtils.typeToStr((CifType)xtype));
            throw new SemanticException();
        }
        Expression y = CifExprsTypeChecker.transExpression(astSvgMove.y, CifExprsTypeChecker.NO_TYPE_HINT, scope, null, this.tchecker);
        svgMove.setY(y);
        CifType ytype = y.getType();
        CifType nytype = CifTypeUtils.normalizeType((CifType)ytype);
        if (!(nytype instanceof IntType) && !(nytype instanceof RealType)) {
            this.tchecker.addProblem(ErrMsg.SVG_MOVE_NON_NUM, y.getPosition(), "y", CifTextUtils.typeToStr((CifType)ytype));
            throw new SemanticException();
        }
        if (astSvgMove.svgFile != null) {
            svgMove.setSvgFile(this.checkSvgFile(astSvgMove.svgFile, scope));
        }
        return svgMove;
    }

    public SvgOut checkSvgOut(ASvgOut astSvgOut, ParentScope<?> scope) {
        SvgOut svgOut = CifConstructors.newSvgOut();
        svgOut.setPosition(astSvgOut.createPosition());
        Expression id = CifExprsTypeChecker.transExpression(astSvgOut.svgId, (CifType)CifExprsTypeChecker.STRING_TYPE_HINT, scope, null, this.tchecker);
        svgOut.setId(id);
        CifType idtype = id.getType();
        CifType nidtype = CifTypeUtils.normalizeType((CifType)idtype);
        if (!(nidtype instanceof StringType)) {
            this.tchecker.addProblem(ErrMsg.SVG_ID_NON_STR, id.getPosition(), CifTextUtils.typeToStr((CifType)idtype));
            throw new SemanticException();
        }
        if (astSvgOut.svgAttr != null) {
            svgOut.setAttr(astSvgOut.svgAttr.txt);
            svgOut.setAttrTextPos(astSvgOut.svgAttr.createPosition());
        } else {
            svgOut.setAttrTextPos(PositionUtils.toPosition((TextPosition)astSvgOut.svgTextPos));
        }
        Expression value = CifExprsTypeChecker.transExpression(astSvgOut.value, CifExprsTypeChecker.NO_TYPE_HINT, scope, null, this.tchecker);
        svgOut.setValue(value);
        if (CifTypeUtils.hasComponentLikeType((CifType)value.getType())) {
            this.tchecker.addProblem(ErrMsg.SVG_OUT_VALUE_COMP_TYPE, astSvgOut.value.position, CifTextUtils.typeToStr((CifType)value.getType()));
            throw new SemanticException();
        }
        if (astSvgOut.svgFile != null) {
            svgOut.setSvgFile(this.checkSvgFile(astSvgOut.svgFile, scope));
        }
        return svgOut;
    }

    public SvgIn checkSvgIn(ASvgIn astSvgIn, ParentScope<?> scope) {
        SvgIn svgIn = CifConstructors.newSvgIn();
        svgIn.setPosition(astSvgIn.createPosition());
        Expression id = CifExprsTypeChecker.transExpression(astSvgIn.svgId, (CifType)CifExprsTypeChecker.STRING_TYPE_HINT, scope, null, this.tchecker);
        svgIn.setId(id);
        CifType idtype = id.getType();
        CifType nidtype = CifTypeUtils.normalizeType((CifType)idtype);
        if (!(nidtype instanceof StringType)) {
            this.tchecker.addProblem(ErrMsg.SVG_ID_NON_STR, id.getPosition(), CifTextUtils.typeToStr((CifType)idtype));
            throw new SemanticException();
        }
        svgIn.setEvent(this.checkSvgInEvent(astSvgIn, scope));
        if (astSvgIn.svgFile != null) {
            svgIn.setSvgFile(this.checkSvgFile(astSvgIn.svgFile, scope));
        }
        return svgIn;
    }

    private SvgInEvent checkSvgInEvent(ASvgIn astSvgIn, ParentScope<?> scope) {
        if (astSvgIn.event instanceof ASvgInEventSingle) {
            return this.checkSvgInEvent((ASvgInEventSingle)astSvgIn.event, scope);
        }
        if (astSvgIn.event instanceof ASvgInEventIf) {
            return this.checkSvgInEvent((ASvgInEventIf)astSvgIn.event, scope);
        }
        String msg = "Unknown svgin event choice: " + astSvgIn.event;
        throw new RuntimeException(msg);
    }

    private SvgInEvent checkSvgInEvent(ASvgInEventSingle astSingle, SymbolScope<?> scope) {
        SvgInEventSingle single = CifConstructors.newSvgInEventSingle();
        Expression eventRef = CifEventRefTypeChecker.checkEventRef(astSingle.name, scope, this.tchecker);
        single.setEvent(eventRef);
        return single;
    }

    private SvgInEvent checkSvgInEvent(ASvgInEventIf astIf, SymbolScope<?> scope) {
        SvgInEventIf mmIf = CifConstructors.newSvgInEventIf();
        EList entries = mmIf.getEntries();
        for (ASvgInEventIfEntry astEntry : astIf.entries) {
            SvgInEventIfEntry entry;
            try {
                entry = CifConstructors.newSvgInEventIfEntry();
                if (astEntry.guard != null) {
                    Expression guard = CifExprsTypeChecker.transExpression(astEntry.guard, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, scope, null, this.tchecker);
                    entry.setGuard(guard);
                    CifType t = entry.getGuard().getType();
                    CifType nt = CifTypeUtils.normalizeType((CifType)t);
                    if (!(nt instanceof BoolType)) {
                        this.tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, entry.getGuard().getPosition(), CifTextUtils.typeToStr((CifType)t));
                    }
                }
                Expression eventRef = CifEventRefTypeChecker.checkEventRef(astEntry.name, scope, this.tchecker);
                entry.setEvent(eventRef);
            }
            catch (SemanticException ex) {
                continue;
            }
            entries.add(entry);
        }
        return mmIf;
    }
}

