/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.declarations.ADiscVariable;
import org.eclipse.escet.cif.parser.ast.declarations.ADiscVariableDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AVariableValue;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.ExprContext;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class DiscVariableDeclWrap
extends DeclWrap<DiscVariable> {
    private static final ExprContext INIT_VALUE_CTXT = ExprContext.DEFAULT_CTXT.add(ExprContext.Condition.ALLOW_DIST);
    private final ADiscVariableDecl astDecls;
    private final ADiscVariable astDecl;

    public DiscVariableDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, ADiscVariableDecl astDecls, ADiscVariable astDecl, DiscVariable mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecls = astDecls;
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((DiscVariable)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        CifType type;
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            type = CifTypesTypeChecker.transCifType(this.astDecls.type, this.scope, this.tchecker);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
            this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Discrete variable", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
            throw new SemanticException();
        }
        ((DiscVariable)this.mmDecl).setType(type);
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        this.typeCheckVarValues();
        this.status = CheckStatus.FULL;
    }

    private void typeCheckVarValues() {
        AVariableValue values1 = this.astDecl.value;
        if (values1 == null) {
            return;
        }
        VariableValue values2 = CifConstructors.newVariableValue();
        values2.setPosition(values1.createPosition());
        ((DiscVariable)this.mmDecl).setValue(values2);
        CifType varType = ((DiscVariable)this.mmDecl).getType();
        EList valueList = values2.getValues();
        List astValues = values1.values;
        if (astValues == null) {
            astValues = Lists.list();
        }
        for (AExpression value1 : astValues) {
            Expression value2 = CifExprsTypeChecker.transExpression(value1, varType, this.scope, INIT_VALUE_CTXT, this.tchecker);
            valueList.add(value2);
            CifType valueType = value2.getType();
            if (CifTypeUtils.checkTypeCompat((CifType)varType, (CifType)valueType, (RangeCompat)RangeCompat.CONTAINED)) continue;
            String articleText = astValues.size() == 1 ? "the" : "an";
            this.tchecker.addProblem(ErrMsg.DISC_VAR_TYPE_VALUE_MISMATCH, value1.position, CifTextUtils.typeToStr((CifType)valueType), articleText, "discrete ", this.getAbsName(), CifTextUtils.typeToStr((CifType)varType));
        }
    }
}

