/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.svg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class SvgNameUtils {
    private static final String NAME_START_CHAR_RE = "[:A-Z_a-z]";
    private static final String NAME_CHAR_RE = "[:A-Z_a-z\\-.0-9]";
    private static final Pattern NAME_PATTERN;
    private static final Map<String, Set<String>> SVG_ELEM_ATTR_MAP;

    static {
        List lines;
        NAME_PATTERN = Pattern.compile(Strings.fmt((String)"%s(%s)*", (Object[])new Object[]{NAME_START_CHAR_RE, NAME_CHAR_RE}));
        ClassLoader loader = SvgNameUtils.class.getClassLoader();
        String resName = String.valueOf(SvgNameUtils.class.getPackageName().replace(".", "/")) + "/svg_1_1_elem_attr_data.txt";
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedInputStream stream = new BufferedInputStream(loader.getResourceAsStream(resName));){
                lines = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load SVG 1.1 element/attribute mapping data.", e);
        }
        Pattern svgElemAttrNameSyntaxPattern = Pattern.compile("[a-zA-Z0-9\\-:]+");
        Map mapping = Maps.map();
        for (String line : lines) {
            if (line.isBlank() || line.startsWith("#")) continue;
            int idx = line.indexOf(" / ");
            Assert.check((idx > 0 ? 1 : 0) != 0);
            String elemName = line.substring(0, idx);
            String attrName = line.substring(idx + " / ".length());
            Assert.check((boolean)svgElemAttrNameSyntaxPattern.matcher(elemName).matches(), (Object)elemName);
            Assert.check((boolean)svgElemAttrNameSyntaxPattern.matcher(attrName).matches(), (Object)attrName);
            Set attrs = (Set)mapping.get(elemName);
            if (attrs == null) {
                attrs = Sets.set();
                mapping.put(elemName, attrs);
            }
            attrs.add(attrName);
        }
        SVG_ELEM_ATTR_MAP = Collections.unmodifiableMap(mapping);
    }

    private SvgNameUtils() {
    }

    public static Set<String> getDefinedAttrs(String elemName) {
        return SVG_ELEM_ATTR_MAP.get(elemName);
    }

    public static boolean isValidSvgName(String name) {
        return NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidSvgPrefixName(String prefix) {
        return prefix.isEmpty() || SvgNameUtils.isValidSvgName(prefix);
    }

    public static boolean isValidSvgPostfixName(String postfix) {
        return postfix.isEmpty() || SvgNameUtils.isValidSvgName("_" + postfix);
    }
}

