/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.scanner;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;

public class AutomatonState {
    public final Set<RegExChar> positions;
    public int id = -1;
    public Terminal accept = null;
    public final Map<Integer, AutomatonState> edges = Maps.map();

    public AutomatonState(Set<RegExChar> positions) {
        this.positions = positions;
        Assert.check((!positions.isEmpty() ? 1 : 0) != 0);
    }

    public void addEdge(int codePoint, AutomatonState state) {
        if (this.edges.containsKey(codePoint)) {
            throw new IllegalStateException("Duplicate edge.");
        }
        this.edges.put(codePoint, state);
    }

    public int hashCode() {
        return AutomatonState.class.hashCode() ^ this.positions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AutomatonState)) {
            return false;
        }
        AutomatonState other = (AutomatonState)obj;
        return this.positions.equals(other.positions);
    }

    public List<Pair<Integer, AutomatonState>> getSortedEdges() {
        List sortedEdges = Lists.list();
        for (Map.Entry<Integer, AutomatonState> entry : this.edges.entrySet()) {
            sortedEdges.add(Pair.pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        Comparator<Pair<Integer, AutomatonState>> cmp = new Comparator<Pair<Integer, AutomatonState>>(){

            @Override
            public int compare(Pair<Integer, AutomatonState> t1, Pair<Integer, AutomatonState> t2) {
                int targetId1 = ((AutomatonState)t1.right).id;
                int targetId2 = ((AutomatonState)t2.right).id;
                if (targetId1 < targetId2) {
                    return -1;
                }
                if (targetId1 > targetId2) {
                    return 1;
                }
                return ((Integer)t1.left).compareTo((Integer)t2.left);
            }
        };
        Collections.sort(sortedEdges, cmp);
        return sortedEdges;
    }

    public void print(AppStream s, boolean initial) {
        List charTxts = Lists.list();
        for (RegExChar regExChar : this.positions) {
            charTxts.add(this.codePointToStr(regExChar.character, true));
        }
        Collections.sort(charTxts, Strings.SORTER);
        s.println(Strings.fmt((String)"%sstate %d (%s):", (Object[])new Object[]{initial ? "initial " : "", this.id, charTxts}));
        if (this.accept != null) {
            String string = Strings.fmt((String)"%s\"%s\" (priority %d)", (Object[])new Object[]{this.accept.name == null ? "" : String.valueOf(this.accept.name) + " = ", this.accept.regEx.toString(), this.accept.priority});
            s.println("  accepts terminal: " + string);
        }
        if (this.accept != null && !this.edges.isEmpty()) {
            s.println();
        }
        for (Pair pair : this.getSortedEdges()) {
            int codePoint = (Integer)pair.left;
            AutomatonState target = (AutomatonState)pair.right;
            String codePointTxt = this.codePointToStr(codePoint, false);
            String edgeTxt = String.valueOf(codePointTxt) + " -> " + target.id;
            s.println("  " + edgeTxt);
        }
    }

    private String codePointToStr(int codePoint, boolean compact) {
        if (codePoint > 127) {
            String msg = "We should not have non-ASCII chars here.";
            throw new RuntimeException(msg);
        }
        String codePointTxt = codePoint == -1 ? "\u00b6" : (codePoint < -1 ? Strings.fmt((String)"\u00ab%d\u00bb", (Object[])new Object[]{codePoint}) : (codePoint == 10 ? "\\n" : (codePoint == 13 ? "\\r" : (codePoint == 9 ? "\\t" : (codePoint <= 31 || codePoint == 127 ? "" : "\"" + Strings.codePointToStr((int)codePoint) + "\"")))));
        if (!codePointTxt.isEmpty() && codePoint >= -1) {
            codePointTxt = String.valueOf(codePointTxt) + (compact ? "=" : " = ");
        }
        if (codePoint >= 0) {
            String hexString = Integer.toHexString(codePoint);
            hexString = StringUtils.leftPad((String)hexString, (int)2, (char)'0');
            if (!compact) {
                codePointTxt = String.valueOf(codePointTxt) + "(";
            }
            codePointTxt = String.valueOf(codePointTxt) + "U+" + hexString;
            if (!compact) {
                codePointTxt = String.valueOf(codePointTxt) + ")";
            }
        } else if (codePoint == -1) {
            codePointTxt = String.valueOf(codePointTxt) + (compact ? "-1" : "(-1)");
        }
        return codePointTxt;
    }
}

