/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.scanner;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.setext.generator.scanner.Automaton;
import org.eclipse.escet.setext.generator.scanner.AutomatonState;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExAlts;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;
import org.eclipse.escet.setext.parser.ast.regex.RegExCharClass;
import org.eclipse.escet.setext.parser.ast.regex.RegExCharSeq;
import org.eclipse.escet.setext.parser.ast.regex.RegExDot;
import org.eclipse.escet.setext.parser.ast.regex.RegExOpt;
import org.eclipse.escet.setext.parser.ast.regex.RegExPlus;
import org.eclipse.escet.setext.parser.ast.regex.RegExSeq;
import org.eclipse.escet.setext.parser.ast.regex.RegExShortcut;
import org.eclipse.escet.setext.parser.ast.regex.RegExStar;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;

public class RegExToDfa {
    private Map<RegExChar, Set<RegExChar>> followposMap = Maps.map();

    public static Automaton terminalsToDfa(List<Terminal> terminals) {
        Assert.check((!terminals.isEmpty() ? 1 : 0) != 0);
        TextPosition dummyPos = TextPosition.createDummy((String)"/dummy.file");
        Map markerMap = Maps.map();
        List regExAlts = Lists.list();
        int markerNr = -1;
        for (Terminal terminal : terminals) {
            RegExChar marker = new RegExChar(--markerNr, dummyPos);
            markerMap.put(marker, terminal);
            RegEx regEx = RegExToDfa.simplify(terminal.regEx);
            regExAlts.add(new RegExSeq(Lists.list((Object[])new RegEx[]{regEx, marker})));
        }
        RegEx combiRegEx = RegExToDfa.makeAlts(regExAlts);
        Automaton dfa = RegExToDfa.regExToDfa(combiRegEx);
        Set unusedTerminals = Sets.list2set(terminals);
        RegExToDfa.decideAcceptance(dfa, markerMap, unusedTerminals);
        if (!unusedTerminals.isEmpty()) {
            List warnings = Lists.list();
            for (Terminal terminal : unusedTerminals) {
                String txt = "\"" + terminal.regEx.toString() + "\"";
                if (terminal.name != null) {
                    txt = String.valueOf(terminal.name) + "=" + txt;
                }
                txt = Strings.fmt((String)"Terminal %s (priority=%d) is not used (it is not accepted in any of the states of the scanner DFA).", (Object[])new Object[]{txt, terminal.priority});
                warnings.add(txt);
            }
            Collections.sort(warnings, Strings.SORTER);
            for (String warning : warnings) {
                OutputProvider.warn((String)warning);
            }
        }
        dfa = RegExToDfa.minimizeDfa(dfa);
        return dfa;
    }

    private static RegEx makeAlts(List<RegEx> alts) {
        Assert.check((!alts.isEmpty() ? 1 : 0) != 0);
        if (alts.size() == 1) {
            return (RegEx)Lists.first(alts);
        }
        RegEx rslt = (RegEx)Lists.first(alts);
        int i = 1;
        while (i < alts.size()) {
            RegEx alt = alts.get(i);
            rslt = new RegExAlts(Lists.list((Object[])new RegEx[]{rslt, alt}));
            ++i;
        }
        return rslt;
    }

    public static Automaton regExToDfa(RegEx regEx) {
        RegExToDfa converter = new RegExToDfa();
        converter.calcFollowpos(regEx);
        Set alphabet = regEx.getCodePoints();
        Set<RegExChar> initialFirst = RegExToDfa.firstpos(regEx);
        AutomatonState initialState = new AutomatonState(initialFirst);
        Automaton automaton = new Automaton(initialState);
        LinkedList<AutomatonState> todoStates = new LinkedList<AutomatonState>();
        todoStates.push(initialState);
        while (!todoStates.isEmpty()) {
            AutomatonState state = (AutomatonState)todoStates.pop();
            for (Integer codePoint : alphabet) {
                Set targetPositions = Sets.set();
                for (RegExChar position : state.positions) {
                    if (position.character != codePoint) continue;
                    Set<RegExChar> followSet = converter.followpos(position);
                    targetPositions.addAll(followSet);
                }
                if (targetPositions.isEmpty()) continue;
                Assert.check((codePoint >= -1 ? 1 : 0) != 0);
                AutomatonState target = new AutomatonState(targetPositions);
                AutomatonState representative = automaton.addState(target);
                if (representative == target) {
                    todoStates.push(target);
                }
                state.addEdge(codePoint, representative);
            }
        }
        return automaton;
    }

    private static void decideAcceptance(Automaton dfa, Map<RegExChar, Terminal> markerMap, Set<Terminal> unusedTerminals) {
        for (AutomatonState state : dfa.states.keySet()) {
            List terminals = Lists.list();
            for (RegExChar c : state.positions) {
                if (!c.isCustomMarker()) continue;
                Terminal terminal = markerMap.get(c);
                Assert.notNull((Object)terminal);
                terminals.add(terminal);
            }
            if (terminals.isEmpty()) continue;
            Collections.sort(terminals, Terminal.PRIORITY_COMPARER);
            int highestPrio = ((Terminal)Lists.first((List)terminals)).priority;
            int highestCnt = 0;
            while (highestCnt < terminals.size() && ((Terminal)terminals.get((int)highestCnt)).priority == highestPrio) {
                ++highestCnt;
            }
            if (highestCnt == 1) {
                Terminal acceptedTerminal;
                state.accept = acceptedTerminal = (Terminal)Lists.first((List)terminals);
                unusedTerminals.remove(acceptedTerminal);
                continue;
            }
            List termTxts = Lists.list();
            int i = 0;
            while (i < highestCnt) {
                Terminal term = (Terminal)terminals.get(i);
                String termTxt = "\"" + term.regEx.toString() + "\"";
                if (term.name != null) {
                    termTxt = String.valueOf(term.name) + "=" + termTxt;
                }
                termTxts.add(termTxt);
                ++i;
            }
            Collections.sort(termTxts, Strings.SORTER);
            String msg = Strings.fmt((String)"Two or more terminals have the same priority and they are overlapping (their languages have at least one string in common): %s.", (Object[])new Object[]{String.join((CharSequence)", ", termTxts)});
            throw new InvalidInputException(msg);
        }
    }

    public static RegEx simplify(RegEx re) {
        if (re instanceof RegExAlts) {
            List alts = Lists.list();
            for (RegEx alt : ((RegExAlts)re).alts) {
                RegEx simpleAlt = RegExToDfa.simplify(alt);
                alts.add(simpleAlt);
            }
            RegEx rslt = (RegEx)Lists.first((List)alts);
            int i = 1;
            while (i < alts.size()) {
                RegEx alt = (RegEx)alts.get(i);
                rslt = new RegExAlts(Lists.list((Object[])new RegEx[]{rslt, alt}));
                ++i;
            }
            return rslt;
        }
        if (re instanceof RegExCharClass) {
            RegExCharClass cls = (RegExCharClass)re;
            Set chars = cls.getCodePoints();
            List sortedChars = Sets.sortedgeneric((Set)chars);
            List alts = Lists.list();
            Iterator iterator = sortedChars.iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                alts.add(new RegExChar(c, cls.position));
            }
            Assert.check((!alts.isEmpty() ? 1 : 0) != 0);
            RegExAlts rslt = alts.size() == 1 ? (RegEx)alts.get(0) : new RegExAlts(alts);
            rslt = RegExToDfa.simplify((RegEx)rslt);
            return rslt;
        }
        if (re instanceof RegExChar) {
            RegExChar c = (RegExChar)re;
            return new RegExChar(c.character, c.position);
        }
        if (re instanceof RegExCharSeq) {
            throw new RuntimeException("Unexpected RegExCharSeq");
        }
        if (re instanceof RegExDot) {
            List alts = Lists.list();
            int c = 0;
            while (c <= 127) {
                if (c != 10) {
                    alts.add(new RegExChar(c, re.position));
                }
                ++c;
            }
            RegExAlts rslt = new RegExAlts(alts);
            rslt = RegExToDfa.simplify((RegEx)rslt);
            return rslt;
        }
        if (re instanceof RegExOpt) {
            RegExOpt opt = (RegExOpt)re;
            return new RegExOpt(RegExToDfa.simplify(opt.child), opt.position);
        }
        if (re instanceof RegExPlus) {
            RegExPlus plus = (RegExPlus)re;
            RegEx child1 = RegExToDfa.simplify(plus.child);
            RegEx child2 = RegExToDfa.simplify(plus.child);
            List seq = Lists.list();
            seq.add(child1);
            seq.add(new RegExStar(child2, plus.position));
            return new RegExSeq(seq);
        }
        if (re instanceof RegExSeq) {
            List parts = Lists.list();
            for (RegEx part : ((RegExSeq)re).sequence) {
                RegEx simplePart = RegExToDfa.simplify(part);
                parts.add(simplePart);
            }
            RegEx rslt = (RegEx)Lists.first((List)parts);
            int i = 1;
            while (i < parts.size()) {
                RegEx part = (RegEx)parts.get(i);
                rslt = new RegExSeq(Lists.list((Object[])new RegEx[]{rslt, part}));
                ++i;
            }
            return rslt;
        }
        if (re instanceof RegExShortcut) {
            RegExShortcut shortcut = (RegExShortcut)re;
            return RegExToDfa.simplify(shortcut.shortcut.regEx);
        }
        if (re instanceof RegExStar) {
            RegExStar star = (RegExStar)re;
            return new RegExStar(RegExToDfa.simplify(star.child), star.position);
        }
        throw new RuntimeException("Unknown regex: " + re);
    }

    public static boolean nullable(RegEx re) {
        if (re instanceof RegExAlts) {
            List alts = ((RegExAlts)re).alts;
            Assert.check((alts.size() == 2 ? 1 : 0) != 0);
            return RegExToDfa.nullable((RegEx)Lists.first((List)alts)) || RegExToDfa.nullable((RegEx)Lists.last((List)alts));
        }
        if (re instanceof RegExChar) {
            return false;
        }
        if (re instanceof RegExOpt) {
            return true;
        }
        if (re instanceof RegExSeq) {
            List seq = ((RegExSeq)re).sequence;
            Assert.check((seq.size() == 2 ? 1 : 0) != 0);
            return RegExToDfa.nullable((RegEx)Lists.first((List)seq)) && RegExToDfa.nullable((RegEx)Lists.last((List)seq));
        }
        if (re instanceof RegExStar) {
            return true;
        }
        throw new RuntimeException("Unknown/unexpected regex: " + re);
    }

    public static Set<RegExChar> firstpos(RegEx re) {
        if (re instanceof RegExAlts) {
            List alts = ((RegExAlts)re).alts;
            Assert.check((alts.size() == 2 ? 1 : 0) != 0);
            return Sets.union(RegExToDfa.firstpos((RegEx)Lists.first((List)alts)), RegExToDfa.firstpos((RegEx)Lists.last((List)alts)));
        }
        if (re instanceof RegExChar) {
            return Sets.set((Object)((RegExChar)re));
        }
        if (re instanceof RegExOpt) {
            return RegExToDfa.firstpos(((RegExOpt)re).child);
        }
        if (re instanceof RegExSeq) {
            List seq = ((RegExSeq)re).sequence;
            Assert.check((seq.size() == 2 ? 1 : 0) != 0);
            RegEx first = (RegEx)Lists.first((List)seq);
            if (RegExToDfa.nullable(first)) {
                return Sets.union(RegExToDfa.firstpos((RegEx)Lists.first((List)seq)), RegExToDfa.firstpos((RegEx)Lists.last((List)seq)));
            }
            return RegExToDfa.firstpos((RegEx)Lists.first((List)seq));
        }
        if (re instanceof RegExStar) {
            return RegExToDfa.firstpos(((RegExStar)re).child);
        }
        throw new RuntimeException("Unknown/unexpected regex: " + re);
    }

    public static Set<RegExChar> lastpos(RegEx re) {
        if (re instanceof RegExAlts) {
            List alts = ((RegExAlts)re).alts;
            Assert.check((alts.size() == 2 ? 1 : 0) != 0);
            return Sets.union(RegExToDfa.lastpos((RegEx)Lists.first((List)alts)), RegExToDfa.lastpos((RegEx)Lists.last((List)alts)));
        }
        if (re instanceof RegExChar) {
            return Sets.set((Object)((RegExChar)re));
        }
        if (re instanceof RegExOpt) {
            return RegExToDfa.lastpos(((RegExOpt)re).child);
        }
        if (re instanceof RegExSeq) {
            List seq = ((RegExSeq)re).sequence;
            Assert.check((seq.size() == 2 ? 1 : 0) != 0);
            RegEx last = (RegEx)Lists.last((List)seq);
            if (RegExToDfa.nullable(last)) {
                return Sets.union(RegExToDfa.lastpos((RegEx)Lists.last((List)seq)), RegExToDfa.lastpos((RegEx)Lists.first((List)seq)));
            }
            return RegExToDfa.lastpos((RegEx)Lists.last((List)seq));
        }
        if (re instanceof RegExStar) {
            return RegExToDfa.lastpos(((RegExStar)re).child);
        }
        throw new RuntimeException("Unknown/unexpected regex: " + re);
    }

    public void calcFollowpos(RegEx re) {
        if (re instanceof RegExAlts) {
            List alts = ((RegExAlts)re).alts;
            Assert.check((alts.size() == 2 ? 1 : 0) != 0);
            this.calcFollowpos((RegEx)Lists.first((List)alts));
            this.calcFollowpos((RegEx)Lists.last((List)alts));
        } else if (re instanceof RegExChar) {
            RegExChar c = (RegExChar)re;
            Set<RegExChar> mapEntry = this.followposMap.get(c);
            if (mapEntry == null) {
                this.followposMap.put(c, Collections.emptySet());
            }
        } else if (re instanceof RegExOpt) {
            this.calcFollowpos(((RegExOpt)re).child);
        } else if (re instanceof RegExSeq) {
            List seq = ((RegExSeq)re).sequence;
            Assert.check((seq.size() == 2 ? 1 : 0) != 0);
            this.calcFollowpos((RegEx)Lists.first((List)seq));
            this.calcFollowpos((RegEx)Lists.last((List)seq));
            Set<RegExChar> last = RegExToDfa.lastpos((RegEx)Lists.first((List)seq));
            Set first = RegExToDfa.firstpos((RegEx)Lists.last((List)seq));
            for (RegExChar c : last) {
                Set<RegExChar> mapEntry = this.followposMap.get(c);
                mapEntry = mapEntry == null ? first : Sets.union(mapEntry, first);
                this.followposMap.put(c, mapEntry);
            }
        } else if (re instanceof RegExStar) {
            this.calcFollowpos(((RegExStar)re).child);
            Set first = RegExToDfa.firstpos(re);
            Set<RegExChar> last = RegExToDfa.lastpos(re);
            for (RegExChar c : last) {
                Set<RegExChar> mapEntry = this.followposMap.get(c);
                mapEntry = mapEntry == null ? first : Sets.union(mapEntry, first);
                this.followposMap.put(c, mapEntry);
            }
        } else {
            throw new RuntimeException("Unknown/unknown regex: " + re);
        }
    }

    public Set<RegExChar> followpos(RegExChar c) {
        Set<RegExChar> rslt = this.followposMap.get(c);
        Assert.notNull(rslt);
        return rslt;
    }

    public static Automaton minimizeDfa(Automaton dfa) {
        return dfa;
    }
}

