/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2supremica;

import java.util.List;
import org.eclipse.escet.cif.common.CifPreconditionChecker;
import org.eclipse.escet.cif.common.checkers.checks.AutNoKindlessCheck;
import org.eclipse.escet.cif.common.checkers.checks.AutOnlyWithOneInitLocCheck;
import org.eclipse.escet.cif.common.checkers.checks.CompNoInitPredsCheck;
import org.eclipse.escet.cif.common.checkers.checks.CompOnlyVarValueMarkerPredsCheck;
import org.eclipse.escet.cif.common.checkers.checks.CompStateInvsOnlyReqsCheck;
import org.eclipse.escet.cif.common.checkers.checks.EdgeNoUrgentCheck;
import org.eclipse.escet.cif.common.checkers.checks.EdgeOnlySimpleAssignmentsCheck;
import org.eclipse.escet.cif.common.checkers.checks.EventNoChannelsCheck;
import org.eclipse.escet.cif.common.checkers.checks.EventOnlyWithControllabilityCheck;
import org.eclipse.escet.cif.common.checkers.checks.ExprNoSpecificBinaryExprsCheck;
import org.eclipse.escet.cif.common.checkers.checks.ExprNoSpecificExprsCheck;
import org.eclipse.escet.cif.common.checkers.checks.ExprNoSpecificUnaryExprsCheck;
import org.eclipse.escet.cif.common.checkers.checks.FuncNoUserDefinedCheck;
import org.eclipse.escet.cif.common.checkers.checks.InvNoKindlessStateEvtExclCheck;
import org.eclipse.escet.cif.common.checkers.checks.LocNoStateInvsCheck;
import org.eclipse.escet.cif.common.checkers.checks.LocNoUrgentCheck;
import org.eclipse.escet.cif.common.checkers.checks.LocOnlyStaticEvalMarkerPredsCheck;
import org.eclipse.escet.cif.common.checkers.checks.TypeNoSpecificTypesCheck;
import org.eclipse.escet.cif.common.checkers.checks.VarNoContinuousCheck;
import org.eclipse.escet.cif.common.checkers.checks.VarNoDiscWithMultiInitValuesCheck;
import org.eclipse.escet.cif.common.checkers.checks.VarNoInputCheck;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Lists;

public class CifToSupremicaPreChecker {
    private CifToSupremicaPreChecker() {
    }

    public static void check(Specification spec) {
        List preconditions = Lists.list();
        preconditions.add(new AutNoKindlessCheck());
        preconditions.add(new EventOnlyWithControllabilityCheck());
        preconditions.add(new CompNoInitPredsCheck());
        preconditions.add(new CompOnlyVarValueMarkerPredsCheck());
        preconditions.add(new LocOnlyStaticEvalMarkerPredsCheck());
        preconditions.add(new AutOnlyWithOneInitLocCheck());
        preconditions.add(new LocNoStateInvsCheck());
        preconditions.add(new CompStateInvsOnlyReqsCheck());
        preconditions.add(new InvNoKindlessStateEvtExclCheck());
        preconditions.add(new VarNoDiscWithMultiInitValuesCheck());
        preconditions.add(new VarNoContinuousCheck());
        preconditions.add(new VarNoInputCheck());
        preconditions.add(new EdgeOnlySimpleAssignmentsCheck());
        preconditions.add(new LocNoUrgentCheck());
        preconditions.add(new EdgeNoUrgentCheck());
        preconditions.add(new FuncNoUserDefinedCheck());
        preconditions.add(new EventNoChannelsCheck());
        TypeNoSpecificTypesCheck typesCheck = new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.DICT_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.INT_TYPES_RANGELESS, TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.REAL_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.SET_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.STRING_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.TUPLE_TYPES});
        preconditions.add(typesCheck);
        ExprNoSpecificExprsCheck exprsCheck = new ExprNoSpecificExprsCheck(new ExprNoSpecificExprsCheck.NoSpecificExpr[]{ExprNoSpecificExprsCheck.NoSpecificExpr.CAST_EXPRS_NON_EQUAL_TYPE, ExprNoSpecificExprsCheck.NoSpecificExpr.DICT_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_CALLS, ExprNoSpecificExprsCheck.NoSpecificExpr.IF_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.LIST_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.REAL_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.SET_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.SLICE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.STRING_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.SWITCH_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.TIME_VAR_REFS, ExprNoSpecificExprsCheck.NoSpecificExpr.TUPLE_LITS});
        preconditions.add(exprsCheck);
        ExprNoSpecificBinaryExprsCheck binCheck = new ExprNoSpecificBinaryExprsCheck(new ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp[]{ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.CONJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DISJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_STRINGS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MULTIPLICATION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MULTIPLICATION_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.INTEGER_DIVISION_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.MODULUS_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_EQUAL_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_EQUAL_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_THAN_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.GREATER_THAN_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_EQUAL_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_EQUAL_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_THAN_INTS_RANGELESS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.LESS_THAN_REALS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DIVISION, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ELEMENT_OF, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBSET});
        preconditions.add(binCheck);
        ExprNoSpecificUnaryExprsCheck unCheck = new ExprNoSpecificUnaryExprsCheck(new ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp[]{ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.NEGATE_INTS_RANGELESS, ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.NEGATE_REALS, ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.PLUS_INTS_RANGELESS, ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.PLUS_REALS, ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.SAMPLE});
        preconditions.add(unCheck);
        new CifPreconditionChecker(preconditions).reportPreconditionViolations(spec, "CIF to Supremica transformation");
    }
}

