/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.emf;

import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.escet.common.emf.EMFPath;
import org.eclipse.escet.common.emf.EMFValidationException;
import org.eclipse.escet.common.java.Lists;

public class EMFValidationHelper {
    private static final String DIAGNOSTIC_INDENT = "  ";

    private EMFValidationHelper() {
    }

    public static void validateObject(EObject obj) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(obj);
        if (diagnostic.getSeverity() == 0) {
            return;
        }
        List<String> diagMsgs = EMFValidationHelper.getDiagMsgs(diagnostic, " - ");
        String msg = "EMF validation resulted in warnings/errors:";
        List messages = Lists.list((Object)msg);
        messages.addAll(diagMsgs);
        throw new EMFValidationException(String.join((CharSequence)"\n", messages));
    }

    private static List<String> getDiagMsgs(Diagnostic diagnostic, String indent) {
        List rslt = Lists.list();
        rslt.addAll(EMFValidationHelper.getDiagMsgs(diagnostic, indent, true));
        for (Diagnostic child : diagnostic.getChildren()) {
            rslt.addAll(EMFValidationHelper.getDiagMsgs(child, DIAGNOSTIC_INDENT + indent));
        }
        rslt.addAll(EMFValidationHelper.getDiagMsgs(diagnostic, indent, false));
        return rslt;
    }

    private static List<String> getDiagMsgs(Diagnostic diagnostic, String indent, boolean preChilds) {
        if (diagnostic instanceof BasicDiagnostic) {
            return EMFValidationHelper.getDiagMsgsEmfValidation((BasicDiagnostic)diagnostic, indent, preChilds);
        }
        return EMFValidationHelper.getDiagMsgsGeneric(diagnostic, indent, preChilds);
    }

    private static List<String> getDiagMsgsGeneric(Diagnostic diagnostic, String indent, boolean preChilds) {
        if (preChilds) {
            String msg = String.valueOf(indent) + "(Severity = " + EMFValidationHelper.diagSeverityToStr(diagnostic.getSeverity()) + "): " + diagnostic.getMessage();
            return Lists.list((Object)msg);
        }
        return Lists.list();
    }

    private static String diagSeverityToStr(int code) {
        if (code == 0) {
            return "OK";
        }
        List rslt = Lists.list();
        if ((code & 8) > 0) {
            rslt.add("CANCEL");
        }
        if ((code & 4) > 0) {
            rslt.add("ERROR");
        }
        if ((code & 2) > 0) {
            rslt.add("WARNING");
        }
        if ((code & 1) > 0) {
            rslt.add("INFO");
        }
        return String.join((CharSequence)", ", rslt);
    }

    private static List<String> getDiagMsgsEmfValidation(BasicDiagnostic diagnostic, String indent, boolean preChilds) {
        if (!preChilds) {
            return EMFValidationHelper.getDiagMsgsGeneric((Diagnostic)diagnostic, indent, preChilds);
        }
        List<String> rslt = EMFValidationHelper.getDiagMsgsGeneric((Diagnostic)diagnostic, indent, preChilds);
        if (diagnostic.getData().size() >= 2 && diagnostic.getData().get(0) instanceof EObject) {
            EObject eObj = (EObject)diagnostic.getData().get(0);
            if (diagnostic.getData().get(1) == null || diagnostic.getData().get(1) instanceof EStructuralFeature) {
                EStructuralFeature eFeat = (EStructuralFeature)diagnostic.getData().get(1);
                String msg = DIAGNOSTIC_INDENT + indent + "Path: " + EMFValidationHelper.makePath(eObj, eFeat);
                rslt.add(msg);
            }
        }
        return rslt;
    }

    private static String makePath(EObject eObj, EStructuralFeature eFeat) {
        EMFPath emfPath = new EMFPath(eObj, eFeat);
        return emfPath.toString();
    }
}

