/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.BitSet;
import org.eclipse.escet.common.java.BitSetIterator;

public class BitSets {
    private BitSets() {
    }

    public static BitSet bitset() {
        return new BitSet();
    }

    public static BitSet bitset(int n) {
        return new BitSet(n);
    }

    public static BitSet makeBitset(int ... indices) {
        BitSet bs = BitSets.bitset();
        BitSets.setBits(bs, indices);
        return bs;
    }

    public static BitSet copy(BitSet bs) {
        return (BitSet)bs.clone();
    }

    public static BitSet ones(int n) {
        BitSet bs = BitSets.bitset(n);
        bs.set(0, n);
        return bs;
    }

    public static BitSet invert(BitSet bs, int n) {
        BitSet result = BitSets.ones(n);
        result.andNot(bs);
        return result;
    }

    public static int first(BitSet bs) {
        return bs.nextSetBit(0);
    }

    public static boolean isConsecutive(BitSet bs) {
        int first = BitSets.first(bs);
        if (first < 0) {
            return true;
        }
        int nextZero = bs.nextClearBit(first + 1);
        return nextZero == first + bs.cardinality();
    }

    public static void setBits(BitSet bs, int ... bitNumbers) {
        int[] nArray = bitNumbers;
        int n = bitNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            bs.set(i);
            ++n2;
        }
    }

    public static int[] getTrueBits(BitSet bs) {
        int[] result = new int[bs.cardinality()];
        int free = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            result[free] = i;
            ++free;
            if (i == Integer.MAX_VALUE) break;
            i = bs.nextSetBit(i + 1);
        }
        return result;
    }

    public static Iterable<Integer> iterateTrueBits(BitSet bitSet) {
        return new BitSetIterator(bitSet);
    }

    public static Iterable<Integer> iterateTrueBits(BitSet bitSet, int fromIndex) {
        return new BitSetIterator(bitSet, fromIndex);
    }
}

