/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.escet.common.java.Assert;

public class Numbers {
    private Numbers() {
    }

    public static String formatNumber(String valueText) {
        return NumberFormat.getNumberInstance(Locale.US).format(new BigInteger(valueText));
    }

    public static String formatNumber(int value) {
        return NumberFormat.getNumberInstance(Locale.US).format(value);
    }

    public static String toOrdinal(int i) {
        Assert.check(i >= 0);
        if (i == 0) {
            return "zeroth";
        }
        String suffix = "th";
        block0 : switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                switch (i % 10) {
                    case 1: {
                        suffix = "st";
                        break block0;
                    }
                    case 2: {
                        suffix = "nd";
                        break block0;
                    }
                    case 3: {
                        suffix = "rd";
                    }
                }
            }
        }
        return String.valueOf(String.valueOf(i)) + suffix;
    }
}

