/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.emf.EMFPath;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimComponentDefInst
extends CifWalker
implements CifToCifTransformation {
    private Set<ComponentDef> elimDefs;
    private boolean foundDefs;
    private Map<ComponentDef, ComplexComponent> cdefMap;
    private Map<ComponentInst, ComplexComponent> instMap;
    private Map<ComponentParameter, Expression> compParamMap;
    private Map<ComponentParameter, Pair<ComponentInst, Integer>> paramOrigMap;
    private Map<Event, Expression> eventParamMap;
    private Map<Location, Expression> locParamMap;

    @Override
    public void transform(Specification spec) {
        while (true) {
            this.elimDefs = Sets.set();
            this.foundDefs = false;
            this.analyzeCompDefs((Group)spec);
            if (this.elimDefs.isEmpty()) break;
            this.cdefMap = Maps.map();
            this.instMap = Maps.map();
            this.compParamMap = Maps.map();
            this.paramOrigMap = Maps.map();
            this.eventParamMap = Maps.map();
            this.locParamMap = Maps.map();
            this.instantiate((Group)spec);
            this.walkSpecification(spec);
        }
        Assert.check((!this.foundDefs ? 1 : 0) != 0);
    }

    private boolean analyzeCompDefs(Group group) {
        boolean foundDefOrInst = false;
        for (ComponentDef cdef : group.getDefinitions()) {
            this.analyzeCompDefs(cdef);
            foundDefOrInst = true;
        }
        for (Component comp : group.getComponents()) {
            if (comp instanceof ComponentInst) {
                foundDefOrInst = true;
                continue;
            }
            if (!(comp instanceof Group)) continue;
            boolean foundDefOrInstInGroup = this.analyzeCompDefs((Group)comp);
            foundDefOrInst |= foundDefOrInstInGroup;
        }
        return foundDefOrInst;
    }

    private void analyzeCompDefs(ComponentDef cdef) {
        ComplexComponent body = cdef.getBody();
        this.foundDefs = true;
        if (body instanceof Automaton) {
            this.elimDefs.add(cdef);
            return;
        }
        Assert.check((boolean)(body instanceof Group));
        Group group = (Group)body;
        boolean foundDefOrInst = false;
        for (ComponentDef cdef2 : group.getDefinitions()) {
            foundDefOrInst = true;
            this.analyzeCompDefs(cdef2);
        }
        for (Component comp : group.getComponents()) {
            if (comp instanceof ComponentInst) {
                foundDefOrInst = true;
                continue;
            }
            if (!(comp instanceof Group)) continue;
            boolean foundDefOrInstInGroup = this.analyzeCompDefs((Group)comp);
            foundDefOrInst |= foundDefOrInstInGroup;
        }
        if (!foundDefOrInst) {
            this.elimDefs.add(cdef);
        }
    }

    private void instantiate(Group group) {
        EList childDefs = group.getDefinitions();
        Iterator childIter = childDefs.iterator();
        while (childIter.hasNext()) {
            ComponentDef cdef = (ComponentDef)childIter.next();
            if (this.elimDefs.contains(cdef)) {
                childIter.remove();
                continue;
            }
            ComplexComponent body = cdef.getBody();
            if (!(body instanceof Group)) continue;
            this.instantiate((Group)body);
        }
        EList childComps = group.getComponents();
        int i = 0;
        while (i < childComps.size()) {
            ComponentInst inst;
            ComponentDef cdef;
            Component comp = (Component)childComps.get(i);
            if (comp instanceof Group) {
                this.instantiate((Group)comp);
            } else if (comp instanceof ComponentInst && this.elimDefs.contains(cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)(inst = (ComponentInst)comp)))) {
                ComplexComponent comp2 = this.instantiate((ComponentInst)comp);
                childComps.set(i, comp2);
            }
            ++i;
        }
    }

    private ComplexComponent instantiate(ComponentInst inst) {
        ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
        cdef = (ComponentDef)EMFHelper.deepclone((EObject)cdef);
        ComplexComponent body = cdef.getBody();
        this.cdefMap.put(cdef, body);
        body.setName(inst.getName());
        this.instMap.put(inst, body);
        EList formals = cdef.getParameters();
        EList actuals = inst.getParameters();
        Assert.check((formals.size() == actuals.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < formals.size()) {
            Parameter formal = (Parameter)formals.get(i);
            Expression actual = (Expression)actuals.get(i);
            if (formal instanceof AlgParameter) {
                AlgVariable var = ((AlgParameter)formal).getVariable();
                body.getDeclarations().add((Object)var);
                var.setValue((Expression)EMFHelper.deepclone((EObject)actual));
            } else if (formal instanceof EventParameter) {
                Event event = ((EventParameter)formal).getEvent();
                this.eventParamMap.put(event, actual);
            } else if (formal instanceof LocationParameter) {
                Location loc = ((LocationParameter)formal).getLocation();
                this.locParamMap.put(loc, actual);
            } else if (formal instanceof ComponentParameter) {
                this.compParamMap.put((ComponentParameter)formal, actual);
                this.paramOrigMap.put((ComponentParameter)formal, (Pair<ComponentInst, Integer>)Pair.pair((Object)inst, (Object)i));
            } else {
                throw new RuntimeException("Unknown formal param: " + formal);
            }
            ++i;
        }
        return body;
    }

    protected void postprocessEventExpression(EventExpression evtRef) {
        Expression newRef = this.eventParamMap.get(evtRef.getEvent());
        if (newRef == null) {
            return;
        }
        newRef = (Expression)EMFHelper.deepclone((EObject)newRef);
        this.setPositionInfo((PositionObject)newRef, evtRef.getPosition());
        EMFHelper.updateParentContainment((EObject)evtRef, (EObject)newRef);
        this.walkExpression(newRef);
    }

    protected void postprocessLocationExpression(LocationExpression locRef) {
        Expression newRef = this.locParamMap.get(locRef.getLocation());
        if (newRef == null) {
            return;
        }
        newRef = (Expression)EMFHelper.deepclone((EObject)newRef);
        this.setPositionInfo((PositionObject)newRef, locRef.getPosition());
        EMFHelper.updateParentContainment((EObject)locRef, (EObject)newRef);
        this.walkExpression(newRef);
    }

    protected void postprocessCompParamExpression(CompParamExpression compParamRef) {
        Expression newRef = this.getActualArgument(compParamRef.getParameter());
        if (newRef == null) {
            return;
        }
        newRef = (Expression)EMFHelper.deepclone((EObject)newRef);
        this.setPositionInfo((PositionObject)newRef, compParamRef.getPosition());
        EMFHelper.updateParentContainment((EObject)compParamRef, (EObject)newRef);
    }

    protected void postprocessComponentExpression(ComponentExpression compRef) {
        Component c = compRef.getComponent();
        if (!(c instanceof ComponentInst)) {
            return;
        }
        ComplexComponent comp = this.instMap.get(c);
        if (comp == null) {
            return;
        }
        compRef.setComponent((Component)comp);
    }

    protected void postprocessSelfExpression(SelfExpression expr) {
        CifType type = expr.getType();
        if (!(type instanceof ComponentDefType)) {
            return;
        }
        ComponentDef cdef = ((ComponentDefType)type).getDefinition();
        ComplexComponent comp = this.cdefMap.get(cdef);
        if (comp == null) {
            return;
        }
        Assert.check((boolean)(comp instanceof Automaton));
        ComponentType ctype = CifConstructors.newComponentType();
        ctype.setComponent((Component)comp);
        expr.setType((CifType)ctype);
    }

    protected void postprocessComponentType(ComponentType compType) {
        Component c = compType.getComponent();
        if (!(c instanceof ComponentInst)) {
            return;
        }
        ComplexComponent comp = this.instMap.get(c);
        if (comp == null) {
            return;
        }
        compType.setComponent((Component)comp);
    }

    protected void walkCompInstWrapExpression(CompInstWrapExpression wrap) {
        ComplexComponent comp = this.instMap.get(wrap.getInstantiation());
        if (comp == null) {
            super.walkCompInstWrapExpression(wrap);
            return;
        }
        ComponentInst inst = wrap.getInstantiation();
        Expression childRef = wrap.getReference();
        PositionObject refObj = CifScopeUtils.getRefObjFromRef((Expression)childRef);
        ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
        ComplexComponent body = cdef.getBody();
        Object newRefObj = this.getNonViaRefObj((EObject)refObj, body, comp);
        if (childRef instanceof ConstantExpression) {
            Constant c = (Constant)newRefObj;
            ((ConstantExpression)childRef).setConstant(c);
        } else if (childRef instanceof DiscVariableExpression) {
            DiscVariable v = (DiscVariable)newRefObj;
            ((DiscVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof AlgVariableExpression) {
            AlgVariable a = (AlgVariable)newRefObj;
            ((AlgVariableExpression)childRef).setVariable(a);
        } else if (childRef instanceof ContVariableExpression) {
            ContVariable v = (ContVariable)newRefObj;
            ((ContVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof LocationExpression) {
            Location l = (Location)newRefObj;
            ((LocationExpression)childRef).setLocation(l);
        } else if (childRef instanceof EnumLiteralExpression) {
            EnumLiteral l = (EnumLiteral)newRefObj;
            ((EnumLiteralExpression)childRef).setLiteral(l);
        } else if (childRef instanceof EventExpression) {
            Event e = (Event)newRefObj;
            ((EventExpression)childRef).setEvent(e);
        } else if (childRef instanceof FunctionExpression) {
            Function f = (Function)newRefObj;
            ((FunctionExpression)childRef).setFunction(f);
        } else if (childRef instanceof InputVariableExpression) {
            InputVariable v = (InputVariable)newRefObj;
            ((InputVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof ComponentExpression) {
            ComponentExpression compRef = (ComponentExpression)childRef;
            Component c = (Component)newRefObj;
            compRef.setComponent(c);
        } else {
            if (childRef instanceof CompParamExpression) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompInstWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown child ref expr: " + childRef);
        }
        EMFHelper.updateParentContainment((EObject)wrap, (EObject)childRef);
        this.walkCifType(childRef.getType());
    }

    protected void walkCompInstWrapType(CompInstWrapType wrap) {
        TypeDecl refObj;
        ComplexComponent comp = this.instMap.get(wrap.getInstantiation());
        if (comp == null) {
            super.walkCompInstWrapType(wrap);
            return;
        }
        ComponentInst inst = wrap.getInstantiation();
        CifType childRef = wrap.getReference();
        if (childRef instanceof TypeRef) {
            refObj = ((TypeRef)childRef).getType();
        } else if (childRef instanceof EnumType) {
            refObj = ((EnumType)childRef).getEnum();
        } else if (childRef instanceof ComponentType) {
            refObj = ((ComponentType)childRef).getComponent();
        } else {
            if (childRef instanceof ComponentDefType) {
                EObject parent = wrap.eContainer();
                while (parent instanceof CompInstWrapType) {
                    parent = ((CompInstWrapType)parent).eContainer();
                }
                Assert.check((parent instanceof ComponentParameter || parent instanceof CompParamExpression ? 1 : 0) != 0);
                EMFHelper.updateParentContainment((EObject)wrap, (EObject)childRef);
                return;
            }
            if (childRef instanceof CompInstWrapType) {
                throw new RuntimeException("Invalid comp inst wrap type.");
            }
            if (childRef instanceof CompParamWrapType) {
                throw new RuntimeException("Invalid comp param wrap type.");
            }
            throw new RuntimeException("Unknown ref type: " + childRef);
        }
        ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)inst);
        ComplexComponent body = cdef.getBody();
        Object newRefObj = this.getNonViaRefObj((EObject)refObj, body, comp);
        if (childRef instanceof TypeRef) {
            TypeDecl t = (TypeDecl)newRefObj;
            ((TypeRef)childRef).setType(t);
        } else if (childRef instanceof EnumType) {
            EnumDecl e = (EnumDecl)newRefObj;
            ((EnumType)childRef).setEnum(e);
        } else if (childRef instanceof ComponentType) {
            Component c = (Component)newRefObj;
            ((ComponentType)childRef).setComponent(c);
        } else {
            if (childRef instanceof ComponentDefType) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompInstWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown ref type: " + childRef);
        }
        EMFHelper.updateParentContainment((EObject)wrap, (EObject)childRef);
    }

    protected void walkCompParamWrapExpression(CompParamWrapExpression wrap) {
        Location l;
        DiscVariable v;
        Constant c;
        ComplexComponent newBody;
        Expression rsltInnerWrap;
        ComponentParameter param = wrap.getParameter();
        Expression arg = this.getActualArgument(param);
        if (arg == null) {
            super.walkCompParamWrapExpression(wrap);
            return;
        }
        Expression rsltExpr = (Expression)EMFHelper.deepclone((EObject)arg);
        Expression argLeaf = CifTypeUtils.unwrapExpression((Expression)rsltExpr);
        Assert.check((argLeaf instanceof ComponentExpression || argLeaf instanceof CompParamExpression ? 1 : 0) != 0);
        if (argLeaf instanceof CompParamExpression) {
            Assert.check((argLeaf == rsltExpr ? 1 : 0) != 0);
            ComponentParameter compParam = ((CompParamExpression)argLeaf).getParameter();
            wrap.setParameter(compParam);
            Assert.check((this.getActualArgument(compParam) == null ? 1 : 0) != 0);
            super.walkCompParamWrapExpression(wrap);
            return;
        }
        Component argLeafComp = ((ComponentExpression)argLeaf).getComponent();
        if (argLeafComp instanceof ComponentInst) {
            ComponentInst argLeafInst = (ComponentInst)argLeafComp;
            Assert.check((!this.instMap.containsKey(argLeafInst) ? 1 : 0) != 0);
            CompInstWrapExpression newWrap = CifConstructors.newCompInstWrapExpression();
            newWrap.setInstantiation(argLeafInst);
            if (argLeaf == rsltExpr) {
                Assert.check((boolean)(arg instanceof ComponentExpression));
                rsltExpr = newWrap;
                rsltInnerWrap = newWrap;
            } else {
                Assert.check((arg instanceof CompInstWrapExpression || arg instanceof CompParamWrapExpression ? 1 : 0) != 0);
                EMFHelper.updateParentContainment((EObject)argLeaf, (EObject)newWrap);
                rsltInnerWrap = newWrap;
            }
            ComponentDef argDef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)argLeafInst);
            newBody = argDef.getBody();
        } else {
            Assert.check((boolean)(argLeafComp instanceof ComplexComponent));
            ComplexComponent argLeafComplexComp = (ComplexComponent)argLeafComp;
            if (argLeaf == rsltExpr) {
                Assert.check((boolean)(arg instanceof ComponentExpression));
                rsltExpr = null;
                rsltInnerWrap = null;
            } else {
                Assert.check((arg instanceof CompInstWrapExpression || arg instanceof CompParamWrapExpression ? 1 : 0) != 0);
                rsltInnerWrap = (Expression)argLeaf.eContainer();
                EMFHelper.removeFromParentContainment((EObject)argLeaf);
            }
            newBody = argLeafComplexComp;
        }
        CifType paramType = wrap.getParameter().getType();
        paramType = CifTypeUtils.normalizeType((CifType)paramType);
        Assert.check((boolean)(paramType instanceof ComponentDefType));
        ComponentDef paramDef = ((ComponentDefType)paramType).getDefinition();
        ComplexComponent curBody = paramDef.getBody();
        Expression childRef = wrap.getReference();
        Assert.check((!(childRef instanceof CompParamWrapExpression) ? 1 : 0) != 0);
        while (childRef instanceof CompInstWrapExpression) {
            CompInstWrapExpression childWrap = (CompInstWrapExpression)childRef;
            ComponentInst viaInst = childWrap.getInstantiation();
            childRef = childWrap.getReference();
            ComplexComponent instComp = this.instMap.get(viaInst);
            if (instComp == null) {
                CompInstWrapExpression newWrap = CifConstructors.newCompInstWrapExpression();
                newWrap.setInstantiation(viaInst);
                if (rsltExpr == null) {
                    rsltExpr = newWrap;
                } else {
                    Assert.notNull((Object)rsltInnerWrap);
                    if (rsltInnerWrap instanceof CompInstWrapExpression) {
                        ((CompInstWrapExpression)rsltInnerWrap).setReference((Expression)newWrap);
                    } else {
                        Assert.check((boolean)(rsltInnerWrap instanceof CompParamWrapExpression));
                        ((CompParamWrapExpression)rsltInnerWrap).setReference((Expression)newWrap);
                    }
                }
                rsltInnerWrap = newWrap;
                ComponentDef viaDef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)viaInst);
                curBody = viaDef.getBody();
                newBody = viaDef.getBody();
                continue;
            }
            Assert.check((!(childRef instanceof CompInstWrapExpression) ? 1 : 0) != 0);
            ComponentDef viaDef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)viaInst);
            curBody = viaDef.getBody();
            newBody = instComp;
        }
        Assert.check((!(childRef instanceof CompInstWrapExpression) ? 1 : 0) != 0);
        Assert.check((!(childRef instanceof CompParamWrapExpression) ? 1 : 0) != 0);
        PositionObject refObj = CifScopeUtils.getRefObjFromRef((Expression)childRef);
        Object newRefObj = curBody == newBody ? refObj : this.getNonViaRefObj((EObject)refObj, curBody, newBody);
        if (childRef instanceof ConstantExpression) {
            c = (Constant)newRefObj;
            ((ConstantExpression)childRef).setConstant(c);
        } else if (childRef instanceof DiscVariableExpression) {
            v = (DiscVariable)newRefObj;
            ((DiscVariableExpression)childRef).setVariable(v);
        } else if (childRef instanceof AlgVariableExpression) {
            AlgVariable a = (AlgVariable)newRefObj;
            ((AlgVariableExpression)childRef).setVariable(a);
        } else if (childRef instanceof ContVariableExpression) {
            v = (ContVariable)newRefObj;
            ((ContVariableExpression)childRef).setVariable((ContVariable)v);
        } else if (childRef instanceof LocationExpression) {
            l = (Location)newRefObj;
            ((LocationExpression)childRef).setLocation(l);
        } else if (childRef instanceof EnumLiteralExpression) {
            l = (EnumLiteral)newRefObj;
            ((EnumLiteralExpression)childRef).setLiteral((EnumLiteral)l);
        } else if (childRef instanceof EventExpression) {
            Event e = (Event)newRefObj;
            ((EventExpression)childRef).setEvent(e);
        } else if (childRef instanceof FunctionExpression) {
            Function f = (Function)newRefObj;
            ((FunctionExpression)childRef).setFunction(f);
        } else if (childRef instanceof InputVariableExpression) {
            v = (InputVariable)newRefObj;
            ((InputVariableExpression)childRef).setVariable((InputVariable)v);
        } else if (childRef instanceof ComponentExpression) {
            c = (Component)newRefObj;
            ((ComponentExpression)childRef).setComponent((Component)c);
            this.walkComponentExpression((ComponentExpression)childRef);
        } else {
            if (childRef instanceof CompParamExpression) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompInstWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapExpression) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown ref expr: " + childRef);
        }
        if (rsltExpr == null) {
            rsltExpr = childRef;
            EMFHelper.updateParentContainment((EObject)wrap, (EObject)rsltExpr);
        } else {
            Assert.notNull((Object)rsltInnerWrap);
            EMFHelper.updateParentContainment((EObject)wrap, (EObject)rsltExpr);
            if (rsltInnerWrap instanceof CompInstWrapExpression) {
                ((CompInstWrapExpression)rsltInnerWrap).setReference(childRef);
            } else {
                Assert.check((boolean)(rsltInnerWrap instanceof CompParamWrapExpression));
                ((CompParamWrapExpression)rsltInnerWrap).setReference(childRef);
            }
        }
        this.walkCifType(childRef.getType());
        EObject ancestor = childRef.eContainer();
        while (ancestor instanceof CompInstWrapExpression || ancestor instanceof CompParamWrapExpression) {
            CifType newType = (CifType)EMFHelper.deepclone((EObject)childRef.getType());
            ((Expression)ancestor).setType(newType);
            ancestor = ancestor.eContainer();
        }
    }

    protected void walkCompParamWrapType(CompParamWrapType wrap) {
        ComplexComponent newBody;
        CompInstWrapType rsltInnerWrap;
        CifType rsltType;
        ComponentParameter param = wrap.getParameter();
        Expression arg = this.getActualArgument(param);
        if (arg == null) {
            super.walkCompParamWrapType(wrap);
            return;
        }
        Expression argLeaf = CifTypeUtils.unwrapExpression((Expression)arg);
        Assert.check((argLeaf instanceof ComponentExpression || argLeaf instanceof CompParamExpression ? 1 : 0) != 0);
        if (argLeaf instanceof CompParamExpression) {
            Assert.check((argLeaf == arg ? 1 : 0) != 0);
            ComponentParameter compParam = ((CompParamExpression)argLeaf).getParameter();
            wrap.setParameter(compParam);
            Assert.check((this.getActualArgument(compParam) == null ? 1 : 0) != 0);
            super.walkCompParamWrapType(wrap);
            return;
        }
        Component argLeafComp = ((ComponentExpression)argLeaf).getComponent();
        if (argLeafComp instanceof ComponentInst) {
            ComponentInst argLeafInst = (ComponentInst)argLeafComp;
            Assert.check((!this.instMap.containsKey(argLeafInst) ? 1 : 0) != 0);
            CompInstWrapType newWrap = CifConstructors.newCompInstWrapType();
            newWrap.setInstantiation(argLeafInst);
            if (argLeaf == arg) {
                Assert.check((boolean)(arg instanceof ComponentExpression));
                rsltType = newWrap;
                rsltInnerWrap = newWrap;
            } else {
                Assert.check((arg instanceof CompInstWrapExpression || arg instanceof CompParamWrapExpression ? 1 : 0) != 0);
                rsltType = this.convertWrapExprToWrapType(arg, (CifType)newWrap);
                rsltInnerWrap = newWrap;
            }
            ComponentDef argDef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)argLeafInst);
            newBody = argDef.getBody();
        } else {
            Assert.check((boolean)(argLeafComp instanceof ComplexComponent));
            ComplexComponent argLeafComplexComp = (ComplexComponent)argLeafComp;
            if (argLeaf == arg) {
                Assert.check((boolean)(arg instanceof ComponentExpression));
                rsltType = null;
                rsltInnerWrap = null;
            } else {
                Assert.check((arg instanceof CompInstWrapExpression || arg instanceof CompParamWrapExpression ? 1 : 0) != 0);
                BoolType dummy = CifConstructors.newBoolType();
                rsltType = this.convertWrapExprToWrapType(arg, (CifType)dummy);
                rsltInnerWrap = (CifType)dummy.eContainer();
                EMFHelper.removeFromParentContainment((EObject)dummy);
            }
            newBody = argLeafComplexComp;
        }
        CifType paramType = wrap.getParameter().getType();
        paramType = CifTypeUtils.normalizeType((CifType)paramType);
        Assert.check((boolean)(paramType instanceof ComponentDefType));
        ComponentDef paramDef = ((ComponentDefType)paramType).getDefinition();
        ComplexComponent curBody = paramDef.getBody();
        CifType childRef = wrap.getReference();
        Assert.check((!(childRef instanceof CompParamWrapType) ? 1 : 0) != 0);
        while (childRef instanceof CompInstWrapType) {
            CompInstWrapType childWrap = (CompInstWrapType)childRef;
            ComponentInst viaInst = childWrap.getInstantiation();
            childRef = childWrap.getReference();
            ComplexComponent instComp = this.instMap.get(viaInst);
            if (instComp == null) {
                CompInstWrapType newWrap = CifConstructors.newCompInstWrapType();
                newWrap.setInstantiation(viaInst);
                if (rsltType == null) {
                    rsltType = newWrap;
                } else {
                    Assert.notNull((Object)rsltInnerWrap);
                    if (rsltInnerWrap instanceof CompInstWrapType) {
                        rsltInnerWrap.setReference((CifType)newWrap);
                    } else {
                        Assert.check((boolean)(rsltInnerWrap instanceof CompParamWrapType));
                        ((CompParamWrapType)rsltInnerWrap).setReference((CifType)newWrap);
                    }
                }
                rsltInnerWrap = newWrap;
                ComponentDef viaDef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)viaInst);
                curBody = viaDef.getBody();
                newBody = viaDef.getBody();
                continue;
            }
            Assert.check((!(childRef instanceof CompInstWrapType) ? 1 : 0) != 0);
            ComponentDef viaDef = CifTypeUtils.getCompDefFromCompInst((ComponentInst)viaInst);
            curBody = viaDef.getBody();
            newBody = instComp;
        }
        Assert.check((!(childRef instanceof CompInstWrapType) ? 1 : 0) != 0);
        Assert.check((!(childRef instanceof CompParamWrapType) ? 1 : 0) != 0);
        Assert.check((!(childRef instanceof ComponentDefType) ? 1 : 0) != 0);
        PositionObject refObj = CifScopeUtils.getRefObjFromRef((CifType)childRef);
        Object newRefObj = curBody == newBody ? refObj : this.getNonViaRefObj((EObject)refObj, curBody, newBody);
        if (childRef instanceof TypeRef) {
            TypeDecl t = (TypeDecl)newRefObj;
            ((TypeRef)childRef).setType(t);
        } else if (childRef instanceof EnumType) {
            EnumDecl e = (EnumDecl)newRefObj;
            ((EnumType)childRef).setEnum(e);
        } else if (childRef instanceof ComponentType) {
            Component c = (Component)newRefObj;
            ((ComponentType)childRef).setComponent(c);
            this.walkComponentType((ComponentType)childRef);
        } else {
            if (childRef instanceof ComponentDefType) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompInstWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            if (childRef instanceof CompParamWrapType) {
                throw new RuntimeException("Should never get here...");
            }
            throw new RuntimeException("Unknown ref type: " + childRef);
        }
        if (rsltType == null) {
            rsltType = childRef;
            EMFHelper.updateParentContainment((EObject)wrap, (EObject)rsltType);
        } else {
            Assert.notNull((Object)rsltInnerWrap);
            EMFHelper.updateParentContainment((EObject)wrap, (EObject)rsltType);
            if (rsltInnerWrap instanceof CompInstWrapType) {
                rsltInnerWrap.setReference(childRef);
            } else {
                Assert.check((boolean)(rsltInnerWrap instanceof CompParamWrapType));
                ((CompParamWrapType)rsltInnerWrap).setReference(childRef);
            }
        }
    }

    private Expression getActualArgument(ComponentParameter param) {
        Expression arg = this.compParamMap.get(param);
        if (arg == null) {
            return null;
        }
        Pair<ComponentInst, Integer> origInfo = this.paramOrigMap.get(param);
        if (origInfo == null) {
            return arg;
        }
        this.walkExpression(arg);
        ComponentInst inst = (ComponentInst)origInfo.left;
        int paramIdx = (Integer)origInfo.right;
        Expression newArg = (Expression)inst.getParameters().get(paramIdx);
        if (arg != newArg) {
            this.compParamMap.put(param, newArg);
        }
        this.paramOrigMap.remove(param);
        return newArg;
    }

    private Object getNonViaRefObj(EObject refObj, ComplexComponent compDefBody, ComplexComponent compInstBody) {
        Object newRefObj;
        LinkedHashSet<ComplexComponent> otherInstComps = new LinkedHashSet<ComplexComponent>(this.instMap.values());
        otherInstComps.remove(compInstBody);
        EObject curObj = refObj;
        boolean inDefBody = false;
        boolean inInstBody = false;
        ComplexComponent otherInstBody = null;
        while (curObj != null) {
            if (curObj == compDefBody) {
                inDefBody = true;
            }
            if (curObj == compInstBody) {
                inInstBody = true;
            }
            if (otherInstComps.contains(curObj)) {
                Assert.check((otherInstBody == null ? 1 : 0) != 0);
                otherInstBody = (ComplexComponent)curObj;
            }
            curObj = curObj.eContainer();
        }
        int successes = 0;
        if (inDefBody) {
            ++successes;
        }
        if (inInstBody) {
            ++successes;
        }
        if (otherInstBody != null) {
            ++successes;
        }
        Assert.check((successes == 1 ? 1 : 0) != 0);
        if (inDefBody) {
            EMFPath path = new EMFPath(refObj, null, (EObject)compDefBody);
            newRefObj = path.resolveAgainst((EObject)compInstBody);
        } else if (inInstBody) {
            newRefObj = refObj;
        } else {
            EMFPath path = new EMFPath(refObj, null, (EObject)otherInstBody);
            newRefObj = path.resolveAgainst((EObject)compInstBody);
        }
        return newRefObj;
    }

    private CifType convertWrapExprToWrapType(Expression wrap, CifType leafType) {
        Assert.check((wrap instanceof CompParamWrapExpression || wrap instanceof CompInstWrapExpression ? 1 : 0) != 0);
        if (wrap instanceof CompParamWrapExpression) {
            CompParamWrapExpression paramWrap = (CompParamWrapExpression)wrap;
            CompParamWrapType newParamWrap = CifConstructors.newCompParamWrapType();
            newParamWrap.setParameter(paramWrap.getParameter());
            Expression reference = paramWrap.getReference();
            if (reference instanceof CompParamWrapExpression || reference instanceof CompInstWrapExpression) {
                newParamWrap.setReference(this.convertWrapExprToWrapType(reference, leafType));
            } else {
                newParamWrap.setReference(leafType);
            }
            return newParamWrap;
        }
        CompInstWrapExpression instWrap = (CompInstWrapExpression)wrap;
        CompInstWrapType newInstWrap = CifConstructors.newCompInstWrapType();
        newInstWrap.setInstantiation(instWrap.getInstantiation());
        Expression reference = instWrap.getReference();
        if (reference instanceof CompParamWrapExpression || reference instanceof CompInstWrapExpression) {
            newInstWrap.setReference(this.convertWrapExprToWrapType(reference, leafType));
        } else {
            newInstWrap.setReference(leafType);
        }
        return newInstWrap;
    }

    private void setPositionInfo(PositionObject obj, Position position) {
        obj.setPosition(position);
        Expression ref = null;
        if (obj instanceof CompParamWrapExpression) {
            ref = ((CompParamWrapExpression)obj).getReference();
        } else if (obj instanceof CompInstWrapExpression) {
            ref = ((CompInstWrapExpression)obj).getReference();
        } else if (obj instanceof CompParamWrapType) {
            ref = ((CompParamWrapType)obj).getReference();
        } else if (obj instanceof CompInstWrapType) {
            ref = ((CompInstWrapType)obj).getReference();
        }
        if (ref != null) {
            this.setPositionInfo((PositionObject)ref, PositionUtils.copyPosition((Position)position));
        }
    }
}

