/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import java.util.List;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.VarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererHelper;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererMetric;
import org.eclipse.escet.common.java.Assert;

public class ChoiceVarOrderer
implements VarOrderer {
    private final String name;
    private final List<VarOrderer> algorithms;
    private final VarOrdererMetric metric;

    public ChoiceVarOrderer(List<VarOrderer> algorithms, VarOrdererMetric metric) {
        this(null, algorithms, metric);
    }

    public ChoiceVarOrderer(String name, List<VarOrderer> algorithms, VarOrdererMetric metric) {
        this.name = name;
        this.algorithms = algorithms;
        this.metric = metric;
        Assert.check((algorithms.size() >= 2 ? 1 : 0) != 0);
    }

    @Override
    public List<SynthesisVariable> order(VarOrdererHelper helper, List<SynthesisVariable> inputOrder, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            if (this.name == null) {
                helper.dbg(dbgLevel, "Applying multiple algorithms, and choosing the best result:", new Object[0]);
            } else {
                helper.dbg(dbgLevel, "Applying %s algorithm:", this.name);
            }
        }
        List<SynthesisVariable> bestOrder = null;
        double bestMetric = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.algorithms.size()) {
            VarOrderer algorithm;
            List<SynthesisVariable> algoOrder;
            double algoMetric;
            if (i > 0 && dbgEnabled) {
                helper.dbg();
            }
            if ((algoMetric = this.metric.compute(helper, algoOrder = (algorithm = this.algorithms.get(i)).order(helper, inputOrder, dbgEnabled, dbgLevel + 1))) < bestMetric) {
                bestOrder = algoOrder;
                bestMetric = algoMetric;
                if (dbgEnabled) {
                    helper.dbg(dbgLevel + 1, "Found new best variable order.", new Object[0]);
                }
            }
            ++i;
        }
        Assert.notNull(bestOrder);
        return bestOrder;
    }
}

