/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.VarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererHelper;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ForceVarOrderer
implements VarOrderer {
    @Override
    public List<SynthesisVariable> order(VarOrdererHelper helper, List<SynthesisVariable> inputOrder, boolean dbgEnabled, int dbgLevel) {
        long curTotalSpan;
        int varCnt = inputOrder.size();
        BitSet[] hyperEdges = helper.getHyperEdges();
        if (dbgEnabled) {
            helper.dbg(dbgLevel, "Applying FORCE algorithm.", new Object[0]);
        }
        double[] locations = new double[varCnt];
        List idxLocPairs = Lists.listc((int)varCnt);
        int i = 0;
        while (i < varCnt) {
            idxLocPairs.add(new IdxLocPair());
            ++i;
        }
        double[] cogs = new double[hyperEdges.length];
        int[] edgeCounts = new int[varCnt];
        BitSet[] bitSetArray = hyperEdges;
        int n = hyperEdges.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet edge = bitSetArray[n2];
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i2;
                int n3 = i2 = ((Integer)iterator.next()).intValue();
                edgeCounts[n3] = edgeCounts[n3] + 1;
            }
            ++n2;
        }
        int[] curIndices = helper.getNewIndicesForVarOrder(inputOrder);
        int[] bestIndices = (int[])curIndices.clone();
        int maxIter = (int)Math.ceil(Math.log(varCnt));
        maxIter *= 10;
        if (dbgEnabled) {
            helper.dbg(dbgLevel, "Maximum number of iterations: %,d", maxIter);
        }
        long bestTotalSpan = curTotalSpan = helper.computeTotalSpanForNewIndices(curIndices);
        if (dbgEnabled) {
            helper.dbgMetricsForNewIndices(dbgLevel, curIndices, "before");
        }
        int curIter = 0;
        while (curIter < maxIter) {
            BitSet edge;
            int i3 = 0;
            while (i3 < hyperEdges.length) {
                edge = hyperEdges[i3];
                double cog = 0.0;
                Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    cog += (double)curIndices[j];
                }
                cogs[i3] = cog / (double)edge.cardinality();
                ++i3;
            }
            Arrays.fill(locations, 0.0);
            i3 = 0;
            while (i3 < hyperEdges.length) {
                edge = hyperEdges[i3];
                Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
                while (iterator.hasNext()) {
                    int j;
                    int n4 = j = ((Integer)iterator.next()).intValue();
                    locations[n4] = locations[n4] + cogs[i3];
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < varCnt) {
                int n5 = i3;
                locations[n5] = locations[n5] / (double)edgeCounts[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < varCnt) {
                IdxLocPair pair = (IdxLocPair)idxLocPairs.get(i3);
                pair.idx = i3;
                pair.location = locations[i3];
                ++i3;
            }
            Collections.sort(idxLocPairs);
            i3 = 0;
            while (i3 < varCnt) {
                curIndices[((IdxLocPair)idxLocPairs.get((int)i3)).idx] = i3;
                ++i3;
            }
            long newTotalSpan = helper.computeTotalSpanForNewIndices(curIndices);
            if (dbgEnabled) {
                helper.dbgMetricsForNewIndices(dbgLevel, curIndices, Strings.fmt((String)"iteration %,d", (Object[])new Object[]{curIter + 1}));
            }
            if (newTotalSpan == curTotalSpan) break;
            if (newTotalSpan < bestTotalSpan) {
                System.arraycopy(curIndices, 0, bestIndices, 0, varCnt);
                bestTotalSpan = newTotalSpan;
            }
            curTotalSpan = newTotalSpan;
            ++curIter;
        }
        if (dbgEnabled) {
            helper.dbgMetricsForNewIndices(dbgLevel, bestIndices, "after");
        }
        return helper.reorderForNewIndices(bestIndices);
    }

    private static class IdxLocPair
    implements Comparable<IdxLocPair> {
        public int idx;
        public double location;

        private IdxLocPair() {
        }

        @Override
        public int compareTo(IdxLocPair other) {
            int rslt = Double.compare(this.location, other.location);
            if (rslt != 0) {
                return rslt;
            }
            return Integer.compare(this.idx, other.idx);
        }

        public String toString() {
            return Strings.fmt((String)"(%s, %s)", (Object[])new Object[]{this.idx, this.location});
        }
    }
}

