/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import java.util.Collections;
import java.util.List;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.VarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererHelper;

public class ReverseVarOrderer
implements VarOrderer {
    private final VarOrderer algorithm;

    public ReverseVarOrderer(VarOrderer algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public List<SynthesisVariable> order(VarOrdererHelper helper, List<SynthesisVariable> inputOrder, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            helper.dbg(dbgLevel, "Applying algorithm, and reversing its result:", new Object[0]);
        }
        List<SynthesisVariable> order = this.algorithm.order(helper, inputOrder, dbgEnabled, dbgLevel + 1);
        Collections.reverse(order);
        if (dbgEnabled) {
            helper.dbg(dbgLevel, "Reversed the variable order.", new Object[0]);
            helper.dbgMetricsForVarOrder(dbgLevel, order, "reversed");
        }
        return order;
    }
}

