/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import java.util.List;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.VarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererHelper;
import org.eclipse.escet.common.java.Assert;

public class SequentialVarOrderer
implements VarOrderer {
    private final List<VarOrderer> algorithms;

    public SequentialVarOrderer(List<VarOrderer> algorithms) {
        this.algorithms = algorithms;
        Assert.check((algorithms.size() >= 2 ? 1 : 0) != 0);
    }

    @Override
    public List<SynthesisVariable> order(VarOrdererHelper helper, List<SynthesisVariable> inputOrder, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            helper.dbg(dbgLevel, "Applying %d algorithms, sequentially:", this.algorithms.size());
        }
        List<SynthesisVariable> order = inputOrder;
        int i = 0;
        while (i < this.algorithms.size()) {
            if (i > 0 && dbgEnabled) {
                helper.dbg();
            }
            VarOrderer algorithm = this.algorithms.get(i);
            order = algorithm.order(helper, order, dbgEnabled, dbgLevel + 1);
            ++i;
        }
        return order;
    }
}

