/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import java.util.List;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.VarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.helper.VarOrdererHelper;
import org.eclipse.escet.common.java.PermuteUtils;
import org.eclipse.escet.common.java.Strings;

public class SlidingWindowVarOrderer
implements VarOrderer {
    private final int maxLen;

    public SlidingWindowVarOrderer(int maxLen) {
        this.maxLen = maxLen;
    }

    @Override
    public List<SynthesisVariable> order(VarOrdererHelper helper, List<SynthesisVariable> inputOrder, boolean dbgEnabled, int dbgLevel) {
        int varCnt = inputOrder.size();
        if (dbgEnabled) {
            helper.dbg(dbgLevel, "Applying sliding window algorithm.", new Object[0]);
        }
        int length = Math.min(this.maxLen, varCnt);
        if (dbgEnabled) {
            helper.dbg(dbgLevel, "Window length: %,d", length);
        }
        int[] curIndices = helper.getNewIndicesForVarOrder(inputOrder);
        long curSpan = helper.computeTotalSpanForNewIndices(curIndices);
        if (dbgEnabled) {
            helper.dbgMetricsForNewIndices(dbgLevel, curIndices, "before");
        }
        int[] window = new int[length];
        int permCnt = PermuteUtils.factorial((int)window.length);
        int[][] windowPerms = new int[permCnt][window.length];
        int offset = 0;
        while (offset <= varCnt - length) {
            System.arraycopy(curIndices, offset, window, 0, length);
            PermuteUtils.permute((int[])window, (int[][])windowPerms);
            int bestIdx = -1;
            int[] windowIndices = (int[])curIndices.clone();
            int i = 0;
            while (i < windowPerms.length) {
                int[] windowPerm = windowPerms[i];
                System.arraycopy(windowPerm, 0, windowIndices, offset, length);
                long windowSpan = helper.computeTotalSpanForNewIndices(windowIndices);
                if (windowSpan < curSpan) {
                    curSpan = windowSpan;
                    bestIdx = i;
                }
                ++i;
            }
            if (bestIdx >= 0) {
                System.arraycopy(windowPerms[bestIdx], 0, curIndices, offset, length);
                if (dbgEnabled) {
                    helper.dbgMetricsForNewIndices(dbgLevel, curIndices, Strings.fmt((String)"window %d..%d", (Object[])new Object[]{offset, offset + length - 1}));
                }
            }
            ++offset;
        }
        if (dbgEnabled) {
            helper.dbgMetricsForNewIndices(dbgLevel, curIndices, "after");
        }
        return helper.reorderForNewIndices(curIndices);
    }
}

