/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.helper;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.datasynth.spec.SynthesisDiscVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisInputVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisLocPtrVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.helper.ComparisonCollector;
import org.eclipse.escet.cif.datasynth.varorder.helper.VariableCollector;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

class HyperEdgeCreator {
    private List<SynthesisVariable> variables;
    private List<BitSet> hyperEdges = Lists.list();
    private Map<Event, Set<PositionObject>> eventHyperEdges = Maps.map();

    HyperEdgeCreator() {
    }

    List<BitSet> getHyperEdges(Specification spec, List<SynthesisVariable> variables) {
        this.variables = variables;
        this.hyperEdges = Lists.list();
        this.eventHyperEdges = Maps.map();
        this.addHyperEdges((ComplexComponent)spec);
        for (Set<PositionObject> vars : this.eventHyperEdges.values()) {
            this.addHyperEdge(vars);
        }
        List<BitSet> rslt = this.hyperEdges;
        this.eventHyperEdges = null;
        this.variables = null;
        this.hyperEdges = null;
        return rslt;
    }

    private void addHyperEdges(ComplexComponent comp) {
        for (Invariant inv : comp.getInvariants()) {
            Expression pred = inv.getPredicate();
            VariableCollector varCollector = new VariableCollector();
            Set vars = Sets.set();
            varCollector.collectCifVarObjs(pred, (Set<PositionObject>)vars);
            this.addHyperEdge(vars);
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : comp.getInvariants()) {
                    Expression pred = inv.getPredicate();
                    VariableCollector varCollector = new VariableCollector();
                    Set vars = Sets.set();
                    varCollector.collectCifVarObjs(pred, (Set<PositionObject>)vars);
                    this.addHyperEdge(vars);
                }
                for (Edge edge : loc.getEdges()) {
                    this.addHyperEdges(aut, edge);
                }
            }
        }
        if (comp instanceof Group) {
            Group group = (Group)comp;
            for (Component child : group.getComponents()) {
                this.addHyperEdges((ComplexComponent)child);
            }
        }
    }

    private void addHyperEdges(Automaton aut, Edge edge) {
        VariableCollector varCollector;
        for (Expression guard : edge.getGuards()) {
            ComparisonCollector cmpCollector = new ComparisonCollector();
            List<BinaryExpression> cmps = cmpCollector.collectComparisons(guard);
            for (BinaryExpression cmp : cmps) {
                varCollector = new VariableCollector();
                Set vars = Sets.set();
                varCollector.collectCifVarObjs(cmp.getLeft(), (Set<PositionObject>)vars);
                varCollector.collectCifVarObjs(cmp.getRight(), (Set<PositionObject>)vars);
                this.addHyperEdge(vars);
            }
        }
        this.addHyperEdges((List<Update>)edge.getUpdates());
        Automaton lpAut = aut.getLocations().size() < 2 ? null : aut;
        for (EdgeEvent edgeEvent : edge.getEvents()) {
            Expression eventRef = edgeEvent.getEvent();
            if (eventRef instanceof TauExpression) continue;
            Event event = ((EventExpression)eventRef).getEvent();
            Set vars = this.eventHyperEdges.get(event);
            if (vars == null) {
                vars = Sets.set();
                this.eventHyperEdges.put(event, vars);
            }
            varCollector = new VariableCollector();
            for (Expression guard : edge.getGuards()) {
                varCollector.collectCifVarObjs(guard, (Set<PositionObject>)vars);
            }
            for (Update update : edge.getUpdates()) {
                varCollector.collectCifVarObjs(update, (Set<PositionObject>)vars);
            }
            if (lpAut == null) continue;
            vars.add(lpAut);
        }
    }

    private void addHyperEdges(List<Update> updates) {
        for (Update update : updates) {
            if (!(update instanceof Assignment)) continue;
            Assignment asgn = (Assignment)update;
            VariableCollector varCollector = new VariableCollector();
            Set vars = Sets.set();
            varCollector.collectCifVarObjs(asgn.getAddressable(), (Set<PositionObject>)vars);
            varCollector.collectCifVarObjs(asgn.getValue(), (Set<PositionObject>)vars);
            this.addHyperEdge(vars);
        }
    }

    private void addHyperEdge(Set<PositionObject> vars) {
        if (vars.isEmpty()) {
            return;
        }
        BitSet hyperEdge = new BitSet(this.variables.size());
        for (PositionObject var : vars) {
            int matchIdx = -1;
            int i = 0;
            while (i < this.variables.size()) {
                SynthesisVariable synthVar = this.variables.get(i);
                Assert.notNull((Object)(synthVar == null ? 1 : 0));
                boolean match = false;
                if (synthVar instanceof SynthesisDiscVariable) {
                    SynthesisDiscVariable sdv = (SynthesisDiscVariable)synthVar;
                    if (sdv.var == var) {
                        match = true;
                    }
                } else if (synthVar instanceof SynthesisInputVariable) {
                    SynthesisInputVariable siv = (SynthesisInputVariable)synthVar;
                    if (siv.var == var) {
                        match = true;
                    }
                } else if (synthVar instanceof SynthesisLocPtrVariable) {
                    SynthesisLocPtrVariable slpv = (SynthesisLocPtrVariable)synthVar;
                    if (slpv.aut == var) {
                        match = true;
                    }
                } else {
                    throw new RuntimeException("Unknown synthesis variable: " + synthVar);
                }
                if (match) {
                    matchIdx = i;
                    break;
                }
                ++i;
            }
            Assert.check((matchIdx >= 0 ? 1 : 0) != 0);
            hyperEdge.set(matchIdx);
        }
        this.hyperEdges.add(hyperEdge);
    }
}

