/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder.helper;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.graph.Graph;
import org.eclipse.escet.cif.datasynth.varorder.graph.Node;
import org.eclipse.escet.cif.datasynth.varorder.helper.HyperEdgeCreator;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;

public class VarOrdererHelper {
    private final Specification spec;
    private final List<SynthesisVariable> variables;
    private final Map<SynthesisVariable, Integer> origIndices;
    private final BitSet[] hyperEdges;
    private final Graph graph;
    private final int metricLengthTotalSpan;
    private final int metricLengthTotalSpanAvg;
    private final int metricLengthWes;
    private final int metricLengthWesAvg;

    public VarOrdererHelper(Specification spec, List<SynthesisVariable> variables) {
        this.spec = spec;
        this.variables = variables;
        this.hyperEdges = this.createHyperEdges();
        this.graph = this.createGraph();
        this.origIndices = IntStream.range(0, variables.size()).boxed().collect(Collectors.toMap(i -> (SynthesisVariable)variables.get((int)i), i -> i));
        this.metricLengthTotalSpan = Strings.fmt((String)"%,d", (Object[])new Object[]{this.computeTotalSpanForVarOrder(variables)}).length() + 2;
        this.metricLengthTotalSpanAvg = Strings.fmt((String)"%,.2f", (Object[])new Object[]{(double)this.computeTotalSpanForVarOrder(variables) / (double)this.hyperEdges.length}).length() + 2;
        this.metricLengthWes = Strings.fmt((String)"%,.6f", (Object[])new Object[]{this.computeWesForVarOrder(variables)}).length() + 2;
        this.metricLengthWesAvg = Strings.fmt((String)"%,.6f", (Object[])new Object[]{this.computeWesForVarOrder(variables) / (double)this.hyperEdges.length}).length() + 2;
    }

    private BitSet[] createHyperEdges() {
        BitSet[] hyperEdges;
        HyperEdgeCreator creator = new HyperEdgeCreator();
        BitSet[] bitSetArray = hyperEdges = (BitSet[])creator.getHyperEdges(this.spec, this.variables).toArray(BitSet[]::new);
        int n = hyperEdges.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet hyperEdge = bitSetArray[n2];
            Assert.check((!hyperEdge.isEmpty() ? 1 : 0) != 0);
            ++n2;
        }
        return hyperEdges;
    }

    public BitSet[] getHyperEdges() {
        return this.hyperEdges;
    }

    private Graph createGraph() {
        Map graphEdges = Maps.mapc((int)this.hyperEdges.length);
        BitSet[] bitSetArray = this.hyperEdges;
        int n = this.hyperEdges.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet edge = bitSetArray[n2];
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Iterator iterator2 = BitSets.iterateTrueBits((BitSet)edge, (int)(i + 1)).iterator();
                while (iterator2.hasNext()) {
                    int j = (Integer)iterator2.next();
                    graphEdges.merge(Pair.pair((Object)i, (Object)j), 1, (a, b) -> a + b);
                }
            }
            ++n2;
        }
        Graph graph = new Graph(this.variables.size());
        for (Map.Entry graphEdge : graphEdges.entrySet()) {
            Node ni = graph.node((Integer)((Pair)graphEdge.getKey()).left);
            Node nj = graph.node((Integer)((Pair)graphEdge.getKey()).right);
            int weight = (Integer)graphEdge.getValue();
            ni.addEdge(nj, weight, true);
        }
        return graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void dbg() {
        OutputProvider.dbg();
    }

    public void dbg(int dbgLevel, String msg, Object ... args) {
        OutputProvider.dbg((String)(String.valueOf(Strings.spaces((int)(dbgLevel * 2))) + msg), (Object[])args);
    }

    public long computeTotalSpanForVarOrder(List<SynthesisVariable> order) {
        int[] newIndices = this.getNewIndicesForVarOrder(order);
        return this.computeTotalSpanForNewIndices(newIndices);
    }

    public long computeTotalSpanForNodeOrder(List<Node> order) {
        int[] newIndices = this.getNewIndicesForNodeOrder(order);
        return this.computeTotalSpanForNewIndices(newIndices);
    }

    public long computeTotalSpanForNewIndices(int[] newIndices) {
        long totalSpan = 0L;
        BitSet[] bitSetArray = this.hyperEdges;
        int n = this.hyperEdges.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet edge = bitSetArray[n2];
            int minIdx = Integer.MAX_VALUE;
            int maxIdx = 0;
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                int newIdx = newIndices[i];
                minIdx = Math.min(minIdx, newIdx);
                maxIdx = Math.max(maxIdx, newIdx);
            }
            int span = maxIdx - minIdx;
            totalSpan += (long)span;
            ++n2;
        }
        return totalSpan;
    }

    public double computeWesForVarOrder(List<SynthesisVariable> order) {
        int[] newIndices = this.getNewIndicesForVarOrder(order);
        return this.computeWesForNewIndices(newIndices);
    }

    public double computeWesForNodeOrder(List<Node> order) {
        int[] newIndices = this.getNewIndicesForNodeOrder(order);
        return this.computeWesForNewIndices(newIndices);
    }

    public double computeWesForNewIndices(int[] newIndices) {
        double nx = this.variables.size();
        double nE = this.hyperEdges.length;
        double wes = 0.0;
        BitSet[] bitSetArray = this.hyperEdges;
        int n = this.hyperEdges.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet edge = bitSetArray[n2];
            int xT = Integer.MAX_VALUE;
            int xB = 0;
            Iterator iterator = BitSets.iterateTrueBits((BitSet)edge).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                int newIdx = newIndices[i];
                xT = Math.min(xT, newIdx);
                xB = Math.max(xB, newIdx);
            }
            wes += (double)(2 * xB) / nx * (double)(xB - xT + 1) / (nx * nE);
            ++n2;
        }
        return wes;
    }

    public void dbgMetricsForVarOrder(int dbgLevel, List<SynthesisVariable> order, String annotation) {
        int[] newIndices = this.getNewIndicesForVarOrder(order);
        this.dbgMetricsForNewIndices(dbgLevel, newIndices, annotation);
    }

    public void dbgMetricsForNodeOrder(int dbgLevel, List<Node> order, String annotation) {
        int[] newIndices = this.getNewIndicesForNodeOrder(order);
        this.dbgMetricsForNewIndices(dbgLevel, newIndices, annotation);
    }

    public void dbgMetricsForNewIndices(int dbgLevel, int[] newIndices, String annotation) {
        String msg = this.fmtMetrics(newIndices, annotation);
        this.dbg(dbgLevel, msg, new Object[0]);
    }

    public String fmtMetrics(int[] newIndices, String annotation) {
        long totalSpan = this.computeTotalSpanForNewIndices(newIndices);
        double wes = this.computeWesForNewIndices(newIndices);
        String fmtTotalSpan = Strings.fmt((String)("%," + this.metricLengthTotalSpan + "d"), (Object[])new Object[]{totalSpan});
        String fmtTotalSpanAvg = Strings.fmt((String)("%," + this.metricLengthTotalSpanAvg + ".2f"), (Object[])new Object[]{(double)totalSpan / (double)this.hyperEdges.length});
        String fmtWes = Strings.fmt((String)("%," + this.metricLengthWes + ".6f"), (Object[])new Object[]{wes});
        String fmtWesAvg = Strings.fmt((String)("%," + this.metricLengthWesAvg + ".6f"), (Object[])new Object[]{wes / (double)this.hyperEdges.length});
        return Strings.fmt((String)"Total span: %s (total) %s (avg/edge) / WES: %s (total) %s (avg/edge) [%s]", (Object[])new Object[]{fmtTotalSpan, fmtTotalSpanAvg, fmtWes, fmtWesAvg, annotation});
    }

    public int[] getNewIndicesForVarOrder(List<SynthesisVariable> order) {
        int[] newIndices = new int[order.size()];
        int i = 0;
        while (i < order.size()) {
            newIndices[this.origIndices.get((Object)order.get((int)i)).intValue()] = i;
            ++i;
        }
        return newIndices;
    }

    public int[] getNewIndicesForNodeOrder(List<Node> order) {
        int[] newIndices = new int[order.size()];
        int i = 0;
        while (i < order.size()) {
            newIndices[order.get((int)i).index] = i;
            ++i;
        }
        return newIndices;
    }

    public List<SynthesisVariable> reorderForNodeOrder(List<Node> order) {
        int[] varOrder = this.getNewIndicesForNodeOrder(order);
        return this.reorderForNewIndices(varOrder);
    }

    public List<SynthesisVariable> reorderForNewIndices(int[] newIndices) {
        Assert.areEqual((Object)this.variables.size(), (Object)newIndices.length);
        SynthesisVariable[] result = new SynthesisVariable[this.variables.size()];
        int i = 0;
        while (i < newIndices.length) {
            result[newIndices[i]] = this.variables.get(i);
            ++i;
        }
        return Arrays.asList(result);
    }
}

