/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.OutputPosition;
import org.eclipse.escet.chi.codegen.java.JavaClass;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.java.JavaParameter;
import org.eclipse.escet.chi.codegen.statements.seq.ForLoopConversion;
import org.eclipse.escet.chi.codegen.statements.seq.Seq;
import org.eclipse.escet.chi.codegen.statements.seq.SeqCode;
import org.eclipse.escet.chi.codegen.statements.switchcases.SwitchCases;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.ForStatement;
import org.eclipse.escet.chi.metamodel.chi.FunctionDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ModelDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Statement;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.Unwind;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.chi.XperDeclaration;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ProcModelFuncXperGenerator {
    private ProcModelFuncXperGenerator() {
    }

    public static void transProcModelXperDeclaration(BehaviourDeclaration bd, CodeGeneratorContext ctxt) {
        String name = ctxt.getDefinition((PositionObject)bd);
        String baseClass = "org.eclipse.escet.chi.runtime.data.BaseProcess";
        int idx = baseClass.lastIndexOf(46);
        JavaClass jClass = ctxt.addJavaClass(name, false, baseClass.substring(idx + 1), null);
        jClass.addImport(baseClass, false);
        jClass.addVariable("private final " + ctxt.specName + " spec;");
        ctxt.openScope(CodeGeneratorContext.ActiveScope.DEFINITION);
        ProcModelFuncXperGenerator.addVariables(true, bd, null, ctxt, jClass);
        ProcModelFuncXperGenerator.transBehaviourConstructor(bd, ctxt, jClass);
        JavaMethod runMethod = ProcModelFuncXperGenerator.transBehaviourStatements(bd, ctxt, jClass);
        jClass.addMethod(runMethod);
        ctxt.closeScope();
    }

    public static void addSpecFunctionInstances(JavaClass javaSpec, List<Declaration> decls, CodeGeneratorContext ctxt) {
        JavaMethod jm = new JavaMethod("public " + javaSpec.getClassName() + "(ChiCoordinator chiCoordinator)");
        for (Declaration decl : decls) {
            if (!(decl instanceof FunctionDeclaration)) continue;
            String fnName = ctxt.getDefinition((PositionObject)decl);
            String instName = "instance" + fnName;
            String line = "public final " + fnName + " " + instName + ";";
            javaSpec.addVariable(line);
            line = String.valueOf(instName) + " = new " + fnName + "(this, chiCoordinator);";
            jm.lines.add(line);
        }
        javaSpec.addMethod(jm);
        javaSpec.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
    }

    public static void transFunctionDeclaration(FunctionDeclaration fn, CodeGeneratorContext ctxt) {
        String fnName = ctxt.getDefinition((PositionObject)fn);
        String callText = "";
        for (VariableDeclaration arg : fn.getVariables()) {
            if (!arg.isParameter()) continue;
            if (!callText.isEmpty()) {
                callText = String.valueOf(callText) + ", ";
            }
            callText = String.valueOf(callText) + "p_" + arg.getName();
        }
        TypeID fnTid = TypeIDCreation.createFunctionTypeID(fn, ctxt);
        String baseClass = fnTid.getJavaType();
        JavaClass funcClass = ctxt.addJavaClass(fnName, false, baseClass, null);
        String args = String.valueOf(ctxt.specName) + " spec, ChiCoordinator chiCoordinator";
        JavaMethod jm = new JavaMethod("public " + fnName + "(" + args + ")");
        jm.lines.add("super(spec, chiCoordinator);");
        funcClass.addMethod(jm);
        funcClass.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        TypeID retTid = TypeIDCreation.createTypeID(fn.getReturnType(), ctxt);
        String pTxt = JavaParameter.convertParamsToString(JavaMethod.makeParameters((List<VariableDeclaration>)fn.getVariables(), ctxt));
        String posdata = "org.eclipse.escet.chi.runtime.data.PositionData";
        posdata = posdata.substring(posdata.lastIndexOf(46) + 1);
        pTxt = pTxt.isEmpty() ? "List<" + posdata + "> positionStack" : "List<" + posdata + "> positionStack, " + pTxt;
        jm = new JavaMethod("public " + retTid.getJavaType() + " compute(" + pTxt + ")");
        funcClass.addImport("java.util.List", false);
        funcClass.addImport("org.eclipse.escet.chi.runtime.data.PositionData", false);
        ctxt.startNewDeclaration();
        ctxt.openScope(CodeGeneratorContext.ActiveScope.DEFINITION);
        ProcModelFuncXperGenerator.addVariables(false, (BehaviourDeclaration)fn, jm, ctxt, funcClass);
        String posDefKind = "org.eclipse.escet.chi.runtime.data.DefinitionKind";
        funcClass.addImport(posDefKind, false);
        int idx = posDefKind.lastIndexOf(46);
        posDefKind = String.valueOf(posDefKind.substring(idx + 1)) + ".FUNCTION";
        jm.lines.add(Strings.fmt((String)"%s position = new %s(%s, \"%s\");", (Object[])new Object[]{posdata, posdata, posDefKind, fn.getName()}));
        jm.lines.add("if (positionStack != null) positionStack.add(position);");
        jm.lines.add();
        List<Seq> seqs = Seq.convertVarInitialization((BehaviourDeclaration)fn, ctxt, funcClass);
        seqs.addAll(Seq.convertStatements((List<Statement>)fn.getStatements(), ctxt, funcClass));
        List lines = Lists.list();
        lines.add(OutputPosition.genCurrentPositionStatement((PositionObject)fn));
        lines.add(Strings.fmt((String)"throw new ChiSimulatorException(\"Reached the end of function \\\"%s\\\" without returning a value.\");", (Object[])new Object[]{fn.getName()}));
        funcClass.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        SeqCode sc = new SeqCode(lines, (PositionObject)fn);
        seqs.add(sc);
        ctxt.closeScope();
        ctxt.stopNewDeclaration();
        for (Seq seq : seqs) {
            jm.lines.add(seq.boxify());
        }
        funcClass.addMethod(jm);
    }

    private static void addVariables(boolean declParms, BehaviourDeclaration bd, JavaMethod jm, CodeGeneratorContext ctxt, JavaClass currentClass) {
        List localVars = Lists.list();
        for (VariableDeclaration vd : bd.getVariables()) {
            localVars.add(vd);
        }
        List<PositionObject> iterVars = Seq.getIteratorVariables((List<Statement>)bd.getStatements());
        VBox b = jm == null ? null : new VBox();
        Set names = Sets.set();
        boolean added = false;
        added |= ProcModelFuncXperGenerator.transBehaviourVariables(declParms, names, localVars, b, ctxt, currentClass);
        if (jm != null && (added |= ProcModelFuncXperGenerator.transBehaviourVariables(declParms, names, iterVars, b, ctxt, currentClass))) {
            jm.lines.add((Box)b);
        }
    }

    private static boolean transBehaviourVariables(boolean declParms, Set<String> names, List<PositionObject> objects, VBox b, CodeGeneratorContext ctxt, JavaClass currentClass) {
        boolean added = false;
        for (PositionObject obj : objects) {
            String typeText;
            String name;
            VariableDeclaration vd = null;
            if (obj instanceof VariableDeclaration) {
                TypeID tid;
                int idx;
                vd = (VariableDeclaration)obj;
                name = vd.isParameter() ? "p_" : "v_";
                if (names.contains(name = String.valueOf(name) + vd.getName())) {
                    name = ctxt.makeUniqueName(vd.isParameter() ? "p" : "v");
                    Assert.check((!names.contains(name) ? 1 : 0) != 0);
                }
                if ((idx = (typeText = (tid = TypeIDCreation.createTypeID(vd.getType(), ctxt)).getJavaType()).lastIndexOf(46)) != -1 && !typeText.startsWith(ctxt.specName)) {
                    currentClass.addImport(typeText, false);
                    typeText = typeText.substring(idx + 1);
                }
            } else {
                Type sourceType;
                if (obj instanceof ForStatement) {
                    ForStatement fs = (ForStatement)obj;
                    Assert.check((fs.getUnwinds().size() == 1 ? 1 : 0) != 0);
                    Unwind unw = (Unwind)Lists.first((List)fs.getUnwinds());
                    sourceType = TypeIDCreation.dropTypeReferences(unw.getSource().getType());
                } else {
                    Assert.check((boolean)(obj instanceof Unwind));
                    Unwind unw = (Unwind)obj;
                    sourceType = TypeIDCreation.dropTypeReferences(unw.getSource().getType());
                }
                name = ctxt.makeUniqueName("for");
                currentClass.addImport("java.util.Iterator", false);
                TypeID tid = ForLoopConversion.getElementType(sourceType, ctxt);
                typeText = tid.getJavaClassType();
                int idx = typeText.lastIndexOf(46);
                if (idx != -1 && !typeText.startsWith(ctxt.specName)) {
                    currentClass.addImport(typeText, false);
                    typeText = typeText.substring(idx + 1);
                }
                typeText = "Iterator<" + typeText + ">";
            }
            names.add(name);
            ctxt.addDefinition(obj, name);
            if (vd != null && vd.isParameter() && !declParms) continue;
            String varText = String.valueOf(typeText) + " " + name + "; // " + PositionUtils.pos2str((PositionObject)obj);
            if (b != null) {
                b.add(varText);
                added = true;
                continue;
            }
            currentClass.addVariable("public " + varText);
        }
        return added;
    }

    private static void transBehaviourConstructor(BehaviourDeclaration bd, CodeGeneratorContext ctxt, JavaFile currentClass) {
        String line;
        String argText = String.valueOf(ctxt.specName) + " spec, ChiCoordinator chiCoordinator";
        currentClass.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        for (VariableDeclaration vd : bd.getVariables()) {
            if (!vd.isParameter()) continue;
            String name = ctxt.getDefinition((PositionObject)vd);
            TypeID tid = TypeIDCreation.createTypeID(vd.getType(), ctxt);
            argText = String.valueOf(argText) + ", " + tid.getJavaType() + " " + name;
        }
        JavaMethod method = new JavaMethod("public", null, currentClass.getClassName(), argText, null);
        String posDefKind = "org.eclipse.escet.chi.runtime.data.DefinitionKind";
        currentClass.addImport(posDefKind, false);
        int idx = posDefKind.lastIndexOf(46);
        if (bd instanceof XperDeclaration) {
            line = String.valueOf(posDefKind.substring(idx + 1)) + ".XPER";
        } else if (bd instanceof ModelDeclaration) {
            line = String.valueOf(posDefKind.substring(idx + 1)) + ".MODEL";
        } else if (bd instanceof ProcessDeclaration) {
            line = String.valueOf(posDefKind.substring(idx + 1)) + ".PROCESS";
        } else {
            Assert.fail((Object)"Encountered unexpected kind of behaviour kind");
            line = "FAIL";
        }
        method.lines.add("super(chiCoordinator, %s, \"%s\");", new Object[]{line, bd.getName()});
        method.lines.add("this.spec = spec;");
        for (VariableDeclaration vd : bd.getVariables()) {
            if (!vd.isParameter()) continue;
            String name = ctxt.getDefinition((PositionObject)vd);
            method.lines.add(Strings.fmt((String)"this.%s = %s;", (Object[])new Object[]{name, name}));
        }
        currentClass.addMethod(method);
    }

    public static Box addStartup(BehaviourDeclaration bd, JavaFile javaSpec, CodeGeneratorContext ctxt) {
        String name = bd.getName();
        String handle = "handle";
        VBox vb = new VBox();
        vb.add("if (readStartupPrefix(handle, \"" + name + "\")) {");
        VBox vc = new VBox(4);
        int n = 1;
        String actParms = "";
        for (VariableDeclaration vd : bd.getVariables()) {
            if (!vd.isParameter()) continue;
            if (n != 1) {
                vc.add("readValueSeparator(handle);");
            }
            TypeID tid = TypeIDCreation.createTypeID(vd.getType(), ctxt);
            String line = Strings.fmt((String)"%s x%d = %s;", (Object[])new Object[]{tid.getJavaType(), n, tid.getReadName("handle", javaSpec)});
            vc.add(line);
            actParms = String.valueOf(actParms) + Strings.fmt((String)", x%d", (Object[])new Object[]{n});
            ++n;
        }
        vc.add("readStartupSuffix(handle);");
        String line = Strings.fmt((String)"return new %s(this, chiCoordinator%s);", (Object[])new Object[]{ctxt.getDefinition((PositionObject)bd), actParms});
        vc.add(line);
        vb.add((Box)vc);
        vb.add("}");
        return vb;
    }

    public static Box addStartupDescription(BehaviourDeclaration bd, JavaFile javaSpec, CodeGeneratorContext ctxt) {
        List parms = Lists.list();
        for (VariableDeclaration vd : bd.getVariables()) {
            if (!vd.isParameter()) continue;
            TypeID tid = TypeIDCreation.createTypeID(vd.getType(), ctxt);
            String fpText = Strings.fmt((String)"new ParameterDescription(\"%s\", \"%s\")", (Object[])new Object[]{tid.getTypeText(), vd.getName()});
            parms.add(fpText);
        }
        String pd = "new ParameterDescription[] {";
        boolean first = true;
        for (String fp : parms) {
            if (!first) {
                pd = String.valueOf(pd) + ", ";
            }
            first = false;
            pd = String.valueOf(pd) + fp;
        }
        pd = String.valueOf(pd) + "}";
        String line = "new StartupDescription(\"" + bd.getName() + "\", ";
        line = String.valueOf(line) + (bd instanceof ModelDeclaration ? "true, " : "false, ");
        line = String.valueOf(line) + pd + "), ";
        TextBox b = new TextBox(line);
        return b;
    }

    private static JavaMethod transBehaviourStatements(BehaviourDeclaration bd, CodeGeneratorContext ctxt, JavaFile currentClass) {
        JavaMethod jrm = new JavaMethod("public", "RunResult", "run", "SelectChoice chiChoice", "ChiSimulatorException");
        currentClass.addImport("org.eclipse.escet.chi.runtime.SelectChoice", false);
        currentClass.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        ctxt.startNewDeclaration();
        List<Seq> seqs = Seq.convertVarInitialization(bd, ctxt, currentClass);
        seqs.addAll(Seq.convertStatements((List<Statement>)bd.getStatements(), ctxt, currentClass));
        ctxt.stopNewDeclaration();
        SwitchCases sc = new SwitchCases();
        sc.convertBody(seqs, bd);
        currentClass.addImports(sc.getNeededImport());
        jrm.lines.add(sc.boxify());
        return jrm;
    }
}

