/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.Constants;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.PrimitiveTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.BoolLiteral;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.UnaryExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class BooleanTypeID
extends PrimitiveTypeID {
    public BooleanTypeID() {
        super(TypeID.TypeKind.BOOL);
    }

    @Override
    public String getTypeText() {
        return "bool";
    }

    @Override
    public String getJavaType() {
        return "boolean";
    }

    @Override
    public String getJavaClassType() {
        return "Boolean";
    }

    @Override
    public String getStaticReadFuncName() {
        return "org.eclipse.escet.chi.runtime.IoFunctions.readBool";
    }

    @Override
    public String getWriteName(String stream, String val, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        jf.addImport("org.eclipse.escet.chi.runtime.IoFunctions.writeBool", true);
        return Strings.fmt((String)"%s(%s, %s);", (Object[])new Object[]{Constants.getClassname("org.eclipse.escet.chi.runtime.IoFunctions.writeBool"), stream, val});
    }

    @Override
    public String getToString(String val, JavaFile jf) {
        return Strings.fmt((String)"String.valueOf(%s)", (Object[])new Object[]{val});
    }

    @Override
    public String getHashCodeName(String val, JavaFile jf) {
        return "(" + val + ") ? 0 : 1";
    }

    @Override
    public String getEqual(String lhs, String rhs) {
        return this.generateEqual(lhs, rhs, true);
    }

    @Override
    public String getUnequal(String lhs, String rhs) {
        return this.generateEqual(lhs, rhs, false);
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        return "false";
    }

    @Override
    public String getSimplestJavaValue() {
        return "false";
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile javaFile) {
        if (expr instanceof BoolLiteral) {
            BoolLiteral bl = (BoolLiteral)expr;
            String text = bl.isValue() ? "true" : "false";
            return new SimpleExpression(text, (PositionObject)expr);
        }
        if (expr instanceof BinaryExpression) {
            String text;
            BinaryExpression binexpr = (BinaryExpression)expr;
            ExpressionBase left = ExpressionBase.convertExpression(binexpr.getLeft(), ctxt, javaFile);
            ExpressionBase right = ExpressionBase.convertExpression(binexpr.getRight(), ctxt, javaFile);
            switch (binexpr.getOp()) {
                case CONJUNCTION: {
                    text = Strings.fmt((String)"(%s) && (%s)", (Object[])new Object[]{left.getValue(), right.getValue()});
                    break;
                }
                case DISJUNCTION: {
                    text = Strings.fmt((String)"(%s) || (%s)", (Object[])new Object[]{left.getValue(), right.getValue()});
                    break;
                }
                case EQUAL: {
                    return this.equalityCompare(binexpr, left, right, true, ctxt);
                }
                case NOT_EQUAL: {
                    return this.equalityCompare(binexpr, left, right, false, ctxt);
                }
                case GREATER_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    return this.orderedCompare(binexpr, left, right, ctxt);
                }
                default: {
                    Assert.fail((Object)("Unexpected binary operator " + binexpr.getOp().toString() + " in BooleanTypeID.convertExprNode"));
                    return null;
                }
            }
            if (!left.getCode().isEmpty() || !right.getCode().isEmpty()) {
                List lines = Lists.list();
                lines.addAll(left.getCode());
                lines.addAll(right.getCode());
                return new CodeExpression(lines, text, (PositionObject)expr);
            }
            return new SimpleExpression(text, (PositionObject)expr);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unexpr = (UnaryExpression)expr;
            ExpressionBase child = ExpressionBase.convertExpression(unexpr.getChild(), ctxt, javaFile);
            switch (unexpr.getOp()) {
                case INVERSE: {
                    return ExpressionBase.makeExpression(child.getCode(), "!(" + child.getValue() + ")", (PositionObject)expr);
                }
            }
            Assert.fail((Object)("Unexpected unary operator " + unexpr.getOp().toString() + " in BooleanTypeID.convertExprNode"));
            return null;
        }
        Assert.fail((Object)("Unexpected expression in convertExprNode(" + expr.toString() + "): kind=" + this.kind.toString()));
        return null;
    }

    private ExpressionBase equalityCompare(BinaryExpression binexpr, ExpressionBase trLeft, ExpressionBase trRight, boolean isEqual, CodeGeneratorContext ctxt) {
        TypeID leftTid = TypeIDCreation.createTypeID(binexpr.getLeft().getType(), ctxt);
        String text = isEqual ? leftTid.getEqual(trLeft.getValue(), trRight.getValue()) : leftTid.getUnequal(trLeft.getValue(), trRight.getValue());
        if (!trLeft.getCode().isEmpty() || !trRight.getCode().isEmpty()) {
            List lines = Lists.list();
            lines.addAll(trLeft.getCode());
            lines.addAll(trRight.getCode());
            return new CodeExpression(lines, text, (PositionObject)binexpr);
        }
        return new SimpleExpression(text, (PositionObject)binexpr);
    }

    private ExpressionBase orderedCompare(BinaryExpression binexpr, ExpressionBase trLeft, ExpressionBase trRight, CodeGeneratorContext ctxt) {
        String text;
        switch (binexpr.getOp()) {
            case LESS_THAN: {
                text = "<";
                break;
            }
            case LESS_EQUAL: {
                text = "<=";
                break;
            }
            case GREATER_THAN: {
                text = ">";
                break;
            }
            case GREATER_EQUAL: {
                text = ">=";
                break;
            }
            default: {
                Assert.fail();
                text = "???";
            }
        }
        TypeID leftTid = TypeIDCreation.createTypeID(binexpr.getLeft().getType(), ctxt);
        text = leftTid.kind == TypeID.TypeKind.STRING ? Strings.fmt((String)"(%s).compareTo(%s) %s 0", (Object[])new Object[]{trLeft.getValue(), trRight.getValue(), text}) : Strings.fmt((String)"(%s) %s (%s)", (Object[])new Object[]{trLeft.getValue(), text, trRight.getValue()});
        if (!trLeft.getCode().isEmpty() || !trRight.getCode().isEmpty()) {
            List lines = Lists.list();
            lines.addAll(trLeft.getCode());
            lines.addAll(trRight.getCode());
            return new CodeExpression(lines, text, (PositionObject)binexpr);
        }
        return new SimpleExpression(text, (PositionObject)binexpr);
    }

    private String generateSimpleEquality(String lhs, String rhs, boolean equal) {
        if (lhs.equals("true")) {
            if (equal) {
                return rhs;
            }
            return Strings.fmt((String)"!(%s)", (Object[])new Object[]{rhs});
        }
        if (lhs.equals("false")) {
            if (equal) {
                return Strings.fmt((String)"!(%s)", (Object[])new Object[]{rhs});
            }
            return rhs;
        }
        return null;
    }

    public String generateEqual(String lhs, String rhs, boolean equal) {
        String line = this.generateSimpleEquality(lhs, rhs, equal);
        if (line != null) {
            return line;
        }
        line = this.generateSimpleEquality(rhs, lhs, equal);
        if (line != null) {
            return line;
        }
        line = equal ? Strings.fmt((String)"(%s) == (%s)", (Object[])new Object[]{lhs, rhs}) : Strings.fmt((String)"(%s) != (%s)", (Object[])new Object[]{lhs, rhs});
        return line;
    }
}

