/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.expressions.SimpleExpression;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.StateLessObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessReference;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ProcessTypeID
extends StateLessObjectTypeID {
    private final String className;

    public ProcessTypeID(List<TypeID> args, CodeGeneratorContext ctxt) {
        super(false, TypeID.TypeKind.PROCESS, args);
        if (!ctxt.hasTypeName(this)) {
            this.className = ctxt.makeUniqueName("ProcessType");
            ctxt.addTypeName(this, this.className);
            ctxt.addProcessType(this);
        } else {
            this.className = ctxt.getTypeName(this);
        }
    }

    @Override
    public String getTypeText() {
        boolean first = true;
        String result = "proc (";
        for (TypeID tid : this.subTypes) {
            if (!first) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + tid.getTypeText();
            first = false;
        }
        return String.valueOf(result) + ")";
    }

    @Override
    public String getJavaClassType() {
        return this.className;
    }

    @Override
    public String getSimplestJavaValue() {
        return String.valueOf(this.getJavaClassType()) + ".PP_NONE";
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        if (expr instanceof ProcessReference) {
            ProcessDeclaration pd = ((ProcessReference)expr).getProcess();
            String pName = String.valueOf(this.className) + ".P_" + pd.getName();
            return new SimpleExpression(pName, (PositionObject)expr);
        }
        Assert.fail((Object)("Unexpected expression in convertExprNode(" + expr.toString() + "): kind=" + this.kind.toString()));
        return null;
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        return String.valueOf(this.getJavaClassType()) + ".PP_NONE";
    }
}

