/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.confluence;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.controllercheck.CheckConclusion;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Pair;

public class ConfluenceCheckConclusion
implements CheckConclusion {
    private final List<Pair<String, String>> cannotProvePairs;

    public ConfluenceCheckConclusion(List<Pair<String, String>> cannotProvePairs) {
        this.cannotProvePairs = cannotProvePairs;
    }

    @Override
    public boolean propertyHolds() {
        return this.cannotProvePairs.isEmpty();
    }

    @Override
    public void printDetails() {
        if (this.cannotProvePairs.isEmpty()) {
            OutputProvider.out((String)"[OK] The specification has confluence.");
        } else {
            OutputProvider.out((String)"[ERROR] The specification may NOT have confluence.");
            OutputProvider.out();
            OutputProvider.iout();
            String pairText = this.cannotProvePairs.size() == 1 ? "pair" : "pairs";
            OutputProvider.out((String)"Confluence of the following event %s could not be decided:", (Object[])new Object[]{pairText});
            OutputProvider.iout();
            OutputProvider.out((String)this.cannotProvePairs.stream().map(Pair::toString).collect(Collectors.joining(", ")));
            OutputProvider.dout();
            OutputProvider.dout();
        }
    }
}

