/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.finiteresponse;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.controllercheck.finiteresponse.EventLoop;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class EventLoopSearch {
    private EventLoopSearch() {
    }

    public static Set<EventLoop> searchEventLoops(Automaton aut, Set<Event> loopEvents, AppEnvData env) {
        List stack = Lists.listc((int)(aut.getLocations().size() + 1));
        Map stackIndex = Maps.mapc((int)aut.getLocations().size());
        Set visitedLocations = Sets.setc((int)aut.getLocations().size());
        Set eventLoops = Sets.set();
        for (Location loc : aut.getLocations()) {
            if (visitedLocations.contains(loc)) continue;
            EventLoopSearch.searchEventLoops(loc, loopEvents, stackIndex, stack, eventLoops, visitedLocations, env);
            if (!env.isTerminationRequested()) continue;
            return null;
        }
        return eventLoops;
    }

    private static void searchEventLoops(Location rootLoc, Set<Event> loopEvents, Map<Location, Integer> stackIndex, List<Event> stack, Set<EventLoop> eventLoops, Set<Location> visitedLocations, AppEnvData env) {
        if (env.isTerminationRequested()) {
            return;
        }
        visitedLocations.add(rootLoc);
        stackIndex.put(rootLoc, stack.size());
        for (Edge edge : rootLoc.getEdges()) {
            if (Sets.isEmptyIntersection(loopEvents, (Set)CifEventUtils.getEvents((Edge)edge))) continue;
            Location edgeTargetLoc = CifEdgeUtils.getTarget((Edge)edge);
            Integer loopStartIndex = stackIndex.get(edgeTargetLoc);
            for (Event event : CifEventUtils.getEvents((Edge)edge)) {
                if (!loopEvents.contains(event)) continue;
                if (loopStartIndex == null) {
                    stack.add(event);
                    EventLoopSearch.searchEventLoops(edgeTargetLoc, loopEvents, stackIndex, stack, eventLoops, visitedLocations, env);
                    stack.remove(stack.size() - 1);
                } else {
                    stack.add(event);
                    eventLoops.add(EventLoopSearch.retrieveLoopFromStack(loopStartIndex, stack));
                    stack.remove(stack.size() - 1);
                }
                if (!env.isTerminationRequested()) continue;
                return;
            }
        }
        stackIndex.remove(rootLoc);
    }

    private static EventLoop retrieveLoopFromStack(Integer fromIndex, List<Event> stack) {
        List events = Lists.listc((int)(stack.size() - fromIndex));
        events.addAll(stack.subList(fromIndex, stack.size()));
        return new EventLoop(events);
    }
}

