/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.finiteresponse;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.options.PrintControlLoopsOutputOption;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FiniteResponseCheckConclusion
implements CheckConclusion {
    private final List<Event> unprovenEvents;

    public FiniteResponseCheckConclusion(List<Event> orderedEvents) {
        this.unprovenEvents = orderedEvents;
    }

    @Override
    public boolean propertyHolds() {
        return this.unprovenEvents.isEmpty();
    }

    @Override
    public void printDetails() {
        if (this.unprovenEvents.isEmpty()) {
            OutputProvider.out((String)"[OK] The specification has finite response.");
        } else {
            OutputProvider.out((String)"[ERROR] The specification may NOT have finite response.");
            OutputProvider.out();
            OutputProvider.iout();
            OutputProvider.out((String)"At least one controllable-event loop was found.");
            if (PrintControlLoopsOutputOption.isPrintControlLoopsEnabled()) {
                OutputProvider.out((String)"The following events might still occur in a controllable-event loop:");
                OutputProvider.iout();
                for (Event event : this.unprovenEvents) {
                    OutputProvider.out((String)"- %s", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                }
                OutputProvider.dout();
            }
            OutputProvider.dout();
        }
    }
}

