/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventdisabler;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValidationUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.eventdisabler.options.EventNamesFileOption;
import org.eclipse.escet.cif.eventdisabler.options.EventNamesOption;
import org.eclipse.escet.cif.eventdisabler.options.EventUsage;
import org.eclipse.escet.cif.eventdisabler.options.EventUsageOption;
import org.eclipse.escet.cif.eventdisabler.options.IncludeInputSpecOption;
import org.eclipse.escet.cif.eventdisabler.options.SvgInputEventsOption;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EventDisabler {
    private final Specification inputSpec;
    private final Set<String> eventNames;
    private final Set<Event> alphabet;
    private final Map<String, Event> eventMap;
    private final Specification resultSpec;

    private EventDisabler(Specification inputSpec) {
        this.inputSpec = inputSpec;
        this.eventNames = EventDisabler.getEventNames(inputSpec);
        this.checkEventNames();
        this.alphabet = Sets.set();
        this.eventMap = Maps.map();
        this.collectEvents((ComplexComponent)inputSpec);
        this.resultSpec = this.getResultSpec();
    }

    public static Specification disableEvents(Specification inputSpec) {
        EventDisabler disabler = new EventDisabler(inputSpec);
        List<Event> eventsToDisable = disabler.getEventsToDisable();
        disabler.addAutomaton(eventsToDisable);
        return disabler.resultSpec;
    }

    private static Set<String> getEventNames(Specification spec) {
        String eventNames = EventNamesOption.getEventNames();
        String eventFile = EventNamesFileOption.getFilePath();
        boolean useSvgInput = SvgInputEventsOption.isEnabled();
        if (eventNames == null && eventFile == null && !useSvgInput) {
            String msg = "No events specified. Use one of the options to specify events.";
            throw new InvalidOptionException(msg);
        }
        Set rslt = Sets.set();
        if (eventNames != null) {
            String[] stringArray = StringUtils.split((String)eventNames, (String)", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String eventName = stringArray[n2];
                rslt.add(eventName);
                ++n2;
            }
        }
        if (eventFile != null) {
            List lines;
            String path = Paths.resolve((String)eventFile);
            try {
                InputStream stream = new FileInputStream(path);
                stream = new BufferedInputStream(stream);
                lines = IOUtils.readLines((InputStream)stream, (String)"UTF-8");
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to read \"%s\".", (Object[])new Object[]{eventFile});
                throw new InputOutputException(msg, (Throwable)e);
            }
            for (String line : lines) {
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
                rslt.add(trimmedLine);
            }
        }
        if (useSvgInput) {
            EventDisabler.collectSvgInputEventNames((ComplexComponent)spec, rslt);
        }
        return rslt;
    }

    private static void collectSvgInputEventNames(ComplexComponent comp, Set<String> names) {
        for (IoDecl decl : comp.getIoDecls()) {
            if (!(decl instanceof SvgIn)) continue;
            SvgInEvent svgInEvt = ((SvgIn)decl).getEvent();
            if (svgInEvt instanceof SvgInEventSingle) {
                Expression evtRef = ((SvgInEventSingle)svgInEvt).getEvent();
                Event evt = ((EventExpression)evtRef).getEvent();
                names.add(CifTextUtils.getAbsName((PositionObject)evt, (boolean)false));
                continue;
            }
            Assert.check((boolean)(svgInEvt instanceof SvgInEventIf));
            for (SvgInEventIfEntry entry : ((SvgInEventIf)svgInEvt).getEntries()) {
                Expression evtRef = entry.getEvent();
                Event evt = ((EventExpression)evtRef).getEvent();
                names.add(CifTextUtils.getAbsName((PositionObject)evt, (boolean)false));
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                EventDisabler.collectSvgInputEventNames((ComplexComponent)child, names);
            }
        }
    }

    private void checkEventNames() {
        for (String eventName : this.eventNames) {
            if (CifValidationUtils.isValidName((String)eventName)) continue;
            String msg = Strings.fmt((String)"Event name \"%s\" is not a valid absolute name for a CIF event.", (Object[])new Object[]{eventName});
            throw new InvalidInputException(msg);
        }
    }

    private void collectEvents(ComplexComponent comp) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            this.eventMap.put(CifTextUtils.getAbsName((PositionObject)decl, (boolean)false), (Event)decl);
        }
        if (comp instanceof Automaton) {
            this.alphabet.addAll(CifEventUtils.getAlphabet((Automaton)((Automaton)comp)));
            return;
        }
        for (Component child : ((Group)comp).getComponents()) {
            this.collectEvents((ComplexComponent)child);
        }
    }

    private Specification getResultSpec() {
        return IncludeInputSpecOption.includeInputSpec() ? this.inputSpec : CifConstructors.newSpecification();
    }

    private List<Event> getEventsToDisable() {
        EventUsage usage = EventUsageOption.getUsage();
        List rslt = Lists.list();
        switch (usage) {
            case DISABLE: {
                for (String eventName : this.eventNames) {
                    rslt.add(this.getEventToDisable(eventName));
                }
                break;
            }
            case ALPHABET: {
                for (String eventName : this.eventNames) {
                    Event event = this.eventMap.get(eventName);
                    if (event == null) {
                        rslt.add(this.getEventToDisable(eventName));
                        continue;
                    }
                    if (this.alphabet.contains(event)) continue;
                    rslt.add(this.getEventToDisable(eventName));
                }
                break;
            }
        }
        return rslt;
    }

    private Event getEventToDisable(String absName) {
        String msg;
        Event origEvent = this.eventMap.get(absName);
        if (this.inputSpec == this.resultSpec && origEvent != null) {
            return origEvent;
        }
        String[] names = StringUtils.split((String)absName, (char)'.');
        Specification scope = this.resultSpec;
        int i = 0;
        while (i < names.length - 1) {
            block12: {
                String name = names[i];
                for (Declaration decl : scope.getDeclarations()) {
                    if (!decl.getName().equals(name)) continue;
                    String msg2 = Strings.fmt((String)"Can't disable event \"%s\": \"%s\" is not a component.", (Object[])new Object[]{absName, Arrays.stream(names).limit(i + 1).collect(Collectors.joining("."))});
                    throw new InvalidInputException(msg2);
                }
                if (scope instanceof Automaton) {
                    String msg3 = Strings.fmt((String)"Can't disable event \"%s\": \"%s\" is an automaton.", (Object[])new Object[]{absName, Arrays.stream(names).limit(i).collect(Collectors.joining("."))});
                    throw new InvalidInputException(msg3);
                }
                Iterator scopeGroup = (Group)scope;
                for (Component child : scopeGroup.getComponents()) {
                    if (!child.getName().equals(name)) continue;
                    scope = (ComplexComponent)child;
                    break block12;
                }
                Group newChildGroup = CifConstructors.newGroup();
                newChildGroup.setName(name);
                scopeGroup.getComponents().add((Object)newChildGroup);
                scope = newChildGroup;
            }
            ++i;
        }
        String name = names[names.length - 1];
        for (Declaration decl : scope.getDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            Assert.check((!(decl instanceof Event) ? 1 : 0) != 0);
            msg = Strings.fmt((String)"Can't disable event \"%s\": \"%s\" exists, but is not an event.", (Object[])new Object[]{absName, absName});
            throw new InvalidInputException(msg);
        }
        if (scope instanceof Group) {
            for (Component child : ((Group)scope).getComponents()) {
                if (!child.getName().equals(name)) continue;
                msg = Strings.fmt((String)"Can't disable event \"%s\": \"%s\" exists, but is a component.", (Object[])new Object[]{absName, absName});
                throw new InvalidInputException(msg);
            }
        }
        Event rslt = CifConstructors.newEvent();
        rslt.setName(name);
        scope.getDeclarations().add((Object)rslt);
        Boolean ctrl = null;
        if (origEvent != null) {
            ctrl = origEvent.getControllable();
        } else {
            if (name.startsWith("c_")) {
                ctrl = true;
            }
            if (name.startsWith("u_")) {
                ctrl = false;
            }
        }
        rslt.setControllable(ctrl);
        return rslt;
    }

    private void addAutomaton(List<Event> eventsToDisable) {
        String autName;
        if (eventsToDisable.isEmpty()) {
            return;
        }
        Automaton aut = CifConstructors.newAutomaton();
        Alphabet autAlphabet = CifConstructors.newAlphabet();
        aut.setAlphabet(autAlphabet);
        for (Event event : eventsToDisable) {
            EventExpression eventRef = CifConstructors.newEventExpression();
            eventRef.setEvent(event);
            eventRef.setType((CifType)CifConstructors.newBoolType());
            autAlphabet.getEvents().add((Object)eventRef);
        }
        Location loc = CifConstructors.newLocation();
        loc.getInitials().add((Object)CifValueUtils.makeTrue());
        aut.getLocations().add((Object)loc);
        Edge edge = CifConstructors.newEdge();
        loc.getEdges().add((Object)edge);
        edge.getGuards().add((Object)CifValueUtils.makeFalse());
        for (Event event : eventsToDisable) {
            EventExpression eventRef = CifConstructors.newEventExpression();
            eventRef.setEvent(event);
            eventRef.setType((CifType)CifConstructors.newBoolType());
            EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
            edgeEvent.setEvent((Expression)eventRef);
            edge.getEvents().add((Object)edgeEvent);
        }
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)this.resultSpec, null);
        if (names.contains(autName = "event_disabler")) {
            autName = CifScopeUtils.getUniqueName((String)autName, (Set)names, Collections.emptySet());
        }
        aut.setName(autName);
        this.resultSpec.getComponents().add((Object)aut);
    }
}

