/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.escet.common.java.Strings;

public abstract class AppStream
implements Closeable {
    private final Charset charset = Charset.forName("UTF-8");
    private boolean convertNewLines = true;
    private byte[] newline = Strings.NL.getBytes(this.charset);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConvertNewLines(boolean convertNewLines) {
        AppStream appStream = this;
        synchronized (appStream) {
            this.convertNewLines = convertNewLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConvertNewLines() {
        AppStream appStream = this;
        synchronized (appStream) {
            return this.convertNewLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewLineBytes(byte[] bytes) {
        AppStream appStream = this;
        synchronized (appStream) {
            this.newline = bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinuxNewLineBytes() {
        AppStream appStream = this;
        synchronized (appStream) {
            this.newline = new byte[]{10};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowsNewLineBytes() {
        AppStream appStream = this;
        synchronized (appStream) {
            this.newline = new byte[]{13, 10};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNewLineBytes() {
        AppStream appStream = this;
        synchronized (appStream) {
            return this.newline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        AppStream appStream = this;
        synchronized (appStream) {
            this.writeInternal(bytes);
        }
    }

    private void writeInternal(byte[] bytes) {
        int curIdx = 0;
        while (curIdx < bytes.length) {
            int nlIdx = ArrayUtils.indexOf((byte[])bytes, (byte)10, (int)curIdx);
            if (nlIdx == -1) {
                this.writeImpl(bytes, curIdx, bytes.length - curIdx);
                break;
            }
            this.writeImpl(bytes, curIdx, nlIdx - curIdx);
            if (this.convertNewLines) {
                this.newLineInternal();
            } else {
                this.writeImpl((byte)10);
                this.flushInternal();
            }
            curIdx = nlIdx + 1;
        }
    }

    protected abstract void writeImpl(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte b) {
        AppStream appStream = this;
        synchronized (appStream) {
            this.writeInternal(b);
        }
    }

    private void writeInternal(byte b) {
        if (b == 10) {
            if (this.convertNewLines) {
                this.newLineInternal();
            } else {
                this.writeImpl(b);
                this.flushInternal();
            }
        } else {
            this.writeImpl(b);
        }
    }

    protected abstract void writeImpl(byte var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine() {
        AppStream appStream = this;
        synchronized (appStream) {
            this.newLineInternal();
        }
    }

    private void newLineInternal() {
        this.writeImpl(this.newline, 0, this.newline.length);
        this.flushInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        AppStream appStream = this;
        synchronized (appStream) {
            this.flushInternal();
        }
    }

    private void flushInternal() {
        this.flushImpl();
    }

    protected abstract void flushImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AppStream appStream = this;
        synchronized (appStream) {
            this.closeInternal();
        }
    }

    private void closeInternal() {
        this.flushInternal();
        this.closeImpl();
    }

    protected abstract void closeImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String s) {
        AppStream appStream = this;
        synchronized (appStream) {
            this.printInternal(s);
        }
    }

    public void printf(String s, Object ... args) {
        this.print(Strings.fmt((String)s, (Object[])args));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) {
        AppStream appStream = this;
        synchronized (appStream) {
            this.printInternal(s);
            this.newLineInternal();
        }
    }

    public void printfln(String s, Object ... args) {
        this.println(Strings.fmt((String)s, (Object[])args));
    }

    private void printInternal(String s) {
        byte[] bytes = s.getBytes(this.charset);
        this.writeInternal(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable ex) {
        AppStream appStream = this;
        synchronized (appStream) {
            this.printStackTraceInternal(ex);
        }
    }

    public void printStackTraceInternal(Throwable ex) {
        boolean oldConvertNewLines = this.convertNewLines;
        this.convertNewLines = false;
        PrintStream printer = this.asPrintStream();
        ex.printStackTrace(printer);
        printer.flush();
        this.convertNewLines = oldConvertNewLines;
    }

    public OutputStream asOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                AppStream.this.write((byte)b);
            }
        };
    }

    public PrintStream asPrintStream() {
        try {
            return new PrintStream(this.asOutputStream(), true, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Writer asWriter() {
        return new OutputStreamWriter(this.asOutputStream(), this.charset);
    }
}

