/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options.processing;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class PatternMatchingOptionProcessing {
    private static final Pattern FILTER_PATTERN = Pattern.compile("[a-zA-Z0-9_*][a-zA-Z0-9_*]*(\\.[a-zA-Z0-9_*][a-zA-Z0-9_*]*)*");

    private PatternMatchingOptionProcessing() {
    }

    public static OptionMatcher makeMatcher(String optValue, boolean allowWildcard, boolean allowRemove, boolean initiallyAdded) {
        if (optValue == null) {
            optValue = "";
        }
        List optPatterns = Lists.list();
        String[] valuePatterns = StringUtils.split((String)optValue, (String)",");
        int i = 0;
        while (i < valuePatterns.length) {
            boolean addMatch;
            String originalText = valuePatterns[i].trim();
            boolean hasAdd = allowRemove && originalText.charAt(0) == '+';
            boolean hasRemove = allowRemove && originalText.charAt(0) == '-';
            String patternText = hasAdd || hasRemove ? originalText.substring(1) : originalText;
            boolean bl = addMatch = !hasRemove;
            if (!patternText.isEmpty()) {
                String regex;
                boolean hasWildcard;
                boolean bl2 = hasWildcard = allowWildcard && patternText.contains("*");
                if (hasWildcard) {
                    if (!FILTER_PATTERN.matcher(patternText).matches()) {
                        String msg = Strings.fmt((String)"Value actions pattern \"%s\" has invalid syntax.", (Object[])new Object[]{originalText});
                        throw new InvalidOptionException(msg);
                    }
                    regex = "^" + patternText.replace(".", "\\.").replace("*", ".*") + "$";
                } else {
                    regex = null;
                }
                optPatterns.add(new OptionPattern(addMatch, originalText, regex));
            }
            ++i;
        }
        return new OptionMatcher(optPatterns, initiallyAdded);
    }

    public static class OptionMatcher {
        public final List<OptionPattern> patterns;
        public final boolean initiallyAdded;

        public OptionMatcher(List<OptionPattern> patterns, boolean initiallyAdded) {
            this.patterns = patterns;
            this.initiallyAdded = initiallyAdded;
        }

        public boolean matchName(String name, boolean literalMatch) {
            boolean added = this.initiallyAdded;
            for (OptionPattern pat : this.patterns) {
                boolean matchCausesChange;
                if (!pat.isMatch(name, matchCausesChange = added ^ pat.addMatch, literalMatch)) continue;
                added = pat.addMatch;
            }
            return added;
        }

        public List<String> filterNames(List<String> names, boolean literalMatch) {
            List result = Lists.list();
            for (String name : names) {
                if (!this.matchName(name, literalMatch)) continue;
                result.add(name);
            }
            return result;
        }

        public Set<String> filterNormalNames(Set<String> names, boolean literalMatch) {
            Set result = Sets.set();
            for (String name : names) {
                if (!this.matchName(name, literalMatch)) continue;
                result.add(name);
            }
            return result;
        }

        public void reportMatching() {
            for (OptionPattern pat : this.patterns) {
                if (!pat.wasMatched) {
                    String msg = Strings.fmt((String)"Option pattern \"%s\" never matched in the specification.", (Object[])new Object[]{pat.originalText});
                    OutputProvider.warn(msg);
                    continue;
                }
                if (pat.causedChange) continue;
                String reason = pat.addMatch ? "Matches were already added earlier." : "Matches were never added or already removed earlier.";
                String msg = Strings.fmt((String)"Option pattern \"%s\" never made a change to the selection. %s", (Object[])new Object[]{pat.originalText, reason});
                OutputProvider.warn(msg);
            }
        }
    }

    public static class OptionPattern {
        public final boolean addMatch;
        public final String originalText;
        public final Pattern pattern;
        public boolean wasMatched;
        public boolean causedChange;

        public OptionPattern(boolean addMatch, String originalText, String patternText) {
            this.addMatch = addMatch;
            this.originalText = originalText;
            this.pattern = patternText == null ? null : Pattern.compile(patternText);
            this.reset();
        }

        public void reset() {
            this.wasMatched = false;
            this.causedChange = false;
        }

        public boolean isMatch(String name, boolean makesChange, boolean literalMatch) {
            boolean match;
            if (this.pattern == null) {
                match = this.originalText.equals(name);
            } else {
                boolean bl = match = !literalMatch && this.pattern.matcher(name).matches();
            }
            if (match) {
                this.wasMatched = true;
                this.causedChange |= makesChange;
            }
            return match;
        }
    }
}

