/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.BaseProcess;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.common.java.Strings;

public abstract class ChiSpecification {
    public abstract StartupDescription[] getStartups();

    public abstract BaseProcess startStartup(ChiCoordinator var1, String var2);

    public String findDefaultStartupInstance() {
        StartupDescription modelStartup = null;
        boolean incorrectDefaultModel = false;
        StartupDescription xperStartup = null;
        StartupDescription[] startupDescriptionArray = this.getStartups();
        int n = startupDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            StartupDescription md = startupDescriptionArray[n2];
            if (md.parameters.length <= 0) {
                if (md.isModel) {
                    if (modelStartup == null) {
                        modelStartup = md;
                    } else {
                        incorrectDefaultModel = true;
                    }
                } else if (xperStartup == null) {
                    xperStartup = md;
                } else {
                    return null;
                }
            }
            ++n2;
        }
        if (xperStartup != null) {
            return String.valueOf(xperStartup.name) + "()";
        }
        if (!incorrectDefaultModel && modelStartup != null) {
            return String.valueOf(modelStartup.name) + "()";
        }
        return null;
    }

    public static boolean readStartupPrefix(ChiFileHandle handle, String name) {
        handle.resetStream();
        int i = 0;
        while (i < name.length()) {
            if (handle.read() != name.charAt(i)) {
                return false;
            }
            ++i;
        }
        int k = handle.read();
        if (k == 32 || k == 9 || k == 10 || k == 13) {
            k = handle.read();
        }
        return k == 40;
    }

    private static void findCharacter(ChiFileHandle handle, int code) {
        handle.skipWhitespace();
        int k = handle.read();
        if (k == code) {
            return;
        }
        String msg = Strings.fmt((String)"Expected character '%c' at the input, but did not find it.", (Object[])new Object[]{code});
        throw new ChiSimulatorException(msg);
    }

    public static void readValueSeparator(ChiFileHandle handle) {
        ChiSpecification.findCharacter(handle, 44);
    }

    public static void readStartupSuffix(ChiFileHandle handle) {
        ChiSpecification.findCharacter(handle, 41);
    }

    public class ParameterDescription {
        public final String typeText;
        public final String parameterName;

        public ParameterDescription(String typeText, String parameterName) {
            this.typeText = typeText;
            this.parameterName = parameterName;
        }
    }

    public class StartupDescription {
        public final String name;
        public final boolean isModel;
        public final ParameterDescription[] parameters;

        public StartupDescription(String name, boolean isModel, ParameterDescription[] parameters) {
            this.name = name;
            this.isModel = isModel;
            this.parameters = parameters;
        }
    }
}

