/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import org.eclipse.escet.chi.runtime.SvgModification;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.svg.SvgUtils;
import org.eclipse.escet.common.svg.SvgVisualizer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGStylable;

public class SvgAttribModification
extends SvgModification {
    public String attribName;
    public String value;

    @Override
    public void apply(SvgVisualizer svgVis) {
        SVGStylable style;
        Element element = svgVis.getDocument().getElementById(this.nodeName);
        if (element == null) {
            String msg = Strings.fmt((String)"Failed to find SVG element \"%s\".", (Object[])new Object[]{this.nodeName});
            throw new InputOutputException(msg);
        }
        SVGStylable sVGStylable = style = SvgUtils.isCssAttr((Element)element, (String)this.attribName) ? (SVGStylable)element : null;
        if (style == null) {
            element.setAttribute(this.attribName, this.value);
        } else {
            style.getStyle().setProperty(this.attribName, this.value, "");
        }
    }

    public static SvgAttribModification decode(String line, String svgPath) {
        if (!line.startsWith("attr")) {
            return null;
        }
        SvgAttribModification sad = new SvgAttribModification();
        sad.svgPath = svgPath;
        int j = line.indexOf(61);
        if (j < 0) {
            String msg = Strings.fmt((String)"Cannot find \"=\" in attr command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        int i = line.indexOf(46);
        if (i < 0 || i > j) {
            String msg = Strings.fmt((String)"Cannot find \".\" in attr command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        sad.nodeName = SvgAttribModification.getWord(line, 4, i);
        sad.attribName = SvgAttribModification.getWord(line, i + 1, j);
        if (sad.nodeName.isEmpty()) {
            String msg = Strings.fmt((String)"Node name of the attr command \"%s\" is empty.", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        if (sad.attribName.isEmpty()) {
            String msg = Strings.fmt((String)"Attribute name of the attr command \"%s\" is empty.", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        sad.value = SvgAttribModification.getWord(line, j + 1, line.length());
        return sad;
    }
}

