/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class CifEnumUtils {
    private CifEnumUtils() {
    }

    public static Map<EnumDecl, EnumDecl> getEnumDeclReprs(List<EnumDecl> enumDecls) {
        Map commonMap = Maps.map();
        for (EnumDecl enumDecl : enumDecls) {
            EnumDeclEqHashWrap wrap = new EnumDeclEqHashWrap(enumDecl);
            List commonList = (List)commonMap.get(wrap);
            if (commonList == null) {
                commonList = Lists.list((Object)wrap);
                commonMap.put(wrap, commonList);
                continue;
            }
            commonList.add(wrap);
        }
        Map rslt = Maps.map();
        for (Map.Entry elem : commonMap.entrySet()) {
            EnumDeclEqHashWrap representative = (EnumDeclEqHashWrap)elem.getKey();
            List equalEnums = (List)elem.getValue();
            for (EnumDeclEqHashWrap equalEnum : equalEnums) {
                rslt.put(equalEnum.enumDecl, representative.enumDecl);
            }
        }
        return rslt;
    }

    private static class EnumDeclEqHashWrap {
        public final EnumDecl enumDecl;
        public final List<String> literals;
        public final int literalsHash;

        public EnumDeclEqHashWrap(EnumDecl enumDecl) {
            this.enumDecl = enumDecl;
            this.literals = CifTypeUtils.getLiteralNames(enumDecl);
            this.literalsHash = this.literals.hashCode();
        }

        public int hashCode() {
            return this.literalsHash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            EnumDeclEqHashWrap other = (EnumDeclEqHashWrap)obj;
            return this.literals.equals(other.literals);
        }
    }
}

