/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.Objects;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.checkers.messages.CifCheckViolationMessage;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifCheckViolation {
    private final PositionObject providedReportObject;
    private final PositionObject actualReportObject;
    private final CifCheckViolationMessage message;

    public CifCheckViolation(PositionObject cifObject, CifCheckViolationMessage message) {
        this.providedReportObject = cifObject instanceof Specification ? null : cifObject;
        this.actualReportObject = this.providedReportObject == null ? null : CifTextUtils.getNamedSelfOrAncestor(this.providedReportObject);
        Assert.implies((this.actualReportObject != null ? 1 : 0) != 0, (boolean)CifTextUtils.hasName(this.actualReportObject));
        this.message = message;
    }

    public boolean isReportOnSelf() {
        return this.providedReportObject == this.actualReportObject;
    }

    public boolean isReportOnSpecification() {
        return this.actualReportObject == null;
    }

    public PositionObject getReportObject() {
        if (this.actualReportObject == null) {
            throw new IllegalStateException();
        }
        return this.actualReportObject;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CifCheckViolation)) {
            return false;
        }
        CifCheckViolation that = (CifCheckViolation)obj;
        return this.providedReportObject == that.providedReportObject && this.actualReportObject == that.actualReportObject && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(this.providedReportObject, this.actualReportObject, this.message);
    }

    public String toString() {
        String name = this.actualReportObject == null ? "specification" : "\"" + CifTextUtils.getAbsName(this.actualReportObject) + "\"";
        String messageText = this.message.getMessageText(this);
        return Strings.fmt((String)"%s: %s.", (Object[])new Object[]{name, messageText});
    }
}

