/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers.checks;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.checkers.messages.IfReportOnAncestorMessage;
import org.eclipse.escet.cif.common.checkers.messages.LiteralMessage;
import org.eclipse.escet.cif.common.checkers.messages.ReportObjectTypeDescrMessage;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutOnlyWithOneInitLocCheck
extends CifCheck {
    private int initLocCount;

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        this.initLocCount = 0;
    }

    protected void postprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        if (this.initLocCount == 0) {
            violations.add((PositionObject)aut, new ReportObjectTypeDescrMessage(), new LiteralMessage("has no initial location", new Object[0]));
        } else if (this.initLocCount > 1) {
            violations.add((PositionObject)aut, new ReportObjectTypeDescrMessage(), new LiteralMessage("has multiple (%,d) initial locations", this.initLocCount));
        }
    }

    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        EObject parent = loc.eContainer();
        if (parent instanceof LocationParameter) {
            return;
        }
        boolean initial = false;
        String errMsg = null;
        try {
            initial = loc.getInitials().isEmpty() ? false : CifEvalUtils.evalPreds((List<Expression>)loc.getInitials(), true, true);
        }
        catch (UnsupportedException e) {
            errMsg = "as one of its initialization predicates cannot be statically evaluated";
        }
        catch (CifEvalException e) {
            errMsg = "as evaluating one of its initialization predicates resulted in an evaluation error";
        }
        if (errMsg != null) {
            violations.add((PositionObject)loc, new LiteralMessage("failed to determine whether the", new Object[0]), new IfReportOnAncestorMessage("automaton's", new Object[0]), new LiteralMessage("location is an initial location,", new Object[0]), new LiteralMessage(errMsg, new Object[0]));
            this.initLocCount = -1;
        }
        if (initial && this.initLocCount != -1) {
            ++this.initLocCount;
        }
    }
}

