/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.checkers.messages.LiteralMessage;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExprNoSpecificBinaryExprsCheck
extends CifCheck {
    private final EnumSet<NoSpecificBinaryOp> disalloweds;

    public ExprNoSpecificBinaryExprsCheck(NoSpecificBinaryOp ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public ExprNoSpecificBinaryExprsCheck(EnumSet<NoSpecificBinaryOp> disalloweds) {
        this.disalloweds = disalloweds;
    }

    protected void preprocessBinaryExpression(BinaryExpression binExpr, CifCheckViolations violations) {
        BinaryOperator op = binExpr.getOperator();
        CifType ltype = CifTypeUtils.normalizeType(binExpr.getLeft().getType());
        CifType rtype = CifTypeUtils.normalizeType(binExpr.getRight().getType());
        switch (op) {
            case ADDITION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_REALS) && (ltype instanceof RealType || rtype instanceof RealType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_LISTS) && (ltype instanceof ListType || rtype instanceof ListType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_STRINGS) && (ltype instanceof StringType || rtype instanceof StringType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_DICTS) || !(ltype instanceof DictType) && !(rtype instanceof DictType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case BI_CONDITIONAL: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.BI_CONDITIONAL)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case CONJUNCTION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.CONJUNCTION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.CONJUNCTION_SETS) || !(ltype instanceof SetType) && !(rtype instanceof SetType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case DISJUNCTION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.DISJUNCTION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.DISJUNCTION_SETS) || !(ltype instanceof SetType) && !(rtype instanceof SetType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case DIVISION: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.DIVISION)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case ELEMENT_OF: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF_LISTS) && (ltype instanceof ListType || rtype instanceof ListType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF_SETS) && (ltype instanceof SetType || rtype instanceof SetType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF_DICTS) || !(ltype instanceof DictType) && !(rtype instanceof DictType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case EQUAL: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case GREATER_EQUAL: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case GREATER_THAN: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case IMPLICATION: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.IMPLICATION)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case INTEGER_DIVISION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION_INTS)) {
                    if (!(ltype instanceof IntType) && !(rtype instanceof IntType)) break;
                    this.addExprViolationOperand(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION_INTS_RANGELESS) || (!(ltype instanceof IntType) || !CifTypeUtils.isRangeless((IntType)ltype)) && (!(rtype instanceof IntType) || !CifTypeUtils.isRangeless((IntType)rtype))) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case LESS_EQUAL: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case LESS_THAN: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case MODULUS: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS_INTS)) {
                    if (!(ltype instanceof IntType) && !(rtype instanceof IntType)) break;
                    this.addExprViolationOperand(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS_INTS_RANGELESS) || (!(ltype instanceof IntType) || !CifTypeUtils.isRangeless((IntType)ltype)) && (!(rtype instanceof IntType) || !CifTypeUtils.isRangeless((IntType)rtype))) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case MULTIPLICATION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case SUBSET: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBSET)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case SUBTRACTION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)ltype) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)rtype))) {
                        this.addExprViolationOperand(binExpr, violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_REALS) && (ltype instanceof RealType || rtype instanceof RealType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_LISTS) && (ltype instanceof ListType || rtype instanceof ListType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_SETS) && (ltype instanceof SetType || rtype instanceof SetType)) {
                    this.addExprViolationOperand(binExpr, violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_DICTS) || !(ltype instanceof DictType) && !(rtype instanceof DictType)) break;
                this.addExprViolationOperand(binExpr, violations);
                break;
            }
            case UNEQUAL: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            default: {
                throw new RuntimeException("Unknown binary operator: " + op);
            }
        }
    }

    private void addExprViolationOperator(BinaryExpression binExpr, CifCheckViolations violations) {
        violations.add((PositionObject)binExpr, new LiteralMessage("uses binary operator \"%s\" in binary expression \"%s\"", CifTextUtils.operatorToStr(binExpr.getOperator()), CifTextUtils.exprToStr((Expression)binExpr)));
    }

    private void addExprViolationOperand(BinaryExpression binExpr, CifCheckViolations violations) {
        CifType ltype = CifTypeUtils.normalizeType(binExpr.getLeft().getType());
        CifType rtype = CifTypeUtils.normalizeType(binExpr.getRight().getType());
        violations.add((PositionObject)binExpr, new LiteralMessage("uses binary operator \"%s\" on operands of types \"%s\" and \"%s\" in binary expression \"%s\"", CifTextUtils.operatorToStr(binExpr.getOperator()), CifTextUtils.typeToStr(ltype), CifTextUtils.typeToStr(rtype), CifTextUtils.exprToStr((Expression)binExpr)));
    }

    public static enum NoSpecificBinaryOp {
        ADDITION,
        ADDITION_INTS,
        ADDITION_INTS_RANGED,
        ADDITION_INTS_RANGELESS,
        ADDITION_REALS,
        ADDITION_LISTS,
        ADDITION_STRINGS,
        ADDITION_DICTS,
        BI_CONDITIONAL,
        CONJUNCTION,
        CONJUNCTION_SETS,
        DISJUNCTION,
        DISJUNCTION_SETS,
        DIVISION,
        ELEMENT_OF,
        ELEMENT_OF_LISTS,
        ELEMENT_OF_SETS,
        ELEMENT_OF_DICTS,
        EQUAL,
        GREATER_EQUAL,
        GREATER_EQUAL_INTS,
        GREATER_EQUAL_INTS_RANGED,
        GREATER_EQUAL_INTS_RANGELESS,
        GREATER_EQUAL_REALS,
        GREATER_THAN,
        GREATER_THAN_INTS,
        GREATER_THAN_INTS_RANGED,
        GREATER_THAN_INTS_RANGELESS,
        GREATER_THAN_REALS,
        IMPLICATION,
        INTEGER_DIVISION,
        INTEGER_DIVISION_INTS,
        INTEGER_DIVISION_INTS_RANGED,
        INTEGER_DIVISION_INTS_RANGELESS,
        LESS_EQUAL,
        LESS_EQUAL_INTS,
        LESS_EQUAL_INTS_RANGED,
        LESS_EQUAL_INTS_RANGELESS,
        LESS_EQUAL_REALS,
        LESS_THAN,
        LESS_THAN_INTS,
        LESS_THAN_INTS_RANGED,
        LESS_THAN_INTS_RANGELESS,
        LESS_THAN_REALS,
        MODULUS,
        MODULUS_INTS,
        MODULUS_INTS_RANGED,
        MODULUS_INTS_RANGELESS,
        MULTIPLICATION,
        MULTIPLICATION_INTS,
        MULTIPLICATION_INTS_RANGED,
        MULTIPLICATION_INTS_RANGELESS,
        MULTIPLICATION_REALS,
        SUBSET,
        SUBTRACTION,
        SUBTRACTION_INTS,
        SUBTRACTION_INTS_RANGED,
        SUBTRACTION_INTS_RANGELESS,
        SUBTRACTION_REALS,
        SUBTRACTION_LISTS,
        SUBTRACTION_SETS,
        SUBTRACTION_DICTS,
        UNEQUAL;

    }
}

