/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.checkers.messages.LiteralMessage;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExprNoSpecificUnaryExprsCheck
extends CifCheck {
    private final EnumSet<NoSpecificUnaryOp> disalloweds;

    public ExprNoSpecificUnaryExprsCheck(NoSpecificUnaryOp ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public ExprNoSpecificUnaryExprsCheck(EnumSet<NoSpecificUnaryOp> disalloweds) {
        this.disalloweds = disalloweds;
    }

    protected void preprocessUnaryExpression(UnaryExpression unExpr, CifCheckViolations violations) {
        UnaryOperator op = unExpr.getOperator();
        CifType ctype = CifTypeUtils.normalizeType(unExpr.getChild().getType());
        switch (op) {
            case INVERSE: {
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.INVERSE)) break;
                this.addExprViolationOperator(unExpr, violations);
                break;
            }
            case NEGATE: {
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE)) {
                    this.addExprViolationOperator(unExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_INTS)) {
                    if (ctype instanceof IntType) {
                        this.addExprViolationOperand(unExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_INTS_RANGED) && ctype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ctype)) {
                        this.addExprViolationOperand(unExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_INTS_RANGELESS) && ctype instanceof IntType && CifTypeUtils.isRangeless((IntType)ctype)) {
                        this.addExprViolationOperand(unExpr, violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_REALS) || !(ctype instanceof RealType)) break;
                this.addExprViolationOperand(unExpr, violations);
                break;
            }
            case PLUS: {
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS)) {
                    this.addExprViolationOperator(unExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_INTS)) {
                    if (ctype instanceof IntType) {
                        this.addExprViolationOperand(unExpr, violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_INTS_RANGED) && ctype instanceof IntType && !CifTypeUtils.isRangeless((IntType)ctype)) {
                        this.addExprViolationOperand(unExpr, violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_INTS_RANGELESS) && ctype instanceof IntType && CifTypeUtils.isRangeless((IntType)ctype)) {
                        this.addExprViolationOperand(unExpr, violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_REALS) || !(ctype instanceof RealType)) break;
                this.addExprViolationOperand(unExpr, violations);
                break;
            }
            case SAMPLE: {
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.SAMPLE)) break;
                this.addExprViolationOperator(unExpr, violations);
                break;
            }
            default: {
                throw new RuntimeException("Unknown unary operator: " + op);
            }
        }
    }

    private void addExprViolationOperator(UnaryExpression unExpr, CifCheckViolations violations) {
        violations.add((PositionObject)unExpr, new LiteralMessage("uses unary operator \"%s\" in unary expression \"%s\"", CifTextUtils.operatorToStr(unExpr.getOperator()), CifTextUtils.exprToStr((Expression)unExpr)));
    }

    private void addExprViolationOperand(UnaryExpression unExpr, CifCheckViolations violations) {
        CifType ctype = CifTypeUtils.normalizeType(unExpr.getChild().getType());
        violations.add((PositionObject)unExpr, new LiteralMessage("uses unary operator \"%s\" on an operand of type \"%s\" in unary expression \"%s\"", CifTextUtils.operatorToStr(unExpr.getOperator()), CifTextUtils.typeToStr(ctype), CifTextUtils.exprToStr((Expression)unExpr)));
    }

    public static enum NoSpecificUnaryOp {
        INVERSE,
        NEGATE,
        NEGATE_INTS,
        NEGATE_INTS_RANGED,
        NEGATE_INTS_RANGELESS,
        NEGATE_REALS,
        PLUS,
        PLUS_INTS,
        PLUS_INTS_RANGED,
        PLUS_INTS_RANGELESS,
        PLUS_REALS,
        SAMPLE;

    }
}

