/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers.messages;

import java.util.List;
import org.eclipse.escet.cif.common.checkers.CifCheckViolation;
import org.eclipse.escet.cif.common.checkers.messages.CifCheckViolationMessage;
import org.eclipse.escet.common.java.Assert;

public class SequenceMessage
extends CifCheckViolationMessage {
    private final List<CifCheckViolationMessage> messages;

    public SequenceMessage(List<CifCheckViolationMessage> messages) {
        Assert.check((!messages.isEmpty() ? 1 : 0) != 0);
        this.messages = messages;
    }

    @Override
    public String getMessageText(CifCheckViolation violation) {
        StringBuilder concatenatedText = new StringBuilder();
        for (CifCheckViolationMessage message : this.messages) {
            String messageText = message.getMessageText(violation);
            if ((messageText = messageText.trim()).isEmpty()) continue;
            if (concatenatedText.length() > 0) {
                concatenatedText.append(" ");
            }
            concatenatedText.append(messageText);
        }
        return concatenatedText.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SequenceMessage)) {
            return false;
        }
        SequenceMessage that = (SequenceMessage)other;
        return this.messages.equals(that.messages);
    }

    @Override
    public int hashCode() {
        return this.messages.hashCode();
    }
}

