/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.CodeExpression;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.StateLessObjectTypeID;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.IntNumber;
import org.eclipse.escet.chi.metamodel.chi.MatrixExpression;
import org.eclipse.escet.chi.metamodel.chi.MatrixRow;
import org.eclipse.escet.chi.metamodel.chi.MatrixType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class MatrixTypeID
extends StateLessObjectTypeID {
    private final int rowSize;
    private final int columnSize;

    public MatrixTypeID(MatrixType m) {
        super(false, TypeID.TypeKind.MATRIX);
        this.rowSize = MatrixTypeID.getValue(m.getRowSize());
        this.columnSize = MatrixTypeID.getValue(m.getColumnSize());
    }

    @Override
    public String getTypeText() {
        return Strings.fmt((String)"matrix(%d, %d)", (Object[])new Object[]{this.rowSize, this.columnSize});
    }

    @Override
    public String getJavaClassType() {
        return "org.eclipse.escet.chi.runtime.data.ChiMatrix";
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        String classPath = this.getJavaClassType();
        int idx = classPath.lastIndexOf(46);
        if (idx != -1) {
            jf.addImport(classPath, false);
            classPath = classPath.substring(idx + 1);
        }
        return Strings.fmt((String)"new %s(%d, %d)", (Object[])new Object[]{classPath, this.rowSize, this.columnSize});
    }

    @Override
    public String getReadName(String stream, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        String classPath = this.getJavaClassType();
        int idx = classPath.lastIndexOf(46);
        if (idx != -1) {
            jf.addImport(String.valueOf(classPath) + ".read", true);
        }
        return Strings.fmt((String)"read(chiCoordinator, %d, %d, %s)", (Object[])new Object[]{this.rowSize, this.columnSize, stream});
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MatrixTypeID)) {
            return false;
        }
        MatrixTypeID other = (MatrixTypeID)obj;
        return this.rowSize == other.rowSize && this.columnSize == other.columnSize;
    }

    @Override
    public int hashCode() {
        return TypeID.TypeKind.MATRIX.hashCode() + this.rowSize * 13 + this.columnSize * 23;
    }

    @Override
    public ExpressionBase convertExprNode(Expression expr, CodeGeneratorContext ctxt, JavaFile currentFile) {
        String className;
        String classPath = this.getJavaClassType();
        int idx = classPath.lastIndexOf(46);
        if (idx != -1) {
            currentFile.addImport(classPath, false);
            className = classPath.substring(idx + 1);
        } else {
            className = classPath;
        }
        MatrixType mType = (MatrixType)expr.getType();
        Assert.check((this.rowSize == MatrixTypeID.getValue(mType.getRowSize()) ? 1 : 0) != 0);
        Assert.check((this.columnSize == MatrixTypeID.getValue(mType.getColumnSize()) ? 1 : 0) != 0);
        if (expr instanceof MatrixExpression) {
            MatrixExpression me = (MatrixExpression)expr;
            List lines = Lists.list();
            String varName = ctxt.makeUniqueName("mat");
            String line = Strings.fmt((String)"%s %s = new %s(%d, %d);", (Object[])new Object[]{className, varName, className, this.rowSize, this.columnSize});
            lines.add(line);
            int r = 0;
            while (r < me.getRows().size()) {
                MatrixRow mr = (MatrixRow)me.getRows().get(r);
                int c = 0;
                while (c < mr.getElements().size()) {
                    Expression eVal = (Expression)mr.getElements().get(c);
                    ExpressionBase valCode = ExpressionBase.convertExpression(eVal, ctxt, currentFile);
                    lines.addAll(valCode.getCode());
                    line = Strings.fmt((String)"%s.set(%d, %d, %s);", (Object[])new Object[]{varName, r, c, valCode.getValue()});
                    lines.add(line);
                    ++c;
                }
                ++r;
            }
            return new CodeExpression(lines, varName, (PositionObject)expr);
        }
        Assert.fail((Object)("Unexpected type of expression node for MatrixTypeID: " + expr.toString()));
        return null;
    }

    public static int getValue(Expression val) {
        Assert.check((boolean)(val instanceof IntNumber));
        IntNumber num = (IntNumber)val;
        return Integer.parseInt(num.getValue());
    }
}

