/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.analysis;

import java.util.List;
import org.eclipse.escet.cif.eventbased.analysis.AutomatonNamesInfo;
import org.eclipse.escet.cif.eventbased.analysis.EventInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedLocationInfo;
import org.eclipse.escet.cif.eventbased.analysis.StateInfo;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.BackgroundColoredText;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.ColoredText;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.ReportText;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.SimpleText;
import org.eclipse.escet.cif.eventbased.apps.SynthesisAnalysisEditor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class StateOverview {
    private SynthesisAnalysisEditor app;
    public final StateInfo locInfo;
    public int[] outEdges = null;
    public List<RemovedEdgeInfo> removedControllables = Lists.list();
    public List<RemovedEdgeInfo> removedUncontrollables = Lists.list();
    public RemovedEdgeInfo killerRemovedEdge = null;
    public RemovedLocationInfo removedState = null;

    public StateOverview(SynthesisAnalysisEditor app, StateInfo locInfo) {
        this.app = app;
        this.locInfo = locInfo;
        Assert.notNull((Object)this.locInfo);
    }

    public boolean stateExists() {
        return this.killerRemovedEdge == null && this.removedState == null;
    }

    public int getSuccessorState() {
        if (this.killerRemovedEdge != null && !this.killerRemovedEdge.toIsAutomaton) {
            return this.killerRemovedEdge.to;
        }
        if (this.removedState != null) {
            int nextState = -1;
            for (RemovedEdgeInfo removedEdge : this.removedControllables) {
                if (removedEdge.toIsAutomaton) continue;
                if (nextState == -1) {
                    nextState = removedEdge.to;
                    continue;
                }
                if (nextState == removedEdge.to) continue;
                return -1;
            }
            return nextState;
        }
        return -1;
    }

    public List<ReportText> makeDescription(boolean displayFullState, boolean displayControllables) {
        List texts = Lists.list();
        texts.add(new SimpleText("Result of "));
        if (!this.stateExists()) {
            texts.add(new ColoredText("removed", this.app.redColor));
            texts.add(new SimpleText(" "));
        }
        texts.addAll(this.getStateText(this.locInfo.targetState, displayFullState));
        texts.add(new SimpleText(":\r\n  "));
        if (this.killerRemovedEdge != null) {
            texts.addAll(this.makeRemovedEdgeText(this.killerRemovedEdge, displayFullState));
            texts.addAll(this.addFullRemovedEdgesDescription(this.removedUncontrollables, this.killerRemovedEdge, displayFullState, 4));
            if (displayControllables) {
                texts.addAll(this.addFullRemovedEdgesDescription(this.removedControllables, null, displayFullState, 4));
            } else {
                texts.addAll(StateOverview.addSummaryRemovedEdgesDescription(this.removedControllables, "controllable", 4));
            }
        } else if (this.removedState != null) {
            texts.addAll(this.makeRemovedLocationText(this.removedState));
            texts.addAll(this.addFullRemovedEdgesDescription(this.removedUncontrollables, this.killerRemovedEdge, displayFullState, 4));
            texts.addAll(this.addFullRemovedEdgesDescription(this.removedControllables, null, displayFullState, 4));
        } else {
            texts.add(new BackgroundColoredText("This state exists in the synthesis result.", this.app.greenColor));
            texts.add(new SimpleText("\r\n"));
            if (this.outEdges != null) {
                texts.add(new SimpleText("\r\n"));
                boolean foundEdge = false;
                int idx = 0;
                while (idx < this.app.data.events.size()) {
                    if (this.outEdges[idx] >= 0 && this.outEdges[idx] < this.app.data.states.size()) {
                        texts.add(new SimpleText(Strings.fmt((String)"    Edge with event \"%s\" leads to ", (Object[])new Object[]{this.app.data.events.get((int)idx).name})));
                        texts.addAll(this.getStateText(this.outEdges[idx], false));
                        texts.add(new SimpleText("\r\n"));
                        foundEdge = true;
                    }
                    ++idx;
                }
                if (!foundEdge) {
                    texts.add(new SimpleText(Strings.fmt((String)"    No outgoing edges found!\r\n", (Object[])new Object[0])));
                }
            }
            texts.add(new SimpleText("\r\n"));
            texts.addAll(this.addFullRemovedEdgesDescription(this.removedControllables, null, displayFullState, 4));
        }
        return texts;
    }

    private List<ReportText> addFullRemovedEdgesDescription(List<RemovedEdgeInfo> edges, RemovedEdgeInfo skipEdge, boolean displayFullState, int indent) {
        List texts = Lists.list();
        for (RemovedEdgeInfo removedEdge : edges) {
            if (removedEdge == skipEdge) continue;
            texts.add(new SimpleText(Strings.spaces((int)indent)));
            texts.addAll(this.makeRemovedEdgeText(removedEdge, displayFullState));
        }
        return texts;
    }

    private static List<ReportText> addSummaryRemovedEdgesDescription(List<RemovedEdgeInfo> edges, String evtType, int indent) {
        if (edges.isEmpty()) {
            return Lists.listc((int)0);
        }
        String msg = edges.size() == 1 ? Strings.fmt((String)"(1 removed edge with a %s event is omitted.)\r\n", (Object[])new Object[]{evtType}) : Strings.fmt((String)"(%d removed edges with %s events are omitted.)\r\n", (Object[])new Object[]{edges.size(), evtType});
        return Lists.list((Object[])new SimpleText[]{new SimpleText(Strings.spaces((int)indent)), new SimpleText(msg)});
    }

    public List<ReportText> makeRemovedEdgeText(RemovedEdgeInfo removedEdge, boolean displayFullState) {
        List result = Lists.list();
        EventInfo info = this.app.data.events.get(removedEdge.event);
        String eventName = info.name;
        String contrText = info.contr ? "controllable" : "uncontrollable";
        result.add(new SimpleText(Strings.fmt((String)"Edge with %s event \"%s\" was removed", (Object[])new Object[]{contrText, eventName})));
        if (removedEdge.toIsAutomaton) {
            String autName = this.app.data.sourceInfo.sourceInfo.get((int)removedEdge.to).autName;
            if (removedEdge.to >= this.app.data.getNumberPlants()) {
                result.add(new SimpleText(Strings.fmt((String)" due to requirement automaton \"%s\".\r\n", (Object[])new Object[]{autName})));
            } else {
                result.add(new SimpleText(Strings.fmt((String)" due to plant automaton \"%s\".\r\n", (Object[])new Object[]{autName})));
            }
        } else {
            result.add(new SimpleText(" due to removal of "));
            result.addAll(this.getStateText(removedEdge.to, displayFullState));
            result.add(new SimpleText(".\r\n"));
        }
        return result;
    }

    public List<ReportText> makeRemovedLocationText(RemovedLocationInfo removedState) {
        List result = Lists.list((Object[])new ReportText[]{new SimpleText("State was "), new ColoredText("removed", this.app.redColor)});
        switch (removedState.reason) {
            case IS_BLOCKING: {
                result.add(new SimpleText(" as it is not marked and locally found to be a deadlock state.\r\n"));
                break;
            }
            case IS_NOT_COREACHABLE: {
                result.add(new SimpleText(" as it was found to be non-coreachable.\r\n"));
                break;
            }
            case IS_NOT_REACHABLE: {
                result.add(new SimpleText(" as it has become non-reachable.\r\n"));
                break;
            }
            default: {
                Assert.fail((Object)"Unknown removed state reason.");
            }
        }
        return result;
    }

    public List<ReportText> getStateText(int stateNumber, boolean full) {
        List result = Lists.list();
        StateInfo state = this.app.data.states.get(stateNumber);
        boolean initial = state.isInitial();
        int numAuts = this.app.data.getNumberAutomata();
        result.add(new SimpleText("state "));
        result.add(new BackgroundColoredText(Strings.fmt((String)"#%d", (Object[])new Object[]{stateNumber}), this.app.linkColor));
        if (initial) {
            if (state.marked) {
                result.add(new SimpleText("[initial, marked]"));
            } else {
                result.add(new SimpleText("[initial]"));
            }
        } else if (state.marked) {
            result.add(new SimpleText("[marked]"));
        }
        if (full) {
            result.add(new SimpleText("("));
            int aut = 0;
            while (aut < numAuts) {
                int locNumber = state.srcLocs[aut];
                if (aut > 0) {
                    result.add(new SimpleText(", "));
                }
                AutomatonNamesInfo nameInfo = this.app.data.sourceInfo.sourceInfo.get(aut);
                result.add(new SimpleText(Strings.fmt((String)"%s.%s", (Object[])new Object[]{nameInfo.autName, nameInfo.locNames.get(locNumber)})));
                ++aut;
            }
            result.add(new SimpleText(")"));
        }
        return result;
    }
}

