/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps.conversion;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.eventbased.apps.conversion.GroupTree;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.OutgoingEdgeIterator;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ConvertFromEventBased {
    private int number = 1;
    Map<org.eclipse.escet.cif.eventbased.automata.Location, Location> locMap;

    public Specification convertAutomaton(org.eclipse.escet.cif.eventbased.automata.Automaton aut, String resultName) {
        Specification spec = CifConstructors.newSpecification();
        Map<Event, org.eclipse.escet.cif.metamodel.cif.declarations.Event> eventMap = this.convertEvents(aut.alphabet, spec);
        Automaton cifAut = CifConstructors.newAutomaton();
        SupKind kind = null;
        switch (aut.kind) {
            case PLANT: {
                kind = SupKind.PLANT;
                break;
            }
            case REQUIREMENT: {
                kind = SupKind.REQUIREMENT;
                break;
            }
            case SUPERVISOR: {
                kind = SupKind.SUPERVISOR;
                break;
            }
            case UNKNOWN: {
                kind = SupKind.NONE;
            }
        }
        cifAut.setKind(kind);
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        if (names.contains(resultName)) {
            resultName = CifScopeUtils.getUniqueName((String)resultName, (Set)names, (Set)names);
        }
        cifAut.setName(resultName);
        spec.getComponents().add((Object)cifAut);
        Alphabet alphabet = CifConstructors.newAlphabet();
        for (Event evt : aut.alphabet) {
            EventExpression ee = CifConstructors.newEventExpression((org.eclipse.escet.cif.metamodel.cif.declarations.Event)eventMap.get(evt), null, (CifType)CifConstructors.newBoolType());
            alphabet.getEvents().add((Object)ee);
        }
        cifAut.setAlphabet(alphabet);
        if (aut.locations == null) {
            Location cifSrc = CifConstructors.newLocation();
            cifAut.getLocations().add((Object)cifSrc);
            return spec;
        }
        this.number = 1;
        this.locMap = Maps.mapc((int)aut.size());
        for (org.eclipse.escet.cif.eventbased.automata.Location loc : aut) {
            Location cifSrc = this.getLocation(loc, aut.initial, cifAut);
            OutgoingEdgeIterator edgeIter = loc.getOutgoing();
            for (org.eclipse.escet.cif.eventbased.automata.Edge edge : edgeIter) {
                Location cifDest = null;
                if (loc != edge.dstLoc) {
                    cifDest = this.getLocation(edge.dstLoc, aut.initial, cifAut);
                }
                org.eclipse.escet.cif.metamodel.cif.declarations.Event event = eventMap.get(edge.event);
                EventExpression ee = CifConstructors.newEventExpression((org.eclipse.escet.cif.metamodel.cif.declarations.Event)event, null, (CifType)CifConstructors.newBoolType());
                EdgeEvent edv = CifConstructors.newEdgeEvent((Expression)ee, null);
                Edge cifEdge = CifConstructors.newEdge((List)Lists.list((Object)edv), null, null, (Location)cifDest, null, (Boolean)false);
                cifSrc.getEdges().add((Object)cifEdge);
            }
        }
        return spec;
    }

    private Map<Event, org.eclipse.escet.cif.metamodel.cif.declarations.Event> convertEvents(Set<Event> alphabet, Specification spec) {
        Map eventMap = Maps.mapc((int)alphabet.size());
        Map groupTree = Maps.map();
        for (Event evt : alphabet) {
            org.eclipse.escet.cif.metamodel.cif.declarations.Event event;
            int j;
            Specification current = spec;
            String name = evt.name;
            int i = 0;
            while ((j = name.indexOf(46, i)) != -1) {
                GroupTree tree = new GroupTree((Group)current, name.substring(i, j));
                Group child = (Group)groupTree.get(tree);
                if (child == null) {
                    child = CifConstructors.newGroup();
                    child.setName(name.substring(i, j));
                    groupTree.put(tree, child);
                    current.getComponents().add((Object)child);
                }
                current = child;
                i = j + 1;
            }
            switch (evt.contr) {
                case CONTR_EVENT: {
                    event = CifConstructors.newEvent((Boolean)true, (String)name.substring(i), null, null);
                    break;
                }
                case PLAIN_EVENT: {
                    event = CifConstructors.newEvent(null, (String)name.substring(i), null, null);
                    break;
                }
                case UNCONTR_EVENT: {
                    event = CifConstructors.newEvent((Boolean)false, (String)name.substring(i), null, null);
                    break;
                }
                default: {
                    Assert.fail((Object)"Unexpected kind of controllability");
                    event = null;
                }
            }
            eventMap.put(evt, event);
            current.getDeclarations().add((Object)event);
        }
        return eventMap;
    }

    private Location getLocation(org.eclipse.escet.cif.eventbased.automata.Location loc, org.eclipse.escet.cif.eventbased.automata.Location initLoc, Automaton cifAut) {
        Location cifLoc = this.locMap.get(loc);
        if (cifLoc != null) {
            return cifLoc;
        }
        String name = "s" + Integer.toString(this.number);
        ++this.number;
        cifLoc = CifConstructors.newLocation();
        cifLoc.setName(name);
        if (loc == initLoc) {
            cifLoc.getInitials().add((Object)CifValueUtils.makeTrue());
        }
        if (loc.marked) {
            cifLoc.getMarkeds().add((Object)CifValueUtils.makeTrue());
        }
        cifAut.getLocations().add((Object)cifLoc);
        this.locMap.put(loc, cifLoc);
        return cifLoc;
    }
}

