/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.automata;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDumpInterface;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.EventAtLocation;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidModelException;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class AutomatonHelper {
    private AutomatonHelper() {
    }

    private static EventAtLocation checkDeterministic(Automaton aut) {
        boolean[] seenEvent = new boolean[aut.alphabet.size()];
        Map eventMap = Maps.mapc((int)aut.alphabet.size());
        int idx = 0;
        for (Event evt : aut.alphabet) {
            eventMap.put(evt, idx);
            ++idx;
        }
        for (Location loc : aut) {
            Arrays.fill(seenEvent, false);
            for (Edge edge : loc.getOutgoing()) {
                idx = (Integer)eventMap.get(edge.event);
                if (seenEvent[idx]) {
                    return new EventAtLocation(loc, edge.event);
                }
                seenEvent[idx] = true;
            }
        }
        return null;
    }

    public static void reportNonDeterministic(Automaton aut) {
        EventAtLocation el = AutomatonHelper.checkDeterministic(aut);
        if (el != null) {
            String msg = Strings.fmt((String)"Unsupported automaton \"%s\": %s has several outgoing edges for event \"%s\", only deterministic automata are supported.", (Object[])new Object[]{aut.name, el.loc.toString(), el.evt.name});
            throw new InvalidInputException(msg);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Location> expandStatesBackward(Set<Location> locs, Queue<Location> notDone, Set<Event> allowed) {
        if (notDone == null) {
            sz = locs.size();
            if (sz < 1000) {
                sz = 1000;
            }
            notDone = new ArrayDeque<Location>(sz);
            notDone.addAll(locs);
        }
        if (allowed != null) ** GOTO lbl24
        while (!notDone.isEmpty()) {
            loc = notDone.remove();
            for (Edge e : loc.getIncoming()) {
                if (!locs.add(e.srcLoc)) continue;
                notDone.add(e.srcLoc);
            }
        }
        return locs;
lbl-1000:
        // 1 sources

        {
            loc = notDone.remove();
            for (Edge e : loc.getIncoming()) {
                if (!allowed.contains(e.event) || !locs.add(e.srcLoc)) continue;
                notDone.add(e.srcLoc);
            }
lbl24:
            // 2 sources

            ** while (!notDone.isEmpty())
        }
lbl25:
        // 1 sources

        return locs;
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Location> expandStatesForward(Set<Location> locs, Queue<Location> notDone, Set<Event> allowed) {
        if (notDone == null) {
            sz = locs.size();
            if (sz < 1000) {
                sz = 1000;
            }
            notDone = new ArrayDeque<Location>(sz);
            notDone.addAll(locs);
        }
        if (allowed != null) ** GOTO lbl24
        while (!notDone.isEmpty()) {
            loc = notDone.remove();
            for (Edge e : loc.getOutgoing()) {
                if (!locs.add(e.dstLoc)) continue;
                notDone.add(e.dstLoc);
            }
        }
        return locs;
lbl-1000:
        // 1 sources

        {
            loc = notDone.remove();
            for (Edge e : loc.getOutgoing()) {
                if (!allowed.contains(e.event) || !locs.add(e.dstLoc)) continue;
                notDone.add(e.dstLoc);
            }
lbl24:
            // 2 sources

            ** while (!notDone.isEmpty())
        }
lbl25:
        // 1 sources

        return locs;
    }

    public static boolean trimCheck(Automaton aut) {
        Set<Location> locs = Sets.setc((int)10000);
        int count = AutomatonHelper.getNonCoreachableCount(aut, locs);
        if (count != 0) {
            return false;
        }
        count = locs.size();
        locs = AutomatonHelper.getReachables(aut);
        return locs.size() == count;
    }

    public static void computeTrim(Automaton aut) {
        Set coreachables = Sets.setc((int)10000);
        int count = AutomatonHelper.getNonCoreachableCount(aut, coreachables);
        boolean isTrim = count == 0;
        Set<Location> reachables = AutomatonHelper.getReachables(aut);
        if (!(isTrim &= reachables.size() == (count += coreachables.size()))) {
            Location loc = aut.locations;
            while (loc != null) {
                Location next = loc.nextLoc;
                if (!coreachables.contains(loc) || !reachables.contains(loc)) {
                    if (loc == aut.initial) {
                        String msg = "Initial state is not coreachable, trimming results in an empty automaton.";
                        throw new InvalidModelException(msg);
                    }
                    aut.removeLocation(loc);
                }
                loc = next;
            }
        }
    }

    public static int getNonCoreachableCount(Automaton aut, Set<Location> coreachables) {
        ArrayDeque<Location> toExpand = new ArrayDeque<Location>(1000);
        coreachables.clear();
        int locCount = 0;
        Location loc = aut.locations;
        while (loc != null) {
            ++locCount;
            if (loc.marked) {
                toExpand.add(loc);
                coreachables.add(loc);
            }
            loc = loc.nextLoc;
        }
        while (!toExpand.isEmpty()) {
            loc = (Location)toExpand.remove();
            for (Edge e : loc.getIncoming()) {
                if (!coreachables.add(e.srcLoc)) continue;
                toExpand.add(e.srcLoc);
            }
        }
        return locCount - coreachables.size();
    }

    public static void removeNonReachables(Automaton aut, SynthesisDumpInterface synDump) {
        if (aut.initial == null) {
            aut.clear();
            return;
        }
        Set<Location> reachables = AutomatonHelper.getReachables(aut);
        AutomatonHelper.removeExcludedLocations(aut, reachables, synDump);
    }

    public static Set<Location> getReachables(Automaton aut) {
        ArrayDeque<Location> toExpand = new ArrayDeque<Location>(1000);
        Set reachables = Sets.setc((int)10000);
        if (aut.initial != null) {
            toExpand.add(aut.initial);
            reachables.add(aut.initial);
        }
        while (!toExpand.isEmpty()) {
            Location loc = (Location)toExpand.remove();
            for (Edge e : loc.getOutgoing()) {
                if (!reachables.add(e.dstLoc)) continue;
                toExpand.add(e.dstLoc);
            }
        }
        return reachables;
    }

    private static void removeExcludedLocations(Automaton aut, Set<Location> locs, SynthesisDumpInterface synDump) {
        Location loc = aut.locations;
        while (loc != null) {
            if (locs.contains(loc)) {
                loc = loc.nextLoc;
                continue;
            }
            Location locDel = loc;
            loc = loc.nextLoc;
            if (synDump != null) {
                synDump.nonReachableLocation(locDel);
            }
            aut.removeLocation(locDel);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Location> expandLocations(Set<Location> locs, Event firstEvent, Set<Event> events) {
        notDone = new ArrayDeque<Location>(1000);
        reachables = Sets.setc((int)(2 * locs.size()));
        if (firstEvent != null) {
            for (Location loc : locs) {
                for (Edge e : loc.getOutgoing(firstEvent)) {
                    if (!reachables.add(e.dstLoc)) continue;
                    notDone.add(e.dstLoc);
                }
            }
        } else {
            notDone.addAll(locs);
            reachables.addAll(locs);
        }
        if (!events.isEmpty() && !reachables.isEmpty()) ** GOTO lbl26
        return reachables;
lbl-1000:
        // 1 sources

        {
            loc = (Location)notDone.poll();
            for (Edge e : loc.getOutgoing()) {
                if (!events.contains(e.event) || reachables.contains(e.dstLoc)) continue;
                reachables.add(e.dstLoc);
                notDone.add(e.dstLoc);
            }
lbl26:
            // 2 sources

            ** while (!notDone.isEmpty())
        }
lbl27:
        // 1 sources

        return reachables;
    }

    public static boolean hasMarkedLocation(Set<Location> locs) {
        for (Location loc : locs) {
            if (!loc.marked) continue;
            return true;
        }
        return false;
    }

    public static Object getAutStatistics(Automaton aut) {
        int[] statistics = aut.getLocEdgeCounts();
        String locTxt = statistics[0] == 1 ? "1 location" : Strings.fmt((String)"%s locations", (Object[])new Object[]{Numbers.formatNumber((int)statistics[0])});
        String edgeTxt = statistics[1] == 1 ? "1 edge" : Strings.fmt((String)"%s edges", (Object[])new Object[]{Numbers.formatNumber((int)statistics[1])});
        return String.valueOf(locTxt) + ", " + edgeTxt;
    }

    public static List<List<Automaton>> findDisjunctGroups(List<Automaton> auts) {
        List groups = Lists.list();
        auts = Lists.copy(auts);
        int avail = auts.size();
        while (avail > 0) {
            Automaton aut = (Automaton)auts.get(avail - 1);
            Set groupAlphabet = Sets.copy(aut.alphabet);
            List group = Lists.listc((int)avail);
            group.add(aut);
            --avail;
            while (avail > 0) {
                boolean progress = false;
                int index = 0;
                while (index < avail) {
                    aut = (Automaton)auts.get(index);
                    if (Sets.isEmptyIntersection((Set)groupAlphabet, aut.alphabet)) {
                        ++index;
                        continue;
                    }
                    groupAlphabet.addAll(aut.alphabet);
                    group.add(aut);
                    if (index < avail - 1) {
                        auts.set(index, (Automaton)auts.get(avail - 1));
                    }
                    --avail;
                    progress = true;
                }
                if (!progress) break;
            }
            groups.add(group);
        }
        return groups;
    }
}

