/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.app;

import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesNoRefsOptimized;
import org.eclipse.escet.cif.explorer.CifAutomatonBuilder;
import org.eclipse.escet.cif.explorer.ExplorerPreChecker;
import org.eclipse.escet.cif.explorer.ExplorerStateFactory;
import org.eclipse.escet.cif.explorer.app.AutomatonNameOption;
import org.eclipse.escet.cif.explorer.app.EnableEdgeMinimizationOption;
import org.eclipse.escet.cif.explorer.app.EnableStatisticsOption;
import org.eclipse.escet.cif.explorer.app.PrintProgressOption;
import org.eclipse.escet.cif.explorer.app.common.EnableCifOutputOption;
import org.eclipse.escet.cif.explorer.app.common.EnableReportOption;
import org.eclipse.escet.cif.explorer.app.common.ReportFileOption;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.ExplorationTerminatedException;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.ExplorerBuilder;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.StreamCodeBox;
import org.eclipse.escet.common.java.Lists;

public class ExplorerApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ExplorerApplication app = new ExplorerApplication();
        app.run(args);
    }

    public ExplorerApplication() {
    }

    public ExplorerApplication(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    private void explore(Explorer explorer) {
        List<BaseState> initials = explorer.getInitialStates(this);
        if (this.isTerminationRequested()) {
            return;
        }
        if (initials == null || initials.isEmpty()) {
            return;
        }
        Integer progressCnt = PrintProgressOption.getProgressCount();
        if (progressCnt != null) {
            this.printProgress(explorer.states.size(), initials.size());
        }
        int cnt = 0;
        ArrayDeque<BaseState> queue = new ArrayDeque<BaseState>();
        queue.addAll(initials);
        while (!queue.isEmpty()) {
            if (this.isTerminationRequested()) {
                return;
            }
            BaseState state = (BaseState)queue.poll();
            queue.addAll(state.getNewSuccessorStates());
            if (progressCnt == null || ++cnt != progressCnt) continue;
            this.printProgress(explorer.states.size(), queue.size());
            cnt = 0;
        }
        if (progressCnt != null) {
            this.printProgress(explorer.states.size(), 0);
        }
        explorer.renumberStates();
    }

    private void printProgress(int found, int todo) {
        if (!OutputProvider.doout()) {
            return;
        }
        OutputProvider.out((String)"Found %,d state%s, %,d state%s to process.", (Object[])new Object[]{found, found == 1 ? "" : "s", todo, todo == 1 ? "" : "s"});
    }

    private void writeStatisticsOutput(Explorer explorer) {
        if (!EnableStatisticsOption.getStatistics()) {
            return;
        }
        int stateCount = 0;
        int edgeCount = 0;
        if (explorer.states != null) {
            stateCount = explorer.states.size();
            for (BaseState state : explorer.states.keySet()) {
                edgeCount += state.getOutgoingEdges().size();
            }
        }
        OutputProvider.out((String)"Number of states in states space: %,d.", (Object[])new Object[]{stateCount});
        OutputProvider.out((String)"Number of edges in states space: %,d.", (Object[])new Object[]{edgeCount});
    }

    public static void writeReportOutput(Explorer explorer) {
        if (ReportFileOption.getPath() == null && !EnableReportOption.getReport()) {
            return;
        }
        String path = ReportFileOption.getDerivedPath(".cif", "_report.txt");
        path = Paths.resolve((String)path);
        try (FileAppStream outFile = null;){
            outFile = new FileAppStream(path);
            if (explorer.states == null || explorer.states.isEmpty()) {
                outFile.println("No initial state found.");
            } else {
                StreamCodeBox box = new StreamCodeBox((AppStream)outFile);
                boolean first = true;
                for (BaseState state : explorer.states.keySet()) {
                    if (!first) {
                        box.add();
                    }
                    first = false;
                    state.printDebug((CodeBox)box);
                }
            }
        }
    }

    public static void writeAutomatonOutput(Explorer explorer, Specification spec, String specPath, String extension) {
        if (OutputFileOption.getPath() == null && !EnableCifOutputOption.getCifOutput()) {
            return;
        }
        extension = "_" + extension + ".cif";
        String path = OutputFileOption.getDerivedPath((String)".cif", (String)extension);
        path = Paths.resolve((String)path);
        CifAutomatonBuilder cab = new CifAutomatonBuilder();
        spec = cab.createAutomaton(explorer, spec);
        CifWriter.writeCifSpec((Specification)spec, (String)path, (String)specPath);
    }

    protected int runInternal() {
        Explorer e;
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new ElimComponentDefInst().transform(spec);
        new ElimSelf().transform(spec);
        new SimplifyValuesNoRefsOptimized().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        EnumSet<ExplorerPreChecker.CheckParameters> params = EnumSet.allOf(ExplorerPreChecker.CheckParameters.class);
        ExplorerPreChecker checker = new ExplorerPreChecker(params);
        checker.checkSpec(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        try {
            ExplorerBuilder builder = new ExplorerBuilder(spec);
            builder.collectData();
            e = builder.buildExplorer(new ExplorerStateFactory());
            this.explore(e);
        }
        catch (ExplorationTerminatedException ex) {
            return 0;
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        if (EnableEdgeMinimizationOption.isEnabled()) {
            e.minimizeEdges();
        }
        if (this.isTerminationRequested()) {
            return 0;
        }
        this.writeStatisticsOutput(e);
        if (this.isTerminationRequested()) {
            return 0;
        }
        ExplorerApplication.writeReportOutput(e);
        if (this.isTerminationRequested()) {
            return 0;
        }
        ExplorerApplication.writeAutomatonOutput(e, spec, cifReader.getAbsDirPath(), "statespace");
        if (this.isTerminationRequested()) {
            return 0;
        }
        return 0;
    }

    public String getAppName() {
        return "CIF untimed state space explorer";
    }

    public String getAppDescription() {
        return "Explore a CIF specification to its untimed state space.";
    }

    private OptionCategory getExploreOptionsCategory() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(EnableEdgeMinimizationOption.class));
        options.add(Options.getInstance(EnableStatisticsOption.class));
        options.add(Options.getInstance(EnableCifOutputOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        options.add(Options.getInstance(AutomatonNameOption.class));
        options.add(Options.getInstance(EnableReportOption.class));
        options.add(Options.getInstance(ReportFileOption.class));
        options.add(Options.getInstance(PrintProgressOption.class));
        return new OptionCategory("CIF explorer options", "Options for exploring a CIF specification to its untimed state space.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(ExplorerApplication.getGeneralOptionCategory());
        subPages.add(this.getExploreOptionsCategory());
        List options = Lists.list();
        String optDesc = "All options for the CIF explorer.";
        return new OptionCategory("CIF explorer options", optDesc, subPages, options);
    }
}

