/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.prettyprinter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.Associativity;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.common.ScopeCache;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public final class CifPrettyPrinter {
    public static final int INDENT = 2;
    private final ScopeCache scopeCache = new ScopeCache();
    private final Map<Pair<EObject, Event>, String> eventRefCache = Maps.map();
    private final CodeBox code;

    public CifPrettyPrinter(CodeBox code) {
        this.code = code;
    }

    public static Box boxSpec(Specification spec) {
        return CifPrettyPrinter.boxSpec(spec, (CodeBox)new MemoryCodeBox(2));
    }

    public static Box boxSpec(Specification spec, CodeBox code) {
        int oldIndentAmount = code.getIndentAmount();
        code.setIndentAmount(2);
        CifPrettyPrinter cpp = new CifPrettyPrinter(code);
        cpp.add(spec);
        code.setIndentAmount(oldIndentAmount);
        return code;
    }

    public void add(Specification spec) {
        this.addCompBody((List<Declaration>)spec.getDeclarations(), (List<ComponentDef>)spec.getDefinitions(), (List<Component>)spec.getComponents(), (List<Expression>)spec.getInitials(), (List<Invariant>)spec.getInvariants(), (List<Equation>)spec.getEquations(), (List<Expression>)spec.getMarkeds(), (List<IoDecl>)spec.getIoDecls());
    }

    public void addCompBody(List<Declaration> decls, List<ComponentDef> cdefs, List<Component> comps, List<Expression> initials, List<Invariant> invs, List<Equation> eqns, List<Expression> markeds, List<IoDecl> ioDecls) {
        for (Declaration decl : decls) {
            this.add(decl);
        }
        for (ComponentDef cdef : cdefs) {
            this.add(cdef);
        }
        for (Component comp : comps) {
            this.add(comp);
        }
        this.addInitInvEqnsMarked(initials, invs, eqns, markeds, false);
        for (IoDecl ioDecl : ioDecls) {
            this.add(ioDecl);
        }
    }

    public void addInitInvEqnsMarked(List<Expression> initials, List<Invariant> invs, List<Equation> eqns, List<Expression> markeds, boolean optInitMarked) {
        StringBuilder line;
        String postfix;
        Object prefix;
        int i;
        if (!initials.isEmpty()) {
            if (optInitMarked && initials.size() == 1 && CifValueUtils.isTriviallyTrue((Expression)initials.get(0), (boolean)false, (boolean)false)) {
                this.code.add("initial;");
            } else {
                i = 0;
                while (i < initials.size()) {
                    prefix = i == 0 ? "initial " : "        ";
                    postfix = i == initials.size() - 1 ? ";" : ",";
                    this.code.add(String.valueOf(prefix) + this.pprint(initials.get(i)) + postfix);
                    ++i;
                }
            }
        }
        if (!markeds.isEmpty()) {
            if (optInitMarked && markeds.size() == 1 && CifValueUtils.isTriviallyTrue((Expression)markeds.get(0), (boolean)false, (boolean)false)) {
                this.code.add("marked;");
            } else {
                i = 0;
                while (i < markeds.size()) {
                    prefix = i == 0 ? "marked " : "       ";
                    postfix = i == markeds.size() - 1 ? ";" : ",";
                    this.code.add(String.valueOf(prefix) + this.pprint(markeds.get(i)) + postfix);
                    ++i;
                }
            }
        }
        if (!invs.isEmpty()) {
            for (Invariant inv : invs) {
                line = new StringBuilder();
                if (inv.getSupKind() != SupKind.NONE) {
                    line.append(CifTextUtils.kindToStr((SupKind)inv.getSupKind()));
                    line.append(" ");
                }
                line.append("invariant ");
                if (inv.getName() != null) {
                    line.append(CifTextUtils.escapeIdentifier((String)inv.getName()));
                    line.append(": ");
                }
                switch (inv.getInvKind()) {
                    case STATE: {
                        line.append(this.pprint(inv.getPredicate()));
                        break;
                    }
                    case EVENT_DISABLES: {
                        line.append(this.pprint(inv.getPredicate()));
                        line.append(" disables ");
                        line.append(this.pprint(inv.getEvent()));
                        break;
                    }
                    case EVENT_NEEDS: {
                        line.append(this.pprint(inv.getEvent()));
                        line.append(" needs ");
                        line.append(this.pprint(inv.getPredicate()));
                    }
                }
                line.append(";");
                this.code.add(line.toString());
            }
        }
        if (!eqns.isEmpty()) {
            int i2 = 0;
            while (i2 < eqns.size()) {
                Equation eqn = eqns.get(i2);
                line = new StringBuilder();
                line.append(i2 == 0 ? "equation " : "         ");
                line.append(CifTextUtils.escapeIdentifier((String)eqn.getVariable().getName()));
                if (eqn.isDerivative()) {
                    line.append("'");
                }
                line.append(" = ");
                line.append(this.pprint(eqn.getValue()));
                line.append(i2 == eqns.size() - 1 ? ";" : ",");
                this.code.add(line.toString());
                ++i2;
            }
        }
    }

    public void add(Declaration decl) {
        if (decl instanceof AlgVariable) {
            this.add((AlgVariable)decl);
        } else if (decl instanceof InputVariable) {
            this.add((InputVariable)decl);
        } else if (decl instanceof Constant) {
            this.add((Constant)decl);
        } else if (decl instanceof ContVariable) {
            this.add((ContVariable)decl);
        } else if (decl instanceof Function) {
            this.add((Function)decl);
        } else if (decl instanceof DiscVariable) {
            this.add((DiscVariable)decl);
        } else if (decl instanceof EnumDecl) {
            this.add((EnumDecl)decl);
        } else if (decl instanceof Event) {
            this.add((Event)decl);
        } else if (decl instanceof TypeDecl) {
            this.add((TypeDecl)decl);
        } else {
            throw new RuntimeException("Unknown decl: " + decl);
        }
    }

    public void add(AlgVariable var) {
        StringBuilder line = new StringBuilder();
        line.append("alg ");
        line.append(this.pprint(var.getType()));
        line.append(" ");
        line.append(CifTextUtils.escapeIdentifier((String)var.getName()));
        if (var.getValue() != null) {
            line.append(" = ");
            line.append(this.pprint(var.getValue()));
        }
        line.append(";");
        this.code.add(line.toString());
    }

    public void add(InputVariable var) {
        this.code.add("input %s %s;", new Object[]{this.pprint(var.getType()), CifTextUtils.escapeIdentifier((String)var.getName())});
    }

    public void add(ContVariable var) {
        StringBuilder txt = new StringBuilder();
        txt.append("cont ");
        txt.append(CifTextUtils.escapeIdentifier((String)var.getName()));
        if (var.getValue() != null) {
            txt.append(" = ");
            txt.append(this.pprint(var.getValue()));
        }
        if (var.getDerivative() != null) {
            txt.append(" der ");
            txt.append(this.pprint(var.getDerivative()));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(Constant constant) {
        StringBuilder txt = new StringBuilder();
        txt.append("const ");
        txt.append(this.pprint(constant.getType()));
        txt.append(" ");
        txt.append(CifTextUtils.escapeIdentifier((String)constant.getName()));
        txt.append(" = ");
        txt.append(this.pprint(constant.getValue()));
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(Function function) {
        List paramTxts = Lists.listc((int)function.getParameters().size());
        for (FunctionParameter param : function.getParameters()) {
            paramTxts.add(String.valueOf(this.pprint(param.getParameter().getType())) + " " + CifTextUtils.escapeIdentifier((String)param.getParameter().getName()));
        }
        String header = Strings.fmt((String)"func %s %s(%s):", (Object[])new Object[]{this.pprintTypes((List<CifType>)function.getReturnTypes(), ", "), CifTextUtils.escapeIdentifier((String)function.getName()), String.join((CharSequence)"; ", paramTxts)});
        if (function instanceof ExternalFunction) {
            String funcRef = ((ExternalFunction)function).getFunction();
            funcRef = Strings.escape((String)funcRef);
            this.code.add("%s \"%s\";", new Object[]{header, funcRef});
        } else {
            InternalFunction ifunction = (InternalFunction)function;
            this.code.add(header);
            this.code.indent();
            for (DiscVariable var : ifunction.getVariables()) {
                this.addFunctionVar(var);
            }
            for (FunctionStatement stat : ifunction.getStatements()) {
                this.add(stat);
            }
            this.code.dedent();
            this.code.add("end");
        }
    }

    public void addFunctionVar(DiscVariable var) {
        StringBuilder txt = new StringBuilder();
        txt.append(this.pprint(var.getType()));
        txt.append(" ");
        txt.append(CifTextUtils.escapeIdentifier((String)var.getName()));
        if (var.getValue() != null) {
            Assert.check((var.getValue().getValues().size() == 1 ? 1 : 0) != 0);
            txt.append(" = ");
            txt.append(this.pprint((Expression)var.getValue().getValues().get(0)));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(FunctionStatement stat) {
        if (stat instanceof AssignmentFuncStatement) {
            TupleExpression tuple;
            AssignmentFuncStatement asgn = (AssignmentFuncStatement)stat;
            StringBuilder txt = new StringBuilder();
            if (asgn.getAddressable() instanceof TupleExpression) {
                tuple = (TupleExpression)asgn.getAddressable();
                txt.append(this.pprint((List<Expression>)tuple.getFields(), ", "));
            } else {
                txt.append(this.pprint(asgn.getAddressable()));
            }
            txt.append(" := ");
            if (asgn.getValue() instanceof TupleExpression) {
                tuple = (TupleExpression)asgn.getValue();
                txt.append(this.pprint((List<Expression>)tuple.getFields(), ", "));
            } else {
                txt.append(this.pprint(asgn.getValue()));
            }
            txt.append(";");
            this.code.add(txt.toString());
        } else if (stat instanceof BreakFuncStatement) {
            this.code.add("break;");
        } else if (stat instanceof ContinueFuncStatement) {
            this.code.add("continue;");
        } else if (stat instanceof IfFuncStatement) {
            IfFuncStatement ifStat = (IfFuncStatement)stat;
            this.code.add("if %s:", new Object[]{this.pprint((List<Expression>)ifStat.getGuards(), ", ")});
            this.code.indent();
            for (FunctionStatement bodyStat : ifStat.getThens()) {
                this.add(bodyStat);
            }
            this.code.dedent();
            for (ElifFuncStatement elif : ifStat.getElifs()) {
                this.code.add("elif %s:", new Object[]{this.pprint((List<Expression>)elif.getGuards(), ", ")});
                this.code.indent();
                for (FunctionStatement bodyStat : elif.getThens()) {
                    this.add(bodyStat);
                }
                this.code.dedent();
            }
            if (!ifStat.getElses().isEmpty()) {
                this.code.add("else");
                this.code.indent();
                for (FunctionStatement bodyStat : ifStat.getElses()) {
                    this.add(bodyStat);
                }
                this.code.dedent();
            }
            this.code.add("end");
        } else if (stat instanceof ReturnFuncStatement) {
            EList values = ((ReturnFuncStatement)stat).getValues();
            this.code.add("return %s;", new Object[]{this.pprint((List<Expression>)values, ", ")});
        } else if (stat instanceof WhileFuncStatement) {
            WhileFuncStatement wstat = (WhileFuncStatement)stat;
            this.code.add("while %s:", new Object[]{this.pprint((List<Expression>)wstat.getGuards(), ", ")});
            this.code.indent();
            for (FunctionStatement bodyStat : wstat.getStatements()) {
                this.add(bodyStat);
            }
            this.code.dedent();
            this.code.add("end");
        } else {
            throw new RuntimeException("Unknown function statement: " + stat);
        }
    }

    public void add(EnumDecl enumDecl) {
        List names = Lists.listc((int)enumDecl.getLiterals().size());
        for (EnumLiteral lit : enumDecl.getLiterals()) {
            names.add(CifTextUtils.escapeIdentifier((String)lit.getName()));
        }
        this.code.add("enum %s = %s;", new Object[]{CifTextUtils.escapeIdentifier((String)enumDecl.getName()), String.join((CharSequence)", ", names)});
    }

    public void add(Event event) {
        String typeTxt = event.getType() == null ? "" : String.valueOf(this.pprint(event.getType())) + " ";
        this.code.add("%s %s%s;", new Object[]{CifTextUtils.controllabilityToStr((Boolean)event.getControllable()), typeTxt, CifTextUtils.escapeIdentifier((String)event.getName())});
    }

    public void add(TypeDecl typeDecl) {
        this.code.add("type %s = %s;", new Object[]{CifTextUtils.escapeIdentifier((String)typeDecl.getName()), this.pprint(typeDecl.getType())});
    }

    public void add(DiscVariable var) {
        StringBuilder txt = new StringBuilder();
        txt.append("disc ");
        txt.append(this.pprint(var.getType()));
        txt.append(" ");
        txt.append(CifTextUtils.escapeIdentifier((String)var.getName()));
        if (var.getValue() != null) {
            if (var.getValue().getValues().isEmpty()) {
                txt.append(" in any");
            } else if (var.getValue().getValues().size() == 1) {
                txt.append(" = ");
                txt.append(this.pprint((Expression)var.getValue().getValues().get(0)));
            } else {
                txt.append(" in ");
                txt.append(this.pprint((List<Expression>)var.getValue().getValues(), "{", ", ", "}"));
            }
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(ComponentDef cdef) {
        String kindTxt;
        ComplexComponent compBody = cdef.getBody();
        boolean isAut = compBody instanceof Automaton;
        List paramTxts = Lists.listc((int)cdef.getParameters().size());
        for (Parameter param : cdef.getParameters()) {
            paramTxts.add(this.pprint(param));
        }
        if (isAut) {
            SupKind kind = ((Automaton)compBody).getKind();
            kindTxt = "automaton";
            if (kind != SupKind.NONE) {
                kindTxt = String.valueOf(CifTextUtils.kindToStr((SupKind)kind)) + " " + kindTxt;
            }
        } else {
            kindTxt = "group";
        }
        this.code.add("%s def %s(%s):", new Object[]{kindTxt, CifTextUtils.escapeIdentifier((String)compBody.getName()), String.join((CharSequence)"; ", paramTxts)});
        this.code.indent();
        if (isAut) {
            Automaton aut = (Automaton)compBody;
            this.addAutBody(aut.getAlphabet(), aut.getMonitors(), (List<Location>)aut.getLocations(), (List<Declaration>)aut.getDeclarations(), (List<Expression>)aut.getInitials(), (List<Invariant>)aut.getInvariants(), (List<Equation>)aut.getEquations(), (List<Expression>)aut.getMarkeds(), (List<IoDecl>)aut.getIoDecls());
        } else {
            Assert.check((boolean)(compBody instanceof Group));
            Group group = (Group)compBody;
            this.addCompBody((List<Declaration>)group.getDeclarations(), (List<ComponentDef>)group.getDefinitions(), (List<Component>)group.getComponents(), (List<Expression>)group.getInitials(), (List<Invariant>)group.getInvariants(), (List<Equation>)group.getEquations(), (List<Expression>)group.getMarkeds(), (List<IoDecl>)group.getIoDecls());
        }
        this.code.dedent();
        this.code.add("end");
    }

    public String pprint(Parameter param) {
        if (param instanceof ComponentParameter) {
            return this.pprint((ComponentParameter)param);
        }
        if (param instanceof EventParameter) {
            return this.pprint((EventParameter)param);
        }
        if (param instanceof LocationParameter) {
            return this.pprint((LocationParameter)param);
        }
        if (param instanceof AlgParameter) {
            return this.pprint((AlgParameter)param);
        }
        throw new RuntimeException("Unknown formal parameter: " + param);
    }

    public String pprint(ComponentParameter param) {
        return String.valueOf(this.pprint(param.getType())) + " " + CifTextUtils.escapeIdentifier((String)param.getName());
    }

    public String pprint(EventParameter param) {
        Event event = param.getEvent();
        String typeTxt = event.getType() == null ? "" : String.valueOf(this.pprint(event.getType())) + " ";
        String flagsTxt = "";
        if (param.isSendFlag()) {
            flagsTxt = String.valueOf(flagsTxt) + "!";
        }
        if (param.isRecvFlag()) {
            flagsTxt = String.valueOf(flagsTxt) + "?";
        }
        if (param.isSyncFlag()) {
            flagsTxt = String.valueOf(flagsTxt) + "~";
        }
        return Strings.fmt((String)"%s %s%s%s", (Object[])new Object[]{CifTextUtils.controllabilityToStr((Boolean)event.getControllable()), typeTxt, CifTextUtils.escapeIdentifier((String)event.getName()), flagsTxt});
    }

    public String pprint(LocationParameter param) {
        Location loc = param.getLocation();
        return "location " + CifTextUtils.escapeIdentifier((String)loc.getName());
    }

    public String pprint(AlgParameter param) {
        AlgVariable var = param.getVariable();
        return Strings.fmt((String)"alg %s %s", (Object[])new Object[]{this.pprint(var.getType()), CifTextUtils.escapeIdentifier((String)var.getName())});
    }

    public void add(Component comp) {
        if (comp instanceof ComponentInst) {
            this.add((ComponentInst)comp);
        } else if (comp instanceof Automaton) {
            this.add((Automaton)comp);
        } else if (comp instanceof Group) {
            Assert.check((!(comp instanceof Specification) ? 1 : 0) != 0);
            this.add((Group)comp);
        } else {
            throw new RuntimeException("Unknown component: " + comp);
        }
    }

    public void add(ComponentInst inst) {
        this.code.add("%s: %s%s;", new Object[]{CifTextUtils.escapeIdentifier((String)inst.getName()), this.pprint(inst.getDefinition()), this.pprint((List<Expression>)inst.getParameters(), "(", ", ", ")")});
    }

    public void add(Automaton aut) {
        SupKind kind = aut.getKind();
        String kindTxt = "automaton";
        if (kind != SupKind.NONE) {
            kindTxt = String.valueOf(CifTextUtils.kindToStr((SupKind)kind)) + " " + kindTxt;
        }
        this.code.add("%s %s:", new Object[]{kindTxt, CifTextUtils.escapeIdentifier((String)aut.getName())});
        this.code.indent();
        this.addAutBody(aut.getAlphabet(), aut.getMonitors(), (List<Location>)aut.getLocations(), (List<Declaration>)aut.getDeclarations(), (List<Expression>)aut.getInitials(), (List<Invariant>)aut.getInvariants(), (List<Equation>)aut.getEquations(), (List<Expression>)aut.getMarkeds(), (List<IoDecl>)aut.getIoDecls());
        this.code.dedent();
        this.code.add("end");
    }

    public void addAutBody(Alphabet alpha, Monitors monitors, List<Location> locs, List<Declaration> decls, List<Expression> initials, List<Invariant> invs, List<Equation> eqns, List<Expression> markeds, List<IoDecl> ioDecls) {
        this.add(alpha);
        this.add(monitors);
        this.addCompBody(decls, Collections.emptyList(), Collections.emptyList(), initials, invs, eqns, markeds, ioDecls);
        for (Location loc : locs) {
            this.add(loc);
        }
    }

    public void add(Alphabet alpha) {
        if (alpha != null) {
            if (alpha.getEvents().isEmpty()) {
                this.code.add("alphabet;");
            } else {
                this.code.add("alphabet %s;", new Object[]{this.pprint((List<Expression>)alpha.getEvents(), ", ")});
            }
        }
    }

    public void add(Monitors monitors) {
        if (monitors != null) {
            if (monitors.getEvents().isEmpty()) {
                this.code.add("monitor;");
            } else {
                this.code.add("monitor %s;", new Object[]{this.pprint((List<Expression>)monitors.getEvents(), ", ")});
            }
        }
    }

    public void add(Group group) {
        this.code.add("group %s:", new Object[]{CifTextUtils.escapeIdentifier((String)group.getName())});
        this.code.indent();
        this.addCompBody((List<Declaration>)group.getDeclarations(), (List<ComponentDef>)group.getDefinitions(), (List<Component>)group.getComponents(), (List<Expression>)group.getInitials(), (List<Invariant>)group.getInvariants(), (List<Equation>)group.getEquations(), (List<Expression>)group.getMarkeds(), (List<IoDecl>)group.getIoDecls());
        this.code.dedent();
        this.code.add("end");
    }

    public void add(Location loc) {
        boolean isEmpty = loc.getEdges().isEmpty() && loc.getInitials().isEmpty() && loc.getInvariants().isEmpty() && loc.getEquations().isEmpty() && loc.getMarkeds().isEmpty() && !loc.isUrgent();
        String header = loc.getName() == null ? "location" : "location " + CifTextUtils.escapeIdentifier((String)loc.getName());
        if (isEmpty) {
            this.code.add(String.valueOf(header) + ";");
            return;
        }
        this.code.add(String.valueOf(header) + ":");
        this.code.indent();
        this.addInitInvEqnsMarked((List<Expression>)loc.getInitials(), (List<Invariant>)loc.getInvariants(), (List<Equation>)loc.getEquations(), (List<Expression>)loc.getMarkeds(), true);
        if (loc.isUrgent()) {
            this.code.add("urgent;");
        }
        for (Edge edge : loc.getEdges()) {
            this.add(edge);
        }
        this.code.dedent();
    }

    public void add(Edge edge) {
        StringBuilder txt = new StringBuilder();
        txt.append("edge ");
        boolean empty = true;
        if (!edge.getEvents().isEmpty()) {
            txt.append(this.pprintEdgeEvents((List<EdgeEvent>)edge.getEvents()));
            empty = false;
        }
        if (!edge.getGuards().isEmpty()) {
            if (!empty) {
                txt.append(" ");
            }
            txt.append("when ");
            txt.append(this.pprint((List<Expression>)edge.getGuards(), ", "));
            empty = false;
        }
        if (edge.isUrgent()) {
            if (!empty) {
                txt.append(" ");
            }
            txt.append("now");
            empty = false;
        }
        if (!edge.getUpdates().isEmpty()) {
            if (!empty) {
                txt.append(" ");
            }
            txt.append("do ");
            txt.append(this.pprintUpdates((List<Update>)edge.getUpdates()));
            empty = false;
        }
        if (empty) {
            txt.append("tau");
        }
        if (edge.getTarget() != null) {
            txt.append(" goto ");
            txt.append(CifTextUtils.escapeIdentifier((String)edge.getTarget().getName()));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public String pprintEdgeEvents(List<EdgeEvent> edgeEvents) {
        StringBuilder txt = new StringBuilder();
        boolean first = true;
        for (EdgeEvent edgeEvent : edgeEvents) {
            if (!first) {
                txt.append(", ");
            }
            first = false;
            txt.append(this.pprint(edgeEvent));
        }
        return txt.toString();
    }

    public String pprint(EdgeEvent edgeEvent) {
        StringBuilder txt = new StringBuilder();
        txt.append(this.pprint(edgeEvent.getEvent()));
        if (edgeEvent instanceof EdgeSend) {
            EdgeSend edgeSend = (EdgeSend)edgeEvent;
            txt.append("!");
            if (edgeSend.getValue() != null) {
                txt.append(this.pprint(edgeSend.getValue()));
            }
        } else if (edgeEvent instanceof EdgeReceive) {
            txt.append("?");
        }
        return txt.toString();
    }

    public String pprintUpdates(List<Update> updates) {
        StringBuilder txt = new StringBuilder();
        boolean first = true;
        for (Update update : updates) {
            if (!first) {
                txt.append(", ");
            }
            first = false;
            txt.append(this.pprint(update));
        }
        return txt.toString();
    }

    public void add(IoDecl ioDecl) {
        if (ioDecl instanceof SvgFile) {
            this.add((SvgFile)ioDecl);
        } else if (ioDecl instanceof SvgCopy) {
            this.add((SvgCopy)ioDecl);
        } else if (ioDecl instanceof SvgMove) {
            this.add((SvgMove)ioDecl);
        } else if (ioDecl instanceof SvgOut) {
            this.add((SvgOut)ioDecl);
        } else if (ioDecl instanceof SvgIn) {
            this.add((SvgIn)ioDecl);
        } else if (ioDecl instanceof PrintFile) {
            this.add((PrintFile)ioDecl);
        } else if (ioDecl instanceof Print) {
            this.add((Print)ioDecl);
        } else {
            throw new RuntimeException("Unknown I/O decl: " + ioDecl);
        }
    }

    public void add(SvgFile svgFile) {
        String path = svgFile.getPath();
        path = Strings.escape((String)path);
        this.code.add("svgfile \"%s\";", new Object[]{path});
    }

    public void add(SvgCopy svgCopy) {
        StringBuilder txt = new StringBuilder();
        txt.append("svgcopy id ");
        txt.append(this.pprint(svgCopy.getId()));
        if (svgCopy.getPre() != null) {
            txt.append(" pre ");
            txt.append(this.pprint(svgCopy.getPre()));
        }
        if (svgCopy.getPost() != null) {
            txt.append(" post ");
            txt.append(this.pprint(svgCopy.getPost()));
        }
        if (svgCopy.getSvgFile() != null) {
            String path = svgCopy.getSvgFile().getPath();
            path = Strings.escape((String)path);
            txt.append(Strings.fmt((String)" file \"%s\"", (Object[])new Object[]{path}));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(SvgMove svgMove) {
        StringBuilder txt = new StringBuilder();
        txt.append("svgmove id ");
        txt.append(this.pprint(svgMove.getId()));
        txt.append(" to ");
        txt.append(this.pprint(svgMove.getX()));
        txt.append(", ");
        txt.append(this.pprint(svgMove.getY()));
        if (svgMove.getSvgFile() != null) {
            String path = svgMove.getSvgFile().getPath();
            path = Strings.escape((String)path);
            txt.append(Strings.fmt((String)" file \"%s\"", (Object[])new Object[]{path}));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(SvgOut svgOut) {
        StringBuilder txt = new StringBuilder();
        txt.append("svgout id ");
        txt.append(this.pprint(svgOut.getId()));
        if (svgOut.getAttr() == null) {
            txt.append(" text");
        } else {
            txt.append(Strings.fmt((String)" attr \"%s\"", (Object[])new Object[]{Strings.escape((String)svgOut.getAttr())}));
        }
        txt.append(" value ");
        txt.append(this.pprint(svgOut.getValue()));
        if (svgOut.getSvgFile() != null) {
            String path = svgOut.getSvgFile().getPath();
            path = Strings.escape((String)path);
            txt.append(Strings.fmt((String)" file \"%s\"", (Object[])new Object[]{path}));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(SvgIn svgIn) {
        StringBuilder txt = new StringBuilder();
        txt.append("svgin id ");
        txt.append(this.pprint(svgIn.getId()));
        txt.append(" event ");
        SvgInEvent event = svgIn.getEvent();
        if (event instanceof SvgInEventSingle) {
            SvgInEventSingle single = (SvgInEventSingle)event;
            txt.append(this.pprint(single.getEvent()));
        } else if (event instanceof SvgInEventIf) {
            SvgInEventIf ifEvent = (SvgInEventIf)event;
            EList entries = ifEvent.getEntries();
            int i = 0;
            while (i < entries.size()) {
                SvgInEventIfEntry entry = (SvgInEventIfEntry)entries.get(i);
                if (i == 0) {
                    txt.append("if ");
                } else if (entry.getGuard() == null) {
                    txt.append("else ");
                } else {
                    txt.append("elif ");
                }
                if (entry.getGuard() != null) {
                    txt.append(this.pprint(entry.getGuard()));
                    txt.append(": ");
                }
                txt.append(this.pprint(entry.getEvent()));
                txt.append(" ");
                ++i;
            }
            txt.append("end");
        } else {
            throw new RuntimeException("Unknown SvgInEvent: " + event);
        }
        if (svgIn.getSvgFile() != null) {
            String path = svgIn.getSvgFile().getPath();
            path = Strings.escape((String)path);
            txt.append(Strings.fmt((String)" file \"%s\"", (Object[])new Object[]{path}));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public void add(PrintFile printFile) {
        String path = printFile.getPath();
        path = Strings.escape((String)path);
        this.code.add("printfile \"%s\";", new Object[]{path});
    }

    public void add(Print print) {
        StringBuilder txt = new StringBuilder();
        txt.append("print");
        if (print.getTxtPre() == null && print.getTxtPost() != null) {
            txt.append(" ");
            txt.append(this.pprint(print.getTxtPost()));
        } else {
            if (print.getTxtPre() != null) {
                txt.append(" pre ");
                txt.append(this.pprint(print.getTxtPre()));
            }
            if (print.getTxtPost() != null) {
                txt.append(" post ");
                txt.append(this.pprint(print.getTxtPost()));
            }
        }
        if (!print.getFors().isEmpty()) {
            txt.append(" for ");
            boolean first = true;
            for (PrintFor printFor : print.getFors()) {
                if (!first) {
                    txt.append(", ");
                }
                first = false;
                switch (printFor.getKind()) {
                    case EVENT: {
                        txt.append("event");
                        break;
                    }
                    case TIME: {
                        txt.append("time");
                        break;
                    }
                    case NAME: {
                        txt.append(this.pprint(printFor.getEvent()));
                        break;
                    }
                    case INITIAL: {
                        txt.append("initial");
                        break;
                    }
                    case FINAL: {
                        txt.append("final");
                    }
                }
            }
        }
        if (print.getWhenPre() != null || print.getWhenPost() != null) {
            txt.append(" when");
            if (print.getWhenPre() == null && print.getWhenPost() != null) {
                txt.append(" ");
                txt.append(this.pprint(print.getWhenPost()));
            } else {
                if (print.getWhenPre() != null) {
                    txt.append(" pre ");
                    txt.append(this.pprint(print.getWhenPre()));
                }
                if (print.getWhenPost() != null) {
                    txt.append(" post ");
                    txt.append(this.pprint(print.getWhenPost()));
                }
            }
        }
        if (print.getFile() != null) {
            String path = print.getFile().getPath();
            path = Strings.escape((String)path);
            txt.append(Strings.fmt((String)" file \"%s\"", (Object[])new Object[]{path}));
        }
        txt.append(";");
        this.code.add(txt.toString());
    }

    public String pprint(Update upd) {
        if (upd instanceof Assignment) {
            Assignment asgn = (Assignment)upd;
            return Strings.fmt((String)"%s := %s", (Object[])new Object[]{this.pprint(asgn.getAddressable()), this.pprint(asgn.getValue())});
        }
        if (upd instanceof IfUpdate) {
            IfUpdate ifUpd = (IfUpdate)upd;
            EList elifs = ifUpd.getElifs();
            StringBuilder txt = new StringBuilder();
            txt.append("if ");
            txt.append(this.pprint((List<Expression>)ifUpd.getGuards(), ", "));
            txt.append(": ");
            txt.append(this.pprintUpdates((List<Update>)ifUpd.getThens()));
            txt.append(" ");
            int i = 0;
            while (i < elifs.size()) {
                ElifUpdate elif = (ElifUpdate)elifs.get(i);
                txt.append("elif ");
                txt.append(this.pprint((List<Expression>)elif.getGuards(), ", "));
                txt.append(": ");
                txt.append(this.pprintUpdates((List<Update>)elif.getThens()));
                txt.append(" ");
                ++i;
            }
            if (!ifUpd.getElses().isEmpty()) {
                txt.append("else ");
                txt.append(this.pprintUpdates((List<Update>)ifUpd.getElses()));
                txt.append(" ");
            }
            txt.append("end");
            return txt.toString();
        }
        throw new RuntimeException("Unknown update: " + upd);
    }

    public String pprintTypes(List<CifType> types, String separator) {
        List typeTxts = Lists.listc((int)types.size());
        for (CifType type : types) {
            typeTxts.add(this.pprint(type));
        }
        return String.join((CharSequence)separator, typeTxts);
    }

    public String pprint(CifType type) {
        if (type instanceof BoolType) {
            return "bool";
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            if (CifTypeUtils.isRangeless((IntType)itype)) {
                return "int";
            }
            int lower = itype.getLower();
            String lowerTxt = lower == Integer.MIN_VALUE ? "-2147483647-1" : Integer.toString(lower);
            return Strings.fmt((String)"int[%s..%d]", (Object[])new Object[]{lowerTxt, itype.getUpper()});
        }
        if (type instanceof RealType) {
            return "real";
        }
        if (type instanceof StringType) {
            return "string";
        }
        if (type instanceof TypeRef) {
            TypeDecl refObj = ((TypeRef)type).getType();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)type, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (type instanceof EnumType) {
            EnumDecl refObj = ((EnumType)type).getEnum();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)type, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            String elemTxt = this.pprint(ltype.getElementType());
            if (CifTypeUtils.isRangeless((ListType)ltype)) {
                return "list " + elemTxt;
            }
            if (ltype.getLower().equals(ltype.getUpper())) {
                return Strings.fmt((String)"list[%d] %s", (Object[])new Object[]{ltype.getLower(), elemTxt});
            }
            return Strings.fmt((String)"list[%d..%d] %s", (Object[])new Object[]{ltype.getLower(), ltype.getUpper(), elemTxt});
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            return "set " + this.pprint(stype.getElementType());
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return Strings.fmt((String)"dict(%s:%s)", (Object[])new Object[]{this.pprint(dtype.getKeyType()), this.pprint(dtype.getValueType())});
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            List fieldTxts = Lists.listc((int)ttype.getFields().size());
            for (Field field : ttype.getFields()) {
                Assert.notNull((Object)field.getName());
                fieldTxts.add(String.valueOf(this.pprint(field.getType())) + " " + CifTextUtils.escapeIdentifier((String)field.getName()));
            }
            return Strings.fmt((String)"tuple(%s)", (Object[])new Object[]{String.join((CharSequence)"; ", fieldTxts)});
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            EList paramTypes = ftype.getParamTypes();
            return Strings.fmt((String)"func %s(%s)", (Object[])new Object[]{this.pprint(ftype.getReturnType()), this.pprintTypes((List<CifType>)paramTypes, ", ")});
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            return "dist " + this.pprint(dtype.getSampleType());
        }
        if (type instanceof ComponentType) {
            Component refObj = ((ComponentType)type).getComponent();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)type, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (type instanceof ComponentDefType) {
            ComponentDef refObj = ((ComponentDefType)type).getDefinition();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)type, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (type instanceof CompParamWrapType) {
            return CifScopeUtils.getViaRefTxt((PositionObject)type, (ScopeCache)this.scopeCache);
        }
        if (type instanceof CompInstWrapType) {
            return CifScopeUtils.getViaRefTxt((PositionObject)type, (ScopeCache)this.scopeCache);
        }
        if (type instanceof VoidType) {
            return "void";
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public String pprint(List<Expression> exprs, String separator) {
        return this.pprint(exprs, "", separator, "");
    }

    public String pprint(List<Expression> exprs, String prefix, String separator, String postfix) {
        StringBuilder txt = new StringBuilder();
        if (!prefix.isEmpty()) {
            txt.append(prefix);
        }
        boolean first = true;
        for (Expression expr : exprs) {
            if (!first) {
                txt.append(separator);
            }
            first = false;
            txt.append(this.pprint(expr));
        }
        if (!postfix.isEmpty()) {
            txt.append(postfix);
        }
        return txt.toString();
    }

    public String pprint(Expression expr) {
        if (expr instanceof BoolExpression) {
            boolean value = ((BoolExpression)expr).isValue();
            return CifMath.boolToStr((boolean)value);
        }
        if (expr instanceof IntExpression) {
            int value = ((IntExpression)expr).getValue();
            return CifMath.intToStr((int)value);
        }
        if (expr instanceof RealExpression) {
            String value = ((RealExpression)expr).getValue();
            return value;
        }
        if (expr instanceof StringExpression) {
            String value = ((StringExpression)expr).getValue();
            return "\"" + Strings.escape((String)value) + "\"";
        }
        if (expr instanceof TimeExpression) {
            return "time";
        }
        if (expr instanceof CastExpression) {
            int childStrength;
            CastExpression cexpr = (CastExpression)expr;
            String childTxt = this.pprint(cexpr.getChild());
            int castStrength = CifTextUtils.getBindingStrength((Expression)expr);
            if (castStrength > (childStrength = CifTextUtils.getBindingStrength((Expression)cexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            }
            return Strings.fmt((String)"<%s>%s", (Object[])new Object[]{this.pprint(cexpr.getType()), childTxt});
        }
        if (expr instanceof UnaryExpression) {
            int childStrength;
            UnaryExpression uexpr = (UnaryExpression)expr;
            String childTxt = this.pprint(uexpr.getChild());
            String opTxt = CifTextUtils.operatorToStr((UnaryOperator)uexpr.getOperator());
            int opStrength = CifTextUtils.getBindingStrength((Expression)expr);
            if (opStrength > (childStrength = CifTextUtils.getBindingStrength((Expression)uexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            } else if (StringUtils.isAlpha((CharSequence)StringUtils.right((String)opTxt, (int)1))) {
                opTxt = String.valueOf(opTxt) + " ";
            }
            return String.valueOf(opTxt) + childTxt;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            BinaryOperator op = bexpr.getOperator();
            String opTxt = CifTextUtils.operatorToStr((BinaryOperator)op);
            int opStrength = CifTextUtils.getBindingStrength((Expression)expr);
            int leftStrength = CifTextUtils.getBindingStrength((Expression)bexpr.getLeft());
            int rightStrength = CifTextUtils.getBindingStrength((Expression)bexpr.getRight());
            String leftTxt = this.pprint(bexpr.getLeft());
            if (opStrength > leftStrength || opStrength == leftStrength && CifTextUtils.getAssociativity((BinaryOperator)op) != Associativity.LEFT) {
                leftTxt = "(" + leftTxt + ")";
            }
            String rightTxt = this.pprint(bexpr.getRight());
            if (opStrength > rightStrength || opStrength == rightStrength && CifTextUtils.getAssociativity((BinaryOperator)op) != Associativity.RIGHT) {
                rightTxt = "(" + rightTxt + ")";
            }
            return String.valueOf(leftTxt) + " " + opTxt + " " + rightTxt;
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            EList elifs = ifExpr.getElifs();
            StringBuilder txt = new StringBuilder();
            txt.append("if ");
            txt.append(this.pprint((List<Expression>)ifExpr.getGuards(), ", "));
            txt.append(": ");
            txt.append(this.pprint(ifExpr.getThen()));
            txt.append(" ");
            int i = 0;
            while (i < elifs.size()) {
                ElifExpression elif = (ElifExpression)elifs.get(i);
                txt.append("elif ");
                txt.append(this.pprint((List<Expression>)elif.getGuards(), ", "));
                txt.append(": ");
                txt.append(this.pprint(elif.getThen()));
                txt.append(" ");
                ++i;
            }
            txt.append("else ");
            txt.append(this.pprint(ifExpr.getElse()));
            txt.append(" ");
            txt.append("end");
            return txt.toString();
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            EList cases = switchExpr.getCases();
            boolean autRef = CifTypeUtils.isAutRefExpr((Expression)value);
            StringBuilder txt = new StringBuilder();
            txt.append("switch ");
            txt.append(this.pprint(value));
            txt.append(": ");
            int i = 0;
            while (i < cases.size()) {
                SwitchCase cse = (SwitchCase)cases.get(i);
                Expression key = cse.getKey();
                if (key == null) {
                    txt.append("else ");
                } else if (autRef) {
                    txt.append("case ");
                    Expression locRef = CifTypeUtils.unwrapExpression((Expression)key);
                    Location loc = ((LocationExpression)locRef).getLocation();
                    String locName = loc.getName();
                    Assert.notNull((Object)locName);
                    txt.append(CifTextUtils.escapeIdentifier((String)locName));
                    txt.append(": ");
                } else {
                    txt.append("case ");
                    txt.append(this.pprint(key));
                    txt.append(": ");
                }
                txt.append(this.pprint(cse.getValue()));
                txt.append(" ");
                ++i;
            }
            txt.append("end");
            return txt.toString();
        }
        if (expr instanceof ProjectionExpression) {
            int childStrength;
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            String childTxt = this.pprint(pexpr.getChild());
            int projStrength = CifTextUtils.getBindingStrength((Expression)expr);
            if (projStrength > (childStrength = CifTextUtils.getBindingStrength((Expression)pexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            }
            return Strings.fmt((String)"%s[%s]", (Object[])new Object[]{childTxt, this.pprint(pexpr.getIndex())});
        }
        if (expr instanceof SliceExpression) {
            int childStrength;
            SliceExpression sexpr = (SliceExpression)expr;
            String childTxt = this.pprint(sexpr.getChild());
            int sliceStrength = CifTextUtils.getBindingStrength((Expression)expr);
            if (sliceStrength > (childStrength = CifTextUtils.getBindingStrength((Expression)sexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            }
            String beginTxt = sexpr.getBegin() == null ? "" : this.pprint(sexpr.getBegin());
            String endTxt = sexpr.getEnd() == null ? "" : this.pprint(sexpr.getEnd());
            return Strings.fmt((String)"%s[%s:%s]", (Object[])new Object[]{childTxt, beginTxt, endTxt});
        }
        if (expr instanceof FunctionCallExpression) {
            int funcStrength;
            FunctionCallExpression fexpr = (FunctionCallExpression)expr;
            String funcTxt = this.pprint(fexpr.getFunction());
            int callStrength = CifTextUtils.getBindingStrength((Expression)expr);
            if (callStrength > (funcStrength = CifTextUtils.getBindingStrength((Expression)fexpr.getFunction()))) {
                funcTxt = "(" + funcTxt + ")";
            }
            return String.valueOf(funcTxt) + this.pprint((List<Expression>)fexpr.getParams(), "(", ", ", ")");
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            String castTxt = null;
            if (lexpr.getElements().isEmpty()) {
                CifType castType;
                CifType type = expr.getType();
                ListType ltype = (ListType)CifTypeUtils.normalizeType((CifType)type);
                if (CifTypeUtils.isRangeless((ListType)ltype) || !ltype.getLower().equals(0) || !ltype.getUpper().equals(0)) {
                    ltype = (ListType)EMFHelper.deepclone((EObject)ltype);
                    ltype.setLower(Integer.valueOf(0));
                    ltype.setUpper(Integer.valueOf(0));
                }
                boolean addCast = true;
                EObject parent = expr.eContainer();
                if (parent instanceof CastExpression && CifTypeUtils.checkTypeCompat((CifType)(castType = ((CastExpression)parent).getType()), (CifType)ltype, (RangeCompat)RangeCompat.EQUAL)) {
                    addCast = false;
                }
                if (addCast) {
                    if (type != ltype) {
                        expr.setType((CifType)ltype);
                    }
                    castTxt = "<" + this.pprint((CifType)ltype) + ">";
                    if (type != ltype) {
                        expr.setType(type);
                    }
                }
            }
            if (castTxt == null) {
                castTxt = "";
            }
            String elemTxt = this.pprint((List<Expression>)lexpr.getElements(), "[", ", ", "]");
            return String.valueOf(castTxt) + elemTxt;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            String castTxt = null;
            if (sexpr.getElements().isEmpty()) {
                CifType castType;
                boolean addCast = true;
                EObject parent = expr.eContainer();
                if (parent instanceof CastExpression && CifTypeUtils.checkTypeCompat((CifType)(castType = ((CastExpression)parent).getType()), (CifType)expr.getType(), (RangeCompat)RangeCompat.EQUAL)) {
                    addCast = false;
                }
                if (addCast) {
                    castTxt = "<" + this.pprint(expr.getType()) + ">";
                }
            }
            if (castTxt == null) {
                castTxt = "";
            }
            String elemTxt = this.pprint((List<Expression>)sexpr.getElements(), "{", ", ", "}");
            return String.valueOf(castTxt) + elemTxt;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            return this.pprint((List<Expression>)texpr.getFields(), "(", ", ", ")");
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            String castTxt = null;
            if (dexpr.getPairs().isEmpty()) {
                CifType castType;
                boolean addCast = true;
                EObject parent = expr.eContainer();
                if (parent instanceof CastExpression && CifTypeUtils.checkTypeCompat((CifType)(castType = ((CastExpression)parent).getType()), (CifType)expr.getType(), (RangeCompat)RangeCompat.EQUAL)) {
                    addCast = false;
                }
                if (addCast) {
                    castTxt = "<" + this.pprint(expr.getType()) + ">";
                }
            }
            StringBuilder txt = new StringBuilder();
            if (castTxt != null) {
                txt.append(castTxt);
            }
            txt.append("{");
            boolean first = true;
            for (DictPair pair : dexpr.getPairs()) {
                if (!first) {
                    txt.append(", ");
                }
                first = false;
                txt.append(this.pprint(pair.getKey()));
                txt.append(": ");
                txt.append(this.pprint(pair.getValue()));
            }
            txt.append("}");
            return txt.toString();
        }
        if (expr instanceof ConstantExpression) {
            Constant refObj = ((ConstantExpression)expr).getConstant();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable refObj = ((DiscVariableExpression)expr).getVariable();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable refObj = ((AlgVariableExpression)expr).getVariable();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cvexpr = (ContVariableExpression)expr;
            ContVariable refObj = cvexpr.getVariable();
            String txt = CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
            if (cvexpr.isDerivative()) {
                txt = String.valueOf(txt) + "'";
            }
            return txt;
        }
        if (expr instanceof TauExpression) {
            return "tau";
        }
        if (expr instanceof LocationExpression) {
            Location refObj = ((LocationExpression)expr).getLocation();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteral refObj = ((EnumLiteralExpression)expr).getLiteral();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof EventExpression) {
            Event refObj = ((EventExpression)expr).getEvent();
            PositionObject scope = CifScopeUtils.getScope((PositionObject)expr);
            Pair key = Pair.pair((Object)scope, (Object)refObj);
            String txt = this.eventRefCache.get(key);
            if (txt == null) {
                txt = CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
                this.eventRefCache.put((Pair<EObject, Event>)key, txt);
            }
            return txt;
        }
        if (expr instanceof FieldExpression) {
            Field field = ((FieldExpression)expr).getField();
            Assert.notNull((Object)field.getName());
            return CifTextUtils.escapeIdentifier((String)field.getName());
        }
        if (expr instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression fexpr = (StdLibFunctionExpression)expr;
            StdLibFunction func = fexpr.getFunction();
            return CifTextUtils.functionToStr((StdLibFunction)func);
        }
        if (expr instanceof FunctionExpression) {
            Function refObj = ((FunctionExpression)expr).getFunction();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof InputVariableExpression) {
            InputVariable refObj = ((InputVariableExpression)expr).getVariable();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof ComponentExpression) {
            Component refObj = ((ComponentExpression)expr).getComponent();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof CompParamExpression) {
            ComponentParameter refObj = ((CompParamExpression)expr).getParameter();
            return CifScopeUtils.getRefTxtFromObj((PositionObject)expr, (PositionObject)refObj, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof CompInstWrapExpression) {
            return CifScopeUtils.getViaRefTxt((PositionObject)expr, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof CompParamWrapExpression) {
            return CifScopeUtils.getViaRefTxt((PositionObject)expr, (ScopeCache)this.scopeCache);
        }
        if (expr instanceof ReceivedExpression) {
            return "?";
        }
        if (expr instanceof SelfExpression) {
            return "self";
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }
}

