/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CifFormatPatternCodeGenerator {
    private CifFormatPatternCodeGenerator() {
    }

    public static String gencodePattern(String pattern, List<String> valueTxts, List<CifType> valueTypes) {
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern);
        StringBuilder patternCode = new StringBuilder();
        List argCodes = Lists.listc((int)parts.size());
        int implicitIndex = 0;
        for (FormatDescription part : parts) {
            if (part.conversion == FormatDescription.Conversion.LITERAL) {
                if (part.text.equals("%")) {
                    patternCode.append("%%");
                    continue;
                }
                patternCode.append(part.text);
                continue;
            }
            int idx = !part.index.isEmpty() ? part.getExplicitIndex() - 1 : implicitIndex++;
            String argCode = valueTxts.get(idx);
            switch (part.conversion) {
                case BOOLEAN: 
                case INTEGER: 
                case REAL: {
                    patternCode.append(part.toString(false));
                    argCodes.add(argCode);
                    break;
                }
                case STRING: {
                    patternCode.append(part.toString(false));
                    CifType t = valueTypes.get(idx);
                    CifType nt = CifTypeUtils.normalizeType((CifType)t);
                    if (!(nt instanceof StringType)) {
                        argCode = "runtimeToString(" + argCode + ")";
                    }
                    argCodes.add(argCode);
                    break;
                }
                default: {
                    String msg = "Unexpected: " + part.conversion;
                    throw new RuntimeException(msg);
                }
            }
        }
        StringBuilder rslt = new StringBuilder();
        rslt.append("fmt(");
        rslt.append(Strings.stringToJava((String)patternCode.toString()));
        if (!argCodes.isEmpty()) {
            rslt.append(", ");
        }
        rslt.append(String.join((CharSequence)", ", argCodes));
        rslt.append(")");
        return rslt.toString();
    }
}

