/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import org.eclipse.escet.cif.simulator.options.AutoAlgoOption;
import org.eclipse.escet.cif.simulator.options.CompleteMode;
import org.eclipse.escet.cif.simulator.options.InputMode;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class CompleteModeOption
extends EnumOption<CompleteMode> {
    public CompleteModeOption() {
        super("Complete mode", "If complete mode is enabled, all possible transitions are computed. If it is disabled, computation stops as soon as a possible transition is found. Specify \"on\" to enable, \"off\" to disable, or \"auto\" (default) to disable if possible, and enable otherwise.", null, "complete", "CMODE", (Enum)CompleteMode.AUTO, true, "If complete mode is enabled, all possible transitions are computed. If it is disabled, computation stops as soon as a possible transition is found.");
    }

    protected String getDialogText(CompleteMode value) {
        switch (value) {
            case AUTO: {
                return "Auto: disable if possible, enable otherwise";
            }
            case ON: {
                return "On: forced enabled";
            }
            case OFF: {
                return "Off: forced disabled";
            }
        }
        throw new RuntimeException("Unknown complete mode: " + (Object)((Object)value));
    }

    public static boolean isEnabled() {
        boolean enabled;
        InputMode inputMode = InputModeOption.getInputMode();
        boolean disableAllowed = false;
        switch (inputMode) {
            case AUTO: 
            case SVG: {
                int autoAlgo = AutoAlgoOption.getAutoAlgo();
                disableAllowed = autoAlgo == -2;
                break;
            }
        }
        CompleteMode completeMode = (CompleteMode)((Object)Options.get(CompleteModeOption.class));
        switch (completeMode) {
            case AUTO: {
                enabled = !disableAllowed;
                break;
            }
            case OFF: {
                enabled = false;
                break;
            }
            case ON: {
                enabled = true;
                break;
            }
            default: {
                String msg = "Unknown complete mode: " + (Object)((Object)completeMode);
                throw new RuntimeException(msg);
            }
        }
        if (!enabled && !disableAllowed) {
            String msg = "Disabling complete mode is only allowed for the automatic and SVG input modes, together with the first transition automatic mode choice algorithm.";
            throw new InvalidOptionException(msg);
        }
        return enabled;
    }
}

