/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.io;

import org.eclipse.escet.cif.simulator.runtime.RuntimeEnumUtils;
import org.eclipse.escet.cif.simulator.runtime.io.LiteralStream;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class RuntimeLiteralReader {
    private RuntimeLiteralReader() {
    }

    public static boolean readBoolLiteral(ClassLoader loader, String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (LiteralStream stream = new LiteralStream(loader, path);){
                return RuntimeLiteralReader.readBoolLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"bool\".";
            throw new RuntimeException(msg, ex);
        }
    }

    public static boolean readBoolLiteral(String valueText) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (LiteralStream stream = new LiteralStream(valueText);){
                return RuntimeLiteralReader.readBoolLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"bool\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static boolean readBoolLiteral(LiteralStream stream) {
        try {
            return RuntimeLiteralReader.readBoolLiteralInternal(stream);
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"bool\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    private static boolean readBoolLiteralInternal(LiteralStream stream) {
        stream.skipWhitespace();
        int c = stream.read();
        if (c == 116) {
            stream.expectCharacter(114);
            stream.expectCharacter(117);
            stream.expectCharacter(101);
            return true;
        }
        if (c == 102) {
            stream.expectCharacter(97);
            stream.expectCharacter(108);
            stream.expectCharacter(115);
            stream.expectCharacter(101);
            return false;
        }
        String msg = "Expected boolean literal (\"true\" or \"false\"), but did not find it";
        String lineColMsg = stream.getLineColMsg();
        if (lineColMsg != null) {
            msg = String.valueOf(msg) + ", " + lineColMsg;
        }
        msg = String.valueOf(msg) + ".";
        throw new InputOutputException(msg);
    }

    public static int readIntLiteral(ClassLoader loader, String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (LiteralStream stream = new LiteralStream(loader, path);){
                return RuntimeLiteralReader.readIntLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"int\".";
            throw new RuntimeException(msg, ex);
        }
    }

    public static int readIntLiteral(String valueText) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (LiteralStream stream = new LiteralStream(valueText);){
                return RuntimeLiteralReader.readIntLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"int\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static int readIntLiteral(LiteralStream stream) {
        try {
            return RuntimeLiteralReader.readIntLiteralInternal(stream);
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"int\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    private static int readIntLiteralInternal(LiteralStream stream) {
        stream.skipWhitespace();
        int c = stream.read();
        boolean negate = false;
        while (c == 43 || c == 45) {
            if (c == 45) {
                negate = !negate;
            }
            c = stream.read();
        }
        int value = 0;
        boolean hasDigits = false;
        while (c >= 48 && c <= 57) {
            if ((value = value * 10 + c - 48) < 0) {
                String msg = "Integer overflow while reading integer number";
                String lineColMsg = stream.getLineColMsg();
                if (lineColMsg != null) {
                    msg = String.valueOf(msg) + ", " + lineColMsg;
                }
                msg = String.valueOf(msg) + ".";
                throw new InputOutputException(msg);
            }
            hasDigits = true;
            stream.mark(1);
            c = stream.read();
        }
        if (hasDigits) {
            stream.reset();
            return negate ? -value : value;
        }
        String msg = "Expected integer number but found no digits";
        String lineColMsg = stream.getLineColMsg();
        if (lineColMsg != null) {
            msg = String.valueOf(msg) + ", " + lineColMsg;
        }
        msg = String.valueOf(msg) + ".";
        throw new InputOutputException(msg);
    }

    public static double readRealLiteral(ClassLoader loader, String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (LiteralStream stream = new LiteralStream(loader, path);){
                return RuntimeLiteralReader.readRealLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"real\".";
            throw new RuntimeException(msg, ex);
        }
    }

    public static double readRealLiteral(String valueText) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (LiteralStream stream = new LiteralStream(valueText);){
                return RuntimeLiteralReader.readRealLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"real\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static double readRealLiteral(LiteralStream stream) {
        try {
            return RuntimeLiteralReader.readRealLiteralInternal(stream);
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"real\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    private static double readRealLiteralInternal(LiteralStream stream) {
        stream.skipWhitespace();
        int state = 1;
        StringBuilder txt = new StringBuilder();
        block11: while (true) {
            if (state == 3 || state == 4 || state == 7 || state == 9) {
                stream.mark(1);
            }
            int c = stream.read();
            switch (state) {
                case 1: {
                    if (c == 48) {
                        state = 3;
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c == 43 || c == 45) {
                        state = 2;
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c < 49 || c > 57) break block11;
                    state = 4;
                    txt.append((char)c);
                    continue block11;
                }
                case 2: {
                    if (c == 48) {
                        state = 3;
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c < 49 || c > 57) break block11;
                    state = 4;
                    txt.append((char)c);
                    continue block11;
                }
                case 3: {
                    if (c == 46) {
                        state = 5;
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c == 69 || c == 101) {
                        state = 6;
                        txt.append((char)c);
                        continue block11;
                    }
                    stream.reset();
                    double rslt = Double.parseDouble(txt.toString());
                    Assert.check((!Double.isNaN(rslt) ? 1 : 0) != 0);
                    if (rslt == -0.0) {
                        rslt = 0.0;
                    }
                    if (Double.isInfinite(rslt)) {
                        String msg = "Real overflow while reading real number";
                        String lineColMsg = stream.getLineColMsg();
                        if (lineColMsg != null) {
                            msg = String.valueOf(msg) + ", " + lineColMsg;
                        }
                        msg = String.valueOf(msg) + ".";
                        throw new InputOutputException(msg);
                    }
                    return rslt;
                }
                case 4: {
                    if (c >= 48 && c <= 57) {
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c == 46) {
                        state = 5;
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c == 69 || c == 101) {
                        state = 6;
                        txt.append((char)c);
                        continue block11;
                    }
                    stream.reset();
                    double rslt = Double.parseDouble(txt.toString());
                    Assert.check((!Double.isNaN(rslt) ? 1 : 0) != 0);
                    if (rslt == -0.0) {
                        rslt = 0.0;
                    }
                    if (Double.isInfinite(rslt)) {
                        String msg = "Real overflow while reading real number";
                        String lineColMsg = stream.getLineColMsg();
                        if (lineColMsg != null) {
                            msg = String.valueOf(msg) + ", " + lineColMsg;
                        }
                        msg = String.valueOf(msg) + ".";
                        throw new InputOutputException(msg);
                    }
                    return rslt;
                }
                case 5: {
                    if (c < 48 || c > 57) break block11;
                    state = 7;
                    txt.append((char)c);
                    continue block11;
                }
                case 6: {
                    if (c == 43 || c == 45) {
                        state = 8;
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c < 48 || c > 57) break block11;
                    state = 9;
                    txt.append((char)c);
                    continue block11;
                }
                case 7: {
                    if (c == 69 || c == 101) {
                        state = 6;
                        txt.append((char)c);
                        continue block11;
                    }
                    if (c >= 48 && c <= 57) {
                        txt.append((char)c);
                        continue block11;
                    }
                    stream.reset();
                    double rslt = Double.parseDouble(txt.toString());
                    Assert.check((!Double.isNaN(rslt) ? 1 : 0) != 0);
                    if (rslt == -0.0) {
                        rslt = 0.0;
                    }
                    if (Double.isInfinite(rslt)) {
                        String msg = "Real overflow while reading real number";
                        String lineColMsg = stream.getLineColMsg();
                        if (lineColMsg != null) {
                            msg = String.valueOf(msg) + ", " + lineColMsg;
                        }
                        msg = String.valueOf(msg) + ".";
                        throw new InputOutputException(msg);
                    }
                    return rslt;
                }
                case 8: {
                    if (c < 48 || c > 57) break block11;
                    state = 9;
                    txt.append((char)c);
                    continue block11;
                }
                case 9: {
                    if (c >= 48 && c <= 57) {
                        txt.append((char)c);
                        continue block11;
                    }
                    stream.reset();
                    double rslt = Double.parseDouble(txt.toString());
                    Assert.check((!Double.isNaN(rslt) ? 1 : 0) != 0);
                    if (rslt == -0.0) {
                        rslt = 0.0;
                    }
                    if (Double.isInfinite(rslt)) {
                        String msg = "Real overflow while reading real number";
                        String lineColMsg = stream.getLineColMsg();
                        if (lineColMsg != null) {
                            msg = String.valueOf(msg) + ", " + lineColMsg;
                        }
                        msg = String.valueOf(msg) + ".";
                        throw new InputOutputException(msg);
                    }
                    return rslt;
                }
                default: {
                    throw new RuntimeException("Unexpected state: " + state);
                }
            }
            break;
        }
        String msg = "Expected a real number but did not find one";
        String lineColMsg = stream.getLineColMsg();
        if (lineColMsg != null) {
            msg = String.valueOf(msg) + ", " + lineColMsg;
        }
        msg = String.valueOf(msg) + ".";
        throw new InputOutputException(msg);
    }

    public static String readStringLiteral(ClassLoader loader, String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (LiteralStream stream = new LiteralStream(loader, path);){
                return RuntimeLiteralReader.readStringLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"string\".";
            throw new RuntimeException(msg, ex);
        }
    }

    public static String readStringLiteral(String valueText) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (LiteralStream stream = new LiteralStream(valueText);){
                return RuntimeLiteralReader.readStringLiteral(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"string\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static String readStringLiteral(LiteralStream stream) {
        try {
            return RuntimeLiteralReader.readStringLiteralInternal(stream);
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read literal of type \"string\".";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    private static String readStringLiteralInternal(LiteralStream stream) {
        int c;
        stream.skipWhitespace();
        stream.expectCharacter(34);
        StringBuilder txt = new StringBuilder();
        boolean inEscape = false;
        while (true) {
            c = stream.read();
            if (!inEscape) {
                if (c == 92) {
                    inEscape = true;
                    continue;
                }
                if (c == 34) {
                    return txt.toString();
                }
                if (c != -1) {
                    txt.append((char)c);
                    continue;
                }
                String msg = "Encountered end-of-file";
                String lineColMsg = stream.getLineColMsg();
                if (lineColMsg != null) {
                    msg = String.valueOf(msg) + ", " + lineColMsg + ",";
                }
                msg = String.valueOf(msg) + " while reading a string literal. Perhaps a closing double quote is missing?";
                throw new InputOutputException(msg);
            }
            inEscape = false;
            if (c == 92 || c == 34) {
                txt.append((char)c);
                continue;
            }
            if (c == 116) {
                txt.append('\t');
                continue;
            }
            if (c != 110) break;
            txt.append('\n');
        }
        if (c == -1) {
            String msg = "Encountered end-of-file";
            String lineColMsg = stream.getLineColMsg();
            if (lineColMsg != null) {
                msg = String.valueOf(msg) + ", " + lineColMsg + ",";
            }
            msg = String.valueOf(msg) + " while reading an escaped character of a string literal.";
            throw new InputOutputException(msg);
        }
        String msg = Strings.fmt((String)"Encountered \"%c\"", (Object[])new Object[]{c});
        String lineColMsg = stream.getLineColMsg();
        if (lineColMsg != null) {
            msg = String.valueOf(msg) + ", " + lineColMsg + ",";
        }
        msg = String.valueOf(msg) + " while reading an escaped character of a string literal.";
        throw new InputOutputException(msg);
    }

    public static <T extends Enum<T>> T readEnumLiteral(ClassLoader loader, String path, Class<T> enumClass) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (LiteralStream stream = new LiteralStream(loader, path);){
                return RuntimeLiteralReader.readEnumLiteral(stream, enumClass);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String name = RuntimeEnumUtils.getEnumCifName(enumClass);
            String msg = Strings.fmt((String)"Failed to read literal of type \"%s\".", (Object[])new Object[]{name});
            throw new RuntimeException(msg, ex);
        }
    }

    public static <T extends Enum<T>> T readEnumLiteral(String valueText, Class<T> enumClass) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (LiteralStream stream = new LiteralStream(valueText);){
                return RuntimeLiteralReader.readEnumLiteral(stream, enumClass);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InputOutputException ex) {
            String name = RuntimeEnumUtils.getEnumCifName(enumClass);
            String msg = Strings.fmt((String)"Failed to read literal of type \"%s\".", (Object[])new Object[]{name});
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    public static <T extends Enum<T>> T readEnumLiteral(LiteralStream stream, Class<T> enumClass) {
        try {
            return RuntimeLiteralReader.readEnumLiteralInternal(stream, enumClass);
        }
        catch (InputOutputException ex) {
            String name = RuntimeEnumUtils.getEnumCifName(enumClass);
            String msg = Strings.fmt((String)"Failed to read literal of type \"%s\".", (Object[])new Object[]{name});
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }

    private static <T extends Enum<T>> T readEnumLiteralInternal(LiteralStream stream, Class<T> enumClass) {
        String name;
        try {
            name = RuntimeLiteralReader.readIdentifier(stream);
        }
        catch (InputOutputException ex) {
            String msg = "Failed to read enumeration literal.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int msg = 0;
        while (msg < n) {
            Enum enumConstant = enumArray[msg];
            if (enumConstant.toString().equals(name)) {
                return (T)enumConstant;
            }
            ++msg;
        }
        String msg2 = Strings.fmt((String)"Identifier \"%s\" is not the name of an expected enumeration literal", (Object[])new Object[]{name});
        String lineColMsg = stream.getLineColMsg();
        if (lineColMsg != null) {
            msg2 = String.valueOf(msg2) + ", " + lineColMsg;
        }
        msg2 = String.valueOf(msg2) + ".";
        throw new InputOutputException(msg2);
    }

    private static String readIdentifier(LiteralStream stream) {
        int c;
        StringBuilder txt;
        block8: {
            stream.skipWhitespace();
            txt = new StringBuilder();
            while (true) {
                stream.mark(1);
                c = stream.read();
                if (c == -1) {
                    if (txt.length() > 0) {
                        return txt.toString();
                    }
                    String msg = "Encountered end-of-file while reading an identifier";
                    String lineColMsg = stream.getLineColMsg();
                    if (lineColMsg != null) {
                        msg = String.valueOf(msg) + ", " + lineColMsg;
                    }
                    msg = String.valueOf(msg) + ".";
                    throw new InputOutputException(msg);
                }
                if (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95) {
                    txt.append((char)c);
                    continue;
                }
                if (c < 48 || c > 57) break block8;
                if (txt.length() <= 0) break;
                txt.append((char)c);
            }
            String msg = Strings.fmt((String)"Encountered \"%c\"", (Object[])new Object[]{c});
            String lineColMsg = stream.getLineColMsg();
            if (lineColMsg != null) {
                msg = String.valueOf(msg) + ", " + lineColMsg + ",";
            }
            msg = String.valueOf(msg) + " while reading the first character of an identifier.";
            throw new InputOutputException(msg);
        }
        if (txt.length() > 0) {
            stream.reset();
            return txt.toString();
        }
        String msg = Strings.fmt((String)"Encountered \"%c\"", (Object[])new Object[]{c});
        String lineColMsg = stream.getLineColMsg();
        if (lineColMsg != null) {
            msg = String.valueOf(msg) + ", " + lineColMsg + ",";
        }
        msg = String.valueOf(msg) + " while reading the first character of an identifier.";
        throw new InputOutputException(msg);
    }
}

